/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.Range;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Trace;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.MemorySessionArtifact;
import com.android.tools.profilers.sessions.SessionArtifact;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class HeapProfdSessionArtifact
extends MemorySessionArtifact<Trace.TraceInfo> {
    public HeapProfdSessionArtifact(@NotNull StudioProfilers profilers, @NotNull Common.Session session, @NotNull Common.SessionMetaData sessionMetaData, @NotNull Trace.TraceInfo info) {
        super(profilers, session, sessionMetaData, info, "Native Sampled");
    }

    @Override
    protected long getStartTime() {
        return ((Trace.TraceInfo)this.getArtifactProto()).getFromTimestamp();
    }

    @Override
    protected long getEndTime() {
        return ((Trace.TraceInfo)this.getArtifactProto()).getToTimestamp();
    }

    @Override
    public void export(@NotNull OutputStream outputStream) {
        assert (this.getCanExport());
        MemoryProfiler.saveHeapProfdSampleToFile(this.getProfilers().getClient(), this.getSession(), (Trace.TraceInfo)this.getArtifactProto(), outputStream);
        File symbols = new File(String.format(Locale.US, "%s%s%d.symbols", FileUtil.getTempDirectory(), File.separator, this.getStartTime()));
        if (symbols.exists()) {
            try {
                FileUtil.copy((InputStream)new FileInputStream(symbols), (OutputStream)outputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    @NotNull
    public String getExportableName() {
        return MemoryProfiler.generateCaptureFileName();
    }

    @Override
    @NotNull
    public String getExportExtension() {
        return "heapprofd";
    }

    public static @Unmodifiable List<SessionArtifact<?>> getSessionArtifacts(@NotNull StudioProfilers profilers, @NotNull Common.Session session, @NotNull Common.SessionMetaData sessionMetaData) {
        Range queryRangeUs = new Range((double)TimeUnit.NANOSECONDS.toMicros(session.getStartTimestamp()), session.getEndTimestamp() == Long.MAX_VALUE ? 9.223372036854776E18 : (double)TimeUnit.NANOSECONDS.toMicros(session.getEndTimestamp()));
        List<Trace.TraceInfo> infos = MemoryProfiler.getNativeHeapSamplesForSession(profilers.getClient(), session, queryRangeUs);
        return ContainerUtil.map(infos, info -> new HeapProfdSessionArtifact(profilers, session, sessionMetaData, (Trace.TraceInfo)info));
    }
}

