/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.StreamingTimeline;
import com.android.tools.idea.io.grpc.StatusRuntimeException;
import com.android.tools.idea.transport.poller.TransportEventListener;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profiler.proto.Trace;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.ImportedSessionUtils;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioProfiler;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.memory.AllocationSamplingRateDataSeries;
import com.android.tools.profilers.memory.AllocationSamplingRateDurationData;
import com.android.tools.profilers.memory.AllocationStage;
import com.android.tools.profilers.memory.BaseStreamingMemoryProfilerStage;
import com.android.tools.profilers.memory.MainMemoryProfilerStage;
import com.android.tools.profilers.memory.MemoryMonitor;
import com.android.tools.profilers.memory.MemoryProfilerKt;
import com.android.tools.profilers.sessions.SessionsManager;
import com.android.tools.profilers.tasks.ProfilerTaskType;
import com.intellij.openapi.diagnostic.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0002J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/profilers/memory/MemoryProfiler;", "Lcom/android/tools/profilers/StudioProfiler;", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "<init>", "(Lcom/android/tools/profilers/StudioProfilers;)V", "myAspectObserver", "Lcom/android/tools/adtui/model/AspectObserver;", "sessionsManager", "Lcom/android/tools/profilers/sessions/SessionsManager;", "Lorg/jetbrains/annotations/NotNull;", "getSessionsManager", "()Lcom/android/tools/profilers/sessions/SessionsManager;", "featureTracker", "Lcom/android/tools/profilers/analytics/FeatureTracker;", "getFeatureTracker", "()Lcom/android/tools/profilers/analytics/FeatureTracker;", "newMonitor", "Lcom/android/tools/profilers/memory/MemoryMonitor;", "startProfiling", "", "session", "Lcom/android/tools/profiler/proto/Common$Session;", "stopProfiling", "agentStatusChanged", "importHprof", "file", "Ljava/io/File;", "importHeapprofd", "importLegacyAllocations", "Companion", "intellij.android.profilers"})
public final class MemoryProfiler
implements StudioProfiler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StudioProfilers profilers;
    @NotNull
    private final AspectObserver myAspectObserver;

    public MemoryProfiler(@NotNull StudioProfilers profilers) {
        Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
        this.profilers = profilers;
        this.myAspectObserver = new AspectObserver();
        this.profilers.addDependency(this.myAspectObserver).onChange((Enum)ProfilerAspect.AGENT, this::agentStatusChanged);
        this.getSessionsManager().registerImportHandler("hprof", this::importHprof);
        this.getSessionsManager().registerImportHandler("alloc", this::importLegacyAllocations);
        this.getSessionsManager().registerImportHandler("heapprofd", this::importHeapprofd);
        this.getSessionsManager().registerImportHandler("asdb", arg_0 -> MemoryProfiler._init_$lambda$0(this, arg_0));
        this.profilers.registerSessionChangeListener(Common.SessionMetaData.SessionType.MEMORY_CAPTURE, () -> MemoryProfiler._init_$lambda$2(this));
    }

    private final SessionsManager getSessionsManager() {
        SessionsManager sessionsManager = this.profilers.getSessionsManager();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sessionsManager), (String)"getSessionsManager(...)");
        return sessionsManager;
    }

    private final FeatureTracker getFeatureTracker() {
        return this.profilers.getIdeServices().getFeatureTracker();
    }

    @Override
    @NotNull
    public MemoryMonitor newMonitor() {
        return new MemoryMonitor(this.profilers);
    }

    @Override
    public void startProfiling(@NotNull Common.Session session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
    }

    @Override
    public void stopProfiling(@NotNull Common.Session session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        try {
            Companion.trackAllocations(this.profilers, session, false, false, null);
        }
        catch (StatusRuntimeException e) {
            MemoryProfiler.Companion.getLogger().info((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void agentStatusChanged() {
        Common.Session session = this.profilers.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)session, (String)"getSession(...)");
        Common.Session session2 = session;
        if (Intrinsics.areEqual((Object)Common.Session.getDefaultInstance(), (Object)session2)) return;
        if (session2.getEndTimestamp() != Long.MAX_VALUE) {
            return;
        }
        if (!this.profilers.isAgentAttached()) {
            if (Common.AgentData.Status.UNATTACHABLE != this.profilers.getAgentData().getStatus()) return;
            if (!this.profilers.getSessionsManager().isSessionAlive()) return;
            if (!(this.profilers.getStage() instanceof AllocationStage)) return;
            Stage stage = this.profilers.getStage();
            Intrinsics.checkNotNull((Object)((Object)stage), (String)"null cannot be cast to non-null type com.android.tools.profilers.memory.AllocationStage");
            if (((AllocationStage)stage).getHasStartedTracking()) return;
            Stage stage2 = this.profilers.getStage();
            Intrinsics.checkNotNull((Object)((Object)stage2), (String)"null cannot be cast to non-null type com.android.tools.profilers.memory.AllocationStage");
            ((AllocationStage)stage2).stopTrackingDueToUnattachableAgent();
            return;
        }
        try {
            if (this.profilers.getIdeServices().getFeatureConfig().isTaskBasedUxEnabled() && this.profilers.getSessionsManager().isSessionAlive() && this.profilers.getSessionsManager().getCurrentTaskType() == ProfilerTaskType.JAVA_KOTLIN_ALLOCATIONS && this.profilers.getStage() instanceof AllocationStage) {
                Stage stage = this.profilers.getStage();
                Intrinsics.checkNotNull((Object)((Object)stage), (String)"null cannot be cast to non-null type com.android.tools.profilers.memory.AllocationStage");
                if (!((AllocationStage)stage).getHasStartedTracking()) {
                    Stage stage3 = this.profilers.getStage();
                    Intrinsics.checkNotNull((Object)((Object)stage3), (String)"null cannot be cast to non-null type com.android.tools.profilers.memory.AllocationStage");
                    ((AllocationStage)stage3).startTracking();
                    return;
                }
            }
            Companion.trackAllocations(this.profilers, session2, false, false, null);
            return;
        }
        catch (StatusRuntimeException e) {
            MemoryProfiler.Companion.getLogger().info((Throwable)e);
        }
    }

    private final void importHprof(File file) {
        ImportedSessionUtils.importFileWithArtifactEvent(this.getSessionsManager(), file, Common.SessionData.SessionStarted.SessionType.MEMORY_CAPTURE, (Function2<? super Long, ? super Long, Common.Event>)((Function2)MemoryProfiler::importHprof$lambda$4));
        this.getFeatureTracker().trackCreateSession(Common.SessionMetaData.SessionType.MEMORY_CAPTURE, SessionsManager.SessionCreationSource.MANUAL);
    }

    private final void importHeapprofd(File file) {
        ImportedSessionUtils.importFileWithArtifactEvent(this.getSessionsManager(), file, Common.SessionData.SessionStarted.SessionType.MEMORY_CAPTURE, (Function2<? super Long, ? super Long, Common.Event>)((Function2)MemoryProfiler::importHeapprofd$lambda$6));
        this.getFeatureTracker().trackCreateSession(Common.SessionMetaData.SessionType.MEMORY_CAPTURE, SessionsManager.SessionCreationSource.MANUAL);
    }

    private final void importLegacyAllocations(File file) {
        ImportedSessionUtils.importFileWithArtifactEvent(this.getSessionsManager(), file, Common.SessionData.SessionStarted.SessionType.MEMORY_CAPTURE, (Function2<? super Long, ? super Long, Common.Event>)((Function2)MemoryProfiler::importLegacyAllocations$lambda$9));
        this.getFeatureTracker().trackCreateSession(Common.SessionMetaData.SessionType.MEMORY_CAPTURE, SessionsManager.SessionCreationSource.MANUAL);
    }

    private static final void _init_$lambda$0(MemoryProfiler this$0, File file) {
        StudioProfilers studioProfilers = this$0.profilers;
        Intrinsics.checkNotNull((Object)file);
        ImportedSessionUtils.importAsdbTask(studioProfilers, file);
    }

    private static final void _init_$lambda$2(MemoryProfiler this$0) {
        StreamingTimeline streamingTimeline;
        MainMemoryProfilerStage stage = new MainMemoryProfilerStage(this$0.profilers);
        this$0.profilers.setStage(stage);
        stage.setPendingCaptureStartTimeGuarded(this$0.profilers.getSession().getStartTimestamp());
        StreamingTimeline $this$lambda_u242_u24lambda_u241 = streamingTimeline = this$0.profilers.getTimeline();
        boolean bl = false;
        $this$lambda_u242_u24lambda_u241.reset(this$0.profilers.getSession().getStartTimestamp(), this$0.profilers.getSession().getEndTimestamp());
        $this$lambda_u242_u24lambda_u241.getViewRange().set($this$lambda_u242_u24lambda_u241.getDataRange());
        $this$lambda_u242_u24lambda_u241.setIsPaused(true);
    }

    private static final Memory.HeapDumpInfo.Builder importHprof$makeInfo(long start, long end) {
        return Memory.HeapDumpInfo.newBuilder().setStartTime(start).setEndTime(end);
    }

    private static final Unit importHprof$lambda$4$lambda$3(long $start, long $end, Common.Event.Builder $this$makeEndedEvent) {
        Intrinsics.checkNotNullParameter((Object)$this$makeEndedEvent, (String)"$this$makeEndedEvent");
        $this$makeEndedEvent.setMemoryHeapdump(Memory.MemoryHeapDumpData.newBuilder().setInfo(MemoryProfiler.importHprof$makeInfo($start, $end)));
        return Unit.INSTANCE;
    }

    private static final Common.Event importHprof$lambda$4(long start, long end) {
        return ImportedSessionUtils.makeEndedEvent(start, start, Common.Event.Kind.MEMORY_HEAP_DUMP, (Function1<? super Common.Event.Builder, Unit>)((Function1)arg_0 -> MemoryProfiler.importHprof$lambda$4$lambda$3(start, end, arg_0)));
    }

    private static final Unit importHeapprofd$lambda$6$lambda$5(long $start, long $end, Common.Event.Builder $this$makeEndedEvent) {
        Intrinsics.checkNotNullParameter((Object)$this$makeEndedEvent, (String)"$this$makeEndedEvent");
        $this$makeEndedEvent.setTraceData(Trace.TraceData.newBuilder().setTraceEnded(Trace.TraceData.TraceEnded.newBuilder().setTraceInfo(Trace.TraceInfo.newBuilder().setFromTimestamp($start).setToTimestamp($end))));
        return Unit.INSTANCE;
    }

    private static final Common.Event importHeapprofd$lambda$6(long start, long end) {
        return ImportedSessionUtils.makeEndedEvent(start, start, Common.Event.Kind.MEMORY_TRACE, (Function1<? super Common.Event.Builder, Unit>)((Function1)arg_0 -> MemoryProfiler.importHeapprofd$lambda$6$lambda$5(start, end, arg_0)));
    }

    private static final Memory.AllocationsInfo.Builder importLegacyAllocations$makeInfo$7(long start, long end) {
        return Memory.AllocationsInfo.newBuilder().setStartTime(start).setEndTime(end).setLegacy(true).setSuccess(true);
    }

    private static final Unit importLegacyAllocations$lambda$9$lambda$8(long $start, long $end, Common.Event.Builder $this$makeEndedEvent) {
        Intrinsics.checkNotNullParameter((Object)$this$makeEndedEvent, (String)"$this$makeEndedEvent");
        $this$makeEndedEvent.setMemoryAllocTracking(Memory.MemoryAllocTrackingData.newBuilder().setInfo(MemoryProfiler.importLegacyAllocations$makeInfo$7($start, $end)));
        return Unit.INSTANCE;
    }

    private static final Common.Event importLegacyAllocations$lambda$9(long start, long end) {
        return ImportedSessionUtils.makeEndedEvent(start, start, Common.Event.Kind.MEMORY_ALLOC_TRACKING, (Function1<? super Common.Event.Builder, Unit>)((Function1)arg_0 -> MemoryProfiler.importLegacyAllocations$lambda$9$lambda$8(start, end, arg_0)));
    }

    @JvmStatic
    public static final void importAllocations(@NotNull StudioProfilers profilers, @NotNull File file) {
        Companion.importAllocations(profilers, file);
    }

    @JvmStatic
    public static final boolean isUsingLiveAllocation(@NotNull StudioProfilers profilers, @NotNull Common.Session session) {
        return Companion.isUsingLiveAllocation(profilers, session);
    }

    @JvmStatic
    public static final boolean hasOnlyFullAllocationTrackingWithinRegion(@NotNull StudioProfilers profilers, @NotNull Common.Session session, long startTimeUs, long endTimeUs) {
        return Companion.hasOnlyFullAllocationTrackingWithinRegion(profilers, session, startTimeUs, endTimeUs);
    }

    @JvmStatic
    public static final void saveHeapDumpToFile(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Memory.HeapDumpInfo info, @NotNull OutputStream outputStream, @NotNull FeatureTracker featureTracker) {
        Companion.saveHeapDumpToFile(client, session, info, outputStream, featureTracker);
    }

    @JvmStatic
    public static final void saveAllocationToFile(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull OutputStream outputStream, @NotNull FeatureTracker featureTracker) {
        Companion.saveAllocationToFile(client, session, outputStream, featureTracker);
    }

    @JvmStatic
    public static final void saveLegacyAllocationToFile(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Memory.AllocationsInfo info, @NotNull OutputStream outputStream, @NotNull FeatureTracker featureTracker) {
        Companion.saveLegacyAllocationToFile(client, session, info, outputStream, featureTracker);
    }

    @JvmStatic
    public static final void saveHeapProfdSampleToFile(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Trace.TraceInfo info, @NotNull OutputStream outputStream) {
        Companion.saveHeapProfdSampleToFile(client, session, info, outputStream);
    }

    @JvmStatic
    @NotNull
    public static final String generateCaptureFileName() {
        return Companion.generateCaptureFileName();
    }

    @JvmStatic
    @NotNull
    public static final List<Trace.TraceInfo> getNativeHeapSamplesForSession(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Range rangeUs) {
        return Companion.getNativeHeapSamplesForSession(client, session, rangeUs);
    }

    @JvmStatic
    @NotNull
    public static final List<Common.Event> getNativeHeapEventsForSessionSortedByTimestamp(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Range rangeUs) {
        return Companion.getNativeHeapEventsForSessionSortedByTimestamp(client, session, rangeUs);
    }

    @JvmStatic
    @NotNull
    public static final List<Memory.HeapDumpInfo> getHeapDumpsForSession(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Range rangeUs) {
        return Companion.getHeapDumpsForSession(client, session, rangeUs);
    }

    @JvmStatic
    @NotNull
    public static final List<Memory.AllocationsInfo> getAllocationInfosForSession(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Range rangeUs) {
        return Companion.getAllocationInfosForSession(client, session, rangeUs);
    }

    @JvmStatic
    public static final void trackAllocations(@NotNull StudioProfilers profilers, @NotNull Common.Session session, boolean enable, boolean endSession, @Nullable Consumer<Memory.TrackStatus> responseHandler) {
        Companion.trackAllocations(profilers, session, enable, endSession, responseHandler);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J(\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0007J0\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J(\u0010\u001f\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J0\u0010 \u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J(\u0010\"\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020#2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J>\u0010$\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\t0'2\u0006\u0010(\u001a\u00020)H\u0002J\b\u0010*\u001a\u00020)H\u0007J.\u0010+\u001a\u0010\u0012\f\u0012\n -*\u0004\u0018\u00010#0#0,2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010.\u001a\u00020/H\u0007J.\u00100\u001a\u0010\u0012\f\u0012\n -*\u0004\u0018\u000101010,2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010.\u001a\u00020/H\u0007J&\u00102\u001a\b\u0012\u0004\u0012\u00020\u001a0,2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010.\u001a\u00020/H\u0007J&\u00103\u001a\b\u0012\u0004\u0012\u00020!0,2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010.\u001a\u00020/H\u0007JH\u00104\u001a\b\u0012\u0004\u0012\u0002H50,\"\u0004\b\u0000\u001052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010.\u001a\u00020/2\u0006\u00106\u001a\u0002072\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u0002H509H\u0002J:\u0010;\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010<\u001a\u00020\u000f2\u0006\u0010=\u001a\u00020\u000f2\u0010\u0010>\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010@\u0018\u00010?H\u0007R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006A"}, d2={"Lcom/android/tools/profilers/memory/MemoryProfiler$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "importAllocations", "", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "file", "Ljava/io/File;", "isUsingLiveAllocation", "", "session", "Lcom/android/tools/profiler/proto/Common$Session;", "hasOnlyFullAllocationTrackingWithinRegion", "startTimeUs", "", "endTimeUs", "saveHeapDumpToFile", "client", "Lcom/android/tools/profilers/ProfilerClient;", "info", "Lcom/android/tools/profiler/proto/Memory$HeapDumpInfo;", "outputStream", "Ljava/io/OutputStream;", "featureTracker", "Lcom/android/tools/profilers/analytics/FeatureTracker;", "saveAllocationToFile", "saveLegacyAllocationToFile", "Lcom/android/tools/profiler/proto/Memory$AllocationsInfo;", "saveHeapProfdSampleToFile", "Lcom/android/tools/profiler/proto/Trace$TraceInfo;", "saveToFile", "startTime", "onFinished", "Lkotlin/Function0;", "errorMsg", "", "generateCaptureFileName", "getNativeHeapSamplesForSession", "", "kotlin.jvm.PlatformType", "rangeUs", "Lcom/android/tools/adtui/model/Range;", "getNativeHeapEventsForSessionSortedByTimestamp", "Lcom/android/tools/profiler/proto/Common$Event;", "getHeapDumpsForSession", "getAllocationInfosForSession", "getForSession", "T", "eventKind", "Lcom/android/tools/profiler/proto/Common$Event$Kind;", "mapper", "Lkotlin/Function1;", "Lcom/android/tools/profiler/proto/Transport$EventGroup;", "trackAllocations", "enable", "endSession", "responseHandler", "Ljava/util/function/Consumer;", "Lcom/android/tools/profiler/proto/Memory$TrackStatus;", "intellij.android.profilers"})
    @SourceDebugExtension(value={"SMAP\nMemoryProfiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryProfiler.kt\ncom/android/tools/profilers/memory/MemoryProfiler$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,363:1\n1#2:364\n1563#3:365\n1634#3,3:366\n*S KotlinDebug\n*F\n+ 1 MemoryProfiler.kt\ncom/android/tools/profilers/memory/MemoryProfiler$Companion\n*L\n307#1:365\n307#1:366,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLogger() {
            Logger logger = Logger.getInstance(MemoryProfiler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            return logger;
        }

        @JvmStatic
        public final void importAllocations(@NotNull StudioProfilers profilers, @NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            SessionsManager sessionsManager = profilers.getSessionsManager();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)sessionsManager), (String)"getSessionsManager(...)");
            ImportedSessionUtils.importEventBasedArtifact(sessionsManager, file, Common.SessionData.SessionStarted.SessionType.FULL, Common.SessionMetaData.SessionType.FULL, (Function2<? super Long, ? super Long, ? extends List<Common.Event>>)((Function2)Companion::importAllocations$lambda$2));
            profilers.getIdeServices().getFeatureTracker().trackCreateSession(Common.SessionMetaData.SessionType.MEMORY_CAPTURE, SessionsManager.SessionCreationSource.MANUAL);
        }

        @JvmStatic
        public final boolean isUsingLiveAllocation(@NotNull StudioProfilers profilers, @NotNull Common.Session session) {
            Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ProfilerClient profilerClient = profilers.getClient();
            Intrinsics.checkNotNullExpressionValue((Object)profilerClient, (String)"getClient(...)");
            Range range = profilers.getTimeline().getDataRange();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getDataRange(...)");
            List<Memory.AllocationsInfo> it = this.getAllocationInfosForSession(profilerClient, session, range);
            boolean bl = false;
            return !((Collection)it).isEmpty() && !it.get(0).getLegacy();
        }

        @JvmStatic
        public final boolean hasOnlyFullAllocationTrackingWithinRegion(@NotNull StudioProfilers profilers, @NotNull Common.Session session, long startTimeUs, long endTimeUs) {
            Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            AllocationSamplingRateDataSeries series = new AllocationSamplingRateDataSeries(profilers.getClient(), session);
            List<SeriesData<AllocationSamplingRateDurationData>> list = series.getDataForRange(new Range((double)startTimeUs, (double)endTimeUs));
            Intrinsics.checkNotNullExpressionValue(list, (String)"getDataForRange(...)");
            List<SeriesData<AllocationSamplingRateDurationData>> samplingModes = list;
            return samplingModes.size() == 1 && ((AllocationSamplingRateDurationData)samplingModes.get((int)0).value).getCurrentRate().getSamplingNumInterval() == BaseStreamingMemoryProfilerStage.LiveAllocationSamplingMode.FULL.getValue();
        }

        @JvmStatic
        public final void saveHeapDumpToFile(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Memory.HeapDumpInfo info, @NotNull OutputStream outputStream, @NotNull FeatureTracker featureTracker) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
            Intrinsics.checkNotNullParameter((Object)featureTracker, (String)"featureTracker");
            this.saveToFile(client, session, info.getStartTime(), outputStream, (Function0<Unit>)((Function0)new Function0<Unit>((Object)featureTracker){

                public final void invoke() {
                    ((FeatureTracker)this.receiver).trackExportHeap();
                }
            }), "Failed to export heap dump file");
        }

        @JvmStatic
        public final void saveAllocationToFile(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull OutputStream outputStream, @NotNull FeatureTracker featureTracker) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
            Intrinsics.checkNotNullParameter((Object)featureTracker, (String)"featureTracker");
            this.saveToFile(client, session, session.getStartTimestamp(), outputStream, (Function0<Unit>)((Function0)new Function0<Unit>((Object)featureTracker){

                public final void invoke() {
                    ((FeatureTracker)this.receiver).trackExportAllocation();
                }
            }), "Failed to export heap dump file");
        }

        @JvmStatic
        public final void saveLegacyAllocationToFile(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Memory.AllocationsInfo info, @NotNull OutputStream outputStream, @NotNull FeatureTracker featureTracker) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
            Intrinsics.checkNotNullParameter((Object)featureTracker, (String)"featureTracker");
            this.saveToFile(client, session, info.getStartTime(), outputStream, (Function0<Unit>)((Function0)new Function0<Unit>((Object)featureTracker){

                public final void invoke() {
                    ((FeatureTracker)this.receiver).trackExportAllocation();
                }
            }), "Failed to export legacy allocation records");
        }

        @JvmStatic
        public final void saveHeapProfdSampleToFile(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Trace.TraceInfo info, @NotNull OutputStream outputStream) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
            this.saveToFile(client, session, info.getFromTimestamp(), outputStream, (Function0<Unit>)((Function0)Companion::saveHeapProfdSampleToFile$lambda$4), "Failed to export native allocation records");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void saveToFile(ProfilerClient client, Common.Session session, long startTime, OutputStream outputStream, Function0<Unit> onFinished, String errorMsg) {
            Transport.FileResponse response = client.getTransportClient().getFile(Transport.BytesRequest.newBuilder().setStreamId(session.getStreamId()).setId(String.valueOf(startTime)).build());
            String string = response.getFilePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFilePath(...)");
            if (((CharSequence)string).length() > 0) {
                try {
                    Closeable closeable = new FileInputStream(new File(response.getFilePath()));
                    Throwable throwable = null;
                    try {
                        FileInputStream it = (FileInputStream)closeable;
                        boolean bl = false;
                        long l = ByteStreamsKt.copyTo$default((InputStream)it, (OutputStream)outputStream, (int)0, (int)2, null);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    onFinished.invoke();
                }
                catch (IOException exception) {
                    this.getLogger().warn(errorMsg + ":\n" + exception);
                }
            }
        }

        @JvmStatic
        @NotNull
        public final String generateCaptureFileName() {
            return "memory-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss"));
        }

        @JvmStatic
        @NotNull
        public final List<Trace.TraceInfo> getNativeHeapSamplesForSession(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Range rangeUs) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)rangeUs, (String)"rangeUs");
            return this.getForSession(client, session, rangeUs, Common.Event.Kind.MEMORY_TRACE, Companion::getNativeHeapSamplesForSession$lambda$6);
        }

        @JvmStatic
        @NotNull
        public final List<Common.Event> getNativeHeapEventsForSessionSortedByTimestamp(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Range rangeUs) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)rangeUs, (String)"rangeUs");
            return CollectionsKt.sortedWith((Iterable)this.getForSession(client, session, rangeUs, Common.Event.Kind.TRACE_STATUS, Companion::getNativeHeapEventsForSessionSortedByTimestamp$lambda$7), (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Common.Event it = (Common.Event)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.getTimestamp());
                    it = (Common.Event)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTimestamp()));
                }
            });
        }

        @JvmStatic
        @NotNull
        public final List<Memory.HeapDumpInfo> getHeapDumpsForSession(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Range rangeUs) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)rangeUs, (String)"rangeUs");
            return this.getForSession(client, session, rangeUs, Common.Event.Kind.MEMORY_HEAP_DUMP, Companion::getHeapDumpsForSession$lambda$9);
        }

        @JvmStatic
        @NotNull
        public final List<Memory.AllocationsInfo> getAllocationInfosForSession(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Range rangeUs) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)rangeUs, (String)"rangeUs");
            return this.getForSession(client, session, rangeUs, Common.Event.Kind.MEMORY_ALLOC_TRACKING, arg_0 -> Companion.getAllocationInfosForSession$lambda$10(session, arg_0));
        }

        /*
         * WARNING - void declaration
         */
        private final <T> List<T> getForSession(ProfilerClient client, Common.Session session, Range rangeUs, Common.Event.Kind eventKind, Function1<? super Transport.EventGroup, ? extends T> mapper) {
            void $this$mapTo$iv$iv;
            Transport.GetEventGroupsRequest it = Transport.GetEventGroupsRequest.newBuilder().setStreamId(session.getStreamId()).setPid(session.getPid()).setKind(eventKind).setFromTimestamp(MemoryProfilerKt.access$microsToNanos(rangeUs.getMin())).setToTimestamp(MemoryProfilerKt.access$microsToNanos(rangeUs.getMax())).build();
            boolean bl = false;
            List list = client.getTransportClient().getEventGroups(it).getGroupsList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getGroupsList(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                destination$iv$iv.add(mapper.invoke(item$iv$iv));
            }
            return (List)destination$iv$iv;
        }

        @JvmStatic
        public final void trackAllocations(@NotNull StudioProfilers profilers, @NotNull Common.Session session, boolean enable, boolean endSession, @Nullable Consumer<Memory.TrackStatus> responseHandler) {
            Commands.Command.Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            long timeNs = profilers.getClient().getTransportClient().getCurrentTime(Transport.TimeRequest.newBuilder().setStreamId(session.getStreamId()).build()).getTimestampNs();
            Commands.Command.Builder $this$trackAllocations_u24lambda_u2412 = builder = Commands.Command.newBuilder();
            boolean bl = false;
            $this$trackAllocations_u24lambda_u2412.setStreamId(session.getStreamId());
            $this$trackAllocations_u24lambda_u2412.setPid(session.getPid());
            if (enable) {
                $this$trackAllocations_u24lambda_u2412.setType(Commands.Command.CommandType.START_ALLOC_TRACKING);
                v0 = $this$trackAllocations_u24lambda_u2412.setStartAllocTracking(Memory.StartAllocTracking.newBuilder().setRequestTime(timeNs));
            } else {
                $this$trackAllocations_u24lambda_u2412.setType(Commands.Command.CommandType.STOP_ALLOC_TRACKING);
                Companion.getLogger().info("Profiler: End session " + $this$trackAllocations_u24lambda_u2412.getSessionId() + " track allocations log, if allocation stop tracking requested; isSessionAlive = " + profilers.getSessionsManager().isSessionAlive());
                if (endSession) {
                    $this$trackAllocations_u24lambda_u2412.setSessionId(session.getSessionId());
                    Companion.getLogger().info("Profiler: End session " + $this$trackAllocations_u24lambda_u2412.getSessionId() + " track allocations log, if end session is true; isSessionAlive = " + profilers.getSessionsManager().isSessionAlive());
                }
                v0 = $this$trackAllocations_u24lambda_u2412.setStopAllocTracking(Memory.StopAllocTracking.newBuilder().setRequestTime(timeNs));
            }
            Commands.Command.Builder trackCommand = builder;
            Transport.ExecuteResponse response = profilers.getClient().getTransportClient().execute(Transport.ExecuteRequest.newBuilder().setCommand(trackCommand).build());
            if (responseHandler != null) {
                TransportEventListener statusListener = new TransportEventListener(Common.Event.Kind.MEMORY_ALLOC_TRACKING_STATUS, profilers.getIdeServices().getMainExecutor(), arg_0 -> Companion.trackAllocations$lambda$13(response, arg_0), () -> Companion.trackAllocations$lambda$14(session), () -> Companion.trackAllocations$lambda$15(session), null, null, null, arg_0 -> Companion.trackAllocations$lambda$17(responseHandler, arg_0), 224, null);
                profilers.getTransportPoller().registerListener(statusListener);
            }
        }

        private static final Unit importAllocations$lambda$2$lambda$0(Memory.AllocationsInfo $startInfo, Common.Event.Builder $this$makeStartedEvent) {
            Intrinsics.checkNotNullParameter((Object)$this$makeStartedEvent, (String)"$this$makeStartedEvent");
            $this$makeStartedEvent.setMemoryAllocTracking(Memory.MemoryAllocTrackingData.newBuilder().setInfo($startInfo));
            return Unit.INSTANCE;
        }

        private static final Unit importAllocations$lambda$2$lambda$1(Memory.AllocationsInfo $endInfo, Common.Event.Builder $this$makeEndedEvent) {
            Intrinsics.checkNotNullParameter((Object)$this$makeEndedEvent, (String)"$this$makeEndedEvent");
            $this$makeEndedEvent.setMemoryAllocTracking(Memory.MemoryAllocTrackingData.newBuilder().setInfo($endInfo));
            return Unit.INSTANCE;
        }

        private static final List importAllocations$lambda$2(long start, long end) {
            Memory.AllocationsInfo startInfo = Memory.AllocationsInfo.newBuilder().setStartTime(start).setEndTime(Long.MAX_VALUE).build();
            Memory.AllocationsInfo endInfo = Memory.AllocationsInfo.newBuilder().setStartTime(start).setEndTime(end).setSuccess(true).build();
            Object[] objectArray = new Common.Event[]{ImportedSessionUtils.makeStartedEvent(start, start, Common.Event.Kind.MEMORY_ALLOC_TRACKING, (Function1<? super Common.Event.Builder, Unit>)((Function1)arg_0 -> Companion.importAllocations$lambda$2$lambda$0(startInfo, arg_0))), ImportedSessionUtils.makeEndedEvent(start, end, Common.Event.Kind.MEMORY_ALLOC_TRACKING, (Function1<? super Common.Event.Builder, Unit>)((Function1)arg_0 -> Companion.importAllocations$lambda$2$lambda$1(endInfo, arg_0)))};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        private static final Unit saveHeapProfdSampleToFile$lambda$4() {
            return Unit.INSTANCE;
        }

        private static final Trace.TraceInfo getNativeHeapSamplesForSession$lambda$6(Transport.EventGroup it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return MemoryProfilerKt.access$last(it).getTraceData().hasTraceStarted() ? MemoryProfilerKt.access$last(it).getTraceData().getTraceStarted().getTraceInfo() : MemoryProfilerKt.access$last(it).getTraceData().getTraceEnded().getTraceInfo();
        }

        private static final Common.Event getNativeHeapEventsForSessionSortedByTimestamp$lambda$7(Transport.EventGroup it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return MemoryProfilerKt.access$last(it);
        }

        private static final Memory.HeapDumpInfo getHeapDumpsForSession$lambda$9(Transport.EventGroup it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return MemoryProfilerKt.access$last(it).getMemoryHeapdump().getInfo();
        }

        private static final Memory.AllocationsInfo getAllocationInfosForSession$lambda$10(Common.Session $session, Transport.EventGroup it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Memory.AllocationsInfo info = MemoryProfilerKt.access$last(it).getMemoryAllocTracking().getInfo();
            if (Intrinsics.areEqual((Object)info, (Object)Memory.AllocationsInfo.getDefaultInstance())) {
                boolean bl;
                boolean bl2 = bl = it.getEventsCount() > 1;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                info = it.getEvents(0).getMemoryAllocTracking().getInfo();
                if (info.getLegacy() && info.getEndTime() == Long.MAX_VALUE) {
                    info = info.toBuilder().setEndTime($session.getEndTimestamp()).setSuccess(false).build();
                }
            }
            return info;
        }

        private static final boolean trackAllocations$lambda$13(Transport.ExecuteResponse $response, Common.Event event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            return event.getCommandId() == $response.getCommandId();
        }

        private static final long trackAllocations$lambda$14(Common.Session $session) {
            return $session.getStreamId();
        }

        private static final int trackAllocations$lambda$15(Common.Session $session) {
            return $session.getPid();
        }

        private static final boolean trackAllocations$lambda$17(Consumer $responseHandler, Common.Event event) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            boolean it = bl = true;
            boolean bl2 = false;
            $responseHandler.accept(event.getMemoryAllocTrackingStatus().getStatus());
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

