/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.Interpolatable;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.adtui.model.legend.EventLegend;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.model.legend.SeriesLegend;
import com.android.tools.profilers.memory.AllocationSamplingRateDurationData;
import com.android.tools.profilers.memory.BaseStreamingMemoryProfilerStage;
import com.android.tools.profilers.memory.DetailedMemoryUsage;
import com.android.tools.profilers.memory.GcDurationData;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\u0004\b\n\u0010\u000bB/\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\u0004\b\n\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\u0015\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0011\u0010\u0017\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0010R\u0011\u0010\u0019\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0010R\u0011\u0010\u001b\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0010R\u0011\u0010\u001d\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0010R\u001f\u0010\u001f\u001a\u0010\u0012\f\u0012\n \"*\u0004\u0018\u00010!0!0 \u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001f\u0010%\u001a\u0010\u0012\f\u0012\n \"*\u0004\u0018\u00010&0&0 \u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010$\u00a8\u0006("}, d2={"Lcom/android/tools/profilers/memory/MemoryStageLegends;", "Lcom/android/tools/adtui/model/legend/LegendComponentModel;", "range", "Lcom/android/tools/adtui/model/Range;", "isTooltip", "", "usage", "Lcom/android/tools/profilers/memory/DetailedMemoryUsage;", "isLiveAllocationTrackingReady", "Lkotlin/Function0;", "<init>", "(Lcom/android/tools/adtui/model/Range;ZLcom/android/tools/profilers/memory/DetailedMemoryUsage;Lkotlin/jvm/functions/Function0;)V", "(Lcom/android/tools/profilers/memory/DetailedMemoryUsage;Lcom/android/tools/adtui/model/Range;ZLkotlin/jvm/functions/Function0;)V", "javaLegend", "Lcom/android/tools/adtui/model/legend/SeriesLegend;", "getJavaLegend", "()Lcom/android/tools/adtui/model/legend/SeriesLegend;", "nativeLegend", "getNativeLegend", "graphicsLegend", "getGraphicsLegend", "stackLegend", "getStackLegend", "codeLegend", "getCodeLegend", "otherLegend", "getOtherLegend", "totalLegend", "getTotalLegend", "objectsLegend", "getObjectsLegend", "gcDurationLegend", "Lcom/android/tools/adtui/model/legend/EventLegend;", "Lcom/android/tools/profilers/memory/GcDurationData;", "kotlin.jvm.PlatformType", "getGcDurationLegend", "()Lcom/android/tools/adtui/model/legend/EventLegend;", "samplingRateDurationLegend", "Lcom/android/tools/profilers/memory/AllocationSamplingRateDurationData;", "getSamplingRateDurationLegend", "intellij.android.profilers"})
@SourceDebugExtension(value={"SMAP\nMemoryStageLegends.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryStageLegends.kt\ncom/android/tools/profilers/memory/MemoryStageLegends\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1869#2,2:69\n*S KotlinDebug\n*F\n+ 1 MemoryStageLegends.kt\ncom/android/tools/profilers/memory/MemoryStageLegends\n*L\n66#1:69,2\n*E\n"})
public final class MemoryStageLegends
extends LegendComponentModel {
    @NotNull
    private final SeriesLegend javaLegend;
    @NotNull
    private final SeriesLegend nativeLegend;
    @NotNull
    private final SeriesLegend graphicsLegend;
    @NotNull
    private final SeriesLegend stackLegend;
    @NotNull
    private final SeriesLegend codeLegend;
    @NotNull
    private final SeriesLegend otherLegend;
    @NotNull
    private final SeriesLegend totalLegend;
    @NotNull
    private final SeriesLegend objectsLegend;
    @NotNull
    private final EventLegend<GcDurationData> gcDurationLegend;
    @NotNull
    private final EventLegend<AllocationSamplingRateDurationData> samplingRateDurationLegend;

    private MemoryStageLegends(Range range, boolean isTooltip, DetailedMemoryUsage usage, Function0<Boolean> isLiveAllocationTrackingReady) {
        super(range);
        List list;
        this.javaLegend = new SeriesLegend(usage.getJavaSeries(), BaseStreamingMemoryProfilerStage.Companion.getMEMORY_AXIS_FORMATTER(), range);
        this.nativeLegend = new SeriesLegend(usage.getNativeSeries(), BaseStreamingMemoryProfilerStage.Companion.getMEMORY_AXIS_FORMATTER(), range);
        this.graphicsLegend = new SeriesLegend(usage.getGraphicsSeries(), BaseStreamingMemoryProfilerStage.Companion.getMEMORY_AXIS_FORMATTER(), range);
        this.stackLegend = new SeriesLegend(usage.getStackSeries(), BaseStreamingMemoryProfilerStage.Companion.getMEMORY_AXIS_FORMATTER(), range);
        this.codeLegend = new SeriesLegend(usage.getCodeSeries(), BaseStreamingMemoryProfilerStage.Companion.getMEMORY_AXIS_FORMATTER(), range);
        this.otherLegend = new SeriesLegend(usage.getOtherSeries(), BaseStreamingMemoryProfilerStage.Companion.getMEMORY_AXIS_FORMATTER(), range);
        this.totalLegend = new SeriesLegend(usage.getTotalMemorySeries(), BaseStreamingMemoryProfilerStage.Companion.getMEMORY_AXIS_FORMATTER(), range);
        this.objectsLegend = new SeriesLegend(usage.getObjectsSeries(), BaseStreamingMemoryProfilerStage.Companion.getOBJECT_COUNT_AXIS_FORMATTER(), range, usage.getObjectsSeries().getName(), Interpolatable.RoundedSegmentInterpolator, arg_0 -> MemoryStageLegends.objectsLegend$lambda$1(isLiveAllocationTrackingReady, usage, arg_0));
        this.gcDurationLegend = new EventLegend("GC Duration", MemoryStageLegends::gcDurationLegend$lambda$2);
        this.samplingRateDurationLegend = new EventLegend("Tracking", MemoryStageLegends::samplingRateDurationLegend$lambda$3);
        if (isTooltip) {
            var6_5 = new Legend[]{this.otherLegend, this.codeLegend, this.stackLegend, this.graphicsLegend, this.nativeLegend, this.javaLegend, this.objectsLegend, this.samplingRateDurationLegend, this.gcDurationLegend, this.totalLegend};
            list = CollectionsKt.listOf((Object[])var6_5);
        } else {
            var6_5 = new SeriesLegend[]{this.totalLegend, this.javaLegend, this.nativeLegend, this.graphicsLegend, this.stackLegend, this.codeLegend, this.otherLegend, this.objectsLegend};
            list = CollectionsKt.listOf((Object[])var6_5);
        }
        List legends2 = list;
        Iterable $this$forEach$iv = legends2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Legend p0 = (Legend)element$iv;
            boolean bl = false;
            this.add(p0);
        }
    }

    public MemoryStageLegends(@NotNull DetailedMemoryUsage usage, @NotNull Range range, boolean isTooltip, @NotNull Function0<Boolean> isLiveAllocationTrackingReady) {
        Intrinsics.checkNotNullParameter((Object)((Object)usage), (String)"usage");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter(isLiveAllocationTrackingReady, (String)"isLiveAllocationTrackingReady");
        this(range, isTooltip, usage, isLiveAllocationTrackingReady);
    }

    @NotNull
    public final SeriesLegend getJavaLegend() {
        return this.javaLegend;
    }

    @NotNull
    public final SeriesLegend getNativeLegend() {
        return this.nativeLegend;
    }

    @NotNull
    public final SeriesLegend getGraphicsLegend() {
        return this.graphicsLegend;
    }

    @NotNull
    public final SeriesLegend getStackLegend() {
        return this.stackLegend;
    }

    @NotNull
    public final SeriesLegend getCodeLegend() {
        return this.codeLegend;
    }

    @NotNull
    public final SeriesLegend getOtherLegend() {
        return this.otherLegend;
    }

    @NotNull
    public final SeriesLegend getTotalLegend() {
        return this.totalLegend;
    }

    @NotNull
    public final SeriesLegend getObjectsLegend() {
        return this.objectsLegend;
    }

    @NotNull
    public final EventLegend<GcDurationData> getGcDurationLegend() {
        return this.gcDurationLegend;
    }

    @NotNull
    public final EventLegend<AllocationSamplingRateDurationData> getSamplingRateDurationLegend() {
        return this.samplingRateDurationLegend;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean objectsLegend$lambda$1(Function0 $isLiveAllocationTrackingReady, DetailedMemoryUsage $usage, Range r) {
        if ((Boolean)$isLiveAllocationTrackingReady.invoke() == false) return true;
        RangedSeries rangedSeries = $usage.getAllocationSamplingRateDurations().getSeries();
        Intrinsics.checkNotNull((Object)r);
        List data = rangedSeries.getSeriesForRange(r);
        boolean bl = false;
        if (((Collection)data).isEmpty()) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        if (BaseStreamingMemoryProfilerStage.LiveAllocationSamplingMode.Companion.getModeFromFrequency(((AllocationSamplingRateDurationData)((SeriesData)CollectionsKt.last((List)data)).value).getCurrentRate().getSamplingNumInterval()) != BaseStreamingMemoryProfilerStage.LiveAllocationSamplingMode.FULL) return false;
        return true;
    }

    private static final String gcDurationLegend$lambda$2(GcDurationData duration) {
        Intrinsics.checkNotNullParameter((Object)((Object)duration), (String)"duration");
        return TimeAxisFormatter.DEFAULT.getFormattedString((double)TimeUnit.MILLISECONDS.toMicros(1L), (double)duration.getDurationUs(), true);
    }

    private static final String samplingRateDurationLegend$lambda$3(AllocationSamplingRateDurationData duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return BaseStreamingMemoryProfilerStage.LiveAllocationSamplingMode.Companion.getModeFromFrequency(duration.getCurrentRate().getSamplingNumInterval()).getDisplayName();
    }
}

