/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.perfetto.config;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import perfetto.protos.PerfettoConfig;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\"\u001a\u00020\u000f*\u00020\u000fH\u0002J\b\u0010#\u001a\u00020\u000fH\u0007J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000fJ\b\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020(H\u0002J\b\u0010*\u001a\u00020(H\u0002J\b\u0010+\u001a\u00020(H\u0002J\u0016\u0010,\u001a\u00020%2\u0006\u0010-\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\u0014J\u0018\u0010/\u001a\u00020(2\u0006\u0010-\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\u0014H\u0002J\b\u00100\u001a\u00020%H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/android/tools/profilers/perfetto/config/PerfettoTraceConfigBuilders;", "", "<init>", "()V", "counterFtraceEvents", "", "", "fenceFtraceEvents", "cpuFreqFtraceEvents", "taskTrackingFtraceEvents", "standardAtraceCategories", "verboseAtraceCategories", "batteryCounters", "Lperfetto/protos/PerfettoConfig$AndroidPowerConfig$BatteryCounters;", "FTRACE_DRAIN_PERIOD_MS", "", "FTRACE_COMPACT_SCHED_BUILDER_ENABLED", "", "PERF_EVENT_ALL_CPUS_ENABLED", "SHARED_MEM_BUFFER_BYTES", "", "PROC_STATS_SCAN_ALL_PROCESS_ON_START_ENABLED", "PROC_STATS_RECORD_THREAD_NAMES_ENABLED", "PROCESS_STATS_POLL_INTERVAL_MS", "BATTERY_POLL_INTERVAL_MS", "CPU_TRACE_CONFIG_BUFFER_1_SIZE_KB", "CPU_TRACE_CONFIG_BUFFER_2_SIZE_KB", "MEMORY_TRACE_CONFIG_BUFFER_0_SIZE_KB", "CONTINUOUS_DUMP_INTERVAL_MS", "HEAP_PROFD_ALL_HEAPS_ENABLED", "HEAP_PROFD_BLOCK_CLIENT_ENABLED", "FLUSH_PERIOD_MS", "FILE_WRITE_PERIOD_MS", "WRITE_INTO_FILE_ENABLED", "mbToKb", "getBatteryCountersCount", "getCpuTraceConfig", "Lperfetto/protos/PerfettoConfig$TraceConfig;", "bufferSizeMb", "getFtraceDataConfig", "Lperfetto/protos/PerfettoConfig$DataSourceConfig;", "getProcessAndThreadNamesDataConfig", "getProcStatDataConfig", "getPowerDataConfig", "getMemoryTraceConfig", "appPkgNameOrPid", "samplingIntervalBytes", "getHeapProfdDataConfig", "buildCommonTraceConfig", "intellij.android.profilers"})
public final class PerfettoTraceConfigBuilders {
    @NotNull
    public static final PerfettoTraceConfigBuilders INSTANCE = new PerfettoTraceConfigBuilders();
    @NotNull
    private static final List<String> counterFtraceEvents;
    @NotNull
    private static final List<String> fenceFtraceEvents;
    @NotNull
    private static final List<String> cpuFreqFtraceEvents;
    @NotNull
    private static final List<String> taskTrackingFtraceEvents;
    @NotNull
    private static final List<String> standardAtraceCategories;
    @NotNull
    private static final List<String> verboseAtraceCategories;
    @NotNull
    private static final List<PerfettoConfig.AndroidPowerConfig.BatteryCounters> batteryCounters;
    private static final int FTRACE_DRAIN_PERIOD_MS = 170;
    private static final boolean FTRACE_COMPACT_SCHED_BUILDER_ENABLED = true;
    private static final boolean PERF_EVENT_ALL_CPUS_ENABLED = true;
    private static final long SHARED_MEM_BUFFER_BYTES = 0x4000000L;
    private static final boolean PROC_STATS_SCAN_ALL_PROCESS_ON_START_ENABLED = true;
    private static final boolean PROC_STATS_RECORD_THREAD_NAMES_ENABLED = true;
    private static final int PROCESS_STATS_POLL_INTERVAL_MS = 1000;
    private static final int BATTERY_POLL_INTERVAL_MS = 250;
    private static final int CPU_TRACE_CONFIG_BUFFER_1_SIZE_KB = 256;
    private static final int CPU_TRACE_CONFIG_BUFFER_2_SIZE_KB = 4096;
    private static final int MEMORY_TRACE_CONFIG_BUFFER_0_SIZE_KB = 131072;
    private static final int CONTINUOUS_DUMP_INTERVAL_MS = 0;
    private static final boolean HEAP_PROFD_ALL_HEAPS_ENABLED = true;
    private static final boolean HEAP_PROFD_BLOCK_CLIENT_ENABLED = true;
    private static final int FLUSH_PERIOD_MS = 1000;
    private static final int FILE_WRITE_PERIOD_MS = 250;
    private static final boolean WRITE_INTO_FILE_ENABLED = true;

    private PerfettoTraceConfigBuilders() {
    }

    private final int mbToKb(int $this$mbToKb) {
        return $this$mbToKb * 1024;
    }

    @JvmStatic
    public static final int getBatteryCountersCount() {
        return batteryCounters.size();
    }

    @NotNull
    public final PerfettoConfig.TraceConfig getCpuTraceConfig(int bufferSizeMb) {
        PerfettoConfig.TraceConfig config = this.buildCommonTraceConfig();
        PerfettoConfig.TraceConfig.Builder configBuilder = config.toBuilder();
        configBuilder.addBuffers(PerfettoConfig.TraceConfig.BufferConfig.newBuilder().setSizeKb(this.mbToKb(bufferSizeMb)));
        configBuilder.addBuffers(PerfettoConfig.TraceConfig.BufferConfig.newBuilder().setSizeKb(256));
        configBuilder.addBuffers(PerfettoConfig.TraceConfig.BufferConfig.newBuilder().setSizeKb(4096));
        PerfettoConfig.TraceConfig.DataSource.Builder ftraceDataSource = PerfettoConfig.TraceConfig.DataSource.newBuilder().setConfig(this.getFtraceDataConfig());
        PerfettoConfig.TraceConfig.DataSource.Builder processAndThreadNamesDataSource = PerfettoConfig.TraceConfig.DataSource.newBuilder().setConfig(this.getProcessAndThreadNamesDataConfig());
        PerfettoConfig.TraceConfig.DataSource.Builder procStatDataSource = PerfettoConfig.TraceConfig.DataSource.newBuilder().setConfig(this.getProcStatDataConfig());
        PerfettoConfig.DataSourceConfig.Builder cpuInfoDataConfig = PerfettoConfig.DataSourceConfig.newBuilder().setName("linux.system_info");
        PerfettoConfig.TraceConfig.DataSource.Builder cpuInfoDataSource = PerfettoConfig.TraceConfig.DataSource.newBuilder().setConfig(cpuInfoDataConfig);
        PerfettoConfig.DataSourceConfig.Builder lifecycleDataConfig = PerfettoConfig.DataSourceConfig.newBuilder().setName("android.surfaceflinger.frame");
        PerfettoConfig.TraceConfig.DataSource.Builder lifeCycleDataSource = PerfettoConfig.TraceConfig.DataSource.newBuilder().setConfig(lifecycleDataConfig);
        PerfettoConfig.DataSourceConfig.Builder frameTimelineDataConfig = PerfettoConfig.DataSourceConfig.newBuilder().setName("android.surfaceflinger.frametimeline");
        PerfettoConfig.TraceConfig.DataSource.Builder frameTimelineDataSource = PerfettoConfig.TraceConfig.DataSource.newBuilder().setConfig(frameTimelineDataConfig);
        PerfettoConfig.DataSourceConfig.Builder trackEventDataConfig = PerfettoConfig.DataSourceConfig.newBuilder().setName("track_event");
        PerfettoConfig.TraceConfig.DataSource.Builder trackEventDataSource = PerfettoConfig.TraceConfig.DataSource.newBuilder().setConfig(trackEventDataConfig);
        PerfettoConfig.TraceConfig.DataSource.Builder powerDataSource = PerfettoConfig.TraceConfig.DataSource.newBuilder().setConfig(this.getPowerDataConfig());
        configBuilder.addDataSources(ftraceDataSource);
        configBuilder.addDataSources(processAndThreadNamesDataSource);
        configBuilder.addDataSources(procStatDataSource);
        configBuilder.addDataSources(cpuInfoDataSource);
        configBuilder.addDataSources(lifeCycleDataSource);
        configBuilder.addDataSources(frameTimelineDataSource);
        configBuilder.addDataSources(trackEventDataSource);
        configBuilder.addDataSources(powerDataSource);
        PerfettoConfig.TraceConfig traceConfig = configBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)traceConfig, (String)"build(...)");
        return traceConfig;
    }

    private final PerfettoConfig.DataSourceConfig getFtraceDataConfig() {
        PerfettoConfig.DataSourceConfig.Builder ftraceDataConfig = PerfettoConfig.DataSourceConfig.newBuilder().setName("linux.ftrace").setTargetBuffer(0);
        PerfettoConfig.FtraceConfig.Builder ftraceConfig = ftraceDataConfig.getFtraceConfig().toBuilder();
        ftraceConfig.setDrainPeriodMs(170);
        ftraceConfig.getCompactSchedBuilder().setEnabled(true);
        ftraceConfig.addAllFtraceEvents((Iterable)counterFtraceEvents);
        ftraceConfig.addAllFtraceEvents((Iterable)fenceFtraceEvents);
        ftraceConfig.addAllFtraceEvents((Iterable)cpuFreqFtraceEvents);
        ftraceConfig.addAllFtraceEvents((Iterable)taskTrackingFtraceEvents);
        ftraceConfig.addAllAtraceCategories((Iterable)standardAtraceCategories);
        ftraceConfig.addAllAtraceCategories((Iterable)verboseAtraceCategories);
        PerfettoConfig.PerfEventConfig.Builder perfEventConfig = ftraceDataConfig.getPerfEventConfig().toBuilder();
        perfEventConfig.setAllCpus(true);
        ftraceDataConfig.setPerfEventConfig(perfEventConfig.build());
        ftraceConfig.addAtraceApps("*");
        ftraceDataConfig.setFtraceConfig(ftraceConfig.build());
        PerfettoConfig.DataSourceConfig dataSourceConfig = ftraceDataConfig.build();
        Intrinsics.checkNotNullExpressionValue((Object)dataSourceConfig, (String)"build(...)");
        return dataSourceConfig;
    }

    private final PerfettoConfig.DataSourceConfig getProcessAndThreadNamesDataConfig() {
        PerfettoConfig.DataSourceConfig.Builder processAndThreadNamesDataConfig = PerfettoConfig.DataSourceConfig.newBuilder().setName("linux.process_stats").setTargetBuffer(1);
        PerfettoConfig.ProcessStatsConfig.Builder procStatsConfig = processAndThreadNamesDataConfig.getProcessStatsConfig().toBuilder();
        procStatsConfig.setScanAllProcessesOnStart(true);
        procStatsConfig.setRecordThreadNames(true);
        processAndThreadNamesDataConfig.setProcessStatsConfig(procStatsConfig.build());
        PerfettoConfig.DataSourceConfig dataSourceConfig = processAndThreadNamesDataConfig.build();
        Intrinsics.checkNotNullExpressionValue((Object)dataSourceConfig, (String)"build(...)");
        return dataSourceConfig;
    }

    private final PerfettoConfig.DataSourceConfig getProcStatDataConfig() {
        PerfettoConfig.DataSourceConfig.Builder procStatDataConfig = PerfettoConfig.DataSourceConfig.newBuilder().setName("linux.process_stats").setTargetBuffer(0);
        PerfettoConfig.ProcessStatsConfig.Builder procStatProcessStatsConfig = procStatDataConfig.getProcessStatsConfig().toBuilder();
        procStatProcessStatsConfig.setProcStatsPollMs(1000);
        procStatProcessStatsConfig.addQuirks(PerfettoConfig.ProcessStatsConfig.Quirks.DISABLE_ON_DEMAND);
        procStatDataConfig.setProcessStatsConfig(procStatProcessStatsConfig.build());
        PerfettoConfig.DataSourceConfig dataSourceConfig = procStatDataConfig.build();
        Intrinsics.checkNotNullExpressionValue((Object)dataSourceConfig, (String)"build(...)");
        return dataSourceConfig;
    }

    private final PerfettoConfig.DataSourceConfig getPowerDataConfig() {
        PerfettoConfig.DataSourceConfig.Builder powerDataConfig = PerfettoConfig.DataSourceConfig.newBuilder().setName("android.power").setTargetBuffer(2);
        PerfettoConfig.AndroidPowerConfig.Builder androidPowerConfig = powerDataConfig.getAndroidPowerConfig().toBuilder();
        androidPowerConfig.setCollectPowerRails(true);
        androidPowerConfig.setBatteryPollMs(250);
        androidPowerConfig.addAllBatteryCounters((Iterable)batteryCounters);
        powerDataConfig.setAndroidPowerConfig(androidPowerConfig.build());
        PerfettoConfig.DataSourceConfig dataSourceConfig = powerDataConfig.build();
        Intrinsics.checkNotNullExpressionValue((Object)dataSourceConfig, (String)"build(...)");
        return dataSourceConfig;
    }

    @NotNull
    public final PerfettoConfig.TraceConfig getMemoryTraceConfig(@NotNull String appPkgNameOrPid, long samplingIntervalBytes) {
        Intrinsics.checkNotNullParameter((Object)appPkgNameOrPid, (String)"appPkgNameOrPid");
        PerfettoConfig.TraceConfig config = this.buildCommonTraceConfig();
        PerfettoConfig.TraceConfig.Builder configBuilder = config.toBuilder();
        configBuilder.addBuffers(PerfettoConfig.TraceConfig.BufferConfig.newBuilder().setSizeKb(131072));
        PerfettoConfig.TraceConfig.DataSource.Builder heapProfdDataSource = PerfettoConfig.TraceConfig.DataSource.newBuilder().setConfig(this.getHeapProfdDataConfig(appPkgNameOrPid, samplingIntervalBytes));
        configBuilder.addDataSources(heapProfdDataSource);
        PerfettoConfig.TraceConfig traceConfig = configBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)traceConfig, (String)"build(...)");
        return traceConfig;
    }

    private final PerfettoConfig.DataSourceConfig getHeapProfdDataConfig(String appPkgNameOrPid, long samplingIntervalBytes) {
        PerfettoConfig.DataSourceConfig.Builder heapProfdDataConfig = PerfettoConfig.DataSourceConfig.newBuilder().setName("android.heapprofd");
        PerfettoConfig.HeapprofdConfig.Builder heapProfdConfig = heapProfdDataConfig.getHeapprofdConfig().toBuilder();
        heapProfdConfig.setSamplingIntervalBytes(samplingIntervalBytes);
        heapProfdConfig.addProcessCmdline(appPkgNameOrPid);
        heapProfdConfig.setShmemSizeBytes(0x4000000L);
        PerfettoConfig.HeapprofdConfig.ContinuousDumpConfig.Builder continuousDumpConfig = heapProfdConfig.getContinuousDumpConfig().toBuilder();
        continuousDumpConfig.setDumpIntervalMs(0);
        heapProfdConfig.setAllHeaps(true);
        heapProfdConfig.setBlockClient(true);
        heapProfdConfig.setContinuousDumpConfig(continuousDumpConfig.build());
        heapProfdDataConfig.setHeapprofdConfig(heapProfdConfig.build());
        PerfettoConfig.DataSourceConfig dataSourceConfig = heapProfdDataConfig.build();
        Intrinsics.checkNotNullExpressionValue((Object)dataSourceConfig, (String)"build(...)");
        return dataSourceConfig;
    }

    private final PerfettoConfig.TraceConfig buildCommonTraceConfig() {
        PerfettoConfig.TraceConfig traceConfig = PerfettoConfig.TraceConfig.newBuilder().setWriteIntoFile(true).setFlushPeriodMs(1000).setFileWritePeriodMs(250).build();
        Intrinsics.checkNotNullExpressionValue((Object)traceConfig, (String)"build(...)");
        return traceConfig;
    }

    static {
        Object[] objectArray = new String[]{"thermal/thermal_temperature", "perf_trace_counters/perf_trace_user"};
        counterFtraceEvents = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"fence/signaled", "fence/fence_wait_start"};
        fenceFtraceEvents = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"power/cpu_frequency", "power/cpu_idle"};
        cpuFreqFtraceEvents = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"task/task_rename", "task/task_newtask"};
        taskTrackingFtraceEvents = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"gfx", "input", "view", "wm", "am", "sm", "camera", "hal", "res", "pm", "ss", "power", "database", "dalvik", "audio", "binder_driver", "binder_lock"};
        standardAtraceCategories = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"sched", "freq"};
        verboseAtraceCategories = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new PerfettoConfig.AndroidPowerConfig.BatteryCounters[]{PerfettoConfig.AndroidPowerConfig.BatteryCounters.BATTERY_COUNTER_CAPACITY_PERCENT, PerfettoConfig.AndroidPowerConfig.BatteryCounters.BATTERY_COUNTER_CHARGE, PerfettoConfig.AndroidPowerConfig.BatteryCounters.BATTERY_COUNTER_CURRENT};
        batteryCounters = CollectionsKt.listOf((Object[])objectArray);
    }
}

