/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.taskbased.task.interim;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.profilers.InterimStage;
import com.android.tools.profilers.RecordingOptionsModel;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StreamingStage;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.memory.MainMemoryProfilerStage;
import com.android.tools.profilers.tasks.ProfilerTaskType;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 )*\f\b\u0000\u0010\u0001*\u00020\u0002*\u00020\u00032\u00020\u00042\u00020\u0005:\u0001)B\u000f\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\"J\u0010\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\rH\u0002J\u0010\u0010(\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0018R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0018R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/android/tools/profilers/taskbased/task/interim/RecordingScreenModel;", "T", "Lcom/android/tools/profilers/StreamingStage;", "Lcom/android/tools/profilers/InterimStage;", "Lcom/android/tools/adtui/model/AspectObserver;", "Lcom/android/tools/adtui/model/updater/Updatable;", "stage", "<init>", "(Lcom/android/tools/profilers/StreamingStage;)V", "taskType", "Lcom/android/tools/profilers/tasks/ProfilerTaskType;", "kotlin.jvm.PlatformType", "isUserStoppable", "", "()Z", "taskName", "", "getTaskName", "()Ljava/lang/String;", "_canRecordingStop", "Lkotlinx/coroutines/flow/MutableStateFlow;", "canRecordingStop", "Lkotlinx/coroutines/flow/StateFlow;", "getCanRecordingStop", "()Lkotlinx/coroutines/flow/StateFlow;", "_isStopButtonClicked", "isStopButtonClicked", "_isRecordingFailed", "isRecordingFailed", "_elapsedNs", "", "elapsedNs", "getElapsedNs", "onStopRecordingButtonClick", "", "setRecordingFailed", "setCanRecordingStop", "canStop", "stopRecordingAction", "Ljava/lang/Runnable;", "update", "Companion", "intellij.android.profilers"})
public final class RecordingScreenModel<T extends StreamingStage>
extends AspectObserver
implements Updatable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final ProfilerTaskType taskType;
    private final boolean isUserStoppable;
    @NotNull
    private final String taskName;
    @NotNull
    private final MutableStateFlow<Boolean> _canRecordingStop;
    @NotNull
    private final StateFlow<Boolean> canRecordingStop;
    @NotNull
    private final MutableStateFlow<Boolean> _isStopButtonClicked;
    @NotNull
    private final StateFlow<Boolean> isStopButtonClicked;
    @NotNull
    private final MutableStateFlow<Boolean> _isRecordingFailed;
    @NotNull
    private final StateFlow<Boolean> isRecordingFailed;
    @NotNull
    private final MutableStateFlow<Long> _elapsedNs;
    @NotNull
    private final StateFlow<Long> elapsedNs;
    @NotNull
    private final Runnable stopRecordingAction;

    public RecordingScreenModel(@NotNull T stage) {
        Intrinsics.checkNotNullParameter(stage, (String)"stage");
        this.taskType = ((Stage)((Object)stage)).getStudioProfilers().getSessionsManager().getCurrentTaskType();
        this.isUserStoppable = this.taskType != ProfilerTaskType.HEAP_DUMP;
        this.taskName = this.taskType.getDescription();
        this._canRecordingStop = StateFlowKt.MutableStateFlow((Object)false);
        this.canRecordingStop = FlowKt.asStateFlow(this._canRecordingStop);
        this._isStopButtonClicked = StateFlowKt.MutableStateFlow((Object)false);
        this.isStopButtonClicked = FlowKt.asStateFlow(this._isStopButtonClicked);
        this._isRecordingFailed = StateFlowKt.MutableStateFlow((Object)false);
        this.isRecordingFailed = FlowKt.asStateFlow(this._isRecordingFailed);
        this._elapsedNs = StateFlowKt.MutableStateFlow((Object)0L);
        this.elapsedNs = FlowKt.asStateFlow(this._elapsedNs);
        T t = stage;
        RecordingOptionsModel recordingModel = t instanceof CpuProfilerStage ? ((CpuProfilerStage)stage).getRecordingModel() : (t instanceof MainMemoryProfilerStage ? ((MainMemoryProfilerStage)stage).getRecordingOptionsModel() : null);
        RecordingOptionsModel recordingOptionsModel = recordingModel;
        if (recordingOptionsModel != null && (recordingOptionsModel = recordingOptionsModel.addDependency(this)) != null) {
            recordingOptionsModel.onChange(RecordingOptionsModel.Aspect.RECORDING_CHANGED, () -> RecordingScreenModel._init_$lambda$0(this, recordingModel));
        }
        this.stopRecordingAction = () -> RecordingScreenModel.stopRecordingAction$lambda$1(stage);
    }

    public final boolean isUserStoppable() {
        return this.isUserStoppable;
    }

    @NotNull
    public final String getTaskName() {
        return this.taskName;
    }

    @NotNull
    public final StateFlow<Boolean> getCanRecordingStop() {
        return this.canRecordingStop;
    }

    @NotNull
    public final StateFlow<Boolean> isStopButtonClicked() {
        return this.isStopButtonClicked;
    }

    @NotNull
    public final StateFlow<Boolean> isRecordingFailed() {
        return this.isRecordingFailed;
    }

    @NotNull
    public final StateFlow<Long> getElapsedNs() {
        return this.elapsedNs;
    }

    public final void onStopRecordingButtonClick() {
        this._isStopButtonClicked.setValue((Object)true);
        this.stopRecordingAction.run();
    }

    public final void setRecordingFailed() {
        this._isRecordingFailed.setValue((Object)true);
    }

    private final void setCanRecordingStop(boolean canStop) {
        this._canRecordingStop.setValue((Object)canStop);
    }

    public void update(long elapsedNs) {
        MutableStateFlow<Long> mutableStateFlow = this._elapsedNs;
        mutableStateFlow.setValue((Object)(((Number)mutableStateFlow.getValue()).longValue() + elapsedNs));
    }

    public void postUpdate() {
        super.postUpdate();
    }

    public void reset() {
        super.reset();
    }

    private static final void _init_$lambda$0(RecordingScreenModel this$0, RecordingOptionsModel $recordingModel) {
        this$0.setCanRecordingStop($recordingModel.canStop());
    }

    private static final void stopRecordingAction$lambda$1(StreamingStage $stage) {
        ((InterimStage)((Object)$stage)).stop();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/profilers/taskbased/task/interim/RecordingScreenModel$Companion;", "", "<init>", "()V", "formatElapsedTime", "", "elapsedNs", "", "intellij.android.profilers"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String formatElapsedTime(long elapsedNs) {
            long minutes = TimeUnit.NANOSECONDS.toMinutes(elapsedNs);
            long seconds = TimeUnit.NANOSECONDS.toSeconds(elapsedNs) - TimeUnit.MINUTES.toSeconds(minutes);
            return minutes + " min, " + seconds + " sec";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

