/*
 * Decompiled with CFR 0.152.
 */
package trebuchet.extractors.html;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import trebuchet.extractors.Extractor;
import trebuchet.extractors.ExtractorFactory;
import trebuchet.importers.ImportFeedback;
import trebuchet.io.BufferProducer;
import trebuchet.io.DataSlice;
import trebuchet.io.GenericByteBuffer;
import trebuchet.io.Pipe;
import trebuchet.io.StreamingReader;
import trebuchet.util.StringSearch;
import trebuchet.util.StringSearchKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0003\u0014\u0015\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\fH\u0016J\u001e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ltrebuchet/extractors/html/SystraceExtractor;", "Ltrebuchet/extractors/Extractor;", "<init>", "()V", "startIndex", "", "endIndex", "extract", "", "stream", "Ltrebuchet/io/StreamingReader;", "processSubStream", "Lkotlin/Function1;", "Ltrebuchet/io/BufferProducer;", "processWindow", "window", "Ltrebuchet/io/StreamingReader$Window;", "pipe", "Ltrebuchet/io/Pipe;", "Ltrebuchet/io/DataSlice;", "SubStream", "Companion", "Factory", "intellij.android.profilers.atrace"})
@SourceDebugExtension(value={"SMAP\nSystraceExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SystraceExtractor.kt\ntrebuchet/extractors/html/SystraceExtractor\n+ 2 DataSlice.kt\ntrebuchet/io/DataSlice\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n33#2,5:91\n1869#3,2:96\n*S KotlinDebug\n*F\n+ 1 SystraceExtractor.kt\ntrebuchet/extractors/html/SystraceExtractor\n*L\n72#1:91,5\n48#1:96,2\n*E\n"})
public final class SystraceExtractor
implements Extractor {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private int startIndex;
    private int endIndex = Integer.MAX_VALUE;
    @NotNull
    private static final StringSearch START = StringSearchKt.searchFor("<script class=\"trace-data\" type=\"application/text\">");
    @NotNull
    private static final StringSearch END = StringSearchKt.searchFor("</script>");

    @Override
    public void extract(@NotNull StreamingReader stream, @NotNull Function1<? super BufferProducer, Unit> processSubStream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter(processSubStream, (String)"processSubStream");
        while (true) {
            stream.setOnWindowReleased(null);
            this.startIndex = StringSearch.find$default(START, stream, this.startIndex, 0, 4, null);
            if (this.startIndex == -1) {
                return;
            }
            this.startIndex += START.getLength();
            if (!stream.loadIndex(this.startIndex)) {
                return;
            }
            if (stream.get(this.startIndex) == 10) {
                int n = this.startIndex;
                this.startIndex = n + 1;
            }
            this.endIndex = Integer.MAX_VALUE;
            Pipe<DataSlice> pipe = new Pipe<DataSlice>(0, 1, null);
            Thread thread = new Thread(() -> SystraceExtractor.extract$lambda$2(stream, this, pipe));
            thread.start();
            processSubStream.invoke((Object)new SubStream(pipe));
            thread.join();
            this.startIndex = this.endIndex;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processWindow(StreamingReader.Window window, Pipe<DataSlice> pipe) {
        if (window.getGlobalEndIndex() >= this.startIndex && window.getGlobalStartIndex() < this.endIndex) {
            if (window.getGlobalStartIndex() >= this.startIndex && window.getGlobalEndIndex() <= this.endIndex) {
                pipe.add(window.getSlice());
            } else {
                void startIndex$iv;
                void $this$iv;
                int sliceStart = Math.max(this.startIndex - window.getGlobalStartIndex(), 0);
                int sliceEnd = Math.min(this.endIndex, window.getGlobalEndIndex()) - window.getGlobalStartIndex();
                DataSlice dataSlice = window.getSlice();
                int n = sliceStart;
                int endIndex$iv = sliceEnd;
                DataSlice dest$iv = new DataSlice();
                boolean $i$f$slice = false;
                dest$iv.set($this$iv.getBuffer(), $this$iv.getStartIndex() + startIndex$iv, $this$iv.getStartIndex() + endIndex$iv);
                pipe.add(dest$iv);
            }
        }
    }

    private static final Unit extract$lambda$2$lambda$0(SystraceExtractor this$0, Pipe $pipe, StreamingReader.Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        this$0.processWindow(window, $pipe);
        return Unit.INSTANCE;
    }

    private static final void extract$lambda$2(StreamingReader $stream, SystraceExtractor this$0, Pipe $pipe) {
        $stream.setOnWindowReleased((Function1<? super StreamingReader.Window, Unit>)((Function1)arg_0 -> SystraceExtractor.extract$lambda$2$lambda$0(this$0, $pipe, arg_0)));
        this$0.endIndex = StringSearch.find$default(END, $stream, this$0.startIndex, 0, 4, null);
        if (this$0.endIndex == -1) {
            this$0.endIndex = $stream.getEndIndex();
        }
        $stream.setOnWindowReleased(null);
        Iterable $this$forEach$iv = $stream.getWindows();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StreamingReader.Window it = (StreamingReader.Window)element$iv;
            boolean bl = false;
            this$0.processWindow(it, $pipe);
        }
        $pipe.close();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Ltrebuchet/extractors/html/SystraceExtractor$Companion;", "", "<init>", "()V", "START", "Ltrebuchet/util/StringSearch;", "getSTART", "()Ltrebuchet/util/StringSearch;", "END", "getEND", "intellij.android.profilers.atrace"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StringSearch getSTART() {
            return START;
        }

        @NotNull
        public final StringSearch getEND() {
            return END;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Ltrebuchet/extractors/html/SystraceExtractor$Factory;", "Ltrebuchet/extractors/ExtractorFactory;", "<init>", "()V", "extractorFor", "Ltrebuchet/extractors/Extractor;", "buffer", "Ltrebuchet/io/GenericByteBuffer;", "feedback", "Ltrebuchet/importers/ImportFeedback;", "intellij.android.profilers.atrace"})
    public static final class Factory
    implements ExtractorFactory {
        @NotNull
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        @Override
        @Nullable
        public Extractor extractorFor(@NotNull GenericByteBuffer buffer, @NotNull ImportFeedback feedback) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Intrinsics.checkNotNullParameter((Object)feedback, (String)"feedback");
            if (StringSearchKt.contains(buffer, "<html>", 1000)) {
                return new SystraceExtractor();
            }
            return null;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\t\u001a\u0004\u0018\u00010\u0004H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Ltrebuchet/extractors/html/SystraceExtractor$SubStream;", "Ltrebuchet/io/BufferProducer;", "pipe", "Ltrebuchet/io/Pipe;", "Ltrebuchet/io/DataSlice;", "<init>", "(Ltrebuchet/io/Pipe;)V", "getPipe", "()Ltrebuchet/io/Pipe;", "next", "intellij.android.profilers.atrace"})
    private static final class SubStream
    implements BufferProducer {
        @NotNull
        private final Pipe<DataSlice> pipe;

        public SubStream(@NotNull Pipe<DataSlice> pipe) {
            Intrinsics.checkNotNullParameter(pipe, (String)"pipe");
            this.pipe = pipe;
        }

        @NotNull
        public final Pipe<DataSlice> getPipe() {
            return this.pipe;
        }

        @Override
        @Nullable
        public DataSlice next() {
            return this.pipe.next();
        }

        @Override
        public void close() {
            BufferProducer.super.close();
        }
    }
}

