/*
 * Decompiled with CFR 0.152.
 */
package trebuchet.importers.ftrace;

import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import trebuchet.collections.SparseArray;
import trebuchet.importers.ImportFeedback;
import trebuchet.importers.ftrace.FtraceLine;
import trebuchet.importers.ftrace.FunctionRegistry;
import trebuchet.importers.ftrace.ImportData;
import trebuchet.importers.ftrace.ParseFunction;
import trebuchet.io.DataSlice;
import trebuchet.model.fragments.CpuModelFragment;
import trebuchet.model.fragments.ModelFragment;
import trebuchet.model.fragments.ProcessModelFragment;
import trebuchet.model.fragments.ThreadModelFragment;
import trebuchet.util.StringCache;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0019\u001a\u00020\u0010J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u001c\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020 2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u001c\u0010#\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020 2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\b\u0010%\u001a\u00020$H\u0002J$\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020 2\b\b\u0002\u0010\u001f\u001a\u00020 2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\"J\u000e\u0010&\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020 R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Ltrebuchet/importers/ftrace/FtraceImporterState;", "", "feedback", "Ltrebuchet/importers/ImportFeedback;", "<init>", "(Ltrebuchet/importers/ImportFeedback;)V", "pidMap", "Ltrebuchet/collections/SparseArray;", "Ltrebuchet/model/fragments/ThreadModelFragment;", "cpuMap", "Ltrebuchet/model/fragments/CpuModelFragment;", "handlers", "", "Ltrebuchet/io/DataSlice;", "Ltrebuchet/importers/ftrace/ParseFunction;", "modelFragment", "Ltrebuchet/model/fragments/ModelFragment;", "getModelFragment", "()Ltrebuchet/model/fragments/ModelFragment;", "stringCache", "Ltrebuchet/util/StringCache;", "getStringCache", "()Ltrebuchet/util/StringCache;", "importData", "Ltrebuchet/importers/ftrace/ImportData;", "finish", "importLine", "", "line", "Ltrebuchet/importers/ftrace/FtraceLine;", "createProcess", "tgid", "", "name", "", "processFor", "Ltrebuchet/model/fragments/ProcessModelFragment;", "createUnknownProcess", "threadFor", "pid", "task", "cpuFor", "cid", "intellij.android.profilers.atrace"})
@SourceDebugExtension(value={"SMAP\nFtraceImporterState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FtraceImporterState.kt\ntrebuchet/importers/ftrace/FtraceImporterState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n2746#2,3:111\n*S KotlinDebug\n*F\n+ 1 FtraceImporterState.kt\ntrebuchet/importers/ftrace/FtraceImporterState\n*L\n77#1:111,3\n*E\n"})
public final class FtraceImporterState {
    @NotNull
    private final SparseArray<ThreadModelFragment> pidMap;
    @NotNull
    private final SparseArray<CpuModelFragment> cpuMap;
    @NotNull
    private final Map<DataSlice, ParseFunction> handlers;
    @NotNull
    private final ModelFragment modelFragment;
    @NotNull
    private final StringCache stringCache;
    @NotNull
    private final ImportData importData;

    public FtraceImporterState(@NotNull ImportFeedback feedback) {
        Intrinsics.checkNotNullParameter((Object)feedback, (String)"feedback");
        this.pidMap = new SparseArray(50);
        this.cpuMap = new SparseArray(6);
        this.handlers = FunctionRegistry.INSTANCE.create();
        this.modelFragment = new ModelFragment();
        this.stringCache = new StringCache();
        this.importData = new ImportData(this, feedback);
    }

    @NotNull
    public final ModelFragment getModelFragment() {
        return this.modelFragment;
    }

    @NotNull
    public final StringCache getStringCache() {
        return this.stringCache;
    }

    @NotNull
    public final ModelFragment finish() {
        return this.modelFragment;
    }

    public final void importLine(@NotNull FtraceLine line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (this.modelFragment.getGlobalStartTime() == 0.0) {
            this.modelFragment.setGlobalStartTime(line.getTimestamp());
        }
        this.modelFragment.setGlobalEndTime(line.getTimestamp());
        if (line.getHasTgid()) {
            this.threadFor(line);
        }
        ParseFunction parseFunction = this.handlers.get(line.getFunction());
        if (parseFunction == null) {
            return;
        }
        ParseFunction handler2 = parseFunction;
        handler2.invoke(this.importData.wrap(line));
    }

    private final ThreadModelFragment createProcess(int tgid, String name) {
        ProcessModelFragment proc = new ProcessModelFragment(tgid, name, null, 4, null);
        this.modelFragment.getProcesses().add(proc);
        ThreadModelFragment thread = proc.threadFor(tgid, name);
        if (this.pidMap.get(tgid) != null) {
            new IllegalStateException("Unable to create process " + tgid + " - already exists!");
        }
        this.pidMap.put(tgid, thread);
        return thread;
    }

    static /* synthetic */ ThreadModelFragment createProcess$default(FtraceImporterState ftraceImporterState, int n, String string, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        return ftraceImporterState.createProcess(n, string);
    }

    private final ProcessModelFragment processFor(int tgid, String name) {
        ThreadModelFragment threadModelFragment = this.pidMap.get(tgid);
        if (threadModelFragment == null) {
            threadModelFragment = this.createProcess(tgid, name);
        }
        ThreadModelFragment thread = threadModelFragment;
        thread.getProcess().hint(tgid, name);
        return thread.getProcess();
    }

    static /* synthetic */ ProcessModelFragment processFor$default(FtraceImporterState ftraceImporterState, int n, String string, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        return ftraceImporterState.processFor(n, string);
    }

    private final ProcessModelFragment createUnknownProcess() {
        return new ProcessModelFragment(-1, null, arg_0 -> FtraceImporterState.createUnknownProcess$lambda$1(this, arg_0), 2, null);
    }

    @NotNull
    public final ThreadModelFragment threadFor(int pid, int tgid, @Nullable String task) {
        String processName;
        ThreadModelFragment thread = this.pidMap.get(pid);
        String string = processName = tgid == pid ? task : null;
        if (thread != null) {
            ThreadModelFragment.hint$default(thread, 0, task, tgid, processName, 1, null);
            return thread;
        }
        ProcessModelFragment process = tgid != -1 ? FtraceImporterState.processFor$default(this, tgid, null, 2, null) : this.createUnknownProcess();
        thread = process.threadFor(pid, task);
        ThreadModelFragment.hint$default(thread, 0, null, 0, processName, 7, null);
        this.pidMap.put(pid, thread);
        return thread;
    }

    public static /* synthetic */ ThreadModelFragment threadFor$default(FtraceImporterState ftraceImporterState, int n, int n2, String string, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = -1;
        }
        if ((n3 & 4) != 0) {
            string = null;
        }
        return ftraceImporterState.threadFor(n, n2, string);
    }

    @NotNull
    public final ThreadModelFragment threadFor(@NotNull FtraceLine line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return this.threadFor(line.getPid(), line.getTgid(), line.getTask());
    }

    @NotNull
    public final CpuModelFragment cpuFor(int cid) {
        CpuModelFragment cpu = this.cpuMap.get(cid);
        if (cpu == null) {
            cpu = new CpuModelFragment(cid);
            this.modelFragment.getCpus().add(cpu);
        }
        this.cpuMap.put(cid, cpu);
        CpuModelFragment cpuModelFragment = this.cpuMap.get(cid);
        Intrinsics.checkNotNull((Object)cpuModelFragment);
        return cpuModelFragment;
    }

    private static final Unit createUnknownProcess$lambda$1(FtraceImporterState this$0, ProcessModelFragment process) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter((Object)process, (String)"process");
            int tgid = process.getId();
            ThreadModelFragment existing = this$0.pidMap.get(tgid);
            if (existing != null) {
                existing.getProcess().merge(process);
            } else {
                this$0.pidMap.put(tgid, process.threadFor(tgid, process.getName()));
            }
            Iterable $this$none$iv = this$0.modelFragment.getProcesses();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    ProcessModelFragment it = (ProcessModelFragment)element$iv;
                    boolean bl2 = false;
                    if (!(it.getId() == process.getId())) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        if (bl) {
            this$0.modelFragment.getProcesses().add(process);
        }
        return Unit.INSTANCE;
    }
}

