/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.instrumentation.threading.agent;

import com.android.tools.instrumentation.threading.agent.AnnotationMappings;
import com.android.tools.instrumentation.threading.agent.InstrumentMethodVisitor;
import com.android.tools.instrumentation.threading.org.objectweb.asm.AnnotationVisitor;
import com.android.tools.instrumentation.threading.org.objectweb.asm.ClassVisitor;
import com.android.tools.instrumentation.threading.org.objectweb.asm.MethodVisitor;
import java.util.logging.Logger;

public class InstrumentClassVisitor
extends ClassVisitor {
    private static final Logger LOGGER = Logger.getLogger(InstrumentClassVisitor.class.getName());
    private final AnnotationMappings annotationMappings;
    private final String className;
    private String threadingAnnotation;

    InstrumentClassVisitor(AnnotationMappings annotationMappings, String className, ClassVisitor classVisitor) {
        super(589824, classVisitor);
        this.annotationMappings = annotationMappings;
        this.className = className;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (this.annotationMappings.isThreadingAnnotation(desc)) {
            if (this.threadingAnnotation != null) {
                LOGGER.warning(this.className + " already has a threading annotation " + this.threadingAnnotation + ". Only one class-level threading annotation can be specified.");
            }
            this.threadingAnnotation = desc;
        }
        return super.visitAnnotation(desc, visible);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
        if (name.equals("<clinit>")) {
            return methodVisitor;
        }
        return new InstrumentMethodVisitor(methodVisitor, this.annotationMappings, this.threadingAnnotation, this.className, access, name, desc);
    }
}

