/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.io.grpc;

import com.android.tools.idea.io.grpc.CallbackMetricInstrument;
import com.android.tools.idea.io.grpc.DoubleCounterMetricInstrument;
import com.android.tools.idea.io.grpc.DoubleHistogramMetricInstrument;
import com.android.tools.idea.io.grpc.Internal;
import com.android.tools.idea.io.grpc.LongCounterMetricInstrument;
import com.android.tools.idea.io.grpc.LongGaugeMetricInstrument;
import com.android.tools.idea.io.grpc.LongHistogramMetricInstrument;
import com.google.common.base.Preconditions;
import java.util.List;

@Internal
public interface MetricRecorder {
    default public void addDoubleCounter(DoubleCounterMetricInstrument metricInstrument, double value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        Preconditions.checkArgument((requiredLabelValues != null && requiredLabelValues.size() == metricInstrument.getRequiredLabelKeys().size() ? 1 : 0) != 0, (String)"Incorrect number of required labels provided. Expected: %s", (int)metricInstrument.getRequiredLabelKeys().size());
        Preconditions.checkArgument((optionalLabelValues != null && optionalLabelValues.size() == metricInstrument.getOptionalLabelKeys().size() ? 1 : 0) != 0, (String)"Incorrect number of optional labels provided. Expected: %s", (int)metricInstrument.getOptionalLabelKeys().size());
    }

    default public void addLongCounter(LongCounterMetricInstrument metricInstrument, long value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        Preconditions.checkArgument((requiredLabelValues != null && requiredLabelValues.size() == metricInstrument.getRequiredLabelKeys().size() ? 1 : 0) != 0, (String)"Incorrect number of required labels provided. Expected: %s", (int)metricInstrument.getRequiredLabelKeys().size());
        Preconditions.checkArgument((optionalLabelValues != null && optionalLabelValues.size() == metricInstrument.getOptionalLabelKeys().size() ? 1 : 0) != 0, (String)"Incorrect number of optional labels provided. Expected: %s", (int)metricInstrument.getOptionalLabelKeys().size());
    }

    default public void recordDoubleHistogram(DoubleHistogramMetricInstrument metricInstrument, double value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        Preconditions.checkArgument((requiredLabelValues != null && requiredLabelValues.size() == metricInstrument.getRequiredLabelKeys().size() ? 1 : 0) != 0, (String)"Incorrect number of required labels provided. Expected: %s", (int)metricInstrument.getRequiredLabelKeys().size());
        Preconditions.checkArgument((optionalLabelValues != null && optionalLabelValues.size() == metricInstrument.getOptionalLabelKeys().size() ? 1 : 0) != 0, (String)"Incorrect number of optional labels provided. Expected: %s", (int)metricInstrument.getOptionalLabelKeys().size());
    }

    default public void recordLongHistogram(LongHistogramMetricInstrument metricInstrument, long value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        Preconditions.checkArgument((requiredLabelValues != null && requiredLabelValues.size() == metricInstrument.getRequiredLabelKeys().size() ? 1 : 0) != 0, (String)"Incorrect number of required labels provided. Expected: %s", (int)metricInstrument.getRequiredLabelKeys().size());
        Preconditions.checkArgument((optionalLabelValues != null && optionalLabelValues.size() == metricInstrument.getOptionalLabelKeys().size() ? 1 : 0) != 0, (String)"Incorrect number of optional labels provided. Expected: %s", (int)metricInstrument.getOptionalLabelKeys().size());
    }

    default public Registration registerBatchCallback(BatchCallback callback, CallbackMetricInstrument ... metricInstruments) {
        return () -> {};
    }

    public static interface Registration
    extends AutoCloseable {
        @Override
        public void close();
    }

    public static interface BatchRecorder {
        default public void recordLongGauge(LongGaugeMetricInstrument metricInstrument, long value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
            Preconditions.checkArgument((requiredLabelValues != null && requiredLabelValues.size() == metricInstrument.getRequiredLabelKeys().size() ? 1 : 0) != 0, (String)"Incorrect number of required labels provided. Expected: %s", (int)metricInstrument.getRequiredLabelKeys().size());
            Preconditions.checkArgument((optionalLabelValues != null && optionalLabelValues.size() == metricInstrument.getOptionalLabelKeys().size() ? 1 : 0) != 0, (String)"Incorrect number of optional labels provided. Expected: %s", (int)metricInstrument.getOptionalLabelKeys().size());
        }
    }

    public static interface BatchCallback {
        public void accept(BatchRecorder var1);
    }
}

