/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.io.grpc.inprocess;

import com.android.tools.idea.io.grpc.ExperimentalApi;
import com.android.tools.idea.io.grpc.inprocess.InProcessServer;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.SocketAddress;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/8626")
public final class AnonymousInProcessSocketAddress
extends SocketAddress {
    private static final long serialVersionUID = -8567592561863414695L;
    @Nullable
    @GuardedBy(value="this")
    private InProcessServer server;

    @Nullable
    synchronized InProcessServer getServer() {
        return this.server;
    }

    synchronized void setServer(InProcessServer server) throws IOException {
        if (this.server != null) {
            throw new IOException("Server instance already registered");
        }
        this.server = server;
    }

    synchronized void clearServer(InProcessServer server) {
        Preconditions.checkState((this.server == server ? 1 : 0) != 0);
        this.server = null;
    }
}

