/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.io.grpc.netty.shaded.io.grpc.netty;

import com.android.tools.idea.io.grpc.Status;
import com.android.tools.idea.io.grpc.netty.shaded.io.grpc.netty.NettyServerStream;
import com.android.tools.idea.io.grpc.netty.shaded.io.grpc.netty.WriteQueue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

final class CancelServerStreamCommand
extends WriteQueue.AbstractQueuedCommand {
    private final NettyServerStream.TransportState stream;
    private final Status reason;
    private final PeerNotify peerNotify;

    private CancelServerStreamCommand(NettyServerStream.TransportState stream, Status reason, PeerNotify peerNotify) {
        this.stream = (NettyServerStream.TransportState)Preconditions.checkNotNull((Object)stream, (Object)"stream");
        this.reason = (Status)Preconditions.checkNotNull((Object)reason, (Object)"reason");
        this.peerNotify = (PeerNotify)((Object)Preconditions.checkNotNull((Object)((Object)peerNotify), (Object)"peerNotify"));
    }

    static CancelServerStreamCommand withReset(NettyServerStream.TransportState stream, Status reason) {
        return new CancelServerStreamCommand(stream, reason, PeerNotify.RESET);
    }

    static CancelServerStreamCommand withReason(NettyServerStream.TransportState stream, Status reason) {
        return new CancelServerStreamCommand(stream, reason, PeerNotify.BEST_EFFORT_STATUS);
    }

    NettyServerStream.TransportState stream() {
        return this.stream;
    }

    Status reason() {
        return this.reason;
    }

    boolean wantsHeaders() {
        return this.peerNotify == PeerNotify.BEST_EFFORT_STATUS;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CancelServerStreamCommand that = (CancelServerStreamCommand)o;
        return Objects.equal((Object)this.stream, (Object)that.stream) && Objects.equal((Object)this.reason, (Object)that.reason);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.stream, this.reason});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("stream", (Object)this.stream).add("reason", (Object)this.reason).toString();
    }

    private static enum PeerNotify {
        RESET,
        BEST_EFFORT_STATUS;

    }
}

