/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.process;

import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutput;
import com.android.ide.common.process.ProcessOutputHandler;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TeeProcessOutputHandler
implements ProcessOutputHandler {
    private final ImmutableList<ProcessOutputHandler> mHandlers;

    public TeeProcessOutputHandler(ProcessOutputHandler ... handlers) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (ProcessOutputHandler h : handlers) {
            if (h == null) continue;
            builder.add((Object)h);
        }
        this.mHandlers = builder.build();
    }

    @Override
    public void handleOutput(ProcessOutput processOutput) throws ProcessException {
        for (int i2 = 0; i2 < this.mHandlers.size(); ++i2) {
            ((ProcessOutputHandler)this.mHandlers.get(i2)).handleOutput((ProcessOutput)((TeeProcessOutput)processOutput).mOutputs.get(i2));
        }
    }

    @Override
    public ProcessOutput createOutput() {
        List outputs = this.mHandlers.stream().map(ProcessOutputHandler::createOutput).collect(Collectors.toList());
        return new TeeProcessOutput(ImmutableList.copyOf(outputs));
    }

    private static class TeeProcessOutput
    implements ProcessOutput {
        private final ImmutableList<ProcessOutput> mOutputs;

        private TeeProcessOutput(ImmutableList<ProcessOutput> outputs) {
            this.mOutputs = outputs;
        }

        private OutputStream getCompositeStream(Function<ProcessOutput, OutputStream> processOutputStreamExtractor) {
            final List streams = this.mOutputs.stream().map(processOutputStreamExtractor).collect(Collectors.toList());
            return new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    for (OutputStream os : streams) {
                        os.write(b);
                    }
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    for (OutputStream os : streams) {
                        os.write(b, off, len);
                    }
                }

                @Override
                public void flush() throws IOException {
                    for (OutputStream os : streams) {
                        os.flush();
                    }
                }

                @Override
                public void close() throws IOException {
                    try (Closer c = Closer.create();){
                        streams.forEach(arg_0 -> ((Closer)c).register(arg_0));
                    }
                }
            };
        }

        @Override
        public OutputStream getStandardOutput() {
            return this.getCompositeStream(ProcessOutput::getStandardOutput);
        }

        @Override
        public OutputStream getErrorOutput() {
            return this.getCompositeStream(ProcessOutput::getErrorOutput);
        }

        @Override
        public void close() throws IOException {
            try (Closer c = Closer.create();){
                this.mOutputs.forEach(arg_0 -> ((Closer)c).register(arg_0));
            }
        }
    }
}

