/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.r8;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u001a\u001bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0007H\u0002J$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u0016\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/ide/common/r8/ConsumerRuleGlobalGuardian;", "", "<init>", "()V", "isBannedOption", "", "optionName", "", "isBannedOptionWithoutPackageArg", "KEEP_OPTION_ARGS_REGEX", "Lkotlin/text/Regex;", "checkForBannedLine", "Lcom/android/ide/common/r8/ConsumerRuleGlobalGuardian$BannedLinePattern;", "keepLine", "validateConsumerRulesHasNoBannedGlobals", "", "consumerKeepRulesFile", "Ljava/io/File;", "isDynamicFeature", "exceptionHandler", "Ljava/util/function/Consumer;", "Lcom/android/ide/common/r8/ConsumerRuleGlobalGuardian$DiscoveredIssue;", "readConsumerKeepRulesRemovingBannedGlobals", "inputStream", "Ljava/io/InputStream;", "shouldRemoveBannedGlobals", "BannedLinePattern", "DiscoveredIssue", "android.sdktools.sdk-common"})
@SourceDebugExtension(value={"SMAP\nConsumerRuleGlobalGuardian.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsumerRuleGlobalGuardian.kt\ncom/android/ide/common/r8/ConsumerRuleGlobalGuardian\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,197:1\n1321#2,2:198\n*S KotlinDebug\n*F\n+ 1 ConsumerRuleGlobalGuardian.kt\ncom/android/ide/common/r8/ConsumerRuleGlobalGuardian\n*L\n185#1:198,2\n*E\n"})
public final class ConsumerRuleGlobalGuardian {
    @NotNull
    public static final ConsumerRuleGlobalGuardian INSTANCE = new ConsumerRuleGlobalGuardian();
    @NotNull
    private static final Regex KEEP_OPTION_ARGS_REGEX = new Regex("\\s*-([a-zA-Z0-9]+)(?:\\s+([^#]*?))?\\s*(?:#.*)?");

    private ConsumerRuleGlobalGuardian() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isBannedOption(@NotNull String optionName) {
        Intrinsics.checkNotNullParameter((Object)optionName, (String)"optionName");
        String string = optionName;
        switch (string.hashCode()) {
            case 1942574248: {
                if (string.equals("include")) return true;
                return false;
            }
            case -609027853: {
                if (string.equals("libraryjars")) return true;
                return false;
            }
            case 2039670483: {
                if (string.equals("packageobfuscationdictionary")) return true;
                return false;
            }
            case -1301785234: {
                if (string.equals("dontoptimize")) return true;
                return false;
            }
            case 463255770: {
                if (string.equals("dontshrink")) return true;
                return false;
            }
            case 304107623: {
                if (string.equals("renamesourcefileattribute")) return true;
                return false;
            }
            case 98472793: {
                if (string.equals("obfuscationdictionary")) return true;
                return false;
            }
            case 159149844: {
                if (string.equals("printusage")) return true;
                return false;
            }
            case 478561583: {
                if (string.equals("dontobfuscate")) return true;
                return false;
            }
            case -1106312698: {
                if (string.equals("outjars")) return true;
                return false;
            }
            case -687113855: {
                if (string.equals("printmapping")) return true;
                return false;
            }
            case 156889493: {
                if (string.equals("printseeds")) return true;
                return false;
            }
            case 1084598603: {
                if (string.equals("overloadaggressively")) return true;
                return false;
            }
            case -666483863: {
                if (string.equals("printconfiguration")) return true;
                return false;
            }
            case -1184064419: {
                if (string.equals("injars")) return true;
                return false;
            }
            case 1120809660: {
                if (string.equals("basedirectory")) return true;
                return false;
            }
            case 96293897: {
                if (string.equals("allowaccessmodification")) return true;
                return false;
            }
            case -960987744: {
                if (string.equals("applymapping")) return true;
                return false;
            }
            case -577613783: {
                if (string.equals("ignorewarnings")) return true;
                return false;
            }
            case -226346855: {
                if (string.equals("addconfigurationdebugging")) return true;
                return false;
            }
            case -1069808415: {
                if (!string.equals("classobfuscationdictionary")) return false;
                return true;
            }
        }
        return false;
    }

    public final boolean isBannedOptionWithoutPackageArg(@NotNull String optionName) {
        Intrinsics.checkNotNullParameter((Object)optionName, (String)"optionName");
        String string = optionName;
        return Intrinsics.areEqual((Object)string, (Object)"repackageclasses") || Intrinsics.areEqual((Object)string, (Object)"flattenpackagehierarchy");
    }

    private final BannedLinePattern checkForBannedLine(String keepLine) {
        MatchResult match = KEEP_OPTION_ARGS_REGEX.matchEntire((CharSequence)keepLine);
        if (match != null) {
            CharSequence charSequence;
            String args;
            MatchGroup matchGroup = match.getGroups().get(1);
            Intrinsics.checkNotNull((Object)matchGroup);
            String option = matchGroup.getValue();
            MatchGroup matchGroup2 = match.getGroups().get(2);
            String string = args = matchGroup2 != null ? matchGroup2.getValue() : null;
            if (this.isBannedOption(option)) {
                return new BannedLinePattern(false, option);
            }
            if (this.isBannedOptionWithoutPackageArg(option) && ((charSequence = (CharSequence)args) == null || charSequence.length() == 0)) {
                return new BannedLinePattern(true, option);
            }
        }
        return null;
    }

    public final void validateConsumerRulesHasNoBannedGlobals(@NotNull File consumerKeepRulesFile, boolean isDynamicFeature, @NotNull Consumer<DiscoveredIssue> exceptionHandler) {
        Intrinsics.checkNotNullParameter((Object)consumerKeepRulesFile, (String)"consumerKeepRulesFile");
        Intrinsics.checkNotNullParameter(exceptionHandler, (String)"exceptionHandler");
        if (!consumerKeepRulesFile.exists()) {
            return;
        }
        FilesKt.forEachLine$default((File)consumerKeepRulesFile, null, arg_0 -> ConsumerRuleGlobalGuardian.validateConsumerRulesHasNoBannedGlobals$lambda$1(exceptionHandler, isDynamicFeature, consumerKeepRulesFile, arg_0), (int)1, null);
    }

    @NotNull
    public final String readConsumerKeepRulesRemovingBannedGlobals(@NotNull InputStream inputStream, boolean shouldRemoveBannedGlobals) {
        String string;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        if (shouldRemoveBannedGlobals) {
            StringBuilder output = new StringBuilder();
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream2, charset);
            int n = 8192;
            Sequence $this$forEach$iv = TextStreamsKt.lineSequence((BufferedReader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String line = (String)element$iv;
                boolean bl = false;
                if (INSTANCE.checkForBannedLine(line) != null) {
                    output.append("# REMOVED CONSUMER RULE: ");
                }
                output.append(line).append(System.lineSeparator());
            }
            String string2 = output.toString();
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else {
            string = StringsKt.decodeToString((byte[])ByteStreamsKt.readBytes((InputStream)inputStream));
        }
        return string;
    }

    private static final Unit validateConsumerRulesHasNoBannedGlobals$lambda$1(Consumer $exceptionHandler, boolean $isDynamicFeature, File $consumerKeepRulesFile, String rawLine) {
        block0: {
            BannedLinePattern bannedLinePattern;
            Intrinsics.checkNotNullParameter((Object)rawLine, (String)"rawLine");
            BannedLinePattern bannedLinePattern2 = INSTANCE.checkForBannedLine(rawLine);
            if (bannedLinePattern2 == null) break block0;
            BannedLinePattern $this$validateConsumerRulesHasNoBannedGlobals_u24lambda_u241_u24lambda_u240 = bannedLinePattern = bannedLinePattern2;
            boolean bl = false;
            String string = $this$validateConsumerRulesHasNoBannedGlobals_u24lambda_u241_u24lambda_u240.getOption();
            boolean bl2 = $this$validateConsumerRulesHasNoBannedGlobals_u24lambda_u241_u24lambda_u240.getRequiresArgumentInConsumerRules();
            String string2 = $consumerKeepRulesFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            String string3 = $this$validateConsumerRulesHasNoBannedGlobals_u24lambda_u241_u24lambda_u240.asExceptionMessage($isDynamicFeature, string2);
            $exceptionHandler.accept(new DiscoveredIssue(bl2, string, string3));
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/android/ide/common/r8/ConsumerRuleGlobalGuardian$BannedLinePattern;", "", "requiresArgumentInConsumerRules", "", "option", "", "<init>", "(ZLjava/lang/String;)V", "getRequiresArgumentInConsumerRules", "()Z", "getOption", "()Ljava/lang/String;", "asExceptionMessage", "isDynamicFeature", "path", "android.sdktools.sdk-common"})
    public static final class BannedLinePattern {
        private final boolean requiresArgumentInConsumerRules;
        @NotNull
        private final String option;

        public BannedLinePattern(boolean requiresArgumentInConsumerRules, @NotNull String option) {
            Intrinsics.checkNotNullParameter((Object)option, (String)"option");
            this.requiresArgumentInConsumerRules = requiresArgumentInConsumerRules;
            this.option = option;
        }

        public final boolean getRequiresArgumentInConsumerRules() {
            return this.requiresArgumentInConsumerRules;
        }

        @NotNull
        public final String getOption() {
            return this.option;
        }

        @NotNull
        public final String asExceptionMessage(boolean isDynamicFeature, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            String baseMessage = isDynamicFeature ? "Global keep option -" + this.option + " was specified in " + path + ". " : "Global keep option -" + this.option + " was specified as a consumerProguardFile in " + path + ". ";
            return baseMessage + (INSTANCE.isBannedOption(this.option) ? (isDynamicFeature ? "It should not be specified in this module. It can be specified in the base module instead." : "It should not be used in a consumer configuration file.") : (isDynamicFeature ? "It should not be specified in this module without specifying a package. Add a package scope, or specify this option in the base module instead." : "It should not be used in a consumer configuration file without specifying a package."));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u000e"}, d2={"Lcom/android/ide/common/r8/ConsumerRuleGlobalGuardian$DiscoveredIssue;", "", "requiresArgumentInConsumerRules", "", "globalOption", "", "errorMessage", "<init>", "(ZLjava/lang/String;Ljava/lang/String;)V", "getRequiresArgumentInConsumerRules", "()Z", "getGlobalOption", "()Ljava/lang/String;", "getErrorMessage", "android.sdktools.sdk-common"})
    public static final class DiscoveredIssue {
        private final boolean requiresArgumentInConsumerRules;
        @NotNull
        private final String globalOption;
        @NotNull
        private final String errorMessage;

        public DiscoveredIssue(boolean requiresArgumentInConsumerRules, @NotNull String globalOption, @NotNull String errorMessage) {
            Intrinsics.checkNotNullParameter((Object)globalOption, (String)"globalOption");
            Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
            this.requiresArgumentInConsumerRules = requiresArgumentInConsumerRules;
            this.globalOption = globalOption;
            this.errorMessage = errorMessage;
        }

        public final boolean getRequiresArgumentInConsumerRules() {
            return this.requiresArgumentInConsumerRules;
        }

        @NotNull
        public final String getGlobalOption() {
            return this.globalOption;
        }

        @NotNull
        public final String getErrorMessage() {
            return this.errorMessage;
        }
    }
}

