/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering;

import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.devices.ButtonType;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Screen;
import java.util.Collections;
import java.util.List;

public class HardwareConfigHelper {
    private final Device mDevice;
    private ScreenOrientation mScreenOrientation = ScreenOrientation.PORTRAIT;
    private int mMaxRenderWidth = -1;
    private int mMaxRenderHeight = -1;
    private int mOverrideRenderWidth = -1;
    private int mOverrideRenderHeight = -1;

    public HardwareConfigHelper(Device device) {
        this.mDevice = device;
    }

    public HardwareConfigHelper setOrientation(ScreenOrientation screenOrientation) {
        this.mScreenOrientation = screenOrientation;
        return this;
    }

    public HardwareConfigHelper setOverrideRenderSize(int overrideRenderWidth, int overrideRenderHeight) {
        this.mOverrideRenderWidth = overrideRenderWidth;
        this.mOverrideRenderHeight = overrideRenderHeight;
        return this;
    }

    public void clearOverrideRenderSize() {
        this.mOverrideRenderWidth = -1;
        this.mOverrideRenderHeight = -1;
    }

    public HardwareConfigHelper setMaxRenderSize(int maxRenderWidth, int maxRenderHeight) {
        this.mMaxRenderWidth = maxRenderWidth;
        this.mMaxRenderHeight = maxRenderHeight;
        return this;
    }

    public HardwareConfig getConfig() {
        int height;
        int width;
        int y;
        Screen screen = this.mDevice.getDefaultHardware().getScreen();
        int x = screen.getXDimension();
        if (x > (y = screen.getYDimension())) {
            if (this.mScreenOrientation == ScreenOrientation.LANDSCAPE) {
                width = x;
                height = y;
            } else {
                width = y;
                height = x;
            }
        } else if (this.mScreenOrientation == ScreenOrientation.LANDSCAPE) {
            width = y;
            height = x;
        } else {
            width = x;
            height = y;
        }
        if (this.mOverrideRenderHeight != -1) {
            width = this.mOverrideRenderWidth;
        }
        if (this.mOverrideRenderHeight != -1) {
            height = this.mOverrideRenderHeight;
        }
        if (this.mMaxRenderWidth != -1) {
            width = this.mMaxRenderWidth;
        }
        if (this.mMaxRenderHeight != -1) {
            height = this.mMaxRenderHeight;
        }
        return new HardwareConfig(width, height, screen.getPixelDensity(), (float)screen.getXdpi(), (float)screen.getYdpi(), screen.getSize(), this.mScreenOrientation, this.mDevice.getDefaultHardware().getScreen().getScreenRound(), this.mDevice.getDefaultHardware().getButtonType() == ButtonType.SOFT);
    }

    public boolean isRenderSizeOverridden() {
        return this.mOverrideRenderWidth != -1 || this.mOverrideRenderHeight != -1;
    }

    public static boolean isGeneric(Device device) {
        return "Generic".equals(device.getManufacturer());
    }

    public static boolean isNexus(Device device) {
        return "Google".equals(device.getManufacturer());
    }

    public static void sortDevicesByScreenSize(List<Device> list) {
        Collections.sort(list, (device1, device2) -> {
            Screen screen1 = device1.getDefaultHardware().getScreen();
            float length1 = (float)screen1.getDiagonalLength();
            Screen screen2 = device2.getDefaultHardware().getScreen();
            float length2 = (float)screen2.getDiagonalLength();
            return (int)Math.signum(length1 - length2);
        });
    }
}

