/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.symbols;

import com.android.ide.common.symbols.PartialRMergingException;
import com.android.ide.common.symbols.Symbol;
import com.android.ide.common.symbols.SymbolIo;
import com.android.ide.common.symbols.SymbolTableKt;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Interner;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.common.collect.UnmodifiableIterator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\b\b&\u0018\u0000 )2\u00020\u0001:\u0005&'()*B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0000J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00142\u0006\u0010\u0015\u001a\u00020\nJ\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00142\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u0005J\u001d\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001b\u001a\u00020\u00052\b\b\u0002\u0010\u001e\u001a\u00020\u001fH\u0086\u0010J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0000R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R$\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006+"}, d2={"Lcom/android/ide/common/symbols/SymbolTable;", "", "<init>", "()V", "tablePackage", "", "getTablePackage", "()Ljava/lang/String;", "symbols", "Lcom/google/common/collect/ImmutableTable;", "Lcom/android/resources/ResourceType;", "Lcom/android/ide/common/symbols/Symbol;", "getSymbols", "()Lcom/google/common/collect/ImmutableTable;", "filter", "table", "merge", "m", "rename", "getSymbolByResourceType", "", "type", "getSymbolByVisibility", "visibility", "Lcom/android/resources/ResourceVisibility;", "containsSymbol", "", "canonicalName", "maybeGetStyleableParentSymbolForChild", "Lcom/android/ide/common/symbols/Symbol$StyleableSymbol;", "start", "", "withValuesFrom", "mainSymbolTable", "resourceTypes", "", "getResourceTypes", "()Ljava/util/Set;", "SymbolTableImpl", "Builder", "FastBuilder", "Companion", "IllegalResourceVisibilityException", "android.sdktools.sdk-common"})
@SourceDebugExtension(value={"SMAP\nSymbolTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SymbolTable.kt\ncom/android/ide/common/symbols/SymbolTable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,421:1\n1056#2:422\n774#2:423\n865#2,2:424\n1056#2:426\n*S KotlinDebug\n*F\n+ 1 SymbolTable.kt\ncom/android/ide/common/symbols/SymbolTable\n*L\n99#1:422\n107#1:423\n107#1:424,2\n108#1:426\n*E\n"})
public abstract class SymbolTable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<SymbolTable> EMPTY$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, SymbolTable::EMPTY_delegate$lambda$3);

    protected SymbolTable() {
    }

    @NotNull
    public abstract String getTablePackage();

    @NotNull
    public abstract ImmutableTable<ResourceType, String, Symbol> getSymbols();

    @NotNull
    public final SymbolTable filter(@NotNull SymbolTable table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        ImmutableTable.Builder builder = ImmutableTable.builder();
        UnmodifiableIterator unmodifiableIterator = table.getSymbols().rowKeySet().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)unmodifiableIterator, (String)"iterator(...)");
        UnmodifiableIterator unmodifiableIterator2 = unmodifiableIterator;
        while (unmodifiableIterator2.hasNext()) {
            UnmodifiableIterator unmodifiableIterator3;
            ResourceType resourceType = (ResourceType)unmodifiableIterator2.next();
            Set set = this.getSymbols().row((Object)resourceType).keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
            ImmutableSet allowedNames = (ImmutableSet)set;
            Intrinsics.checkNotNullExpressionValue((Object)((ImmutableCollection)table.getSymbols().row((Object)resourceType).values()).iterator(), (String)"iterator(...)");
            while (unmodifiableIterator3.hasNext()) {
                Symbol s;
                Symbol s1 = (Symbol)unmodifiableIterator3.next();
                if (!allowedNames.contains((Object)s1.getCanonicalName())) continue;
                if ((Symbol)this.getSymbols().get((Object)resourceType, (Object)s1.getCanonicalName()) == null) continue;
                boolean bl = false;
                builder.put((Object)resourceType, (Object)s1.getCanonicalName(), (Object)s);
            }
        }
        String string = this.getTablePackage();
        ImmutableTable immutableTable = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableTable, (String)"build(...)");
        return new SymbolTableImpl(string, (ImmutableTable<ResourceType, String, Symbol>)immutableTable);
    }

    @NotNull
    public final SymbolTable merge(@NotNull SymbolTable m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Object[] objectArray = new SymbolTable[]{this, m};
        return Companion.merge(CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public final SymbolTable rename(@NotNull String tablePackage) {
        Intrinsics.checkNotNullParameter((Object)tablePackage, (String)"tablePackage");
        return new SymbolTableImpl(tablePackage, this.getSymbols());
    }

    @NotNull
    public final List<Symbol> getSymbolByResourceType(@NotNull ResourceType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Collection collection = this.getSymbols().row((Object)type).values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"<get-values>(...)");
        Iterable $this$sortedBy$iv = collection;
        boolean $i$f$sortedBy = false;
        List<Symbol> list = Collections.unmodifiableList(CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Symbol p0 = (Symbol)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)p0.getCanonicalName());
                p0 = (Symbol)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)p0.getCanonicalName())));
            }
        }));
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(...)");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Symbol> getSymbolByVisibility(@NotNull ResourceVisibility visibility) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)visibility, (String)"visibility");
        ImmutableCollection immutableCollection = this.getSymbols().values();
        Intrinsics.checkNotNullExpressionValue((Object)immutableCollection, (String)"values(...)");
        Iterable $this$filter$iv = (Iterable)immutableCollection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Symbol it = (Symbol)element$iv$iv;
            boolean bl = false;
            if (!(it.getResourceVisibility() == visibility)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List symbols = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Symbol p0 = (Symbol)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)p0.getCanonicalName());
                p0 = (Symbol)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)p0.getCanonicalName())));
            }
        });
        List<Symbol> list = Collections.unmodifiableList(symbols);
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(...)");
        return list;
    }

    public final boolean containsSymbol(@NotNull ResourceType type, @NotNull String canonicalName) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)canonicalName, (String)"canonicalName");
        if (this.getSymbols().contains((Object)type, (Object)canonicalName)) {
            return true;
        }
        return type == ResourceType.STYLEABLE && SymbolTable.maybeGetStyleableParentSymbolForChild$default(this, canonicalName, 0, 2, null) != null;
    }

    @Nullable
    public final Symbol.StyleableSymbol maybeGetStyleableParentSymbolForChild(@NotNull String canonicalName, int start) {
        Intrinsics.checkNotNullParameter((Object)canonicalName, (String)"canonicalName");
        Object object = this;
        int index;
        while ((index = StringsKt.indexOf$default((CharSequence)canonicalName, (char)'_', (int)start, (boolean)false, (int)4, null)) >= 0) {
            Symbol.StyleableSymbol parent;
            String parentName = StringsKt.take((String)canonicalName, (int)index);
            Object object2 = ((SymbolTable)object).getSymbols().get((Object)ResourceType.STYLEABLE, (Object)parentName);
            Symbol.StyleableSymbol styleableSymbol = parent = object2 instanceof Symbol.StyleableSymbol ? (Symbol.StyleableSymbol)object2 : null;
            if (parent != null) {
                String childName = StringsKt.drop((String)canonicalName, (int)(index + 1));
                if (parent.getChildren().contains((Object)childName)) {
                    return parent;
                }
                if (StringsKt.startsWith$default((String)childName, (String)"android_", (boolean)false, (int)2, null)) {
                    String childNameWithColon = "android:" + StringsKt.drop((String)childName, (int)8);
                    if (parent.getChildren().contains((Object)childNameWithColon)) {
                        return parent;
                    }
                }
            }
            object2 = object;
            String string = canonicalName;
            int n = index + 1;
            object = object2;
            canonicalName = string;
            start = n;
        }
        return null;
    }

    public static /* synthetic */ Symbol.StyleableSymbol maybeGetStyleableParentSymbolForChild$default(SymbolTable symbolTable, String string, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: maybeGetStyleableParentSymbolForChild");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return symbolTable.maybeGetStyleableParentSymbolForChild(string, n);
    }

    @NotNull
    public final SymbolTable withValuesFrom(@NotNull SymbolTable mainSymbolTable) {
        Intrinsics.checkNotNullParameter((Object)mainSymbolTable, (String)"mainSymbolTable");
        return mainSymbolTable.filter(this).rename(this.getTablePackage());
    }

    @NotNull
    public final Set<ResourceType> getResourceTypes() {
        ImmutableSet immutableSet = this.getSymbols().rowKeySet();
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"rowKeySet(...)");
        return (Set)immutableSet;
    }

    private static final SymbolTable EMPTY_delegate$lambda$3() {
        return Companion.builder().build();
    }

    @JvmStatic
    @NotNull
    public static final SymbolTable merge(@NotNull List<? extends SymbolTable> tables) {
        return Companion.merge(tables);
    }

    @JvmStatic
    @NotNull
    public static final SymbolTable mergePartialTables(@NotNull List<? extends File> tables, @NotNull String packageName) {
        return Companion.mergePartialTables(tables, packageName);
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\tJ\u0014\u0010\f\u001a\u00020\u00002\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\t0\rJ\u0014\u0010\u000e\u001a\u00020\u00002\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\t0\rJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\tH\u0002J\u0015\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0014J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u0011\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\tH\u0086\u0002J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0005J\u0013\u0010\u0019\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\tH\u0086\u0002J\u0018\u0010\u001a\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0005J\u0006\u0010\u001b\u001a\u00020\u0016J\u0006\u0010\u001c\u001a\u00020\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/ide/common/symbols/SymbolTable$Builder;", "", "<init>", "()V", "tablePackage", "", "symbols", "Lcom/google/common/collect/Table;", "Lcom/android/resources/ResourceType;", "Lcom/android/ide/common/symbols/Symbol;", "add", "symbol", "addAll", "", "addAllIfNotExist", "addFromPartialHelper", "", "addFromPartial", "table", "Lcom/android/ide/common/symbols/SymbolTable;", "addFromPartial$android_sdktools_sdk_common", "contains", "", "resourceType", "canonicalName", "get", "remove", "isEmpty", "build", "android.sdktools.sdk-common"})
    @SourceDebugExtension(value={"SMAP\nSymbolTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SymbolTable.kt\ncom/android/ide/common/symbols/SymbolTable$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,421:1\n1#2:422\n1869#3,2:423\n1869#3,2:425\n1869#3,2:427\n*S KotlinDebug\n*F\n+ 1 SymbolTable.kt\ncom/android/ide/common/symbols/SymbolTable$Builder\n*L\n192#1:423,2\n196#1:425,2\n263#1:427,2\n*E\n"})
    public static final class Builder {
        @NotNull
        private String tablePackage = "";
        @NotNull
        private final Table<ResourceType, String, Symbol> symbols;

        public Builder() {
            Table table = Tables.newCustomTable((Map)Maps.newEnumMap(ResourceType.class), HashMap::new);
            Intrinsics.checkNotNullExpressionValue((Object)table, (String)"newCustomTable(...)");
            this.symbols = table;
        }

        @NotNull
        public final Builder add(@NotNull Symbol symbol) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
            Builder $this$add_u24lambda_u241 = builder = this;
            boolean bl = false;
            if (!(!$this$add_u24lambda_u241.symbols.contains((Object)symbol.getResourceType(), (Object)symbol.getCanonicalName()))) {
                boolean bl2 = false;
                String string = "Duplicate symbol in table with resource type '" + symbol.getResourceType() + "' and symbol name '" + symbol.getCanonicalName() + '\'';
                throw new IllegalArgumentException(string.toString());
            }
            $this$add_u24lambda_u241.symbols.put((Object)symbol.getResourceType(), (Object)symbol.getCanonicalName(), (Object)symbol);
            return builder;
        }

        @NotNull
        public final Builder addAll(@NotNull Collection<? extends Symbol> symbols) {
            Builder builder;
            Intrinsics.checkNotNullParameter(symbols, (String)"symbols");
            Builder $this$addAll_u24lambda_u243 = builder = this;
            boolean bl = false;
            Iterable $this$forEach$iv = symbols;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Symbol it = (Symbol)element$iv;
                boolean bl2 = false;
                $this$addAll_u24lambda_u243.add(it);
            }
            return builder;
        }

        @NotNull
        public final Builder addAllIfNotExist(@NotNull Collection<? extends Symbol> symbols) {
            Builder builder;
            Intrinsics.checkNotNullParameter(symbols, (String)"symbols");
            Builder $this$addAllIfNotExist_u24lambda_u245 = builder = this;
            boolean bl = false;
            Iterable $this$forEach$iv = symbols;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Symbol it = (Symbol)element$iv;
                boolean bl2 = false;
                if ($this$addAllIfNotExist_u24lambda_u245.contains(it)) continue;
                $this$addAllIfNotExist_u24lambda_u245.add(it);
            }
            return builder;
        }

        private final void addFromPartialHelper(Symbol symbol) {
            Symbol existing = (Symbol)this.symbols.get((Object)symbol.getResourceType(), (Object)symbol.getCanonicalName());
            if (existing == null) {
                this.symbols.put((Object)symbol.getResourceType(), (Object)symbol.getCanonicalName(), (Object)symbol);
                return;
            }
            if (existing.getResourceVisibility() != symbol.getResourceVisibility() && existing.getResourceVisibility() != ResourceVisibility.PRIVATE_XML_ONLY && symbol.getResourceVisibility() != ResourceVisibility.PRIVATE_XML_ONLY) {
                throw new IllegalResourceVisibilityException("Symbol with resource type " + symbol.getResourceType() + " and name " + symbol.getCanonicalName() + " defined both as " + symbol.getResourceVisibility() + " and " + existing.getResourceVisibility() + '.');
            }
            if (symbol.getResourceType() != ResourceType.STYLEABLE) {
                if (symbol.getResourceVisibility().compareTo((Enum)existing.getResourceVisibility()) > 0) {
                    this.symbols.remove((Object)existing.getResourceType(), (Object)existing.getCanonicalName());
                    this.symbols.put((Object)symbol.getResourceType(), (Object)symbol.getCanonicalName(), (Object)symbol);
                }
                return;
            }
            ImmutableList children = ImmutableList.copyOf((Collection)CollectionsKt.sorted((Iterable)CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)((Collection)symbol.getChildren()), (Iterable)((Iterable)existing.getChildren())))));
            ResourceVisibility visibility = ResourceVisibility.max((ResourceVisibility)symbol.getResourceVisibility(), (ResourceVisibility)existing.getResourceVisibility());
            this.symbols.remove((Object)existing.getResourceType(), (Object)existing.getCanonicalName());
            ResourceType resourceType = symbol.getResourceType();
            String string = symbol.getCanonicalName();
            String string2 = symbol.getCanonicalName();
            ImmutableList immutableList = ImmutableList.of();
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"of(...)");
            Intrinsics.checkNotNull((Object)children);
            Intrinsics.checkNotNull((Object)visibility);
            this.symbols.put((Object)resourceType, (Object)string, (Object)Symbol.Companion.styleableSymbol$default(Symbol.Companion, string2, immutableList, children, visibility, null, 16, null));
        }

        @NotNull
        public final Builder addFromPartial$android_sdktools_sdk_common(@NotNull SymbolTable table) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Builder $this$addFromPartial_u24lambda_u247 = builder = this;
            boolean bl = false;
            ImmutableCollection immutableCollection = table.getSymbols().values();
            Intrinsics.checkNotNullExpressionValue((Object)immutableCollection, (String)"values(...)");
            Iterable $this$forEach$iv = (Iterable)immutableCollection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Symbol it = (Symbol)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                $this$addFromPartial_u24lambda_u247.addFromPartialHelper(it);
            }
            return builder;
        }

        @NotNull
        public final Builder tablePackage(@NotNull String tablePackage) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)tablePackage, (String)"tablePackage");
            Builder $this$tablePackage_u24lambda_u248 = builder = this;
            boolean bl = false;
            $this$tablePackage_u24lambda_u248.tablePackage = SymbolTableKt.access$validate(tablePackage);
            return builder;
        }

        public final boolean contains(@NotNull Symbol symbol) {
            Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
            return this.contains(symbol.getResourceType(), symbol.getCanonicalName());
        }

        public final boolean contains(@NotNull ResourceType resourceType, @NotNull String canonicalName) {
            Intrinsics.checkNotNullParameter((Object)resourceType, (String)"resourceType");
            Intrinsics.checkNotNullParameter((Object)canonicalName, (String)"canonicalName");
            return this.symbols.contains((Object)resourceType, (Object)canonicalName);
        }

        @Nullable
        public final Symbol get(@NotNull Symbol symbol) {
            Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
            return (Symbol)this.symbols.get((Object)symbol.getResourceType(), (Object)symbol.getCanonicalName());
        }

        @Nullable
        public final Symbol remove(@NotNull ResourceType resourceType, @NotNull String canonicalName) {
            Intrinsics.checkNotNullParameter((Object)resourceType, (String)"resourceType");
            Intrinsics.checkNotNullParameter((Object)canonicalName, (String)"canonicalName");
            return (Symbol)this.symbols.remove((Object)resourceType, (Object)canonicalName);
        }

        public final boolean isEmpty() {
            return this.symbols.isEmpty();
        }

        @NotNull
        public final SymbolTable build() {
            ImmutableTable immutableTable = ImmutableTable.copyOf(this.symbols);
            Intrinsics.checkNotNullExpressionValue((Object)immutableTable, (String)"copyOf(...)");
            return new SymbolTableImpl(this.tablePackage, (ImmutableTable<ResourceType, String, Symbol>)immutableTable);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\u00020\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0007J\u001e\u0010\r\u001a\u00020\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0007R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/android/ide/common/symbols/SymbolTable$Companion;", "", "<init>", "()V", "EMPTY", "Lcom/android/ide/common/symbols/SymbolTable;", "getEMPTY", "()Lcom/android/ide/common/symbols/SymbolTable;", "EMPTY$delegate", "Lkotlin/Lazy;", "merge", "tables", "", "mergePartialTables", "Ljava/io/File;", "packageName", "", "builder", "Lcom/android/ide/common/symbols/SymbolTable$Builder;", "android.sdktools.sdk-common"})
    @SourceDebugExtension(value={"SMAP\nSymbolTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SymbolTable.kt\ncom/android/ide/common/symbols/SymbolTable$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,421:1\n774#2:422\n865#2,2:423\n1869#2,2:425\n*S KotlinDebug\n*F\n+ 1 SymbolTable.kt\ncom/android/ide/common/symbols/SymbolTable$Companion\n*L\n381#1:422\n381#1:423,2\n387#1:425,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SymbolTable getEMPTY() {
            Lazy lazy = EMPTY$delegate;
            return (SymbolTable)lazy.getValue();
        }

        @JvmStatic
        @NotNull
        public final SymbolTable merge(@NotNull List<? extends SymbolTable> tables) {
            Intrinsics.checkNotNullParameter(tables, (String)"tables");
            if (tables.size() == 1) {
                return (SymbolTable)CollectionsKt.first(tables);
            }
            ImmutableTable.Builder builder = ImmutableTable.builder();
            Set seenNamesInResourceType = new LinkedHashSet();
            for (ResourceType resourceType : ResourceType.values()) {
                for (SymbolTable symbolTable : tables) {
                    UnmodifiableIterator unmodifiableIterator;
                    Intrinsics.checkNotNullExpressionValue((Object)((ImmutableCollection)symbolTable.getSymbols().row((Object)resourceType).values()).iterator(), (String)"iterator(...)");
                    while (unmodifiableIterator.hasNext()) {
                        Symbol symbol = (Symbol)unmodifiableIterator.next();
                        if (!seenNamesInResourceType.add(symbol.getCanonicalName())) continue;
                        builder.put((Object)resourceType, (Object)symbol.getCanonicalName(), (Object)symbol);
                    }
                }
                seenNamesInResourceType.clear();
            }
            Object object = (SymbolTable)CollectionsKt.firstOrNull(tables);
            if (object == null || (object = ((SymbolTable)object).getTablePackage()) == null) {
                object = "";
            }
            ImmutableTable immutableTable = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)immutableTable, (String)"build(...)");
            return new SymbolTableImpl((String)object, (ImmutableTable<ResourceType, String, Symbol>)immutableTable);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final SymbolTable mergePartialTables(@NotNull List<? extends File> tables, @NotNull String packageName) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(tables, (String)"tables");
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            SymbolIo symbolIo = new SymbolIo();
            Builder builder = this.builder().tablePackage(packageName);
            HashSet<String> visitedLayoutFiles = new HashSet<String>();
            Iterable $this$filter$iv = CollectionsKt.asReversed(tables);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                File it = (File)element$iv$iv;
                boolean bl = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!(!StringsKt.startsWith$default((String)string, (String)"layout", (boolean)false, (int)2, null) || visitedLayoutFiles.add(it.getName()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                try {
                    SymbolTable symbolTable = symbolIo.readFromPartialRFile(it, null);
                    Intrinsics.checkNotNullExpressionValue((Object)symbolTable, (String)"readFromPartialRFile(...)");
                    builder.addFromPartial$android_sdktools_sdk_common(symbolTable);
                }
                catch (Exception e) {
                    throw new PartialRMergingException("An error occurred during merging of the partial R files", e);
                }
            }
            return builder.build();
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004J\u0014\u0010\u000f\u001a\u00020\r2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010J\u000e\u0010\u0007\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\u0011\u001a\u00020\u0012R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/ide/common/symbols/SymbolTable$FastBuilder;", "", "symbolInterner", "Lcom/google/common/collect/Interner;", "Lcom/android/ide/common/symbols/Symbol;", "<init>", "(Lcom/google/common/collect/Interner;)V", "tablePackage", "", "symbols", "Lcom/google/common/collect/ImmutableTable$Builder;", "Lcom/android/resources/ResourceType;", "add", "", "symbol", "addAll", "", "build", "Lcom/android/ide/common/symbols/SymbolTable;", "android.sdktools.sdk-common"})
    @SourceDebugExtension(value={"SMAP\nSymbolTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SymbolTable.kt\ncom/android/ide/common/symbols/SymbolTable$FastBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,421:1\n1869#2,2:422\n*S KotlinDebug\n*F\n+ 1 SymbolTable.kt\ncom/android/ide/common/symbols/SymbolTable$FastBuilder\n*L\n319#1:422,2\n*E\n"})
    public static final class FastBuilder {
        @NotNull
        private final Interner<Symbol> symbolInterner;
        @NotNull
        private String tablePackage;
        @NotNull
        private final ImmutableTable.Builder<ResourceType, String, Symbol> symbols;

        public FastBuilder(@NotNull Interner<Symbol> symbolInterner) {
            Intrinsics.checkNotNullParameter(symbolInterner, (String)"symbolInterner");
            this.symbolInterner = symbolInterner;
            this.tablePackage = "";
            ImmutableTable.Builder builder = ImmutableTable.builder();
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder(...)");
            this.symbols = builder;
        }

        public final void add(@NotNull Symbol symbol) {
            Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
            this.symbols.put((Object)symbol.getResourceType(), (Object)symbol.getCanonicalName(), this.symbolInterner.intern((Object)symbol));
        }

        public final void addAll(@NotNull Collection<? extends Symbol> symbols) {
            Intrinsics.checkNotNullParameter(symbols, (String)"symbols");
            Iterable $this$forEach$iv = symbols;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Symbol it = (Symbol)element$iv;
                boolean bl = false;
                this.add(it);
            }
        }

        public final void tablePackage(@NotNull String tablePackage) {
            Intrinsics.checkNotNullParameter((Object)tablePackage, (String)"tablePackage");
            this.tablePackage = SymbolTableKt.access$validate(tablePackage);
        }

        @NotNull
        public final SymbolTable build() {
            ImmutableTable immutableTable = this.symbols.build();
            Intrinsics.checkNotNullExpressionValue((Object)immutableTable, (String)"build(...)");
            return new SymbolTableImpl(this.tablePackage, (ImmutableTable<ResourceType, String, Symbol>)immutableTable);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/ide/common/symbols/SymbolTable$IllegalResourceVisibilityException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "description", "", "<init>", "(Ljava/lang/String;)V", "android.sdktools.sdk-common"})
    public static final class IllegalResourceVisibilityException
    extends Exception {
        public IllegalResourceVisibilityException(@NotNull String description) {
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            super(description);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u0003H\u0016J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u001b\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0003J/\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u001a\b\u0002\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR&\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/android/ide/common/symbols/SymbolTable$SymbolTableImpl;", "Lcom/android/ide/common/symbols/SymbolTable;", "tablePackage", "", "symbols", "Lcom/google/common/collect/ImmutableTable;", "Lcom/android/resources/ResourceType;", "Lcom/android/ide/common/symbols/Symbol;", "<init>", "(Ljava/lang/String;Lcom/google/common/collect/ImmutableTable;)V", "getTablePackage", "()Ljava/lang/String;", "getSymbols", "()Lcom/google/common/collect/ImmutableTable;", "toString", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "android.sdktools.sdk-common"})
    private static final class SymbolTableImpl
    extends SymbolTable {
        @NotNull
        private final String tablePackage;
        @NotNull
        private final ImmutableTable<ResourceType, String, Symbol> symbols;

        public SymbolTableImpl(@NotNull String tablePackage, @NotNull ImmutableTable<ResourceType, String, Symbol> symbols) {
            Intrinsics.checkNotNullParameter((Object)tablePackage, (String)"tablePackage");
            Intrinsics.checkNotNullParameter(symbols, (String)"symbols");
            this.tablePackage = tablePackage;
            this.symbols = symbols;
        }

        @Override
        @NotNull
        public String getTablePackage() {
            return this.tablePackage;
        }

        @Override
        @NotNull
        public ImmutableTable<ResourceType, String, Symbol> getSymbols() {
            return this.symbols;
        }

        @NotNull
        public String toString() {
            ImmutableCollection immutableCollection = this.getSymbols().values();
            Intrinsics.checkNotNullExpressionValue((Object)immutableCollection, (String)"values(...)");
            return CollectionsKt.joinToString$default((Iterable)((Iterable)immutableCollection), (CharSequence)"\n  ", (CharSequence)("SymbolTable (" + this.getTablePackage() + ")\n "), null, (int)0, null, null, (int)60, null);
        }

        @NotNull
        public final String component1() {
            return this.tablePackage;
        }

        @NotNull
        public final ImmutableTable<ResourceType, String, Symbol> component2() {
            return this.symbols;
        }

        @NotNull
        public final SymbolTableImpl copy(@NotNull String tablePackage, @NotNull ImmutableTable<ResourceType, String, Symbol> symbols) {
            Intrinsics.checkNotNullParameter((Object)tablePackage, (String)"tablePackage");
            Intrinsics.checkNotNullParameter(symbols, (String)"symbols");
            return new SymbolTableImpl(tablePackage, symbols);
        }

        public static /* synthetic */ SymbolTableImpl copy$default(SymbolTableImpl symbolTableImpl, String string, ImmutableTable immutableTable, int n, Object object) {
            if ((n & 1) != 0) {
                string = symbolTableImpl.tablePackage;
            }
            if ((n & 2) != 0) {
                immutableTable = symbolTableImpl.symbols;
            }
            return symbolTableImpl.copy(string, immutableTable);
        }

        public int hashCode() {
            int result = this.tablePackage.hashCode();
            result = result * 31 + this.symbols.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SymbolTableImpl)) {
                return false;
            }
            SymbolTableImpl symbolTableImpl = (SymbolTableImpl)other;
            if (!Intrinsics.areEqual((Object)this.tablePackage, (Object)symbolTableImpl.tablePackage)) {
                return false;
            }
            return Intrinsics.areEqual(this.symbols, symbolTableImpl.symbols);
        }
    }
}

