/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutlib;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public final class LayoutlibBundle {
    private static final String BUNDLE_NAME = "messages.LayoutlibBundle";
    private static Reference<ResourceBundle> ourBundle;

    private static ResourceBundle getBundle() {
        ResourceBundle bundle;
        ResourceBundle resourceBundle = bundle = ourBundle != null ? ourBundle.get() : null;
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(BUNDLE_NAME);
            ourBundle = new SoftReference<ResourceBundle>(bundle);
        }
        return bundle;
    }

    private LayoutlibBundle() {
    }

    public static String message(String key, Object ... params) {
        return LayoutlibBundle.readFromBundleAndFormat(LayoutlibBundle.getBundle(), key, params);
    }

    private static String readFromBundleAndFormat(ResourceBundle bundle, String key, Object ... params) {
        String rawValue = bundle.getString(key);
        Locale locale = bundle.getLocale();
        MessageFormat format = new MessageFormat(rawValue, locale);
        return format.format(params);
    }
}

