/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.developerexperience.cloudcode.intellij.auth;

import androidx.annotation.OpenForTesting;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleRefreshTokenRequest;
import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.cloud.developerexperience.cloudcode.intellij.auth.ApplicationDefaultCredential;
import com.google.cloud.developerexperience.cloudcode.intellij.auth.GoogleLoginCredential;
import com.google.cloud.developerexperience.cloudcode.intellij.auth.IntellijLoginClient;
import com.google.cloud.developerexperience.cloudcode.intellij.auth.OAuthDataStore;
import com.google.common.annotations.VisibleForTesting;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.time.Instant;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 72\u00020\u0001:\u00017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0013H\u0017J\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\"\u0010\u001d\u001a\u00020\u001e2\b\u0010!\u001a\u0004\u0018\u00010\u001c2\b\u0010\"\u001a\u0004\u0018\u00010\u001c2\u0006\u0010#\u001a\u00020$J\u0010\u0010%\u001a\u00020\u001e2\b\u0010&\u001a\u0004\u0018\u00010\u001cJ\b\u0010'\u001a\u00020\u001eH\u0017J\u0006\u0010(\u001a\u00020\u001eJ\u0010\u0010)\u001a\u00020\u001e2\b\u0010*\u001a\u0004\u0018\u00010\u001cJ\u0006\u0010+\u001a\u00020\u001eJ\r\u0010,\u001a\u00020\u001eH\u0011\u00a2\u0006\u0002\b-J\b\u0010.\u001a\u00020\u001eH\u0002J\b\u0010/\u001a\u00020\u0013H\u0002J\u000f\u00100\u001a\u0004\u0018\u00010\u001cH\u0011\u00a2\u0006\u0002\b1J\r\u00102\u001a\u000203H\u0011\u00a2\u0006\u0002\b4J\r\u00105\u001a\u00020$H\u0011\u00a2\u0006\u0002\b6R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000f\"\u0004\b\u0010\u0010\u0011R$\u0010\u0012\u001a\u00020\u00138\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u00068"}, d2={"Lcom/google/cloud/developerexperience/cloudcode/intellij/auth/GoogleLoginStateStore;", "", "oauthDataStore", "Lcom/google/cloud/developerexperience/cloudcode/intellij/auth/OAuthDataStore;", "intellijLoginClient", "Lcom/google/cloud/developerexperience/cloudcode/intellij/auth/IntellijLoginClient;", "<init>", "(Lcom/google/cloud/developerexperience/cloudcode/intellij/auth/OAuthDataStore;Lcom/google/cloud/developerexperience/cloudcode/intellij/auth/IntellijLoginClient;)V", "netHttpTransport", "Lcom/google/api/client/http/javanet/NetHttpTransport;", "gsonFactory", "Lcom/google/api/client/json/gson/GsonFactory;", "kotlin.jvm.PlatformType", "isLoggedIn", "", "()Z", "setLoggedIn", "(Z)V", "innerCredentials", "Lcom/google/cloud/developerexperience/cloudcode/intellij/auth/GoogleLoginCredential;", "getInnerCredentials$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib$annotations", "()V", "getInnerCredentials$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib", "()Lcom/google/cloud/developerexperience/cloudcode/intellij/auth/GoogleLoginCredential;", "setInnerCredentials$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib", "(Lcom/google/cloud/developerexperience/cloudcode/intellij/auth/GoogleLoginCredential;)V", "getGoogleLoginCredential", "getEmail", "", "updateAndSaveUserCredentials", "", "credential", "Lcom/google/api/client/auth/oauth2/Credential;", "refreshToken", "accessToken", "accessTokenExpiryTimeInSeconds", "", "updateAndSaveEmail", "userEmail", "logOutAndDeleteCredentials", "refreshCredentials", "stageAdc", "quotaProjectId", "deleteAdc", "saveCredentials", "saveCredentials$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib", "reloadSavedCredentialsIfAccessTokenEmpty", "fetchGoogleLoginCredential", "refreshAccessToken", "refreshAccessToken$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib", "initiateGoogleRefreshTokenRequest", "Lcom/google/api/client/googleapis/auth/oauth2/GoogleTokenResponse;", "initiateGoogleRefreshTokenRequest$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib", "getCurrentTime", "getCurrentTime$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib", "Companion", "java.com.google.cloud.developerexperience.cloudcode.intellij.auth_google_auth_intellij_lib"})
@OpenForTesting
@SourceDebugExtension(value={"SMAP\nGoogleLoginStateStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoogleLoginStateStore.kt\ncom/google/cloud/developerexperience/cloudcode/intellij/auth/GoogleLoginStateStore\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,236:1\n1#2:237\n*E\n"})
public class GoogleLoginStateStore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OAuthDataStore oauthDataStore;
    @NotNull
    private final IntellijLoginClient intellijLoginClient;
    @NotNull
    private final NetHttpTransport netHttpTransport;
    private final GsonFactory gsonFactory;
    private boolean isLoggedIn;
    @NotNull
    private volatile GoogleLoginCredential innerCredentials;
    @NotNull
    private static final Logger logger;

    public GoogleLoginStateStore(@NotNull OAuthDataStore oauthDataStore, @NotNull IntellijLoginClient intellijLoginClient) {
        Intrinsics.checkNotNullParameter((Object)oauthDataStore, (String)"oauthDataStore");
        Intrinsics.checkNotNullParameter((Object)intellijLoginClient, (String)"intellijLoginClient");
        this.oauthDataStore = oauthDataStore;
        this.intellijLoginClient = intellijLoginClient;
        this.netHttpTransport = new NetHttpTransport();
        this.gsonFactory = GsonFactory.getDefaultInstance();
        this.innerCredentials = new GoogleLoginCredential(null, null, null, null);
    }

    public final boolean isLoggedIn() {
        return this.isLoggedIn;
    }

    public final void setLoggedIn(boolean bl) {
        this.isLoggedIn = bl;
    }

    @NotNull
    public final GoogleLoginCredential getInnerCredentials$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib() {
        return this.innerCredentials;
    }

    public final void setInnerCredentials$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib(@NotNull GoogleLoginCredential googleLoginCredential) {
        Intrinsics.checkNotNullParameter((Object)googleLoginCredential, (String)"<set-?>");
        this.innerCredentials = googleLoginCredential;
    }

    @VisibleForTesting
    public static /* synthetic */ void getInnerCredentials$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib$annotations() {
    }

    @OpenForTesting
    @Nullable
    public GoogleLoginCredential getGoogleLoginCredential() {
        this.reloadSavedCredentialsIfAccessTokenEmpty();
        if (!this.isLoggedIn) {
            logger.log(Level.WARNING, "Bad State: Unable to retrieve the access token since user is not logged in");
            return null;
        }
        return this.fetchGoogleLoginCredential();
    }

    @Nullable
    public final String getEmail() {
        if (this.innerCredentials.getEmail() == null) {
            this.refreshCredentials();
        }
        return this.innerCredentials.getEmail();
    }

    public final void updateAndSaveUserCredentials(@NotNull Credential credential) {
        Intrinsics.checkNotNullParameter((Object)credential, (String)"credential");
        String string = credential.getRefreshToken();
        String string2 = credential.getAccessToken();
        Long l = credential.getExpiresInSeconds();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getExpiresInSeconds(...)");
        this.updateAndSaveUserCredentials(string, string2, ((Number)l).longValue());
    }

    public final void updateAndSaveUserCredentials(@Nullable String refreshToken, @Nullable String accessToken, long accessTokenExpiryTimeInSeconds) {
        this.isLoggedIn = true;
        this.innerCredentials.setRefreshToken(refreshToken);
        this.innerCredentials.setAccessToken(accessToken);
        this.innerCredentials.setAccessTokenExpiryTimeInSeconds(this.getCurrentTime$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib() + accessTokenExpiryTimeInSeconds);
        this.saveCredentials$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib();
    }

    public final void updateAndSaveEmail(@Nullable String userEmail) {
        this.innerCredentials.setEmail(userEmail);
        this.saveCredentials$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib();
    }

    @OpenForTesting
    public void logOutAndDeleteCredentials() {
        this.isLoggedIn = false;
        this.innerCredentials = new GoogleLoginCredential(null, null, null, null);
        this.oauthDataStore.clearStoredOAuthData();
    }

    public final void refreshCredentials() {
        GoogleLoginCredential newCredentials = this.oauthDataStore.loadOAuthData();
        if (newCredentials == null) {
            this.logOutAndDeleteCredentials();
            return;
        }
        this.isLoggedIn = true;
        this.innerCredentials = newCredentials;
    }

    public final void stageAdc(@Nullable String quotaProjectId) {
        if (!this.isLoggedIn) {
            return;
        }
        this.oauthDataStore.stageAdc(new ApplicationDefaultCredential(this.intellijLoginClient.getOAuthClientId(), this.intellijLoginClient.getOAuthClientNotSoSecret(), quotaProjectId, this.innerCredentials.getRefreshToken(), null, 16, null));
    }

    public final void deleteAdc() {
        this.oauthDataStore.deleteAdc();
    }

    @VisibleForTesting
    @OpenForTesting
    public void saveCredentials$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib() {
        this.oauthDataStore.saveOAuthData(this.innerCredentials);
    }

    private final void reloadSavedCredentialsIfAccessTokenEmpty() {
        if (this.innerCredentials.getAccessToken() == null) {
            this.refreshCredentials();
        }
    }

    private final GoogleLoginCredential fetchGoogleLoginCredential() {
        Long l = this.innerCredentials.getAccessTokenExpiryTimeInSeconds();
        if (l != null) {
            long expiryTime = ((Number)l).longValue();
            boolean bl = false;
            if (expiryTime <= 0L || this.getCurrentTime$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib() >= expiryTime) {
                this.refreshAccessToken$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib();
            }
        } else {
            GoogleLoginStateStore $this$fetchGoogleLoginCredential_u24lambda_u241 = this;
            boolean bl = false;
            $this$fetchGoogleLoginCredential_u24lambda_u241.refreshAccessToken$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib();
        }
        return this.innerCredentials.clone();
    }

    @VisibleForTesting
    @OpenForTesting
    @CanIgnoreReturnValue
    @Nullable
    public String refreshAccessToken$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib() {
        if (this.innerCredentials.getRefreshToken() == null) {
            this.logOutAndDeleteCredentials();
            return null;
        }
        try {
            GoogleTokenResponse authResponse = this.initiateGoogleRefreshTokenRequest$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib();
            this.innerCredentials.setAccessToken(authResponse.getAccessToken());
            long l = this.getCurrentTime$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib();
            Long l2 = authResponse.getExpiresInSeconds();
            Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"getExpiresInSeconds(...)");
            this.innerCredentials.setAccessTokenExpiryTimeInSeconds(l + ((Number)l2).longValue());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to fetch OAuth token", e);
            this.logOutAndDeleteCredentials();
        }
        this.saveCredentials$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib();
        return this.innerCredentials.getAccessToken();
    }

    @VisibleForTesting
    @OpenForTesting
    @NotNull
    public GoogleTokenResponse initiateGoogleRefreshTokenRequest$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib() throws IOException {
        GoogleRefreshTokenRequest request = new GoogleRefreshTokenRequest((HttpTransport)this.netHttpTransport, (JsonFactory)this.gsonFactory, this.innerCredentials.getRefreshToken(), this.intellijLoginClient.getOAuthClientId(), this.intellijLoginClient.getOAuthClientNotSoSecret());
        GoogleTokenResponse googleTokenResponse = request.execute();
        Intrinsics.checkNotNullExpressionValue((Object)googleTokenResponse, (String)"execute(...)");
        return googleTokenResponse;
    }

    @VisibleForTesting
    @OpenForTesting
    public long getCurrentTime$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib() {
        return Instant.now().getEpochSecond();
    }

    static {
        Logger logger = Logger.getLogger(Companion.getClass().getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        GoogleLoginStateStore.logger = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/google/cloud/developerexperience/cloudcode/intellij/auth/GoogleLoginStateStore$Companion;", "", "<init>", "()V", "logger", "Ljava/util/logging/Logger;", "java.com.google.cloud.developerexperience.cloudcode.intellij.auth_google_auth_intellij_lib"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

