/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.project.workspace;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.project.CidrRootConfigurationListener;
import com.jetbrains.cidr.project.workspace.CidrWorkspace;
import com.jetbrains.cidr.project.workspace.CidrWorkspaceListener;
import com.jetbrains.cidr.project.workspace.CidrWorkspaceManager;
import com.jetbrains.cidr.project.workspace.CidrWorkspaceState;
import com.jetbrains.cidr.project.workspace.OCRootsSynchronizer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010\u0011\u001a\u00020\u00102\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/project/workspace/OCRootsSynchronizerHandler;", "Lcom/intellij/openapi/Disposable$Default;", "workspaceManager", "Lcom/jetbrains/cidr/project/workspace/CidrWorkspaceManager;", "<init>", "(Lcom/jetbrains/cidr/project/workspace/CidrWorkspaceManager;)V", "project", "Lcom/intellij/openapi/project/Project;", "isListening", "", "myBusConnectionDisposable", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "lock", "", "startListeningIfNecessary", "", "stopListeningIfNecessary", "allWorkspaces", "", "Lcom/jetbrains/cidr/project/workspace/CidrWorkspace;", "Lcom/jetbrains/cidr/project/workspace/CidrWorkspaceState;", "intellij.cidr.workspaceModel"})
@SourceDebugExtension(value={"SMAP\nCidrWorkspaceManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrWorkspaceManager.kt\ncom/jetbrains/cidr/project/workspace/OCRootsSynchronizerHandler\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,240:1\n188#2,3:241\n*S KotlinDebug\n*F\n+ 1 CidrWorkspaceManager.kt\ncom/jetbrains/cidr/project/workspace/OCRootsSynchronizerHandler\n*L\n225#1:241,3\n*E\n"})
final class OCRootsSynchronizerHandler
implements Disposable.Default {
    @NotNull
    private final Project project;
    private volatile boolean isListening;
    @NotNull
    private final Disposable myBusConnectionDisposable;
    @NotNull
    private final Object lock;

    public OCRootsSynchronizerHandler(@NotNull CidrWorkspaceManager workspaceManager) {
        Intrinsics.checkNotNullParameter((Object)workspaceManager, (String)"workspaceManager");
        this.project = workspaceManager.getProject();
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.myBusConnectionDisposable = disposable;
        Object object = ObjectUtils.sentinel((String)"OCRootsSynchronizerHandler's lock");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sentinel(...)");
        this.lock = object;
        Disposer.register((Disposable)workspaceManager, (Disposable)((Disposable)this));
        this.project.getMessageBus().connect((Disposable)this).subscribe(CidrWorkspaceListener.TOPIC, (Object)new CidrWorkspaceListener(){

            @Override
            public void workspaceStateChanged(CidrWorkspace workspace, CidrWorkspaceState oldState, CidrWorkspaceState newState, Map<CidrWorkspace, ? extends CidrWorkspaceState> allWorkspaces) {
                Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
                Intrinsics.checkNotNullParameter((Object)((Object)oldState), (String)"oldState");
                Intrinsics.checkNotNullParameter((Object)((Object)newState), (String)"newState");
                Intrinsics.checkNotNullParameter(allWorkspaces, (String)"allWorkspaces");
                if (newState.getExists()) {
                    this.startListeningIfNecessary();
                } else {
                    this.stopListeningIfNecessary(allWorkspaces);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void startListeningIfNecessary() {
        if (this.isListening) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (this.isListening) {
                return;
            }
            this.isListening = true;
            Disposer.register((Disposable)((Disposable)this), (Disposable)this.myBusConnectionDisposable);
            MessageBusConnection messageBusConnection = this.project.getMessageBus().connect(this.myBusConnectionDisposable);
            Topic<CidrRootConfigurationListener> topic = CidrRootConfigurationListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
            messageBusConnection.subscribe(topic, () -> OCRootsSynchronizerHandler.startListeningIfNecessary$lambda$1$lambda$0(this));
            OCRootsSynchronizer.Companion.getInstance(this.project).startListening();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void stopListeningIfNecessary(Map<CidrWorkspace, ? extends CidrWorkspaceState> allWorkspaces) {
        boolean bl;
        block9: {
            Map<CidrWorkspace, ? extends CidrWorkspaceState> $this$any$iv = allWorkspaces;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator<Map.Entry<CidrWorkspace, ? extends CidrWorkspaceState>> iterator = $this$any$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<CidrWorkspace, ? extends CidrWorkspaceState> element$iv;
                    Map.Entry<CidrWorkspace, ? extends CidrWorkspaceState> entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    CidrWorkspaceState value = entry.getValue();
                    if (!value.getExists()) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        if (!this.isListening) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            boolean bl3 = false;
            if (!this.isListening) {
                return;
            }
            this.isListening = false;
            OCRootsSynchronizer.Companion.getInstance(this.project).shutdown();
            Disposer.dispose((Disposable)this.myBusConnectionDisposable);
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final void startListeningIfNecessary$lambda$1$lambda$0(OCRootsSynchronizerHandler this$0) {
        List<CidrWorkspace> initializedWorkspaces = CidrWorkspaceManager.Companion.getInstance(this$0.project).getInitializedWorkspaces();
        OCRootsSynchronizer.Companion.getInstance(this$0.project).batchUpdateRoots(initializedWorkspaces);
    }
}

