/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml;

import com.android.studio.ml.TerminalService;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.ui.TerminalWidget;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalToolWindowManager;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u0010H\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\fH\u0016J\u001a\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0012\u001a\u00020\fH\u0002J\f\u0010\u0016\u001a\u00020\u000e*\u00020\u000eH\u0002J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\fH\u0002R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/studio/ml/TerminalServiceImpl;", "Lcom/android/studio/ml/TerminalService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "terminalToolWindow", "Lorg/jetbrains/plugins/terminal/TerminalToolWindowManager;", "kotlin.jvm.PlatformType", "getActiveTerminal", "Lcom/android/studio/ml/TerminalService$TerminalInfo;", "isTerminalPresent", "", "terminalName", "", "getOpenTerminals", "", "getTerminalContentByName", "onlySelectedText", "toTerminalInfo", "widget", "Lcom/intellij/terminal/ui/TerminalWidget;", "takeLastLines", "getText", "aiplugin.core.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalService.kt\ncom/android/studio/ml/TerminalServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,131:1\n295#2,2:132\n1761#2,3:135\n1563#2:138\n1634#2,3:139\n295#2,2:142\n1#3:134\n*S KotlinDebug\n*F\n+ 1 TerminalService.kt\ncom/android/studio/ml/TerminalServiceImpl\n*L\n56#1:132,2\n61#1:135,3\n67#1:138\n67#1:139,3\n72#1:142,2\n*E\n"})
public final class TerminalServiceImpl
implements TerminalService {
    private final TerminalToolWindowManager terminalToolWindow;

    public TerminalServiceImpl(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.terminalToolWindow = TerminalToolWindowManager.getInstance((Project)project2);
    }

    @Override
    @Nullable
    public TerminalService.TerminalInfo getActiveTerminal() {
        TerminalService.TerminalInfo terminalInfo;
        Object v1;
        block3: {
            Set set = this.terminalToolWindow.getTerminalWidgets();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getTerminalWidgets(...)");
            Iterable $this$firstOrNull$iv = set;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                TerminalWidget it = (TerminalWidget)element$iv;
                boolean bl = false;
                if (!it.getComponent().isShowing()) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        TerminalWidget terminalWidget = v1;
        if (terminalWidget != null) {
            TerminalWidget it = terminalWidget;
            boolean bl = false;
            terminalInfo = this.toTerminalInfo(it, true);
        } else {
            terminalInfo = null;
        }
        return terminalInfo;
    }

    @Override
    public boolean isTerminalPresent(@NotNull String terminalName) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)terminalName, (String)"terminalName");
            Set set = this.terminalToolWindow.getTerminalWidgets();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getTerminalWidgets(...)");
            Iterable $this$any$iv = set;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TerminalWidget it = (TerminalWidget)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)String.valueOf(it.getTerminalTitle().getDefaultTitle()), (Object)terminalName)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<TerminalService.TerminalInfo> getOpenTerminals() {
        void $this$mapTo$iv$iv;
        Set set = this.terminalToolWindow.getTerminalWidgets();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getTerminalWidgets(...)");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TerminalWidget terminalWidget = (TerminalWidget)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(TerminalServiceImpl.toTerminalInfo$default(this, (TerminalWidget)it, false, 2, null));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public String getTerminalContentByName(@NotNull String terminalName, boolean onlySelectedText) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)terminalName, (String)"terminalName");
            Set set = this.terminalToolWindow.getTerminalWidgets();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getTerminalWidgets(...)");
            Iterable $this$firstOrNull$iv = set;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                TerminalWidget it = (TerminalWidget)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)String.valueOf(it.getTerminalTitle().getDefaultTitle()), (Object)terminalName)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        TerminalWidget terminalWidget = v1;
        return this.getText(terminalWidget, onlySelectedText);
    }

    private final TerminalService.TerminalInfo toTerminalInfo(TerminalWidget widget, boolean onlySelectedText) {
        String terminalId = String.valueOf(widget.getTerminalTitle().getDefaultTitle());
        boolean isActive = widget.getComponent().isShowing();
        String selectedText = onlySelectedText ? this.getText(widget, true) : null;
        return new TerminalService.TerminalInfo(terminalId, isActive, selectedText);
    }

    static /* synthetic */ TerminalService.TerminalInfo toTerminalInfo$default(TerminalServiceImpl terminalServiceImpl, TerminalWidget terminalWidget, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return terminalServiceImpl.toTerminalInfo(terminalWidget, bl);
    }

    private final String takeLastLines(String $this$takeLastLines) {
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.takeLast((List)StringsKt.lines((CharSequence)$this$takeLastLines), (int)1000), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    private final String getText(TerminalWidget widget, boolean onlySelectedText) {
        String rawText;
        String string;
        if (widget == null) {
            return null;
        }
        DataContext dataContext2 = DataManager.getInstance().getDataContext((Component)widget.getComponent());
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        DataContext dataContext3 = dataContext2;
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext3);
        if (editor2 != null) {
            string = (String)ApplicationManager.getApplication().runReadAction(() -> TerminalServiceImpl.getText$lambda$5(onlySelectedText, editor2));
        } else if (widget.getComponent() instanceof JBTerminalWidget) {
            JComponent jComponent = widget.getComponent();
            Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.intellij.terminal.JBTerminalWidget");
            JBTerminalWidget terminalWidget = (JBTerminalWidget)jComponent;
            string = onlySelectedText ? terminalWidget.getSelectedText() : terminalWidget.getText();
        } else {
            string = null;
        }
        String string2 = rawText = string;
        return string2 != null ? this.takeLastLines(string2) : null;
    }

    private static final String getText$lambda$5(boolean $onlySelectedText, Editor $editor) {
        return $onlySelectedText ? $editor.getSelectionModel().getSelectedText() : ((Object)$editor.getDocument().getImmutableCharSequence()).toString();
    }
}

