/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.action;

import com.android.studio.ml.bot.action.CodeSelectionExtractor;
import com.android.studio.ml.bot.action.CodeSelectionUtils;
import com.android.studio.ml.bot.action.JvmCodeSelectionExtractorKt;
import com.android.studio.ml.bot.parse.UtilsKt;
import com.android.tools.idea.studiobot.MimeType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtScriptInitializer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0003R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/android/studio/ml/bot/action/JvmCodeSelectionExtractor;", "Lcom/android/studio/ml/bot/action/CodeSelectionExtractor;", "<init>", "()V", "languages", "", "Lcom/android/tools/idea/studiobot/MimeType;", "getLanguages", "()Ljava/util/List;", "getApplicableCodeFrom", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "extractSurroundingPsiElement", "Lcom/intellij/psi/PsiElement;", "surroundingPsiElement", "element", "extractSurroundingBlock", "aiplugin.lang.kotlin"})
public final class JvmCodeSelectionExtractor
implements CodeSelectionExtractor {
    @NotNull
    private final List<MimeType> languages;

    public JvmCodeSelectionExtractor() {
        Object[] objectArray = new MimeType[]{MimeType.box-impl(MimeType.Companion.getKOTLIN-i_3W7CY()), MimeType.box-impl(MimeType.Companion.getJAVA-i_3W7CY())};
        this.languages = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public List<MimeType> getLanguages() {
        return this.languages;
    }

    @Override
    @Nullable
    public String getApplicableCodeFrom(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        String selectedText = CodeSelectionUtils.INSTANCE.getSelectedTextOrNull(editor2);
        CharSequence charSequence = selectedText;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return this.extractSurroundingBlock(editor2);
        }
        if (UtilsKt.isValidJavaIdentifier(selectedText)) {
            PsiElement parent;
            PsiElement element;
            PsiElement psiElement = element = CodeSelectionUtils.INSTANCE.getCurrentElement(editor2);
            if (Intrinsics.areEqual((Object)(psiElement != null ? psiElement.getText() : null), (Object)selectedText) && element instanceof LeafPsiElement && (Intrinsics.areEqual((Object)((LeafPsiElement)element).getElementType(), (Object)KtTokens.IDENTIFIER) || Intrinsics.areEqual((Object)((LeafPsiElement)element).getElementType(), (Object)JavaTokenType.IDENTIFIER)) && ((parent = ((LeafPsiElement)element).getParent()) instanceof KtClassOrObject || parent instanceof KtFunction || parent instanceof PsiClass || parent instanceof PsiMethod)) {
                String string = parent.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                return CodeSelectionUtils.INSTANCE.removeIndentFrom(string);
            }
        }
        String cleanCode = JvmCodeSelectionExtractorKt.access$getRE_FILE_ANNOTATION$p().replace((CharSequence)selectedText, "");
        cleanCode = JvmCodeSelectionExtractorKt.access$getRE_COPYRIGHT$p().replace((CharSequence)cleanCode, "");
        cleanCode = JvmCodeSelectionExtractorKt.access$getRE_PACKAGE$p().replace((CharSequence)cleanCode, "");
        return !StringsKt.isBlank((CharSequence)cleanCode) ? cleanCode : selectedText;
    }

    @Override
    @Nullable
    public PsiElement extractSurroundingPsiElement(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        PsiElement psiElement = CodeSelectionUtils.INSTANCE.getCurrentElement(editor2);
        if (psiElement == null) {
            return null;
        }
        PsiElement element = psiElement;
        return this.surroundingPsiElement(element);
    }

    private final PsiElement surroundingPsiElement(PsiElement element) {
        PsiElement psiElement;
        PsiElement target;
        for (target = element; target != null && ((psiElement = target) instanceof KtFunctionLiteral || !(psiElement instanceof KtFunction ? !(target instanceof KtConstructor) : psiElement instanceof KtClassOrObject || psiElement instanceof PsiMember || psiElement instanceof XmlTag || psiElement instanceof KtScriptInitializer || psiElement instanceof PsiFile)); target = target.getParent()) {
        }
        return target;
    }

    @NlsSafe
    private final String extractSurroundingBlock(Editor editor2) {
        String string;
        Object object = this.extractSurroundingPsiElement(editor2);
        if (object != null && (object = object.getText()) != null) {
            Object it = object;
            boolean bl = false;
            string = CodeSelectionUtils.INSTANCE.removeIndentFrom((String)it);
        } else {
            string = null;
        }
        return string;
    }

    @Override
    @RequiresReadLock
    @Nullable
    public PsiElement closestPsiElementInSelection(@NotNull PsiFile psiFile2, @NotNull SelectionModel selectionModel, @NotNull Function1<? super PsiElement, Boolean> elementSelector) {
        return CodeSelectionExtractor.super.closestPsiElementInSelection(psiFile2, selectionModel, elementSelector);
    }
}

