/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.action;

import com.android.studio.ml.bot.action.JvmReferenceDefinitionFinder;
import com.android.studio.ml.bot.action.JvmReferenceDefinitionFinderKt;
import com.android.studio.ml.bot.action.ReferenceDefinition;
import com.android.studio.ml.bot.action.ReferenceDefinitionFinder;
import com.android.studio.ml.bot.parse.JvmUtilsKt;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\rH\u0016J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/studio/ml/bot/action/JvmReferenceDefinitionFinder;", "Lcom/android/studio/ml/bot/action/ReferenceDefinitionFinder;", "element", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "usages", "", "Lcom/android/studio/ml/bot/action/ReferenceDefinition;", "", "referenceVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "find", "", "markReferenceDefinition", "", "reference", "resolved", "KotlinReferenceVisitor", "JavaReferenceVisitor", "aiplugin.lang.kotlin"})
@SourceDebugExtension(value={"SMAP\nJvmReferenceDefinitionFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmReferenceDefinitionFinder.kt\ncom/android/studio/ml/bot/action/JvmReferenceDefinitionFinder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n1#2:126\n213#3:127\n213#3:128\n1563#4:129\n1634#4,3:130\n1563#4:133\n1634#4,3:134\n*S KotlinDebug\n*F\n+ 1 JvmReferenceDefinitionFinder.kt\ncom/android/studio/ml/bot/action/JvmReferenceDefinitionFinder\n*L\n95#1:127\n96#1:128\n106#1:129\n106#1:130,3\n107#1:133\n107#1:134,3\n*E\n"})
final class JvmReferenceDefinitionFinder
implements ReferenceDefinitionFinder {
    @NotNull
    private final PsiElement element;
    @NotNull
    private final Map<ReferenceDefinition, Integer> usages;
    @NotNull
    private final PsiElementVisitor referenceVisitor;

    public JvmReferenceDefinitionFinder(@NotNull PsiElement element) {
        PsiElementVisitor psiElementVisitor;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.element = element;
        this.usages = new LinkedHashMap();
        Language language2 = this.element.getLanguage();
        if (language2 instanceof KotlinLanguage) {
            psiElementVisitor = (PsiElementVisitor)new KotlinReferenceVisitor();
        } else if (language2 instanceof JavaLanguage) {
            psiElementVisitor = (PsiElementVisitor)new JavaReferenceVisitor();
        } else {
            throw new IllegalArgumentException("Unexpected language " + this.element.getLanguage());
        }
        this.referenceVisitor = psiElementVisitor;
    }

    @Override
    @NotNull
    public Map<ReferenceDefinition, Integer> find() {
        if (!this.usages.isEmpty()) {
            boolean bl = false;
            String string = "Do not reuse ReferenceDefinitionFinder!";
            throw new IllegalStateException(string.toString());
        }
        if (!JvmReferenceDefinitionFinderKt.access$getJVM_LANGUAGES$p().contains(this.element.getLanguage())) {
            return MapsKt.emptyMap();
        }
        this.element.accept(this.referenceVisitor);
        return MapsKt.toMap(this.usages);
    }

    private final void markReferenceDefinition(PsiElement reference, PsiElement resolved) {
        String p0;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        List list;
        Object[] objectArray;
        String containingClass;
        if (resolved == null || resolved.getContainingFile() == null) {
            return;
        }
        String string = reference.getText();
        if (string == null) {
            return;
        }
        String referenceName = string;
        String packageName = JvmUtilsKt.getPackageName(resolved);
        if (packageName != null && (Intrinsics.areEqual((Object)packageName, (Object)"kotlin") || StringsKt.startsWith$default((String)packageName, (String)"kotlin.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)packageName, (String)"java.", (boolean)false, (int)2, null))) {
            return;
        }
        VirtualFile virtualFile2 = resolved.getContainingFile().getVirtualFile();
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile definitionFile = virtualFile2;
        String string2 = resolved.getText();
        if (string2 == null || (string2 = ((Object)StringsKt.trim((CharSequence)string2)).toString()) == null) {
            return;
        }
        String resolvedText = string2;
        if (resolved instanceof KtElement) {
            $this$getStrictParentOfType$iv = resolved;
            $i$f$getStrictParentOfType = false;
            KtClass ktClass = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtClass.class, (boolean)true);
            v4 = ktClass != null ? ktClass.getName() : null;
        } else {
            $this$getStrictParentOfType$iv = resolved;
            $i$f$getStrictParentOfType = false;
            PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, PsiClass.class, (boolean)true);
            v4 = containingClass = psiClass != null ? psiClass.getName() : null;
        }
        if (StringsKt.startsWith$default((String)resolvedText, (String)"/**", (boolean)false, (int)2, null)) {
            objectArray = new String[]{StringsKt.substringBefore$default((String)resolvedText, (String)"*/", null, (int)2, null) + "*/", StringsKt.substringAfter$default((String)resolvedText, (String)"*/", null, (int)2, null)};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            objectArray = new String[]{"", resolvedText};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        objectArray = list;
        boolean $i$f$map = false;
        void $i$f$getStrictParentOfType = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string3 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.trimIndent((String)p0));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            p0 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)p0)).toString());
        }
        List list2 = (List)destination$iv$iv;
        String docs = (String)list2.get(0);
        String code = (String)list2.get(1);
        Language language2 = reference.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"getLanguage(...)");
        Language language3 = resolved.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language3, (String)"getLanguage(...)");
        ReferenceDefinition definition = new ReferenceDefinition(referenceName, docs, code, definitionFile, containingClass, packageName, language2, language3);
        this.usages.merge(definition, 1, (arg_0, arg_1) -> JvmReferenceDefinitionFinder.markReferenceDefinition$lambda$2(markReferenceDefinition.3.INSTANCE, arg_0, arg_1));
    }

    private static final Integer markReferenceDefinition$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        return (Integer)$tmp0.invoke(p0, p1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/studio/ml/bot/action/JvmReferenceDefinitionFinder$JavaReferenceVisitor;", "Lcom/intellij/psi/JavaRecursiveElementVisitor;", "<init>", "(Lcom/android/studio/ml/bot/action/JvmReferenceDefinitionFinder;)V", "visitReferenceElement", "", "reference", "Lcom/intellij/psi/PsiJavaCodeReferenceElement;", "aiplugin.lang.kotlin"})
    private final class JavaReferenceVisitor
    extends JavaRecursiveElementVisitor {
        public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
            Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
            PsiElement psiElement = reference.resolve();
            JvmReferenceDefinitionFinder.this.markReferenceDefinition((PsiElement)reference, (PsiElement)(psiElement != null ? psiElement.getNavigationElement() : null));
            super.visitReferenceElement(reference);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/studio/ml/bot/action/JvmReferenceDefinitionFinder$KotlinReferenceVisitor;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "<init>", "(Lcom/android/studio/ml/bot/action/JvmReferenceDefinitionFinder;)V", "visitReferenceExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "aiplugin.lang.kotlin"})
    private final class KotlinReferenceVisitor
    extends KtTreeVisitorVoid {
        public void visitReferenceExpression(@NotNull KtReferenceExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            PsiElement psiElement = ReferenceUtilsKt.getMainReference((KtReferenceExpression)expression).resolve();
            JvmReferenceDefinitionFinder.this.markReferenceDefinition((PsiElement)expression, (PsiElement)(psiElement != null ? psiElement.getNavigationElement() : null));
            super.visitReferenceExpression(expression);
        }
    }
}

