/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.diff.ephemeral;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.bot.diff.ephemeral.EphemeralFileManager;
import com.android.studio.ml.util.CoroutineScopesKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ApplicationKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import io.ktor.util.collections.ConcurrentSetKt;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelIterator;
import kotlinx.coroutines.channels.ChannelKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0003\u001a\u001b\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0019\u001a\u00020\u0011H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/studio/ml/bot/diff/ephemeral/EphemeralFileManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "inboundListeners", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/nio/file/Path;", "Lcom/android/studio/ml/bot/diff/ephemeral/EphemeralFileManager$InboundSyncListener;", "inboundListenersAttachedToDocuments", "", "isSyncingMap", "Ljava/util/concurrent/atomic/AtomicBoolean;", "managedFilesCache", "Ljava/lang/ref/WeakReference;", "Lcom/intellij/testFramework/LightVirtualFile;", "attachDocumentListener", "", "path", "createEphemeralFile", "realFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "realFilePath", "", "detachDocumentListener", "dispose", "Companion", "InboundSyncListener", "OutboundSyncListener", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nEphemeralFileManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EphemeralFileManager.kt\ncom/android/studio/ml/bot/diff/ephemeral/EphemeralFileManager\n+ 2 CollectionEx.kt\ncom/jetbrains/rd/util/CollectionExKt\n*L\n1#1,246:1\n66#2,3:247\n*S KotlinDebug\n*F\n+ 1 EphemeralFileManager.kt\ncom/android/studio/ml/bot/diff/ephemeral/EphemeralFileManager\n*L\n144#1:247,3\n*E\n"})
public final class EphemeralFileManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentHashMap<Path, WeakReference<LightVirtualFile>> managedFilesCache;
    @NotNull
    private final ConcurrentHashMap<Path, InboundSyncListener> inboundListeners;
    @NotNull
    private final Set<InboundSyncListener> inboundListenersAttachedToDocuments;
    @NotNull
    private final ConcurrentHashMap<Path, AtomicBoolean> isSyncingMap;
    public static final int $stable = 8;

    public EphemeralFileManager(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.managedFilesCache = new ConcurrentHashMap();
        this.inboundListeners = new ConcurrentHashMap();
        this.inboundListenersAttachedToDocuments = ConcurrentSetKt.ConcurrentSet();
        this.isSyncingMap = new ConcurrentHashMap();
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        messageBusConnection.subscribe(topic, (Object)new FileEditorManagerListener(){

            public void fileOpened(FileEditorManager source, VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Path path2 = file.toNioPath();
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toNioPath(...)");
                this.attachDocumentListener(path2);
            }

            public void fileClosed(FileEditorManager source, VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                this.detachDocumentListener(file);
            }
        });
    }

    @NotNull
    public final LightVirtualFile createEphemeralFile(@NotNull String realFilePath) {
        Intrinsics.checkNotNullParameter((Object)realFilePath, (String)"realFilePath");
        Path path2 = Path.of(realFilePath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
        return this.createEphemeralFile(path2);
    }

    @NotNull
    public final LightVirtualFile createEphemeralFile(@NotNull VirtualFile realFile) {
        Intrinsics.checkNotNullParameter((Object)realFile, (String)"realFile");
        Path path2 = realFile.toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toNioPath(...)");
        return this.createEphemeralFile(path2);
    }

    private final LightVirtualFile createEphemeralFile(Path realFilePath) {
        LightVirtualFile lightVirtualFile;
        WeakReference<LightVirtualFile> weakReference = this.managedFilesCache.get(realFilePath);
        if (weakReference != null && (lightVirtualFile = (LightVirtualFile)weakReference.get()) != null) {
            LightVirtualFile it = lightVirtualFile;
            boolean bl = false;
            return it;
        }
        LinkOption[] linkOptionArray = new LinkOption[]{};
        String initialContent = Files.exists(realFilePath, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? PathsKt.readText((Path)realFilePath, (Charset)Charsets.UTF_8) : "";
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(PathsKt.getName((Path)realFilePath));
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileTypeByFileName(...)");
        FileType fileType2 = fileType;
        LightVirtualFile placeholderFile = new LightVirtualFile(PathsKt.getName((Path)realFilePath), fileType2, (CharSequence)initialContent);
        placeholderFile.setCharset(Charsets.UTF_8);
        Document document2 = FileDocumentManager.getInstance().getDocument((VirtualFile)placeholderFile);
        if (document2 == null) {
            boolean bl = false;
            String string = "Could not get a document for a new LightVirtualFile";
            throw new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"checkNotNull(...)");
        Document placeholderDocument = document2;
        AtomicBoolean atomicBoolean = this.isSyncingMap.computeIfAbsent(realFilePath, arg_0 -> EphemeralFileManager.createEphemeralFile$lambda$2(createEphemeralFile.isSyncing.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)atomicBoolean, (String)"computeIfAbsent(...)");
        AtomicBoolean isSyncing2 = atomicBoolean;
        placeholderDocument.addDocumentListener((DocumentListener)new OutboundSyncListener(realFilePath, isSyncing2), (Disposable)this);
        InboundSyncListener inboundListener = new InboundSyncListener(placeholderDocument, realFilePath, isSyncing2, this);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        messageBusConnection.subscribe(topic, (Object)inboundListener);
        ((Map)this.managedFilesCache).put(realFilePath, new WeakReference<LightVirtualFile>(placeholderFile));
        this.attachDocumentListener(realFilePath);
        return placeholderFile;
    }

    /*
     * WARNING - void declaration
     */
    private final void attachDocumentListener(Path path2) {
        InboundSyncListener listener2;
        void $this$getOrCreate$iv;
        LightVirtualFile lightVirtualFile = this.managedFilesCache.get(path2);
        if (lightVirtualFile == null || (lightVirtualFile = (LightVirtualFile)lightVirtualFile.get()) == null) {
            return;
        }
        LightVirtualFile placeholderFile = lightVirtualFile;
        Document document2 = FileDocumentManager.getInstance().getDocument((VirtualFile)placeholderFile);
        if (document2 == null) {
            return;
        }
        Document placeholderDocument = document2;
        VirtualFile virtualFile2 = LocalFileSystem.getInstance().findFileByNioFile(path2);
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile realFile = virtualFile2;
        Document document3 = FileDocumentManager.getInstance().getCachedDocument(realFile);
        if (document3 == null) {
            return;
        }
        Document realDocument = document3;
        AtomicBoolean atomicBoolean = this.isSyncingMap.get(path2);
        if (atomicBoolean == null) {
            return;
        }
        AtomicBoolean isSyncing2 = atomicBoolean;
        Map map2 = this.inboundListeners;
        Path key$iv = path2;
        boolean $i$f$getOrCreate = false;
        Object object = $this$getOrCreate$iv.get(key$iv);
        if (object == null) {
            Path it = key$iv;
            boolean bl = false;
            InboundSyncListener it$iv = new InboundSyncListener(placeholderDocument, path2, isSyncing2, this);
            boolean bl2 = false;
            $this$getOrCreate$iv.put(key$iv, it$iv);
            object = it$iv;
        }
        if (this.inboundListenersAttachedToDocuments.contains(listener2 = (InboundSyncListener)object)) {
            return;
        }
        realDocument.addDocumentListener((DocumentListener)listener2);
        this.inboundListenersAttachedToDocuments.add(listener2);
    }

    private final void detachDocumentListener(VirtualFile realFile) {
        InboundSyncListener inboundSyncListener = this.inboundListeners.get(realFile.toNioPath());
        if (inboundSyncListener == null) {
            return;
        }
        InboundSyncListener listener2 = inboundSyncListener;
        if (!this.inboundListenersAttachedToDocuments.remove(listener2)) {
            return;
        }
        Document document2 = FileDocumentManager.getInstance().getDocument(realFile);
        if (document2 == null) {
            return;
        }
        Document realDocument = document2;
        realDocument.removeDocumentListener((DocumentListener)listener2);
    }

    public void dispose() {
        this.managedFilesCache.clear();
        this.inboundListeners.clear();
        this.isSyncingMap.clear();
    }

    private static final AtomicBoolean createEphemeralFile$lambda$2(Function1 $tmp0, Object p0) {
        return (AtomicBoolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/studio/ml/bot/diff/ephemeral/EphemeralFileManager$Companion;", "", "()V", "getInstance", "Lcom/android/studio/ml/bot/diff/ephemeral/EphemeralFileManager;", "project", "Lcom/intellij/openapi/project/Project;", "aiplugin.core.aicore"})
    @SourceDebugExtension(value={"SMAP\nEphemeralFileManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EphemeralFileManager.kt\ncom/android/studio/ml/bot/diff/ephemeral/EphemeralFileManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,246:1\n30#2,2:247\n*S KotlinDebug\n*F\n+ 1 EphemeralFileManager.kt\ncom/android/studio/ml/bot/diff/ephemeral/EphemeralFileManager$Companion\n*L\n243#1:247,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EphemeralFileManager getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<EphemeralFileManager> serviceClass$iv = EphemeralFileManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (EphemeralFileManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/studio/ml/bot/diff/ephemeral/EphemeralFileManager$InboundSyncListener;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "placeholderDocument", "Lcom/intellij/openapi/editor/Document;", "realFilePath", "Ljava/nio/file/Path;", "isSyncing", "Ljava/util/concurrent/atomic/AtomicBoolean;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/editor/Document;Ljava/nio/file/Path;Ljava/util/concurrent/atomic/AtomicBoolean;Lcom/intellij/openapi/Disposable;)V", "updatesChannel", "Lkotlinx/coroutines/channels/Channel;", "", "after", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "documentChanged", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "aiplugin.core.aicore"})
    private static final class InboundSyncListener
    implements BulkFileListener,
    DocumentListener {
        @NotNull
        private final Document placeholderDocument;
        @NotNull
        private final Path realFilePath;
        @NotNull
        private final AtomicBoolean isSyncing;
        @NotNull
        private final Channel<String> updatesChannel;

        public InboundSyncListener(@NotNull Document placeholderDocument, @NotNull Path realFilePath, @NotNull AtomicBoolean isSyncing2, @NotNull Disposable parentDisposable) {
            Intrinsics.checkNotNullParameter((Object)placeholderDocument, (String)"placeholderDocument");
            Intrinsics.checkNotNullParameter((Object)realFilePath, (String)"realFilePath");
            Intrinsics.checkNotNullParameter((Object)isSyncing2, (String)"isSyncing");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            this.placeholderDocument = placeholderDocument;
            this.realFilePath = realFilePath;
            this.isSyncing = isSyncing2;
            this.updatesChannel = ChannelKt.Channel$default((int)-1, null, null, (int)6, null);
            BuildersKt.launch$default((CoroutineScope)CoroutineScopesKt.createCoroutineScope$default(parentDisposable, null, null, 3, null), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                Object L$0;
                int label;
                final /* synthetic */ InboundSyncListener this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            var2_3 = InboundSyncListener.access$getUpdatesChannel$p(this.this$0).iterator();
lbl6:
                            // 2 sources

                            while (true) {
                                this.L$0 = var2_3;
                                this.label = 1;
                                v0 = var2_3.hasNext((Continuation)this);
                                if (v0 == var4_2) {
                                    return var4_2;
                                }
                                ** GOTO lbl17
                                break;
                            }
                        }
                        case 1: {
                            var2_3 = (ChannelIterator)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            if (!((Boolean)v0).booleanValue()) break;
                            content = (String)var2_3.next();
                            this.L$0 = var2_3;
                            this.label = 2;
                            v1 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, content, null){
                                int label;
                                final /* synthetic */ InboundSyncListener this$0;
                                final /* synthetic */ String $content;
                                {
                                    this.this$0 = $receiver;
                                    this.$content = $content;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public final Object invokeSuspend(Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            this.this$0.isSyncing.set(true);
                                            try {
                                                ApplicationKt.getApplication().runWriteAction(() -> 1.invokeSuspend$lambda$0(this.this$0, this.$content));
                                            }
                                            finally {
                                                this.this$0.isSyncing.set(false);
                                            }
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }

                                private static final void invokeSuspend$lambda$0(InboundSyncListener this$0, String $content) {
                                    this$0.placeholderDocument.setText((CharSequence)$content);
                                }
                            }), (Continuation)((Continuation)this));
                            if (v1 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl29
                        }
                        case 2: {
                            var2_3 = (ChannelIterator)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl29:
                            // 2 sources

                            ** continue;
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        public void after(@NotNull List<? extends VFileEvent> events) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            if (this.isSyncing.get()) {
                return;
            }
            for (VFileEvent vFileEvent : events) {
                if (!Intrinsics.areEqual((Object)Path.of(vFileEvent.getPath(), new String[0]), (Object)this.realFilePath)) continue;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                String newContent2 = Files.exists(this.realFilePath, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? PathsKt.readText((Path)this.realFilePath, (Charset)Charsets.UTF_8) : "";
                this.updatesChannel.trySend-JP2dKIU((Object)newContent2);
            }
        }

        public void documentChanged(@NotNull DocumentEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (this.isSyncing.get()) {
                return;
            }
            String string = event.getDocument().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            this.updatesChannel.trySend-JP2dKIU((Object)string);
        }

        public static final /* synthetic */ Channel access$getUpdatesChannel$p(InboundSyncListener $this) {
            return $this.updatesChannel;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/studio/ml/bot/diff/ephemeral/EphemeralFileManager$OutboundSyncListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "realFilePath", "Ljava/nio/file/Path;", "isSyncing", "Ljava/util/concurrent/atomic/AtomicBoolean;", "(Ljava/nio/file/Path;Ljava/util/concurrent/atomic/AtomicBoolean;)V", "documentChanged", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "aiplugin.core.aicore"})
    private static final class OutboundSyncListener
    implements DocumentListener {
        @NotNull
        private final Path realFilePath;
        @NotNull
        private final AtomicBoolean isSyncing;

        public OutboundSyncListener(@NotNull Path realFilePath, @NotNull AtomicBoolean isSyncing2) {
            Intrinsics.checkNotNullParameter((Object)realFilePath, (String)"realFilePath");
            Intrinsics.checkNotNullParameter((Object)isSyncing2, (String)"isSyncing");
            this.realFilePath = realFilePath;
            this.isSyncing = isSyncing2;
        }

        public void documentChanged(@NotNull DocumentEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ApplicationKt.getApplication().runWriteAction(() -> OutboundSyncListener.documentChanged$lambda$0(this, event));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final void documentChanged$lambda$0(OutboundSyncListener this$0, DocumentEvent $event) {
            if (!this$0.isSyncing.compareAndSet(false, true)) {
                return;
            }
            try {
                String string = $event.getDocument().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (((CharSequence)string).length() == 0) {
                    VirtualFile virtualFile2 = LocalFileSystem.getInstance().findFileByNioFile(this$0.realFilePath);
                    if (virtualFile2 != null) {
                        virtualFile2.delete((Object)this$0);
                    }
                } else {
                    VirtualFile virtualFile3 = VfsUtil.createDirectoryIfMissing((String)((Object)this$0.realFilePath.getParent()).toString());
                    if (virtualFile3 == null) {
                        throw new IOException("Could not create parent directory");
                    }
                    VirtualFile parentDir = virtualFile3;
                    VirtualFile virtualFile4 = parentDir.findOrCreateChildData((Object)this$0, PathsKt.getName((Path)this$0.realFilePath));
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"findOrCreateChildData(...)");
                    VirtualFile file = virtualFile4;
                    String string2 = $event.getDocument().getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                    String string3 = string2;
                    Charset charset = file.getCharset();
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"getCharset(...)");
                    byte[] byArray = string3.getBytes(charset);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    file.setBinaryContent(byArray);
                }
                VfsUtil.findFileByIoFile((File)this$0.realFilePath.toFile(), (boolean)true);
            }
            finally {
                this$0.isSyncing.set(false);
            }
        }
    }
}

