/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.history;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.SmlConversation;
import com.android.studio.ml.bot.ResponseMode;
import com.android.studio.ml.bot.history.ConversationBuffer;
import com.android.studio.ml.bot.history.HistoryPersister;
import com.android.studio.ml.bot.history.Session;
import com.android.studio.ml.bot.history.SessionInfo;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\fJ\u0006\u0010\u0010\u001a\u00020\fJ\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015J\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00180\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u00020\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/android/studio/ml/bot/history/Session;", "", "buffer", "Lcom/android/studio/ml/bot/history/ConversationBuffer;", "sessionInfo", "Lcom/android/studio/ml/bot/history/SessionInfo;", "persisterJob", "Lkotlinx/coroutines/Job;", "(Lcom/android/studio/ml/bot/history/ConversationBuffer;Lcom/android/studio/ml/bot/history/SessionInfo;Lkotlinx/coroutines/Job;)V", "getSessionInfo", "()Lcom/android/studio/ml/bot/history/SessionInfo;", "addEntry", "", "entry", "Lcom/android/studio/ml/SmlConversation;", "clear", "close", "deleteConversation", "conversationId", "", "deleteOption", "Lcom/android/studio/ml/bot/history/ConversationBuffer$DeleteOption;", "getEntries", "Lkotlinx/coroutines/flow/StateFlow;", "", "Companion", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
public final class Session {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConversationBuffer buffer;
    @NotNull
    private final SessionInfo sessionInfo;
    @NotNull
    private final Job persisterJob;
    public static final int $stable = 8;
    public static final int MAX_MESSAGES_IN_SESSION = 100;

    @VisibleForTesting
    public Session(@NotNull ConversationBuffer buffer, @NotNull SessionInfo sessionInfo, @NotNull Job persisterJob) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)sessionInfo, (String)"sessionInfo");
        Intrinsics.checkNotNullParameter((Object)persisterJob, (String)"persisterJob");
        this.buffer = buffer;
        this.sessionInfo = sessionInfo;
        this.persisterJob = persisterJob;
    }

    @VisibleForTesting
    @NotNull
    public final SessionInfo getSessionInfo() {
        return this.sessionInfo;
    }

    public final void addEntry(@NotNull SmlConversation entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this.sessionInfo.setLastUpdateTimestamp(ZonedDateTime.now().toInstant().toEpochMilli());
        this.buffer.addEntry(entry);
    }

    @NotNull
    public final StateFlow<List<SmlConversation>> getEntries() {
        return this.buffer.getState();
    }

    public final void deleteConversation(@NotNull String conversationId, @NotNull ConversationBuffer.DeleteOption deleteOption) {
        Intrinsics.checkNotNullParameter((Object)conversationId, (String)"conversationId");
        Intrinsics.checkNotNullParameter((Object)((Object)deleteOption), (String)"deleteOption");
        this.buffer.deleteConversation(conversationId, deleteOption);
    }

    public static /* synthetic */ void deleteConversation$default(Session session2, String string, ConversationBuffer.DeleteOption deleteOption, int n, Object object) {
        if ((n & 2) != 0) {
            deleteOption = ConversationBuffer.DeleteOption.ALL;
        }
        session2.deleteConversation(string, deleteOption);
    }

    public final void clear() {
        this.buffer.clear();
    }

    public final void close() {
        Job.DefaultImpls.cancel$default((Job)this.persisterJob, null, (int)1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/studio/ml/bot/history/Session$Companion;", "", "()V", "MAX_MESSAGES_IN_SESSION", "", "createConnection", "Lcom/android/studio/ml/bot/history/Session;", "storageFilePath", "Ljava/nio/file/Path;", "sessionInfo", "Lcom/android/studio/ml/bot/history/SessionInfo;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "ioDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "aiplugin.core.aicore"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Session createConnection(@NotNull Path storageFilePath, @NotNull SessionInfo sessionInfo, @NotNull CoroutineScope coroutineScope, @NotNull CoroutineDispatcher ioDispatcher) {
            Intrinsics.checkNotNullParameter((Object)storageFilePath, (String)"storageFilePath");
            Intrinsics.checkNotNullParameter((Object)sessionInfo, (String)"sessionInfo");
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            Intrinsics.checkNotNullParameter((Object)ioDispatcher, (String)"ioDispatcher");
            ResponseMode responseMode2 = sessionInfo.getResponseMode();
            Intrinsics.checkNotNull((Object)((Object)responseMode2));
            HistoryPersister<SmlConversation> historyPersister2 = new HistoryPersister<SmlConversation>(storageFilePath, responseMode2.name(), createConnection.historyPersister.1.INSTANCE, createConnection.historyPersister.2.INSTANCE);
            List history2 = historyPersister2.readPersistedState();
            ConversationBuffer buffer = new ConversationBuffer(100, history2);
            Job persisterJob = historyPersister2.launchPersister(coroutineScope, buffer.getState(), ioDispatcher);
            return new Session(buffer, sessionInfo, persisterJob);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

