/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.permissions;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.FormBuilder;
import java.net.URI;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0014J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0014J\b\u0010\u000f\u001a\u00020\fH\u0016J\b\u0010\u0010\u001a\u00020\u0006H\u0002R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/studio/ml/bot/permissions/UrlEntryDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "enteredUrl", "", "getEnteredUrl", "()Ljava/lang/String;", "urlField", "Lcom/intellij/ui/components/JBTextField;", "createCenterPanel", "Ljavax/swing/JComponent;", "doValidate", "Lcom/intellij/openapi/ui/ValidationInfo;", "getPreferredFocusedComponent", "getUrlText", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
public final class UrlEntryDialog
extends DialogWrapper {
    @NotNull
    private final JBTextField urlField;
    public static final int $stable = 8;

    public UrlEntryDialog(@Nullable Project project2) {
        super(project2);
        this.urlField = new JBTextField(40);
        this.init();
        this.setTitle("Enter URL");
    }

    public /* synthetic */ UrlEntryDialog(Project project2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            project2 = null;
        }
        this(project2);
    }

    @NotNull
    public final String getEnteredUrl() {
        return this.getUrlText();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel jPanel = FormBuilder.createFormBuilder().addLabeledComponent("URL:", (JComponent)this.urlField, true).getPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"getPanel(...)");
        return jPanel;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String text2 = this.getUrlText();
        if (StringsKt.isBlank((CharSequence)text2)) {
            return new ValidationInfo("URL cannot be empty.", (JComponent)this.urlField);
        }
        try {
            URI.create(text2).toURL();
        }
        catch (Exception exception) {
            return new ValidationInfo("Please enter a valid URL (e.g., https://example.com)", (JComponent)this.urlField);
        }
        return null;
    }

    private final String getUrlText() {
        String enteredUrl = this.urlField.getText();
        Intrinsics.checkNotNull((Object)enteredUrl);
        return !StringsKt.startsWith$default((String)enteredUrl, (String)"http://", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)enteredUrl, (String)"https://", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)enteredUrl, (CharSequence)"://", (boolean)false, (int)2, null) ? "https://" + enteredUrl : enteredUrl;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.urlField;
    }

    public UrlEntryDialog() {
        this(null, 1, null);
    }
}

