/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.completion;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.completion.SmlInlineCompletionEventListenerService;
import com.android.studio.ml.completion.SmlInlineCompletionInlayManager;
import com.android.studio.ml.completion.SmlInlineCompletionProvider;
import com.android.studio.ml.completion.metrics.SmlInlineCompletionMetricsService;
import com.android.studio.ml.metrics.AiCodeEditingActionListener;
import com.android.studio.ml.metrics.CodeEditingAction;
import com.android.studio.ml.metrics.SmlCodeEditedMetricsService;
import com.intellij.codeInsight.inline.completion.InlineCompletion;
import com.intellij.codeInsight.inline.completion.InlineCompletionEventAdapter;
import com.intellij.codeInsight.inline.completion.InlineCompletionEventListener;
import com.intellij.codeInsight.inline.completion.InlineCompletionEventType;
import com.intellij.codeInsight.inline.completion.InlineCompletionHandler;
import com.intellij.codeInsight.inline.completion.session.InlineCompletionContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Key;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.Clock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00072\u00020\u0001:\u0002\u0007\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/android/studio/ml/completion/SmlInlineCompletionEventListenerServiceImpl;", "Lcom/android/studio/ml/completion/SmlInlineCompletionEventListenerService;", "()V", "ensureRegistered", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "Companion", "Listener", "aiplugin.core.aicore"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nSmlInlineCompletionEventListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SmlInlineCompletionEventListener.kt\ncom/android/studio/ml/completion/SmlInlineCompletionEventListenerServiceImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,137:1\n24#2:138\n*S KotlinDebug\n*F\n+ 1 SmlInlineCompletionEventListener.kt\ncom/android/studio/ml/completion/SmlInlineCompletionEventListenerServiceImpl\n*L\n49#1:138\n*E\n"})
public final class SmlInlineCompletionEventListenerServiceImpl
implements SmlInlineCompletionEventListenerService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    @NotNull
    private static final Key<Boolean> COMPLETION_EVENT_LISTENER_REGISTERED;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ensureRegistered(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (Intrinsics.areEqual((Object)editor2.getUserData(COMPLETION_EVENT_LISTENER_REGISTERED), (Object)true)) {
            return;
        }
        InlineCompletionHandler handler = InlineCompletion.INSTANCE.getHandlerOrNull(editor2);
        if (handler == null) {
            SmlInlineCompletionEventListenerServiceImpl $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SmlInlineCompletionEventListenerServiceImpl.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Unable to get InlineCompletionHandler from editor");
            return;
        }
        Key<Boolean> key = COMPLETION_EVENT_LISTENER_REGISTERED;
        synchronized (key) {
            boolean bl = false;
            if (Intrinsics.areEqual((Object)editor2.getUserData(COMPLETION_EVENT_LISTENER_REGISTERED), (Object)true)) {
                return;
            }
            editor2.putUserData(COMPLETION_EVENT_LISTENER_REGISTERED, (Object)true);
            Unit unit = Unit.INSTANCE;
        }
        handler.addEventListener((InlineCompletionEventListener)new Listener(editor2));
    }

    static {
        COMPLETION_EVENT_LISTENER_REGISTERED = new Key("com.android.studio.ml.completion.COMPLETION_EVENT_LISTENER_REGISTERED");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/studio/ml/completion/SmlInlineCompletionEventListenerServiceImpl$Companion;", "", "()V", "COMPLETION_EVENT_LISTENER_REGISTERED", "Lcom/intellij/openapi/util/Key;", "", "aiplugin.core.aicore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u001aH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/studio/ml/completion/SmlInlineCompletionEventListenerServiceImpl$Listener;", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionEventAdapter;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/editor/Editor;)V", "clock", "Lkotlinx/datetime/Clock$System;", "currentRequestIsSmlProvider", "", "isAccepted", "callRecordVariantDisplayedWithContext", "", "variantIndex", "", "onChange", "event", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionEventType$Change;", "onHide", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionEventType$Hide;", "onInsert", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionEventType$Insert;", "onRequest", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionEventType$Request;", "onShow", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionEventType$Show;", "onVariantSwitched", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionEventType$VariantSwitched;", "aiplugin.core.aicore"})
    @SourceDebugExtension(value={"SMAP\nSmlInlineCompletionEventListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SmlInlineCompletionEventListener.kt\ncom/android/studio/ml/completion/SmlInlineCompletionEventListenerServiceImpl$Listener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,137:1\n24#2:138\n*S KotlinDebug\n*F\n+ 1 SmlInlineCompletionEventListener.kt\ncom/android/studio/ml/completion/SmlInlineCompletionEventListenerServiceImpl$Listener\n*L\n105#1:138\n*E\n"})
    private static final class Listener
    implements InlineCompletionEventAdapter {
        @NotNull
        private final Editor editor;
        @NotNull
        private final Clock.System clock;
        private boolean isAccepted;
        private boolean currentRequestIsSmlProvider;

        public Listener(@NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            this.editor = editor2;
            this.clock = Clock.System.INSTANCE;
            this.currentRequestIsSmlProvider = true;
        }

        public void onRequest(@NotNull InlineCompletionEventType.Request event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.currentRequestIsSmlProvider = Intrinsics.areEqual((Object)event.getProvider(), SmlInlineCompletionProvider.class);
        }

        public void onShow(@NotNull InlineCompletionEventType.Show event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!this.currentRequestIsSmlProvider) {
                return;
            }
            this.isAccepted = false;
            this.callRecordVariantDisplayedWithContext(event.getVariantIndex());
            SmlInlineCompletionInlayManager.Companion.show$default(SmlInlineCompletionInlayManager.Companion, this.editor, null, null, 6, null);
        }

        public void onVariantSwitched(@NotNull InlineCompletionEventType.VariantSwitched event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!this.currentRequestIsSmlProvider) {
                return;
            }
            this.callRecordVariantDisplayedWithContext(event.getToVariantIndex());
        }

        public void onChange(@NotNull InlineCompletionEventType.Change event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!this.currentRequestIsSmlProvider) {
                return;
            }
            this.callRecordVariantDisplayedWithContext(event.getVariantIndex());
        }

        private final void callRecordVariantDisplayedWithContext(int variantIndex) {
            InlineCompletionContext context2 = InlineCompletionContext.Companion.getOrNull(this.editor);
            if (context2 == null) {
                Listener $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(Listener.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Could not get InlineCompletionContext");
                return;
            }
            SmlInlineCompletionMetricsService.Companion.getInstance(this.editor).recordVariantDisplayed(variantIndex, context2, this.clock.now());
        }

        public void onHide(@NotNull InlineCompletionEventType.Hide event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!this.currentRequestIsSmlProvider) {
                return;
            }
            SmlInlineCompletionInlayManager.Companion.hide();
            SmlInlineCompletionMetricsService.Companion.getInstance(this.editor).recordCompletionHidden(this.clock.now(), this.isAccepted);
            this.isAccepted = false;
        }

        public void onInsert(@NotNull InlineCompletionEventType.Insert event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!this.currentRequestIsSmlProvider) {
                return;
            }
            this.isAccepted = true;
            SmlCodeEditedMetricsService.Companion.getInstance().setCodeEditingAction(CodeEditingAction.AiCodeCompletion.INSTANCE);
            AiCodeEditingActionListener.Companion.setCodeEditingAction(AiCodeEditingActionListener.CodeEditingAction.AI_CODE_COMPLETION);
        }

        public void on(@NotNull InlineCompletionEventType event) {
            super.on(event);
        }

        public void onAfterInsert(@NotNull InlineCompletionEventType.AfterInsert event) {
            super.onAfterInsert(event);
        }

        public void onCompletion(@NotNull InlineCompletionEventType.Completion event) {
            super.onCompletion(event);
        }

        public void onComputed(@NotNull InlineCompletionEventType.Computed event) {
            super.onComputed(event);
        }

        public void onEmpty(@NotNull InlineCompletionEventType.Empty event) {
            super.onEmpty(event);
        }

        public void onInvalidated(@NotNull InlineCompletionEventType.Invalidated event) {
            super.onInvalidated(event);
        }

        public void onNoVariants(@NotNull InlineCompletionEventType.NoVariants event) {
            super.onNoVariants(event);
        }

        @ApiStatus.Internal
        @ApiStatus.NonExtendable
        public void onSuggestionInitialized(@NotNull InlineCompletionEventType.SuggestionInitialized event) {
            super.onSuggestionInitialized(event);
        }

        public void onVariantComputed(@NotNull InlineCompletionEventType.VariantComputed event) {
            super.onVariantComputed(event);
        }
    }
}

