/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.deploy;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.deploy.DeployToolArgs;
import com.android.studio.ml.deploy.DeployToolHandler;
import com.android.studio.ml.icons.AndroidToolIcon;
import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolArgument;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.intellij.openapi.project.Project;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KParameter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ToolDescription(summary="Deploys an application to an Android device", description="\n      An application can be deployed in Run or Debug modes. Using Debug mode will start a \n      debugger and attach it to the app.\n      \n      Invoking this tool will also automatically trigger the build system to build the application.\n    ", examples={"deploy(ANDROID_APP,My_Project.app,DEFAULT_ACTIVITY, RUN)", "deploy(ANDROID_APP,My_Project.app,DEFAULT_ACTIVITY, DEBUG)"})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/android/studio/ml/deploy/DeployTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/android/studio/ml/deploy/DeployToolArgs;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "icon", "Lcom/android/studio/ml/icons/AndroidToolIcon;", "getIcon", "()Lcom/android/studio/ml/icons/AndroidToolIcon;", "getRunningDisplayText", "args", "getCompletedDisplayText", "createHandler", "Lcom/android/studio/ml/deploy/DeployToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "aiplugin.android"})
@StabilityInferred(parameters=1)
public final class DeployTool
implements Tool<DeployToolArgs> {
    @NotNull
    private final String name;
    @NotNull
    private final AndroidToolIcon icon = AndroidToolIcon.DEPLOY;
    public static final int $stable;

    public DeployTool() {
        this.name = "deploy";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public AndroidToolIcon getIcon() {
        return this.icon;
    }

    @Override
    @NotNull
    public String getRunningDisplayText(@NotNull DeployToolArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Deploying app";
    }

    @Override
    @NotNull
    public String getCompletedDisplayText(@NotNull DeployToolArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Deployed app";
    }

    @NotNull
    public DeployToolHandler createHandler(@NotNull ToolContext context2, @NotNull DeployToolArgs args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new DeployToolHandler(context2, args);
    }

    @Override
    @Nullable
    public String getStatusMessage() {
        return Tool.super.getStatusMessage();
    }

    @Override
    @Nullable
    public Map<KParameter, ToolArgument> getToolArguments() {
        return Tool.super.getToolArguments();
    }

    @Override
    @NotNull
    public ToolDescription getToolDescription() {
        return Tool.super.getToolDescription();
    }

    @Override
    @Nullable
    public ToolResult getToolResult() {
        return Tool.super.getToolResult();
    }

    @Override
    @Nullable
    public ToolHandler restoreHandler(@NotNull Project project2, @NotNull DeployToolArgs args, @NotNull Response response2) {
        return Tool.super.restoreHandler(project2, args, response2);
    }

    @Override
    @NotNull
    public String getDescription() {
        return Tool.super.getDescription();
    }
}

