/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.designer.compose.preview.agents;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.StudioGeminiBundle;
import com.android.studio.ml.bot.BotToolWindowService;
import com.android.studio.ml.designer.compose.preview.ComposePreviewActionContext;
import com.android.studio.ml.designer.compose.preview.UtilsKt;
import com.android.studio.ml.designer.compose.preview.agents.AgentInvoker;
import com.android.studio.ml.designer.compose.preview.agents.FixRenderIssueAgent;
import com.android.studio.ml.designer.compose.preview.agents.FixVisualLintIssuesAgent;
import com.android.studio.ml.designer.compose.preview.agents.MatchUiToTargetImageAgent;
import com.android.studio.ml.designer.compose.preview.agents.ScreenshotToCodeAgent;
import com.android.studio.ml.designer.compose.preview.agents.TransformPreviewAgent;
import com.android.studio.ml.designer.compose.preview.agents.tools.VisualLintServiceTool;
import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.studiobot.Blob;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintRenderIssue;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolsProvider;
import com.google.aiplugin.agents.tools.ui.AskUserTool;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J.\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\u0016\u0010\u0019\u001a\u00020\t2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/studio/ml/designer/compose/preview/agents/AgentInvokerImpl;", "Lcom/android/studio/ml/designer/compose/preview/agents/AgentInvoker;", "project", "Lcom/intellij/openapi/project/Project;", "previewContext", "Lcom/android/studio/ml/designer/compose/preview/ComposePreviewActionContext;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/studio/ml/designer/compose/preview/ComposePreviewActionContext;)V", "invokeMatchUiToTargetImageAgent", "", "targetImage", "Lcom/android/tools/idea/studiobot/Blob;", "invokeTransformPreviewAgent", "userQuery", "", "invokeScreenToCodeAgent", "sourceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "invokeFixVisualLintIssuesAgent", "composableName", "filePath", "initialVisualLintIssues", "", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintRenderIssue;", "displayText", "invokeFixRenderIssuesAgent", "issues", "Lcom/android/tools/idea/common/error/Issue;", "aiplugin.android"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAgentInvoker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgentInvoker.kt\ncom/android/studio/ml/designer/compose/preview/agents/AgentInvokerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,201:1\n1#2:202\n827#3:203\n855#3,2:204\n2746#3,3:206\n*S KotlinDebug\n*F\n+ 1 AgentInvoker.kt\ncom/android/studio/ml/designer/compose/preview/agents/AgentInvokerImpl\n*L\n170#1:203\n170#1:204,2\n172#1:206,3\n*E\n"})
public final class AgentInvokerImpl
implements AgentInvoker {
    @NotNull
    private final Project project;
    @Nullable
    private final ComposePreviewActionContext previewContext;
    public static final int $stable = 8;

    public AgentInvokerImpl(@NotNull Project project2, @Nullable ComposePreviewActionContext previewContext) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.previewContext = previewContext;
    }

    @Override
    public void invokeMatchUiToTargetImageAgent(@NotNull Blob targetImage) {
        Intrinsics.checkNotNullParameter((Object)targetImage, (String)"targetImage");
        if (this.previewContext == null) {
            boolean bl = false;
            String string = "Compose Preview context is null";
            throw new IllegalArgumentException(string.toString());
        }
        Blob blob = UtilsKt.toBlob(this.previewContext.getImage());
        VirtualFile virtualFile2 = this.previewContext.getFilePointer().getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
        MatchUiToTargetImageAgent agent2 = new MatchUiToTargetImageAgent(blob, virtualFile2, targetImage, ToolsProvider.Companion.getTools(this.project));
        BotToolWindowService botToolWindowService = BotToolWindowService.Companion.getInstance(this.project);
        String string = StudioGeminiBundle.Companion.message("designer.action.match.ui.to.image", new Object[0]);
        List list = CollectionsKt.listOf((Object)targetImage);
        String string2 = StudioGeminiBundle.Companion.message("designer.action.match.ui.to.image", new Object[0]);
        botToolWindowService.runAgentOnPinnedSession(agent2, string, string2, list);
    }

    @Override
    public void invokeTransformPreviewAgent(@NotNull String userQuery) {
        Intrinsics.checkNotNullParameter((Object)userQuery, (String)"userQuery");
        if (this.previewContext == null) {
            boolean bl = false;
            String string = "Compose Preview context is null";
            throw new IllegalArgumentException(string.toString());
        }
        TransformPreviewAgent transformAgent = new TransformPreviewAgent(this.project, this.previewContext, userQuery, ToolsProvider.Companion.getTools(this.project));
        BotToolWindowService botToolWindowService = BotToolWindowService.Companion.getInstance(this.project);
        Object object = new Object[]{userQuery};
        String string = StudioGeminiBundle.Companion.message("designer.action.transform.ui.with.gemini.agent.title", object);
        object = CollectionsKt.listOf((Object)UtilsKt.toBlob(this.previewContext.getImage()));
        Object[] objectArray = new Object[]{userQuery};
        String string2 = StudioGeminiBundle.Companion.message("designer.action.transform.ui.with.gemini.agent.title", objectArray);
        botToolWindowService.runAgentOnPinnedSession(transformAgent, string, string2, (List<Blob>)object);
    }

    @Override
    public void invokeScreenToCodeAgent(@NotNull Blob targetImage, @NotNull VirtualFile sourceFile) {
        Intrinsics.checkNotNullParameter((Object)targetImage, (String)"targetImage");
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        ScreenshotToCodeAgent agent2 = new ScreenshotToCodeAgent(targetImage, ToolsProvider.Companion.getTools(this.project), sourceFile, null, 8, null);
        BotToolWindowService botToolWindowService = BotToolWindowService.Companion.getInstance(this.project);
        String string = StudioGeminiBundle.Companion.message("screenshot.to.code.action.description", new Object[0]);
        List list = CollectionsKt.listOf((Object)targetImage);
        String string2 = StudioGeminiBundle.Companion.message("screenshot.to.code.action.title", new Object[0]);
        botToolWindowService.runAgentOnPinnedSession(agent2, string, string2, list);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void invokeFixVisualLintIssuesAgent(@NotNull String composableName, @NotNull String filePath, @NotNull List<VisualLintRenderIssue> initialVisualLintIssues, @NotNull String displayText) {
        boolean bl;
        Set tools2;
        block5: {
            void $this$filterNotTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)composableName, (String)"composableName");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Intrinsics.checkNotNullParameter(initialVisualLintIssues, (String)"initialVisualLintIssues");
            Intrinsics.checkNotNullParameter((Object)displayText, (String)"displayText");
            Iterable $this$filterNot$iv = ToolsProvider.Companion.getTools(this.project);
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                Tool it = (Tool)element$iv$iv;
                boolean bl2 = false;
                if (StringsKt.contains((CharSequence)it.getName(), (CharSequence)"test", (boolean)true)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List projectTools = (List)destination$iv$iv;
            tools2 = CollectionsKt.toMutableSet((Iterable)CollectionsKt.plus((Collection)projectTools, (Object)new VisualLintServiceTool()));
            Iterable $this$none$iv = projectTools;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Tool it = (Tool)element$iv;
                    boolean bl3 = false;
                    if (!(it instanceof AskUserTool)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (bl) {
            tools2.add(new AskUserTool());
        }
        FixVisualLintIssuesAgent agent2 = new FixVisualLintIssuesAgent(composableName, filePath, initialVisualLintIssues, 0, tools2, 8, null);
        BotToolWindowService.runAgentOnPinnedSession$default(BotToolWindowService.Companion.getInstance(this.project), agent2, displayText, StudioGeminiBundle.Companion.message("designer.action.fix.visual.issues.agent.title", new Object[0]), null, 8, null);
    }

    @Override
    public void invokeFixRenderIssuesAgent(@NotNull List<? extends Issue> issues) {
        Intrinsics.checkNotNullParameter(issues, (String)"issues");
        FixRenderIssueAgent agent2 = new FixRenderIssueAgent(this.project, issues, ToolsProvider.Companion.getTools(this.project));
        BotToolWindowService.runAgentOnPinnedSession$default(BotToolWindowService.Companion.getInstance(this.project), agent2, StudioGeminiBundle.Companion.message("designer.action.fix.render.agent.text", new Object[0]), StudioGeminiBundle.Companion.message("designer.action.fix.render.issues.agent.title", new Object[0]), null, 8, null);
    }
}

