/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.designer.compose.preview.agents.tools;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.ide.common.vectordrawable.Svg2Vector;
import com.android.studio.ml.ModelProvider;
import com.android.studio.ml.designer.compose.preview.agents.tools.GenerateVectorDrawableArgs;
import com.android.studio.ml.designer.compose.preview.agents.tools.GenerateVectorDrawableTool;
import com.android.studio.ml.designer.compose.preview.agents.tools.GenerateVectorDrawableTool$Handler$handle$;
import com.android.tools.idea.studiobot.Content;
import com.android.tools.idea.studiobot.Model;
import com.android.tools.idea.studiobot.configuration.ContextSharingSettingsProvider;
import com.android.tools.idea.studiobot.prompts.Prompt;
import com.android.tools.idea.studiobot.prompts.PromptBuilder;
import com.android.tools.idea.studiobot.prompts.impl.PromptBuilderImpl;
import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.ToolIcon;
import com.google.aiplugin.agents.tools.ToolArgument;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.intellij.openapi.project.Project;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KParameter;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ToolDescription(summary="Generates a vector drawable from a description.", description="This tool uses an AI model to generate an SVG image from a user-provided description, then converts it to an Android Vector Drawable. The `imageType` parameter can be 'icon' for a simple, monochrome 24x24 image, or 'placeholder' for a more detailed, colorful 200x200 image.", examples={})
@ToolResult(description="The generated Vector Drawable XML content, or an error message.")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/android/studio/ml/designer/compose/preview/agents/tools/GenerateVectorDrawableTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/android/studio/ml/designer/compose/preview/agents/tools/GenerateVectorDrawableArgs;", "modelProvider", "Lcom/android/studio/ml/ModelProvider;", "<init>", "(Lcom/android/studio/ml/ModelProvider;)V", "name", "", "getName", "()Ljava/lang/String;", "createHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "args", "Handler", "aiplugin.android"})
@StabilityInferred(parameters=0)
public final class GenerateVectorDrawableTool
implements Tool<GenerateVectorDrawableArgs> {
    @NotNull
    private final ModelProvider modelProvider;
    @NotNull
    private final String name;
    public static final int $stable = 8;

    public GenerateVectorDrawableTool(@NotNull ModelProvider modelProvider) {
        Intrinsics.checkNotNullParameter((Object)modelProvider, (String)"modelProvider");
        this.modelProvider = modelProvider;
        this.name = "generate_vector_drawable";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public ToolHandler createHandler(@NotNull ToolContext context2, @NotNull GenerateVectorDrawableArgs args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new Handler(context2, this.modelProvider, args);
    }

    @Override
    @NotNull
    public String getCompletedDisplayText(@NotNull GenerateVectorDrawableArgs args) {
        return Tool.super.getCompletedDisplayText(args);
    }

    @Override
    @NotNull
    public String getRunningDisplayText(@NotNull GenerateVectorDrawableArgs args) {
        return Tool.super.getRunningDisplayText(args);
    }

    @Override
    @Nullable
    public String getStatusMessage() {
        return Tool.super.getStatusMessage();
    }

    @Override
    @Nullable
    public Map<KParameter, ToolArgument> getToolArguments() {
        return Tool.super.getToolArguments();
    }

    @Override
    @NotNull
    public ToolDescription getToolDescription() {
        return Tool.super.getToolDescription();
    }

    @Override
    @Nullable
    public ToolResult getToolResult() {
        return Tool.super.getToolResult();
    }

    @Override
    @Nullable
    public ToolHandler restoreHandler(@NotNull Project project2, @NotNull GenerateVectorDrawableArgs args, @NotNull Response response2) {
        return Tool.super.restoreHandler(project2, args, response2);
    }

    @Override
    @NotNull
    public String getDescription() {
        return Tool.super.getDescription();
    }

    @Override
    @Nullable
    public ToolIcon getIcon() {
        return Tool.super.getIcon();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\n\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/studio/ml/designer/compose/preview/agents/tools/GenerateVectorDrawableTool$Handler;", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "modelProvider", "Lcom/android/studio/ml/ModelProvider;", "args", "Lcom/android/studio/ml/designer/compose/preview/agents/tools/GenerateVectorDrawableArgs;", "<init>", "(Lcom/google/aiplugin/agents/tools/ToolContext;Lcom/android/studio/ml/ModelProvider;Lcom/android/studio/ml/designer/compose/preview/agents/tools/GenerateVectorDrawableArgs;)V", "handle", "Lcom/google/aiplugin/agents/Response;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createPrompt", "", "description", "imageType", "aiplugin.android"})
    @SourceDebugExtension(value={"SMAP\nGenerateVectorDrawableTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateVectorDrawableTool.kt\ncom/android/studio/ml/designer/compose/preview/agents/tools/GenerateVectorDrawableTool$Handler\n+ 2 PromptBuilder.kt\ncom/android/tools/idea/studiobot/prompts/PromptBuilderKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Transform.kt\nkotlinx/coroutines/flow/FlowKt__TransformKt\n+ 5 Emitters.kt\nkotlinx/coroutines/flow/FlowKt__EmittersKt\n+ 6 SafeCollector.common.kt\nkotlinx/coroutines/flow/internal/SafeCollector_commonKt\n*L\n1#1,145:1\n82#2,13:146\n95#2:161\n96#2,9:163\n1761#3,2:159\n1763#3:162\n32#4:172\n17#4:173\n19#4:177\n46#5:174\n51#5:176\n105#6:175\n*S KotlinDebug\n*F\n+ 1 GenerateVectorDrawableTool.kt\ncom/android/studio/ml/designer/compose/preview/agents/tools/GenerateVectorDrawableTool$Handler\n*L\n63#1:146,13\n63#1:161\n63#1:163,9\n63#1:159,2\n63#1:162\n70#1:172\n70#1:173\n70#1:177\n70#1:174\n70#1:176\n70#1:175\n*E\n"})
    private static final class Handler
    implements ToolHandler {
        @NotNull
        private final ToolContext context;
        @NotNull
        private final ModelProvider modelProvider;
        @NotNull
        private final GenerateVectorDrawableArgs args;

        public Handler(@NotNull ToolContext context2, @NotNull ModelProvider modelProvider, @NotNull GenerateVectorDrawableArgs args) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)modelProvider, (String)"modelProvider");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.context = context2;
            this.modelProvider = modelProvider;
            this.args = args;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        @Nullable
        public Object handle(@NotNull Continuation<? super Response> $completion) {
            if (!($completion instanceof handle.1)) ** GOTO lbl-1000
            var27_2 = $completion;
            if ((var27_2.label & -2147483648) != 0) {
                var27_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    /* synthetic */ Object result;
                    final /* synthetic */ Handler this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.handle((Continuation<? super Response>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var28_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    model = this.modelProvider.getModel();
                    project = this.context.getProject();
                    prompt = this.createPrompt(this.args.getDescription(), this.args.getImageType());
                    project$iv = project;
                    existingPrompt$iv = null;
                    $i$f$buildPrompt = false;
                    builder$iv = new PromptBuilderImpl(project$iv);
                    var10_16 = builder$iv;
                    $this$handle_u24lambda_u241 = var10_16;
                    $i$a$-buildPrompt$default-GenerateVectorDrawableTool$Handler$handle$builtPrompt$1 = false;
                    $this$handle_u24lambda_u241.userMessage((Function1<? super PromptBuilder.UserMessageBuilder, Unit>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, handle$lambda$1$lambda$0(java.lang.String com.android.tools.idea.studiobot.prompts.PromptBuilder$UserMessageBuilder ), (Lcom/android/tools/idea/studiobot/prompts/PromptBuilder$UserMessageBuilder;)Lkotlin/Unit;)((String)prompt));
                    prompt$iv = var10_16.build();
                    $this$any$iv$iv = prompt$iv.getMessages();
                    $i$f$any = false;
                    if (!($this$any$iv$iv instanceof Collection) || !((Collection)$this$any$iv$iv).isEmpty()) ** GOTO lbl31
                    v0 = false;
                    ** GOTO lbl69
lbl31:
                    // 2 sources

                    for (T element$iv$iv : $this$any$iv$iv) {
                        it$iv = (Prompt.Message)element$iv$iv;
                        $i$a$-any-PromptBuilderKt$buildPrompt$usedAnyFiles$1$iv = false;
                        $this$any$iv$iv = it$iv.getChunks();
                        $i$f$any = false;
                        if (!($this$any$iv$iv instanceof Collection) || !((Collection)$this$any$iv$iv).isEmpty()) ** GOTO lbl39
                        v1 = false;
                        ** GOTO lbl47
lbl39:
                        // 2 sources

                        for (T element$iv$iv : $this$any$iv$iv) {
                            chunk$iv = (Prompt.Chunk)element$iv$iv;
                            $i$a$-any-PromptBuilderKt$buildPrompt$usedAnyFiles$1$1$iv = false;
                            v2 = !chunk$iv.getFilesUsed().isEmpty();
                            if (!v2) continue;
                            v1 = true;
                            ** GOTO lbl47
                        }
                        v1 = false;
lbl47:
                        // 3 sources

                        if (v1) ** GOTO lbl-1000
                        if (!(it$iv instanceof Prompt.ContextMessage)) ** GOTO lbl-1000
                        $this$any$iv$iv = ((Prompt.ContextMessage)it$iv).getFiles();
                        $i$f$any = false;
                        if (!($this$any$iv$iv instanceof Collection) || !((Collection)$this$any$iv$iv).isEmpty()) ** GOTO lbl54
                        v3 = false;
                        ** GOTO lbl61
lbl54:
                        // 2 sources

                        for (T element$iv$iv : $this$any$iv$iv) {
                            file$iv = (Prompt.ContextFile)element$iv$iv;
                            $i$a$-any-PromptBuilderKt$buildPrompt$usedAnyFiles$1$2$iv = false;
                            if (!(file$iv.getAttachedByUser() == false)) continue;
                            v3 = true;
                            ** GOTO lbl61
                        }
                        v3 = false;
lbl61:
                        // 3 sources

                        if (v3) lbl-1000:
                        // 2 sources

                        {
                            v4 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v4 = false;
                        }
                        if (!v4) continue;
                        v0 = true;
                        ** GOTO lbl69
                    }
                    v0 = usedAnyFiles$iv = false;
lbl69:
                    // 3 sources

                    if (usedAnyFiles$iv && !ContextSharingSettingsProvider.Companion.isContextSharingAllowed(project$iv)) {
                        $i$a$-check-PromptBuilderKt$buildPrompt$2$iv = false;
                        var15_26 = "User has not enabled context sharing. This setting must be checked before building a prompt that used any files as context.";
                        throw new IllegalStateException(var15_26.toString());
                    }
                    builtPrompt = prompt$iv;
                    $this$filterIsInstance$iv = Model.generateContent$default((Model)var2_5, builtPrompt, null, 2, null);
                    $i$f$filterIsInstance = false;
                    $this$filter$iv$iv = $this$filterIsInstance$iv;
                    $i$f$filter = false;
                    $this$unsafeTransform$iv$iv$iv = $this$filter$iv$iv;
                    $i$f$unsafeTransform = false;
                    $i$f$unsafeFlow = false;
                    $continuation.label = 1;
                    v5 = FlowKt.toList$default((Flow)((Flow)new Flow<Object>($this$unsafeTransform$iv$iv$iv){
                        final /* synthetic */ Flow $this_unsafeTransform$inlined;
                        {
                            this.$this_unsafeTransform$inlined = flow2;
                        }

                        public Object collect(FlowCollector collector2, Continuation $completion) {
                            Continuation continuation = $completion;
                            FlowCollector $this$unsafeTransform_u24lambda_u240 = collector2;
                            boolean bl = false;
                            Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u240){
                                final /* synthetic */ FlowCollector $this_unsafeFlow;
                                {
                                    this.$this_unsafeFlow = $receiver;
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                public final Object emit(Object var1_1, Continuation $completion) {
                                    if (!($completion instanceof Handler$handle$$inlined$filterIsInstance$1$2$1)) ** GOTO lbl-1000
                                    var3_3 = $completion;
                                    if ((var3_3.label & -2147483648) != 0) {
                                        var3_3.label -= -2147483648;
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        $continuation = new ContinuationImpl(this, $completion){
                                            /* synthetic */ Object result;
                                            int label;
                                            Object L$0;
                                            Object L$1;
                                            final /* synthetic */ Handler$handle$$inlined$filterIsInstance$1$2 this$0;
                                            {
                                                this.this$0 = this$0;
                                                super($completion);
                                            }

                                            public final Object invokeSuspend(Object $result) {
                                                this.result = $result;
                                                this.label |= Integer.MIN_VALUE;
                                                return this.this$0.emit(null, (Continuation)this);
                                            }
                                        };
                                    }
                                    $result = $continuation.result;
                                    var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch ($continuation.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            var6_6 = value;
                                            $this$filter_u24lambda_u240 = this.$this_unsafeFlow;
                                            $i$a$-unsafeTransform-FlowKt__TransformKt$filter$1 = false;
                                            (Continuation)$continuation;
                                            it = value;
                                            $i$a$-filter-FlowKt__TransformKt$filterIsInstance$1 = false;
                                            if (!(it instanceof Content.TextContent)) break;
                                            $continuation.label = 1;
                                            v0 = $this$filter_u24lambda_u240.emit((Object)value, (Continuation)$continuation);
                                            if (v0 == var5_5) {
                                                return var5_5;
                                            }
                                            break;
                                        }
                                        case 1: {
                                            $i$a$-unsafeTransform-FlowKt__TransformKt$filter$1 = false;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
                                            break;
                                        }
                                    }
                                    return Unit.INSTANCE;
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }
                            }, $completion);
                            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                return object;
                            }
                            return Unit.INSTANCE;
                        }
                    }), null, (Continuation)$continuation, (int)1, null);
                    ** if (v5 != var28_4) goto lbl91
lbl90:
                    // 1 sources

                    return var28_4;
lbl91:
                    // 1 sources

                    ** GOTO lbl97
                }
                case 1: {
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v5 = $result;
lbl97:
                        // 2 sources

                        if (StringsKt.isBlank((CharSequence)(svgContent = CollectionsKt.joinToString$default((Iterable)((Iterable)v5), (CharSequence)"", null, null, (int)0, null, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, handle$lambda$2(com.android.tools.idea.studiobot.Content$TextContent ), (Lcom/android/tools/idea/studiobot/Content$TextContent;)Ljava/lang/CharSequence;)(), (int)30, null)))) {
                            return new Response(null, "Gemini did not return any content.", null, null, Response.ToolExecutionStatus.ERROR_OCCURRED, 13, null);
                        }
                    }
                    catch (Exception e) {
                        return new Response(null, "Error calling Gemini: " + e.getMessage(), null, null, Response.ToolExecutionStatus.ERROR_OCCURRED, 13, null);
                    }
                    tempSvgFile = Files.createTempFile("generated_vector", ".svg", new FileAttribute[0]);
                    Files.writeString(tempSvgFile, (CharSequence)svgContent, new OpenOption[0]);
                    try {
                        outputStream = new ByteArrayOutputStream();
                        errorMessage = Svg2Vector.parseSvgToXml((Path)tempSvgFile, (OutputStream)outputStream);
                        Intrinsics.checkNotNull((Object)errorMessage);
                        if (((CharSequence)errorMessage).length() > 0) {
                            var11_24 = new Response(null, "SVG to Vector Drawable conversion error: " + errorMessage + "\n\n" + svgContent, null, null, Response.ToolExecutionStatus.ERROR_OCCURRED, 13, null);
                            return var11_24;
                        }
                        v6 = outputStream.toString(Charsets.UTF_8);
                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"toString(...)");
                        vectorDrawableXml = v6;
                    }
                    catch (Exception e) {
                        var10_19 = new Response(null, "Error converting SVG to Vector Drawable: " + e.getMessage() + "\n\n" + svgContent, null, null, Response.ToolExecutionStatus.ERROR_OCCURRED, 13, null);
                        return var10_19;
                    }
                    finally {
                        Files.delete(tempSvgFile);
                    }
                    return new Response(vectorDrawableXml, null, null, null, Response.ToolExecutionStatus.OK, 14, null);
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private final String createPrompt(String description, String imageType) {
            String basePrompt = "Generate an SVG image for the following description: '" + description + "'.\n        Respond with only the SVG contents, no other text since the result will be put into an\n        svg file.\n\n        We will convert the SVG to a different format so there are some restrictions on the SVG:\n        - No filter primitive elements: (e.g., <feGaussianBlur>, <feBlend>, <feMerge>).\n        - No text or font elements: (e.g., <text>, <font>, <tspan>, <glyph>). The provided GenerateVectorDrawableTool.kt explicitly prompts the AI to avoid these.\n        - No animation elements: (e.g., <animate>, <set>, <animateMotion>).\n        - No scripting, linking, or external objects: (e.g., <script>, <a>, <image>, <foreignObject>).\n        - No complex structural and reusability elements: (e.g., <symbol>, <marker>, <pattern>, <switch>).\n        - No light source elements for filters: (e.g., <fePointLight>, <feSpotLight>).\n        - Limited gradient attributes: The gradientTransform attribute is explicitly ignored.\n        - No nested clipPath elements: A <clipPath> that references another <clipPath> is not supported.\n        - No multiple <svg> tags: The file must contain only one <svg> element.\n        - No circular dependencies: Using <use> tags to create a circular reference will result in an error.\n        ";
            String string = imageType.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String string2 = string;
            String typeSpecifics = Intrinsics.areEqual((Object)string2, (Object)"icon") ? " The SVG should be suitable for an Android application icon. It should be simple, monochrome (black on transparent background), and have a viewport of 24x24." : (Intrinsics.areEqual((Object)string2, (Object)"placeholder") ? " The SVG should be suitable for a placeholder image in an app. It can be more detailed and colorful. A viewport of 200x200 is appropriate." : "");
            return basePrompt + typeSpecifics;
        }

        private static final Unit handle$lambda$1$lambda$0(String $prompt, PromptBuilder.UserMessageBuilder $this$userMessage) {
            Intrinsics.checkNotNullParameter((Object)$this$userMessage, (String)"$this$userMessage");
            PromptBuilder.MessageBuilder.text$default($this$userMessage, $prompt, CollectionsKt.emptyList(), null, 4, null);
            return Unit.INSTANCE;
        }

        private static final CharSequence handle$lambda$2(Content.TextContent it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return StringsKt.replace$default((String)StringsKt.replace$default((String)it.getText(), (String)"```xml", (String)"", (boolean)false, (int)4, null), (String)"```", (String)"", (boolean)false, (int)4, null);
        }
    }
}

