/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.designer.compose.preview.agents.tools;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.designer.compose.preview.agents.tools.ComposePreviewToolArgs;
import com.android.studio.ml.designer.compose.preview.agents.tools.VisualLintToolHandler;
import com.android.studio.ml.icons.AndroidToolIcon;
import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolArgument;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KParameter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ToolDescription(summary="Returns a list of Accessibility, Color Contrast, Typography and form factor issues of the Compose preview", description="Use this tool to identify Accessibility, Color Contrast, Typography and form factor issues with a Compose Preview", examples={})
@ToolResult(description="Output: returns a list of issues:\n- Empty list: no issues has been detected\n- Returns error if no Previews has been found in the input or if the Preview fails to render.\n- A list of type List<VisualLintRenderIssue> if UI issues has been detected.\n\nThe UI issues can be of type:\n- Accessibility\n- Color contrast\n- Typography\n- Adaptive and layout issues with many different form factors.\n")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0018H\u0007R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/studio/ml/designer/compose/preview/agents/tools/VisualLintServiceTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/android/studio/ml/designer/compose/preview/agents/tools/ComposePreviewToolArgs;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "icon", "Lcom/android/studio/ml/icons/AndroidToolIcon;", "getIcon", "()Lcom/android/studio/ml/icons/AndroidToolIcon;", "currentResponse", "", "Lcom/google/aiplugin/agents/Response;", "getRunningDisplayText", "args", "getCompletedDisplayText", "createHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "getToolResponsesForTest", "", "aiplugin.android"})
@StabilityInferred(parameters=0)
public final class VisualLintServiceTool
implements Tool<ComposePreviewToolArgs> {
    @NotNull
    private final AndroidToolIcon icon = AndroidToolIcon.UI_CHECK;
    @NotNull
    private final List<Response> currentResponse = new ArrayList();
    public static final int $stable = 8;

    @Override
    @NotNull
    public String getName() {
        return "visual_lint_service_tool";
    }

    @Override
    @NotNull
    public AndroidToolIcon getIcon() {
        return this.icon;
    }

    @Override
    @NotNull
    public String getRunningDisplayText(@NotNull ComposePreviewToolArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Checking for UI issues in preview";
    }

    @Override
    @NotNull
    public String getCompletedDisplayText(@NotNull ComposePreviewToolArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Checked for UI issues in preview";
    }

    @Override
    @NotNull
    public ToolHandler createHandler(@NotNull ToolContext context2, @NotNull ComposePreviewToolArgs args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new VisualLintToolHandler(context2, args, null, arg_0 -> VisualLintServiceTool.createHandler$lambda$0(this, arg_0), 4, null);
    }

    @TestOnly
    @NotNull
    public final List<Response> getToolResponsesForTest() {
        return this.currentResponse;
    }

    @Override
    @Nullable
    public String getStatusMessage() {
        return Tool.super.getStatusMessage();
    }

    @Override
    @Nullable
    public Map<KParameter, ToolArgument> getToolArguments() {
        return Tool.super.getToolArguments();
    }

    @Override
    @NotNull
    public ToolDescription getToolDescription() {
        return Tool.super.getToolDescription();
    }

    @Override
    @Nullable
    public ToolResult getToolResult() {
        return Tool.super.getToolResult();
    }

    @Override
    @Nullable
    public ToolHandler restoreHandler(@NotNull Project project2, @NotNull ComposePreviewToolArgs args, @NotNull Response response2) {
        return Tool.super.restoreHandler(project2, args, response2);
    }

    @Override
    @NotNull
    public String getDescription() {
        return Tool.super.getDescription();
    }

    private static final Unit createHandler$lambda$0(VisualLintServiceTool this$0, Response it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.currentResponse.add(it);
        return Unit.INSTANCE;
    }
}

