/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.gradle.buildsystem;

import com.android.studio.ml.gradle.buildsystem.ArtifactCoordinate;
import com.android.studio.ml.gradle.buildsystem.GradleTool;
import com.android.studio.ml.gradle.buildsystem.GradleToolsUtilsKt;
import com.android.studio.ml.gradle.buildsystem.ProjectData;
import com.android.studio.ml.gradle.buildsystem.SourceSetModuleData;
import com.android.studio.ml.icons.AndroidToolIcon;
import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolArgument;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.Project;
import java.util.Map;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KParameter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ToolDescription(summary="Returns the name of the task to build the given artifact", instructions="The input should not be inferred from path and other data. It should be based on returned values of get_gradle_artifact_from_file\n", examples={})
@ToolResult(description="The name of the Gradle task to run")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0002\u0011\u0012B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/android/studio/ml/gradle/buildsystem/GetAssembleTaskForArtifact;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/android/studio/ml/gradle/buildsystem/ArtifactCoordinate;", "Lcom/android/studio/ml/gradle/buildsystem/GradleTool;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "getRunningDisplayText", "args", "getCompletedDisplayText", "createHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "Companion", "Handler", "aiplugin.android.gradle"})
public final class GetAssembleTaskForArtifact
implements Tool<ArtifactCoordinate>,
GradleTool<ArtifactCoordinate> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "get_assemble_task_for_artifact";

    @Override
    @NotNull
    public String getName() {
        return NAME;
    }

    @Override
    @NotNull
    public String getRunningDisplayText(@NotNull ArtifactCoordinate args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Finding assemble task for " + args.getSubproject_path() + ":" + args.getArtifact_name();
    }

    @Override
    @NotNull
    public String getCompletedDisplayText(@NotNull ArtifactCoordinate args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Found assemble task for " + args.getSubproject_path() + ":" + args.getArtifact_name();
    }

    @Override
    @NotNull
    public ToolHandler createHandler(@NotNull ToolContext context2, @NotNull ArtifactCoordinate args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new Handler(context2, args);
    }

    @Override
    @Nullable
    public String getStatusMessage() {
        return Tool.super.getStatusMessage();
    }

    @Override
    @Nullable
    public Map<KParameter, ToolArgument> getToolArguments() {
        return Tool.super.getToolArguments();
    }

    @Override
    @NotNull
    public ToolDescription getToolDescription() {
        return Tool.super.getToolDescription();
    }

    @Override
    @Nullable
    public ToolResult getToolResult() {
        return Tool.super.getToolResult();
    }

    @Override
    @Nullable
    public ToolHandler restoreHandler(@NotNull Project project2, @NotNull ArtifactCoordinate args, @NotNull Response response2) {
        return Tool.super.restoreHandler(project2, args, response2);
    }

    @Override
    @NotNull
    public String getDescription() {
        return Tool.super.getDescription();
    }

    @Override
    @NotNull
    public AndroidToolIcon getIcon() {
        return GradleTool.super.getIcon();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/studio/ml/gradle/buildsystem/GetAssembleTaskForArtifact$Companion;", "", "<init>", "()V", "NAME", "", "aiplugin.android.gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/studio/ml/gradle/buildsystem/GetAssembleTaskForArtifact$Handler;", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "args", "Lcom/android/studio/ml/gradle/buildsystem/ArtifactCoordinate;", "<init>", "(Lcom/google/aiplugin/agents/tools/ToolContext;Lcom/android/studio/ml/gradle/buildsystem/ArtifactCoordinate;)V", "handle", "Lcom/google/aiplugin/agents/Response;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "aiplugin.android.gradle"})
    @SourceDebugExtension(value={"SMAP\nGetAssembleTaskForArtifact.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GetAssembleTaskForArtifact.kt\ncom/android/studio/ml/gradle/buildsystem/GetAssembleTaskForArtifact$Handler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n1#2:92\n*E\n"})
    private static final class Handler
    implements ToolHandler {
        @NotNull
        private final ToolContext context;
        @NotNull
        private final ArtifactCoordinate args;

        public Handler(@NotNull ToolContext context2, @NotNull ArtifactCoordinate args) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.context = context2;
            this.args = args;
        }

        @Override
        @Nullable
        public Object handle(@NotNull Continuation<? super Response> $completion) {
            return CoroutinesKt.readAction(() -> Handler.handle$lambda$3(this), $completion);
        }

        private static final Response handle$lambda$3$lambda$2(Project $project, Handler this$0) {
            Response response2;
            Object v1;
            block6: {
                Map<String, ProjectData> modulesByGradlePath = GradleToolsUtilsKt.buildModulesMap($project);
                if (modulesByGradlePath.isEmpty()) {
                    return GradleToolsUtilsKt.errorNoModules();
                }
                ProjectData projectData = modulesByGradlePath.get(this$0.args.getSubproject_path());
                if (projectData == null) {
                    return GradleToolsUtilsKt.errorModuleNotFound(this$0.args.getSubproject_path());
                }
                ProjectData projectData2 = projectData;
                Iterable iterable = projectData2.getSourceSetModules();
                for (Object t : iterable) {
                    SourceSetModuleData it = (SourceSetModuleData)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getSourceSetName(), (Object)this$0.args.getArtifact_name())) continue;
                    v1 = t;
                    break block6;
                }
                v1 = null;
            }
            SourceSetModuleData sourceSetModuleData = v1;
            if (sourceSetModuleData == null) {
                return GradleToolsUtilsKt.errorArtifactNotFoundInProject(this$0.args.getArtifact_name(), this$0.args.getSubproject_path());
            }
            SourceSetModuleData sourceSetModule = sourceSetModuleData;
            String string = sourceSetModule.findTasksData().getAssembleTask();
            if (string != null) {
                String it = string;
                boolean bl = false;
                response2 = new Response(GradleToolsUtilsKt.fullTaskPath(this$0.args.getSubproject_path(), it), null, null, null, null, 30, null);
            } else {
                response2 = new Response(null, "Missing assemble task data for artifact " + this$0.args.getArtifact_name() + " for gradle project " + this$0.args.getSubproject_path(), null, null, Response.ToolExecutionStatus.GRADLE_ERR_MISSING_DATA, 13, null);
            }
            return response2;
        }

        private static final Response handle$lambda$3(Handler this$0) {
            Project project2 = this$0.context.getProject();
            return GradleToolsUtilsKt.handleCheckingSyncState(project2, (Function0<Response>)((Function0)() -> Handler.handle$lambda$3$lambda$2(project2, this$0)));
        }
    }
}

