/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.gradle.buildsystem;

import com.android.studio.ml.gradle.buildsystem.AbsolutePath;
import com.android.studio.ml.gradle.buildsystem.ArtifactWithSourceType;
import com.android.studio.ml.gradle.buildsystem.GetGradleArtifactFromFileKt;
import com.android.studio.ml.gradle.buildsystem.GradleTool;
import com.android.studio.ml.gradle.buildsystem.GradleToolsUtilsKt;
import com.android.studio.ml.gradle.buildsystem.ProjectData;
import com.android.studio.ml.gradle.buildsystem.SourceSetModuleData;
import com.android.studio.ml.icons.AndroidToolIcon;
import com.android.tools.idea.gradle.model.IdeSourceProvider;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.projectsystem.gradle.LinkedAndroidModuleGroupUtilsKt;
import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolArgument;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KParameter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;

@ToolDescription(summary="Returns an artifact that contains the provided file in its sources", instructions="The result can be used to request more information about the project structure, e.g. in get_test_artifacts_for_sub_project, get_source_folders_for_artifact, get_assemble_task_for_artifact, get_test_task_for_artifact, get_artifact_consumers tools.", examples={})
@ToolResult(description="Returns a JSON object which represents an artifact containing the file, with the following information:\n- subproject_path: Gradle path of the sub-project\n- artifact_name: Name of the artifact in this sub-project\n- sources: the type of source folder that contains the file. it could be java, kotlin, android resources, android assets, etc...")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0002\u0011\u0012B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/android/studio/ml/gradle/buildsystem/GetGradleArtifactFromFile;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/android/studio/ml/gradle/buildsystem/AbsolutePath;", "Lcom/android/studio/ml/gradle/buildsystem/GradleTool;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "getRunningDisplayText", "args", "getCompletedDisplayText", "createHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "Companion", "Handler", "aiplugin.android.gradle"})
public final class GetGradleArtifactFromFile
implements Tool<AbsolutePath>,
GradleTool<AbsolutePath> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "get_gradle_artifact_from_file";

    @Override
    @NotNull
    public String getName() {
        return NAME;
    }

    @Override
    @NotNull
    public String getRunningDisplayText(@NotNull AbsolutePath args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Finding Gradle artifact for " + new File(args.getAbsolutePath()).getName();
    }

    @Override
    @NotNull
    public String getCompletedDisplayText(@NotNull AbsolutePath args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Found Gradle artifact for " + new File(args.getAbsolutePath()).getName();
    }

    @Override
    @NotNull
    public ToolHandler createHandler(@NotNull ToolContext context2, @NotNull AbsolutePath args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new Handler(context2, args);
    }

    @Override
    @Nullable
    public String getStatusMessage() {
        return Tool.super.getStatusMessage();
    }

    @Override
    @Nullable
    public Map<KParameter, ToolArgument> getToolArguments() {
        return Tool.super.getToolArguments();
    }

    @Override
    @NotNull
    public ToolDescription getToolDescription() {
        return Tool.super.getToolDescription();
    }

    @Override
    @Nullable
    public ToolResult getToolResult() {
        return Tool.super.getToolResult();
    }

    @Override
    @Nullable
    public ToolHandler restoreHandler(@NotNull Project project2, @NotNull AbsolutePath args, @NotNull Response response2) {
        return Tool.super.restoreHandler(project2, args, response2);
    }

    @Override
    @NotNull
    public String getDescription() {
        return Tool.super.getDescription();
    }

    @Override
    @NotNull
    public AndroidToolIcon getIcon() {
        return GradleTool.super.getIcon();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/studio/ml/gradle/buildsystem/GetGradleArtifactFromFile$Companion;", "", "<init>", "()V", "NAME", "", "aiplugin.android.gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/studio/ml/gradle/buildsystem/GetGradleArtifactFromFile$Handler;", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "args", "Lcom/android/studio/ml/gradle/buildsystem/AbsolutePath;", "<init>", "(Lcom/google/aiplugin/agents/tools/ToolContext;Lcom/android/studio/ml/gradle/buildsystem/AbsolutePath;)V", "handle", "Lcom/google/aiplugin/agents/Response;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "aiplugin.android.gradle"})
    @SourceDebugExtension(value={"SMAP\nGetGradleArtifactFromFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GetGradleArtifactFromFile.kt\ncom/android/studio/ml/gradle/buildsystem/GetGradleArtifactFromFile$Handler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,213:1\n1869#2,2:214\n295#2,2:220\n11228#3:216\n11563#3,3:217\n*S KotlinDebug\n*F\n+ 1 GetGradleArtifactFromFile.kt\ncom/android/studio/ml/gradle/buildsystem/GetGradleArtifactFromFile$Handler\n*L\n131#1:214,2\n151#1:220,2\n151#1:216\n151#1:217,3\n*E\n"})
    private static final class Handler
    implements ToolHandler {
        @NotNull
        private final ToolContext context;
        @NotNull
        private final AbsolutePath args;

        public Handler(@NotNull ToolContext context2, @NotNull AbsolutePath args) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.context = context2;
            this.args = args;
        }

        @Override
        @Nullable
        public Object handle(@NotNull Continuation<? super Response> $completion) {
            File file = new File(this.args.getAbsolutePath());
            if (!file.exists()) {
                return new Response(null, "File does not exist", null, null, Response.ToolExecutionStatus.ERR_FILE_NOT_FOUND, 13, null);
            }
            return CoroutinesKt.readAction(() -> Handler.handle$lambda$5(this, file), $completion);
        }

        /*
         * WARNING - void declaration
         */
        private static final Response handle$lambda$5$lambda$4(Project $project, File $file) {
            Object sourceSetModuleData;
            ProjectData projectData;
            String gradlePath;
            ModuleManager moduleManager = ModuleManager.Companion.getInstance($project);
            Module[] modules = moduleManager.getModules();
            if (modules.length == 0) {
                return GradleToolsUtilsKt.errorNoModules();
            }
            Map allModules = MapsKt.toMutableMap(GradleToolsUtilsKt.buildModulesMap($project));
            Set checkedProjects = new LinkedHashSet();
            for (Map.Entry entry : allModules.entrySet()) {
                Module module2;
                gradlePath = (String)entry.getKey();
                projectData = (ProjectData)entry.getValue();
                ProgressManager.checkCanceled();
                if (checkedProjects.contains(gradlePath) || !LinkedAndroidModuleGroupUtilsKt.isLinkedAndroidModule((Module)(module2 = projectData.getRootModule().getModule())) || !LinkedAndroidModuleGroupUtilsKt.isHolderModule((Module)module2)) continue;
                checkedProjects.add(gradlePath);
                ProgressManager.checkCanceled();
                if (GradleAndroidModel.Companion.get(module2) == null) continue;
                Iterable $this$forEach$iv = projectData.getSourceSetModules();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    GradleAndroidModel gradleModel;
                    sourceSetModuleData = (SourceSetModuleData)element$iv;
                    boolean bl = false;
                    List<IdeSourceProvider> list = ((SourceSetModuleData)sourceSetModuleData).retrieveSourceProviders(gradleModel);
                    if (list == null || (list = GetGradleArtifactFromFileKt.access$checkForFile(list, $file)) == null) continue;
                    List<IdeSourceProvider> sourceType = list;
                    boolean bl2 = false;
                    ArtifactWithSourceType matchingArtifact = new ArtifactWithSourceType(((SourceSetModuleData)sourceSetModuleData).toArtifact(gradlePath), (String)((Object)sourceType));
                    return new Response(GradleToolsUtilsKt.createGson().toJson((Object)matchingArtifact), null, null, null, null, 30, null);
                }
            }
            for (Map.Entry entry : allModules.entrySet()) {
                gradlePath = (String)entry.getKey();
                projectData = (ProjectData)entry.getValue();
                if (checkedProjects.contains(gradlePath)) continue;
                checkedProjects.add(gradlePath);
                for (SourceSetModuleData sourceSetModule : projectData.getSourceSetModules()) {
                    Path matchFolder;
                    Object v1;
                    block7: {
                        void $this$firstOrNull$iv;
                        void $this$mapTo$iv$iv;
                        VirtualFile[] sourceRoots;
                        Object $this$map$iv = sourceRoots = ProjectRootsUtilKt.getSourceRoots((Module)sourceSetModule.getModule());
                        boolean $i$f$map = false;
                        sourceSetModuleData = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(((VirtualFile[])$this$map$iv).length);
                        boolean $i$f$mapTo = false;
                        int n = ((void)$this$mapTo$iv$iv).length;
                        for (int bl2 = 0; bl2 < n; ++bl2) {
                            void it;
                            void item$iv$iv;
                            void var22_29 = item$iv$iv = $this$mapTo$iv$iv[bl2];
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(it.toNioPath());
                        }
                        $this$map$iv = (List)destination$iv$iv;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            Path it = (Path)element$iv;
                            boolean bl = false;
                            Intrinsics.checkNotNull((Object)it);
                            if (!GetGradleArtifactFromFileKt.access$containsFile(it, $file)) continue;
                            v1 = element$iv;
                            break block7;
                        }
                        v1 = null;
                    }
                    if ((matchFolder = (Path)v1) == null) continue;
                    return new Response(GradleToolsUtilsKt.createGson().toJson((Object)new ArtifactWithSourceType(gradlePath, sourceSetModule.getSourceSetName(), CollectionsKt.last((Iterable)matchFolder).toString())), null, null, null, null, 30, null);
                }
            }
            return new Response(null, "File not in project", null, null, Response.ToolExecutionStatus.ERR_FILE_NOT_IN_PROJECT, 13, null);
        }

        private static final Response handle$lambda$5(Handler this$0, File $file) {
            Project project2 = this$0.context.getProject();
            return GradleToolsUtilsKt.handleCheckingSyncState(project2, (Function0<Response>)((Function0)() -> Handler.handle$lambda$5$lambda$4(project2, $file)));
        }
    }
}

