/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.gradle.updatedeps;

import com.android.studio.ml.bot.agents.tools.dependency.DependencyUpdaterState;
import com.android.studio.ml.bot.agents.tools.dependency.LibraryUpgrade;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.intellij.openapi.diagnostic.Logger;
import java.lang.reflect.Type;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u00020\u0001:\u0001\nB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0005\u00a8\u0006\u000b"}, d2={"Lcom/android/studio/ml/gradle/updatedeps/UpgradeStatusSerializer;", "", "<init>", "()V", "serialize", "", "result", "Lcom/android/studio/ml/bot/agents/tools/dependency/DependencyUpdaterState$UpgradeResult;", "deserialize", "s", "State", "aiplugin.android.gradle"})
@SourceDebugExtension(value={"SMAP\nUpdateDepsRefactoringTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateDepsRefactoringTool.kt\ncom/android/studio/ml/gradle/updatedeps/UpgradeStatusSerializer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,315:1\n24#2:316\n*S KotlinDebug\n*F\n+ 1 UpdateDepsRefactoringTool.kt\ncom/android/studio/ml/gradle/updatedeps/UpgradeStatusSerializer\n*L\n296#1:316\n*E\n"})
final class UpgradeStatusSerializer {
    @NotNull
    public static final UpgradeStatusSerializer INSTANCE = new UpgradeStatusSerializer();

    private UpgradeStatusSerializer() {
    }

    @NotNull
    public final String serialize(@NotNull DependencyUpdaterState.UpgradeResult result2) {
        State state2;
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        DependencyUpdaterState.UpgradeResult upgradeResult = result2;
        if (upgradeResult instanceof DependencyUpdaterState.UpgradeResult.Upgraded) {
            state2 = new State(null, ((DependencyUpdaterState.UpgradeResult.Upgraded)result2).getArtifacts());
        } else if (upgradeResult instanceof DependencyUpdaterState.UpgradeResult.Error) {
            state2 = new State(((DependencyUpdaterState.UpgradeResult.Error)result2).getMessage(), null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        State state3 = state2;
        String string = new Gson().toJson((Object)state3);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        return string;
    }

    @NotNull
    public final DependencyUpdaterState.UpgradeResult deserialize(@NotNull String s) {
        State state2;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        try {
            Type type2 = new TypeToken<State>(){}.getType();
            state2 = (State)new Gson().fromJson(s, type2);
        }
        catch (Exception e) {
            UpgradeStatusSerializer $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(UpgradeStatusSerializer.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Unable to deserialize " + s);
            state2 = new State("Error restoring state", null);
        }
        State state3 = state2;
        if (state3.getUpgradedArtifacts() == null) {
            String string = state3.getError();
            if (string == null) {
                string = "Error restoring state";
            }
            return new DependencyUpdaterState.UpgradeResult.Error(string);
        }
        return new DependencyUpdaterState.UpgradeResult.Upgraded(state3.getUpgradedArtifacts());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0017\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003J-\u0010\u000f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/android/studio/ml/gradle/updatedeps/UpgradeStatusSerializer$State;", "", "error", "", "upgradedArtifacts", "", "Lcom/android/studio/ml/bot/agents/tools/dependency/LibraryUpgrade$IndividualUpgrade;", "<init>", "(Ljava/lang/String;Ljava/util/Map;)V", "getError", "()Ljava/lang/String;", "getUpgradedArtifacts", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "aiplugin.android.gradle"})
    public static final class State {
        @Nullable
        private final String error;
        @Nullable
        private final Map<String, LibraryUpgrade.IndividualUpgrade> upgradedArtifacts;

        public State(@Nullable String error, @Nullable Map<String, LibraryUpgrade.IndividualUpgrade> upgradedArtifacts) {
            this.error = error;
            this.upgradedArtifacts = upgradedArtifacts;
        }

        @Nullable
        public final String getError() {
            return this.error;
        }

        @Nullable
        public final Map<String, LibraryUpgrade.IndividualUpgrade> getUpgradedArtifacts() {
            return this.upgradedArtifacts;
        }

        @Nullable
        public final String component1() {
            return this.error;
        }

        @Nullable
        public final Map<String, LibraryUpgrade.IndividualUpgrade> component2() {
            return this.upgradedArtifacts;
        }

        @NotNull
        public final State copy(@Nullable String error, @Nullable Map<String, LibraryUpgrade.IndividualUpgrade> upgradedArtifacts) {
            return new State(error, upgradedArtifacts);
        }

        public static /* synthetic */ State copy$default(State state2, String string, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                string = state2.error;
            }
            if ((n & 2) != 0) {
                map2 = state2.upgradedArtifacts;
            }
            return state2.copy(string, map2);
        }

        @NotNull
        public String toString() {
            return "State(error=" + this.error + ", upgradedArtifacts=" + this.upgradedArtifacts + ")";
        }

        public int hashCode() {
            int result2 = this.error == null ? 0 : this.error.hashCode();
            result2 = result2 * 31 + (this.upgradedArtifacts == null ? 0 : ((Object)this.upgradedArtifacts).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state2 = (State)other;
            if (!Intrinsics.areEqual((Object)this.error, (Object)state2.error)) {
                return false;
            }
            return Intrinsics.areEqual(this.upgradedArtifacts, state2.upgradedArtifacts);
        }
    }
}

