/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.journeys;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.annotations.concurrency.AnyThread;
import com.android.annotations.concurrency.UiThread;
import com.android.studio.ml.journeys.JourneyActionPrompt;
import com.android.studio.ml.journeys.JourneysAndroidTestResultsListener;
import com.android.studio.ml.journeys.JourneysEditorViewModel;
import com.android.studio.ml.journeys.TestStatus;
import com.android.studio.ml.journeys.run.JourneysRunToken;
import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.testartifacts.instrumented.testsuite.api.AndroidTestResultListener;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidDevice;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestCase;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestCaseResult;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestStep;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestSuite;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.JourneyActionArtifacts;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J(\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0003J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/studio/ml/journeys/JourneysAndroidTestResultsListener;", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/api/AndroidTestResultListener;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "model", "Lcom/android/studio/ml/journeys/JourneysEditorViewModel;", "token", "Lcom/android/studio/ml/journeys/run/JourneysRunToken;", "Lcom/android/tools/idea/projectsystem/AndroidProjectSystem;", "module", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/android/studio/ml/journeys/JourneysEditorViewModel;Lcom/android/studio/ml/journeys/run/JourneysRunToken;Lcom/intellij/openapi/module/Module;)V", "onTestStepStarted", "", "device", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidDevice;", "testSuite", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidTestSuite;", "testCase", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidTestCase;", "testStep", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidTestStep;", "onTestStepFinished", "isApplicableTest", "", "validateTestStep", "toTestStatus", "Lcom/android/studio/ml/journeys/TestStatus;", "result", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidTestCaseResult;", "aiplugin.android.journeys"})
@StabilityInferred(parameters=0)
public final class JourneysAndroidTestResultsListener
implements AndroidTestResultListener {
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final JourneysEditorViewModel model;
    @NotNull
    private final JourneysRunToken<AndroidProjectSystem> token;
    @NotNull
    private final Module module;
    public static final int $stable = 8;

    public JourneysAndroidTestResultsListener(@NotNull VirtualFile file, @NotNull JourneysEditorViewModel model2, @NotNull JourneysRunToken<AndroidProjectSystem> token, @NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter(token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        this.file = file;
        this.model = model2;
        this.token = token;
        this.module = module2;
    }

    public void onTestStepStarted(@NotNull AndroidDevice device, @NotNull AndroidTestSuite testSuite, @NotNull AndroidTestCase testCase, @NotNull AndroidTestStep testStep) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Intrinsics.checkNotNullParameter((Object)testSuite, (String)"testSuite");
        Intrinsics.checkNotNullParameter((Object)testCase, (String)"testCase");
        Intrinsics.checkNotNullParameter((Object)testStep, (String)"testStep");
        if (!this.isApplicableTest(testSuite, testCase)) {
            return;
        }
        BuildersKt.launch$default((CoroutineScope)this.model.getViewModelEdtScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, testStep, null){
            int label;
            final /* synthetic */ JourneysAndroidTestResultsListener this$0;
            final /* synthetic */ AndroidTestStep $testStep;
            {
                this.this$0 = $receiver;
                this.$testStep = $testStep;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        if (!JourneysAndroidTestResultsListener.access$validateTestStep(this.this$0, this.$testStep)) {
                            return Unit.INSTANCE;
                        }
                        switch (onTestStepStarted.WhenMappings.$EnumSwitchMapping$0[this.$testStep.getResult().ordinal()]) {
                            case 1: {
                                JourneysAndroidTestResultsListener.access$getModel$p(this.this$0).onTestScheduled(this.$testStep.getIndex());
                                break;
                            }
                            case 2: {
                                JourneysAndroidTestResultsListener.access$getModel$p(this.this$0).onTestStarted(this.$testStep.getIndex());
                                break;
                            }
                            default: {
                                Logger.getInstance(JourneysAndroidTestResultsListener.class).warn("Unexpected test step result: " + this.$testStep.getResult());
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public void onTestStepFinished(@NotNull AndroidDevice device, @NotNull AndroidTestSuite testSuite, @NotNull AndroidTestCase testCase, @NotNull AndroidTestStep testStep) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Intrinsics.checkNotNullParameter((Object)testSuite, (String)"testSuite");
        Intrinsics.checkNotNullParameter((Object)testCase, (String)"testCase");
        Intrinsics.checkNotNullParameter((Object)testStep, (String)"testStep");
        if (!this.isApplicableTest(testSuite, testCase)) {
            return;
        }
        List artifacts = JourneyActionArtifacts.Companion.parseFromAdditionalTestArtifacts(testStep.getAdditionalTestArtifacts());
        BuildersKt.launch$default((CoroutineScope)this.model.getViewModelEdtScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, testStep, (List<JourneyActionArtifacts>)artifacts, null){
            int label;
            final /* synthetic */ JourneysAndroidTestResultsListener this$0;
            final /* synthetic */ AndroidTestStep $testStep;
            final /* synthetic */ List<JourneyActionArtifacts> $artifacts;
            {
                this.this$0 = $receiver;
                this.$testStep = $testStep;
                this.$artifacts = $artifacts;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        if (!JourneysAndroidTestResultsListener.access$validateTestStep(this.this$0, this.$testStep)) {
                            return Unit.INSTANCE;
                        }
                        JourneysAndroidTestResultsListener.access$getModel$p(this.this$0).onTestFinished(this.$testStep.getIndex(), JourneysAndroidTestResultsListener.access$toTestStatus(this.this$0, this.$testStep.getResult()), this.$artifacts);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final boolean isApplicableTest(AndroidTestSuite testSuite, AndroidTestCase testCase) {
        RunConfiguration runConfiguration = testSuite.getRunConfiguration();
        if (runConfiguration == null) {
            return false;
        }
        RunConfiguration runConfiguration2 = runConfiguration;
        if (!this.token.isRunConfigurationThatRunsJourneyFile(runConfiguration2, this.file, this.module)) {
            return false;
        }
        return this.token.isRelativePathForJourneyTest(this.file, this.module, testCase.getMethodName());
    }

    @UiThread
    private final boolean validateTestStep(AndroidTestStep testStep) {
        JourneyActionPrompt prompt2 = (JourneyActionPrompt)CollectionsKt.getOrNull((List)((List)this.model.getActionValueList()), (int)testStep.getIndex());
        if (prompt2 == null) {
            Logger.getInstance(JourneysAndroidTestResultsListener.class).warn("No prompt found at index: " + testStep.getIndex());
            return false;
        }
        if (!Intrinsics.areEqual((Object)prompt2.getTextState().getText(), (Object)testStep.getName())) {
            Logger.getInstance(JourneysAndroidTestResultsListener.class).warn("Prompt at index " + testStep.getIndex() + " does not match test step name");
            return false;
        }
        return true;
    }

    private final TestStatus toTestStatus(AndroidTestCaseResult result2) {
        return switch (WhenMappings.$EnumSwitchMapping$0[result2.ordinal()]) {
            case 1 -> TestStatus.PASSED;
            case 2 -> TestStatus.FAILED;
            case 3 -> TestStatus.SKIPPED;
            case 4 -> TestStatus.LOADING;
            case 5 -> TestStatus.CANCELLED;
            case 6 -> TestStatus.SCHEDULED;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @AnyThread
    public void onRerunScheduled(@NotNull AndroidDevice device) {
        super.onRerunScheduled(device);
    }

    @AnyThread
    public void onTestCaseFinished(@NotNull AndroidDevice device, @NotNull AndroidTestSuite testSuite, @NotNull AndroidTestCase testCase) {
        super.onTestCaseFinished(device, testSuite, testCase);
    }

    @AnyThread
    public void onTestCaseStarted(@NotNull AndroidDevice device, @NotNull AndroidTestSuite testSuite, @NotNull AndroidTestCase testCase) {
        super.onTestCaseStarted(device, testSuite, testCase);
    }

    @AnyThread
    public void onTestStepUpdated(@NotNull AndroidDevice device, @NotNull AndroidTestSuite testSuite, @NotNull AndroidTestCase testCase, @NotNull AndroidTestStep testStep) {
        super.onTestStepUpdated(device, testSuite, testCase, testStep);
    }

    @AnyThread
    public void onTestSuiteFinished(@NotNull AndroidDevice device, @NotNull AndroidTestSuite testSuite) {
        super.onTestSuiteFinished(device, testSuite);
    }

    @AnyThread
    public void onTestSuiteScheduled(@NotNull AndroidDevice device) {
        super.onTestSuiteScheduled(device);
    }

    @AnyThread
    public void onTestSuiteStarted(@NotNull AndroidDevice device, @NotNull AndroidTestSuite testSuite) {
        super.onTestSuiteStarted(device, testSuite);
    }

    public static final /* synthetic */ boolean access$validateTestStep(JourneysAndroidTestResultsListener $this, AndroidTestStep testStep) {
        return $this.validateTestStep(testStep);
    }

    public static final /* synthetic */ JourneysEditorViewModel access$getModel$p(JourneysAndroidTestResultsListener $this) {
        return $this.model;
    }

    public static final /* synthetic */ TestStatus access$toTestStatus(JourneysAndroidTestResultsListener $this, AndroidTestCaseResult result2) {
        return $this.toTestStatus(result2);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AndroidTestCaseResult.values().length];
            try {
                nArray[AndroidTestCaseResult.PASSED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidTestCaseResult.FAILED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidTestCaseResult.SKIPPED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidTestCaseResult.IN_PROGRESS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidTestCaseResult.CANCELLED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidTestCaseResult.SCHEDULED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

