/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.journeys;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.annotations.concurrency.AnyThread;
import com.android.annotations.concurrency.WorkerThread;
import com.android.studio.ml.journeys.ActionDomElement;
import com.android.studio.ml.journeys.ActionsDomElement;
import com.android.studio.ml.journeys.DescriptionDomElement;
import com.android.studio.ml.journeys.JourneyDocumentUtilsKt;
import com.android.studio.ml.journeys.JourneyDomElement;
import com.android.tools.idea.flags.StudioFlags;
import com.intellij.openapi.application.ReadAndWriteScope;
import com.intellij.openapi.application.ReadResult;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.CoroutinesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0087@\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0087@\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0087@\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0087@\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0087@\u00a2\u0006\u0002\u0010\u0018J\u001e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0087@\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0017H\u0087@\u00a2\u0006\u0002\u0010\u0018J\u001e\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0010H\u0087@\u00a2\u0006\u0002\u0010\u001bJ\u001e\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0010H\u0087@\u00a2\u0006\u0002\u0010\u001bJ&\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u0010H\u0087@\u00a2\u0006\u0002\u0010$J\u001e\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u0017H\u0087@\u00a2\u0006\u0002\u0010(J\u0010\u0010)\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020+H\u0003J\u0010\u0010,\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020-H\u0003J\n\u0010.\u001a\u0004\u0018\u00010/H\u0002J\n\u00100\u001a\u0004\u0018\u00010-H\u0002J\n\u00101\u001a\u0004\u0018\u00010+H\u0002J8\u00102\u001a\b\u0012\u0004\u0012\u0002H403\"\u0004\b\u0000\u00104*\u0002052\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u00106\u001a\u00020\u00102\f\u00107\u001a\b\u0012\u0004\u0012\u0002H408H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/android/studio/ml/journeys/XmlTagUpdater;", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "domManager", "Lcom/intellij/util/xml/DomManager;", "kotlin.jvm.PlatformType", "xmlFile", "Lcom/intellij/psi/xml/XmlFile;", "updateJourneyName", "", "text", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateJourneyDescription", "addNewActionToFile", "updateEmptyOrAddNewActionToFile", "addNewActionToFileAt", "index", "", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateActionTagValue", "row", "(ILjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "removeAction", "mergeActionWithNext", "itemText", "mergeActionWithPrevious", "splitAction", "itemIndex", "textBefore", "textAfter", "(ILjava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "moveAction", "currentIndex", "newIndex", "(IILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ensureActionsSpacePreserve", "element", "Lcom/android/studio/ml/journeys/ActionsDomElement;", "ensureDescriptionSpacePreserve", "Lcom/android/studio/ml/journeys/DescriptionDomElement;", "getRootDom", "Lcom/android/studio/ml/journeys/JourneyDomElement;", "getDescriptionDom", "getActionsDom", "writeAction", "Lcom/intellij/openapi/application/ReadResult;", "T", "Lcom/intellij/openapi/application/ReadAndWriteScope;", "commandName", "action", "Lkotlin/Function0;", "aiplugin.android.journeys"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nXmlTagUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlTagUpdater.kt\ncom/android/studio/ml/journeys/XmlTagUpdater\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,315:1\n360#2,7:316\n*S KotlinDebug\n*F\n+ 1 XmlTagUpdater.kt\ncom/android/studio/ml/journeys/XmlTagUpdater\n*L\n95#1:316,7\n*E\n"})
public final class XmlTagUpdater {
    @NotNull
    private final Project project;
    private final DomManager domManager;
    @Nullable
    private final XmlFile xmlFile;
    public static final int $stable = 8;

    public XmlTagUpdater(@NotNull Project project2, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.project = project2;
        this.domManager = DomManager.getDomManager((Project)this.project);
        PsiFile psiFile2 = PsiManager.getInstance((Project)this.project).findFile(file);
        this.xmlFile = psiFile2 instanceof XmlFile ? (XmlFile)psiFile2 : null;
    }

    @WorkerThread
    @Nullable
    public final Object updateJourneyName(@NotNull String text2, @NotNull Continuation<? super Unit> $completion) {
        return com.intellij.openapi.application.CoroutinesKt.readAndWriteAction(arg_0 -> XmlTagUpdater.updateJourneyName$lambda$2(this, text2, arg_0), $completion);
    }

    @WorkerThread
    @Nullable
    public final Object updateJourneyDescription(@NotNull String text2, @NotNull Continuation<? super Unit> $completion) {
        return com.intellij.openapi.application.CoroutinesKt.readAndWriteAction(arg_0 -> XmlTagUpdater.updateJourneyDescription$lambda$5(this, text2, arg_0), $completion);
    }

    @WorkerThread
    @Nullable
    public final Object addNewActionToFile(@NotNull String text2, @NotNull Continuation<? super Unit> $completion) {
        return com.intellij.openapi.application.CoroutinesKt.readAndWriteAction(arg_0 -> XmlTagUpdater.addNewActionToFile$lambda$8(this, text2, arg_0), $completion);
    }

    @WorkerThread
    @Nullable
    public final Object updateEmptyOrAddNewActionToFile(@NotNull String text2, @NotNull Continuation<? super Unit> $completion) {
        return com.intellij.openapi.application.CoroutinesKt.readAndWriteAction(arg_0 -> XmlTagUpdater.updateEmptyOrAddNewActionToFile$lambda$12(this, text2, arg_0), $completion);
    }

    @WorkerThread
    @Nullable
    public final Object addNewActionToFileAt(int index, @NotNull Continuation<? super Unit> $completion) {
        return com.intellij.openapi.application.CoroutinesKt.readAndWriteAction(arg_0 -> XmlTagUpdater.addNewActionToFileAt$lambda$15(this, index, arg_0), $completion);
    }

    @WorkerThread
    @Nullable
    public final Object updateActionTagValue(int row, @NotNull String text2, @NotNull Continuation<? super Unit> $completion) {
        return com.intellij.openapi.application.CoroutinesKt.readAndWriteAction(arg_0 -> XmlTagUpdater.updateActionTagValue$lambda$18(this, row, text2, arg_0), $completion);
    }

    @WorkerThread
    @Nullable
    public final Object removeAction(int row, @NotNull Continuation<? super Unit> $completion) {
        return com.intellij.openapi.application.CoroutinesKt.readAndWriteAction(arg_0 -> XmlTagUpdater.removeAction$lambda$21(this, row, arg_0), $completion);
    }

    @WorkerThread
    @Nullable
    public final Object mergeActionWithNext(int row, @NotNull String itemText, @NotNull Continuation<? super Unit> $completion) {
        return com.intellij.openapi.application.CoroutinesKt.readAndWriteAction(arg_0 -> XmlTagUpdater.mergeActionWithNext$lambda$24(this, row, itemText, arg_0), $completion);
    }

    @WorkerThread
    @Nullable
    public final Object mergeActionWithPrevious(int row, @NotNull String itemText, @NotNull Continuation<? super Unit> $completion) {
        return com.intellij.openapi.application.CoroutinesKt.readAndWriteAction(arg_0 -> XmlTagUpdater.mergeActionWithPrevious$lambda$27(this, row, itemText, arg_0), $completion);
    }

    @WorkerThread
    @Nullable
    public final Object splitAction(int itemIndex, @NotNull String textBefore, @NotNull String textAfter, @NotNull Continuation<? super Unit> $completion) {
        return com.intellij.openapi.application.CoroutinesKt.readAndWriteAction(arg_0 -> XmlTagUpdater.splitAction$lambda$30(this, itemIndex, textBefore, textAfter, arg_0), $completion);
    }

    @WorkerThread
    @Nullable
    public final Object moveAction(int currentIndex, int newIndex, @NotNull Continuation<? super Unit> $completion) {
        return com.intellij.openapi.application.CoroutinesKt.readAndWriteAction(arg_0 -> XmlTagUpdater.moveAction$lambda$33(this, currentIndex, newIndex, arg_0), $completion);
    }

    @AnyThread
    @RequiresWriteLock
    private final void ensureActionsSpacePreserve(ActionsDomElement element) {
        if (((Boolean)StudioFlags.JOURNEYS_WITH_GEMINI_EDITOR_DISABLE_XML_SPACE_PRESERVE.get()).booleanValue()) {
            return;
        }
        if (!Intrinsics.areEqual((Object)element.getXmlSpace().getValue(), (Object)"preserve")) {
            element.getXmlSpace().setValue("preserve");
        }
    }

    @AnyThread
    @RequiresWriteLock
    private final void ensureDescriptionSpacePreserve(DescriptionDomElement element) {
        if (((Boolean)StudioFlags.JOURNEYS_WITH_GEMINI_EDITOR_DISABLE_XML_SPACE_PRESERVE.get()).booleanValue()) {
            return;
        }
        if (!Intrinsics.areEqual((Object)element.getXmlSpace().getValue(), (Object)"preserve")) {
            element.getXmlSpace().setValue("preserve");
        }
    }

    private final JourneyDomElement getRootDom() {
        JourneyDomElement journeyDomElement;
        XmlFile xmlFile2 = this.xmlFile;
        if (xmlFile2 != null) {
            XmlFile it = xmlFile2;
            boolean bl = false;
            DomFileElement domFileElement = this.domManager.getFileElement(this.xmlFile, JourneyDomElement.class);
            journeyDomElement = domFileElement != null ? (JourneyDomElement)domFileElement.getRootElement() : null;
        } else {
            journeyDomElement = null;
        }
        return journeyDomElement;
    }

    private final DescriptionDomElement getDescriptionDom() {
        JourneyDomElement journeyDomElement = this.getRootDom();
        return journeyDomElement != null ? journeyDomElement.getDescription() : null;
    }

    private final ActionsDomElement getActionsDom() {
        JourneyDomElement journeyDomElement = this.getRootDom();
        return journeyDomElement != null ? journeyDomElement.getActions() : null;
    }

    private final <T> ReadResult<T> writeAction(ReadAndWriteScope $this$writeAction, Project project2, @NlsContexts.Command String commandName, Function0<? extends T> action) {
        XmlFile xmlFile2 = this.xmlFile;
        Document document2 = xmlFile2 != null ? xmlFile2.getFileDocument() : null;
        return document2 != null ? CoroutinesKt.writeCommandAction((ReadAndWriteScope)$this$writeAction, (Project)project2, (String)commandName, () -> XmlTagUpdater.writeAction$lambda$36(document2, action)) : CoroutinesKt.writeCommandAction((ReadAndWriteScope)$this$writeAction, (Project)project2, (String)commandName, () -> XmlTagUpdater.writeAction$lambda$37(action));
    }

    private static final Unit updateJourneyName$lambda$2$lambda$1$lambda$0(XmlTagUpdater this$0, JourneyDomElement $it, String $text) {
        CommandProcessor.getInstance().markCurrentCommandAsGlobal(this$0.project);
        $it.getName().setValue((Object)$text);
        return Unit.INSTANCE;
    }

    private static final ReadResult updateJourneyName$lambda$2(XmlTagUpdater this$0, String $text, ReadAndWriteScope $this$readAndWriteAction) {
        ReadResult readResult;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$readAndWriteAction, (String)"$this$readAndWriteAction");
                readResult = this$0.getRootDom();
                if (readResult == null) break block2;
                ReadResult it = readResult;
                boolean bl = false;
                ReadResult readResult2 = this$0.writeAction($this$readAndWriteAction, this$0.project, "Setting attribute of " + it.getName(), () -> XmlTagUpdater.updateJourneyName$lambda$2$lambda$1$lambda$0(this$0, (JourneyDomElement)it, $text));
                readResult = readResult2;
                if (readResult2 != null) break block3;
            }
            readResult = $this$readAndWriteAction.value(null);
        }
        return readResult;
    }

    private static final Unit updateJourneyDescription$lambda$5$lambda$4$lambda$3(XmlTagUpdater this$0, DescriptionDomElement $it, String $text) {
        CommandProcessor.getInstance().markCurrentCommandAsGlobal(this$0.project);
        this$0.ensureDescriptionSpacePreserve($it);
        $it.setValue($text);
        return Unit.INSTANCE;
    }

    private static final ReadResult updateJourneyDescription$lambda$5(XmlTagUpdater this$0, String $text, ReadAndWriteScope $this$readAndWriteAction) {
        ReadResult readResult;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$readAndWriteAction, (String)"$this$readAndWriteAction");
                readResult = this$0.getDescriptionDom();
                if (readResult == null) break block2;
                ReadResult it = readResult;
                boolean bl = false;
                ReadResult readResult2 = this$0.writeAction($this$readAndWriteAction, this$0.project, "Setting value of " + it.getValue(), () -> XmlTagUpdater.updateJourneyDescription$lambda$5$lambda$4$lambda$3(this$0, (DescriptionDomElement)it, $text));
                readResult = readResult2;
                if (readResult2 != null) break block3;
            }
            readResult = $this$readAndWriteAction.value(null);
        }
        return readResult;
    }

    private static final Unit addNewActionToFile$lambda$8$lambda$7$lambda$6(XmlTagUpdater this$0, ActionsDomElement $it, String $text) {
        this$0.ensureActionsSpacePreserve($it);
        ActionDomElement action = $it.addAction();
        action.setValue($text);
        return Unit.INSTANCE;
    }

    private static final ReadResult addNewActionToFile$lambda$8(XmlTagUpdater this$0, String $text, ReadAndWriteScope $this$readAndWriteAction) {
        ReadResult readResult;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$readAndWriteAction, (String)"$this$readAndWriteAction");
                readResult = this$0.getActionsDom();
                if (readResult == null) break block2;
                ReadResult it = readResult;
                boolean bl = false;
                ReadResult readResult2 = this$0.writeAction($this$readAndWriteAction, this$0.project, "Adding action " + $text, () -> XmlTagUpdater.addNewActionToFile$lambda$8$lambda$7$lambda$6(this$0, (ActionsDomElement)it, $text));
                readResult = readResult2;
                if (readResult2 != null) break block3;
            }
            readResult = $this$readAndWriteAction.value(null);
        }
        return readResult;
    }

    private static final Unit updateEmptyOrAddNewActionToFile$lambda$12$lambda$11$lambda$10(XmlTagUpdater this$0, ActionsDomElement $it, String $text) {
        int firstNonEmptyFromEnd;
        List actionsReversed;
        block4: {
            int n;
            this$0.ensureActionsSpacePreserve($it);
            List $this$indexOfFirst$iv = actionsReversed = CollectionsKt.reversed((Iterable)$it.getItems());
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                ActionDomElement action = (ActionDomElement)item$iv;
                boolean bl = false;
                boolean bl2 = !StringsKt.isBlank((CharSequence)action.getValue());
                if (bl2) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = firstNonEmptyFromEnd = -1;
        }
        if (firstNonEmptyFromEnd == 0 || actionsReversed.isEmpty()) {
            action = $it.addAction();
            action.setValue($text);
        } else {
            action = $it.getItems().get(firstNonEmptyFromEnd < 0 ? 0 : actionsReversed.size() - firstNonEmptyFromEnd);
            this$0.ensureActionsSpacePreserve($it);
            action.setValue($text);
        }
        return Unit.INSTANCE;
    }

    private static final ReadResult updateEmptyOrAddNewActionToFile$lambda$12(XmlTagUpdater this$0, String $text, ReadAndWriteScope $this$readAndWriteAction) {
        ReadResult readResult;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$readAndWriteAction, (String)"$this$readAndWriteAction");
                readResult = this$0.getActionsDom();
                if (readResult == null) break block2;
                ReadResult it = readResult;
                boolean bl = false;
                ReadResult readResult2 = this$0.writeAction($this$readAndWriteAction, this$0.project, "Updating or adding action " + $text, () -> XmlTagUpdater.updateEmptyOrAddNewActionToFile$lambda$12$lambda$11$lambda$10(this$0, (ActionsDomElement)it, $text));
                readResult = readResult2;
                if (readResult2 != null) break block3;
            }
            readResult = $this$readAndWriteAction.value(null);
        }
        return readResult;
    }

    private static final Unit addNewActionToFileAt$lambda$15$lambda$14$lambda$13(XmlTagUpdater this$0, ActionsDomElement $it, int $index) {
        this$0.ensureActionsSpacePreserve($it);
        ActionDomElement action = $it.addAction($index);
        action.setValue("");
        return Unit.INSTANCE;
    }

    private static final ReadResult addNewActionToFileAt$lambda$15(XmlTagUpdater this$0, int $index, ReadAndWriteScope $this$readAndWriteAction) {
        ReadResult readResult;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$readAndWriteAction, (String)"$this$readAndWriteAction");
                readResult = this$0.getActionsDom();
                if (readResult == null) break block2;
                ReadResult it = readResult;
                boolean bl = false;
                ReadResult readResult2 = this$0.writeAction($this$readAndWriteAction, this$0.project, "Adding action at " + $index, () -> XmlTagUpdater.addNewActionToFileAt$lambda$15$lambda$14$lambda$13(this$0, (ActionsDomElement)it, $index));
                readResult = readResult2;
                if (readResult2 != null) break block3;
            }
            readResult = $this$readAndWriteAction.value(null);
        }
        return readResult;
    }

    private static final Unit updateActionTagValue$lambda$18$lambda$17$lambda$16(XmlTagUpdater this$0, ActionsDomElement $it, ActionDomElement $action, String $text) {
        CommandProcessor.getInstance().markCurrentCommandAsGlobal(this$0.project);
        this$0.ensureActionsSpacePreserve($it);
        $action.setValue($text);
        return Unit.INSTANCE;
    }

    private static final ReadResult updateActionTagValue$lambda$18(XmlTagUpdater this$0, int $row, String $text, ReadAndWriteScope $this$readAndWriteAction) {
        ReadResult readResult;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$readAndWriteAction, (String)"$this$readAndWriteAction");
                readResult = this$0.getActionsDom();
                if (readResult == null) break block2;
                ReadResult it = readResult;
                boolean bl = false;
                ActionDomElement action = it.getItems().get($row);
                ReadResult readResult2 = this$0.writeAction($this$readAndWriteAction, this$0.project, "Setting value of " + action.getValue(), () -> XmlTagUpdater.updateActionTagValue$lambda$18$lambda$17$lambda$16(this$0, (ActionsDomElement)it, action, $text));
                readResult = readResult2;
                if (readResult2 != null) break block3;
            }
            readResult = $this$readAndWriteAction.value(null);
        }
        return readResult;
    }

    private static final Unit removeAction$lambda$21$lambda$20$lambda$19(XmlTagUpdater this$0, ActionDomElement $actionElement) {
        CommandProcessor.getInstance().markCurrentCommandAsGlobal(this$0.project);
        $actionElement.undefine();
        return Unit.INSTANCE;
    }

    private static final ReadResult removeAction$lambda$21(XmlTagUpdater this$0, int $row, ReadAndWriteScope $this$readAndWriteAction) {
        ReadResult readResult;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$readAndWriteAction, (String)"$this$readAndWriteAction");
                readResult = this$0.getActionsDom();
                if (readResult == null) break block2;
                ReadResult it = readResult;
                boolean bl = false;
                ActionDomElement actionElement = it.getItems().get($row);
                ReadResult readResult2 = this$0.writeAction($this$readAndWriteAction, this$0.project, "Deleting action " + actionElement.getValue(), () -> XmlTagUpdater.removeAction$lambda$21$lambda$20$lambda$19(this$0, actionElement));
                readResult = readResult2;
                if (readResult2 != null) break block3;
            }
            readResult = $this$readAndWriteAction.value(null);
        }
        return readResult;
    }

    private static final Unit mergeActionWithNext$lambda$24$lambda$23$lambda$22(XmlTagUpdater this$0, ActionsDomElement $it, ActionDomElement $actionElement, String $itemText, ActionDomElement $otherActionElement) {
        CommandProcessor.getInstance().markCurrentCommandAsGlobal(this$0.project);
        this$0.ensureActionsSpacePreserve($it);
        $actionElement.setValue($itemText + $otherActionElement.getValue());
        $otherActionElement.undefine();
        return Unit.INSTANCE;
    }

    private static final ReadResult mergeActionWithNext$lambda$24(XmlTagUpdater this$0, int $row, String $itemText, ReadAndWriteScope $this$readAndWriteAction) {
        ReadResult readResult;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$readAndWriteAction, (String)"$this$readAndWriteAction");
                readResult = this$0.getActionsDom();
                if (readResult == null) break block2;
                ReadResult it = readResult;
                boolean bl = false;
                int nextRow = $row + 1;
                ActionDomElement actionElement = it.getItems().get($row);
                ActionDomElement otherActionElement = it.getItems().get(nextRow);
                ReadResult readResult2 = this$0.writeAction($this$readAndWriteAction, this$0.project, "Merging action " + actionElement.getValue() + " with action " + otherActionElement.getValue(), () -> XmlTagUpdater.mergeActionWithNext$lambda$24$lambda$23$lambda$22(this$0, (ActionsDomElement)it, actionElement, $itemText, otherActionElement));
                readResult = readResult2;
                if (readResult2 != null) break block3;
            }
            readResult = $this$readAndWriteAction.value(null);
        }
        return readResult;
    }

    private static final Unit mergeActionWithPrevious$lambda$27$lambda$26$lambda$25(XmlTagUpdater this$0, ActionsDomElement $it, ActionDomElement $previousActionElement, String $itemText, ActionDomElement $actionElement) {
        CommandProcessor.getInstance().markCurrentCommandAsGlobal(this$0.project);
        this$0.ensureActionsSpacePreserve($it);
        $previousActionElement.setValue($previousActionElement.getValue() + $itemText);
        $actionElement.undefine();
        return Unit.INSTANCE;
    }

    private static final ReadResult mergeActionWithPrevious$lambda$27(XmlTagUpdater this$0, int $row, String $itemText, ReadAndWriteScope $this$readAndWriteAction) {
        ReadResult readResult;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$readAndWriteAction, (String)"$this$readAndWriteAction");
                readResult = this$0.getActionsDom();
                if (readResult == null) break block2;
                ReadResult it = readResult;
                boolean bl = false;
                int previousRow = $row - 1;
                ActionDomElement actionElement = it.getItems().get($row);
                ActionDomElement previousActionElement = it.getItems().get(previousRow);
                ReadResult readResult2 = this$0.writeAction($this$readAndWriteAction, this$0.project, "Merging action action " + previousActionElement.getValue() + " with action " + actionElement.getValue(), () -> XmlTagUpdater.mergeActionWithPrevious$lambda$27$lambda$26$lambda$25(this$0, (ActionsDomElement)it, previousActionElement, $itemText, actionElement));
                readResult = readResult2;
                if (readResult2 != null) break block3;
            }
            readResult = $this$readAndWriteAction.value(null);
        }
        return readResult;
    }

    private static final Unit splitAction$lambda$30$lambda$29$lambda$28(XmlTagUpdater this$0, ActionsDomElement $it, ActionDomElement $actionElement, String $textBefore, int $itemIndex, String $textAfter) {
        CommandProcessor.getInstance().markCurrentCommandAsGlobal(this$0.project);
        this$0.ensureActionsSpacePreserve($it);
        $actionElement.setValue($textBefore);
        ActionDomElement newAction = $it.addAction($itemIndex + 1);
        newAction.setValue($textAfter);
        return Unit.INSTANCE;
    }

    private static final ReadResult splitAction$lambda$30(XmlTagUpdater this$0, int $itemIndex, String $textBefore, String $textAfter, ReadAndWriteScope $this$readAndWriteAction) {
        ReadResult readResult;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$readAndWriteAction, (String)"$this$readAndWriteAction");
                readResult = this$0.getActionsDom();
                if (readResult == null) break block2;
                ReadResult it = readResult;
                boolean bl = false;
                ActionDomElement actionElement = it.getItems().get($itemIndex);
                ReadResult readResult2 = this$0.writeAction($this$readAndWriteAction, this$0.project, "Splitting action " + actionElement.getValue(), () -> XmlTagUpdater.splitAction$lambda$30$lambda$29$lambda$28(this$0, (ActionsDomElement)it, actionElement, $textBefore, $itemIndex, $textAfter));
                readResult = readResult2;
                if (readResult2 != null) break block3;
            }
            readResult = $this$readAndWriteAction.value(null);
        }
        return readResult;
    }

    private static final Unit moveAction$lambda$33$lambda$32$lambda$31(XmlTagUpdater this$0, ActionsDomElement $it, int $currentIndex, int $newIndex) {
        CommandProcessor.getInstance().markCurrentCommandAsGlobal(this$0.project);
        this$0.ensureActionsSpacePreserve($it);
        String currentActionText = $it.getItems().get($currentIndex).getValue();
        $it.getItems().get($currentIndex).undefine();
        ActionDomElement newAction = $it.addAction($newIndex);
        newAction.setValue(currentActionText);
        return Unit.INSTANCE;
    }

    private static final ReadResult moveAction$lambda$33(XmlTagUpdater this$0, int $currentIndex, int $newIndex, ReadAndWriteScope $this$readAndWriteAction) {
        ReadResult readResult;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$readAndWriteAction, (String)"$this$readAndWriteAction");
                readResult = this$0.getActionsDom();
                if (readResult == null) break block2;
                ReadResult it = readResult;
                boolean bl = false;
                ReadResult readResult2 = this$0.writeAction($this$readAndWriteAction, this$0.project, "Moving Action", () -> XmlTagUpdater.moveAction$lambda$33$lambda$32$lambda$31(this$0, (ActionsDomElement)it, $currentIndex, $newIndex));
                readResult = readResult2;
                if (readResult2 != null) break block3;
            }
            readResult = $this$readAndWriteAction.value(null);
        }
        return readResult;
    }

    private static final Object writeAction$lambda$36$lambda$35(Function0 $action) {
        return $action.invoke();
    }

    private static final Object writeAction$lambda$36(Document $document, Function0 $action) {
        return JourneyDocumentUtilsKt.withJourneyModification($document, () -> XmlTagUpdater.writeAction$lambda$36$lambda$35($action));
    }

    private static final Object writeAction$lambda$37(Function0 $action) {
        return $action.invoke();
    }
}

