/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.suggestion.controls;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.suggestion.controls.BalloonBasedControl;
import com.android.studio.ml.suggestion.controls.ControlUtilKt;
import com.android.studio.ml.suggestion.controls.EditorSuggestionControl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\fH\u0014J\u0014\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0012H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/studio/ml/suggestion/controls/DeletionWithinSingleLineControl;", "Lcom/android/studio/ml/suggestion/controls/BalloonBasedControl;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "rangeMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/editor/RangeMarker;)V", "calculateBalloonPosition", "Lcom/intellij/ui/awt/RelativePoint;", "content", "Ljavax/swing/JComponent;", "createBalloonContent", "getRangeStartAndEndPoints", "Lkotlin/Pair;", "Ljava/awt/Point;", "configure", "Lcom/intellij/openapi/ui/popup/BalloonBuilder;", "Companion", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
public final class DeletionWithinSingleLineControl
extends BalloonBasedControl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RangeMarker rangeMarker;
    public static final int $stable = 8;
    @NotNull
    private static final TextAttributesKey deletedTextBackgroundKey;
    @NotNull
    private static final TextAttributesKey popupBorderKey;

    private DeletionWithinSingleLineControl(Project project2, Editor editor2, RangeMarker rangeMarker) {
        super(project2, editor2, CollectionsKt.listOf((Object)rangeMarker), null);
        this.rangeMarker = rangeMarker;
    }

    private final Pair<Point, Point> getRangeStartAndEndPoints() {
        TextRange textRange = this.rangeMarker.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        TextRange deletedRange = textRange;
        Point point = this.getEditor().offsetToXY(deletedRange.getStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"offsetToXY(...)");
        Point startPoint = point;
        Point point2 = this.getEditor().offsetToXY(deletedRange.getEndOffset());
        Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"offsetToXY(...)");
        Point endPoint = point2;
        return TuplesKt.to((Object)startPoint, (Object)endPoint);
    }

    @Override
    @NotNull
    protected BalloonBuilder configure(@NotNull BalloonBuilder $this$configure) {
        Intrinsics.checkNotNullParameter((Object)$this$configure, (String)"<this>");
        $this$configure.setFillColor(ControlUtilKt.getTRANSPARENT());
        $this$configure.setShowCallout(false);
        $this$configure.setBorderInsets((Insets)JBUI.insets((int)1));
        $this$configure.setBorderColor(popupBorderKey.getDefaultAttributes().getForegroundColor());
        $this$configure.setShadow(false);
        return $this$configure;
    }

    @Override
    @NotNull
    protected JComponent createBalloonContent() {
        JPanel jPanel;
        Pair<Point, Point> pair = this.getRangeStartAndEndPoints();
        Point startPoint = (Point)pair.component1();
        Point endPoint = (Point)pair.component2();
        int width = endPoint.x - startPoint.x;
        JPanel $this$createBalloonContent_u24lambda_u240 = jPanel = new JPanel();
        boolean bl = false;
        $this$createBalloonContent_u24lambda_u240.setPreferredSize(new Dimension(width, this.getEditor().getLineHeight()));
        $this$createBalloonContent_u24lambda_u240.setBackground(deletedTextBackgroundKey.getDefaultAttributes().getBackgroundColor());
        $this$createBalloonContent_u24lambda_u240.setCursor(new Cursor(2));
        JPanel content2 = jPanel;
        return content2;
    }

    @Override
    @NotNull
    protected RelativePoint calculateBalloonPosition(@NotNull JComponent content2) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Pair<Point, Point> pair = this.getRangeStartAndEndPoints();
        Point startPoint = (Point)pair.component1();
        Point endPoint = (Point)pair.component2();
        if (!(startPoint.y == endPoint.y)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Point displayPoint = new Point((startPoint.x + endPoint.x) / 2, startPoint.y + this.getEditor().getLineHeight() / 2);
        return new RelativePoint((Component)this.getEditor().getContentComponent(), displayPoint);
    }

    public /* synthetic */ DeletionWithinSingleLineControl(Project project2, Editor editor2, RangeMarker rangeMarker, DefaultConstructorMarker $constructor_marker) {
        this(project2, editor2, rangeMarker);
    }

    static {
        TextAttributesKey textAttributesKey = TextAttributesKey.createTextAttributesKey((String)"EDITOR_SUGGESTION_DELETED_OVERLAY_COLOR");
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"createTextAttributesKey(...)");
        deletedTextBackgroundKey = textAttributesKey;
        TextAttributesKey textAttributesKey2 = TextAttributesKey.createTextAttributesKey((String)"EDITOR_SUGGESTION_POPUP_BORDER");
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey2, (String)"createTextAttributesKey(...)");
        popupBorderKey = textAttributesKey2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/studio/ml/suggestion/controls/DeletionWithinSingleLineControl$Companion;", "", "()V", "deletedTextBackgroundKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "Lorg/jetbrains/annotations/NotNull;", "popupBorderKey", "create", "Lcom/android/studio/ml/suggestion/controls/EditorSuggestionControl;", "rangeMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "create$aiplugin_core_aicore", "aiplugin.core.aicore"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EditorSuggestionControl create$aiplugin_core_aicore(@NotNull RangeMarker rangeMarker, @NotNull Project project2, @NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)rangeMarker, (String)"rangeMarker");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            return new DeletionWithinSingleLineControl(project2, editor2, rangeMarker, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

