/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.templates.modelproviders.data;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.templates.modelproviders.contract.ModelProviderSettingsConfiguration;
import com.android.studio.ml.templates.modelproviders.data.ProviderDetails;
import com.android.studio.ml.templates.modelproviders.data.ValidationDetails;
import com.android.studio.ml.templates.modelproviders.data.ValidationError;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0014\u0010\b\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a8\u0006\t"}, d2={"Lcom/android/studio/ml/templates/modelproviders/data/DataValidator;", "", "()V", "doGenericValidations", "Lcom/android/studio/ml/templates/modelproviders/data/ValidationDetails;", "providers", "", "Lcom/android/studio/ml/templates/modelproviders/data/ProviderDetails;", "execute", "aiplugin.core.aicore"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nDataValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataValidator.kt\ncom/android/studio/ml/templates/modelproviders/data/DataValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ValidationDetails.kt\ncom/android/studio/ml/templates/modelproviders/data/ValidationDetails$Companion\n*L\n1#1,57:1\n1878#2,3:58\n36#3:61\n*S KotlinDebug\n*F\n+ 1 DataValidator.kt\ncom/android/studio/ml/templates/modelproviders/data/DataValidator\n*L\n45#1:58,3\n54#1:61\n*E\n"})
public final class DataValidator {
    @NotNull
    public static final DataValidator INSTANCE = new DataValidator();
    public static final int $stable;

    private DataValidator() {
    }

    @NotNull
    public final ValidationDetails execute(@NotNull List<ProviderDetails> providers) {
        ValidationDetails validationDetails;
        block1: {
            ModelProviderSettingsConfiguration configuration;
            Intrinsics.checkNotNullParameter(providers, (String)"providers");
            validationDetails = this.doGenericValidations(providers);
            if (!Intrinsics.areEqual((Object)validationDetails.getValidationError(), (Object)ValidationError.NoError.INSTANCE)) break block1;
            Iterator<ModelProviderSettingsConfiguration> iterator = ModelProviderSettingsConfiguration.Companion.modelProviderSettingsConfigurations().iterator();
            while (iterator.hasNext() && Intrinsics.areEqual((Object)(validationDetails = (configuration = iterator.next()).doDataValidations(providers)).getValidationError(), (Object)ValidationError.NoError.INSTANCE)) {
            }
        }
        return validationDetails;
    }

    /*
     * WARNING - void declaration
     */
    private final ValidationDetails doGenericValidations(List<ProviderDetails> providers) {
        Set providerNameSet = new LinkedHashSet();
        Iterable $this$forEachIndexed$iv = providers;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void provider;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ProviderDetails providerDetails = (ProviderDetails)item$iv;
            int index = n;
            boolean bl = false;
            String providerName = ((Object)StringsKt.trim((CharSequence)provider.getDescription())).toString();
            if (providerNameSet.contains(providerName)) {
                return new ValidationDetails(ValidationError.DuplicateProviderName.INSTANCE, index);
            }
            providerNameSet.add(providerName);
            if (!StringsKt.isBlank((CharSequence)providerName)) continue;
            return new ValidationDetails(ValidationError.EmptyProviderName.INSTANCE, index);
        }
        ValidationDetails.Companion this_$iv = ValidationDetails.Companion;
        boolean $i$f$noError = false;
        return this_$iv.getNO_ERROR_INSTANCE();
    }
}

