/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.templates.settings;

import com.android.studio.ml.ModelProvider;
import com.android.studio.ml.SmlBundle;
import com.android.studio.ml.TransformService;
import com.android.studio.ml.templates.BuiltInPromptsProvider;
import com.android.studio.ml.templates.PromptTemplateImpl;
import com.android.studio.ml.templates.PromptTemplateMacros;
import com.android.studio.ml.templates.settings.PromptTemplateHighlighter;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.List;
import java.util.Objects;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.DefaultCaret;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PromptTemplateEditor
implements Disposable {
    private static final String DEFAULT_PROMPTS_TEXT_PLACEHOLDER = "Explain this code: $SELECTION";
    private static final String DEFAULT_RULES_TEXT_PLACEHOLDER = "Kotlin is the preferred language.";
    private final Project myProject;
    private JPanel myMainPanel;
    private Editor myTemplateEditor;
    private JTextField myNameField;
    private JCheckBox myEnabledForChatCheckBox;
    private JCheckBox myEnabledInSlashCommandsCheckBox;
    private JPanel textEditorPanel;
    private JEditorPane descriptionComponent;
    private PromptTemplateImpl promptTemplate;
    private final List<ChangeListener> myChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final FileType myVelocityFileType = FileTypeManager.getInstance().getFileTypeByExtension("ft");

    public PromptTemplateEditor(Project project2) {
        this.myProject = project2;
    }

    public PromptTemplateImpl getTemplate() {
        return this.promptTemplate;
    }

    public void setTemplate(@Nullable PromptTemplateImpl template) {
        this.promptTemplate = template;
        if (this.myMainPanel != null) {
            this.reset();
            if (this.myNameField.isEnabled()) {
                this.myNameField.selectAll();
            }
        }
    }

    public JComponent createComponent() {
        this.myMainPanel = new JPanel(new GridLayout(0, 1));
        this.myNameField = new JTextField();
        this.myNameField.setEnabled(false);
        this.myEnabledForChatCheckBox = new JCheckBox(SmlBundle.message("sml.studiobot.settings.prompt.templates.enabled", new Object[0]));
        this.myEnabledForChatCheckBox.setEnabled(false);
        this.myEnabledInSlashCommandsCheckBox = new JCheckBox(SmlBundle.message("sml.studiobot.settings.prompt.templates.enabled.in.slash.commands", new Object[0]));
        this.myEnabledInSlashCommandsCheckBox.setEnabled(false);
        this.myTemplateEditor = this.createEditor(null, true, DEFAULT_PROMPTS_TEXT_PLACEHOLDER);
        JPanel namePanel = new JPanel(new GridBagLayout());
        namePanel.setBorder((Border)JBUI.Borders.emptyBottom((int)3));
        JLabel label = new JLabel(IdeBundle.message((String)"label.name", (Object[])new Object[0]));
        label.setLabelFor(this.myNameField);
        namePanel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBInsets.emptyInsets(), 0, 0));
        namePanel.add((Component)this.myNameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, (Insets)JBUI.insets((int)0, (int)3), 0, 0));
        this.textEditorPanel = new JPanel(new GridLayout(0, 1));
        this.textEditorPanel.add(this.myTemplateEditor.getComponent());
        JPanel southPanel = new JPanel(new BorderLayout(0, 5));
        southPanel.add((Component)this.myEnabledForChatCheckBox, "North");
        southPanel.add((Component)this.myEnabledInSlashCommandsCheckBox, "South");
        this.myEnabledInSlashCommandsCheckBox.setVisible(this.showEnabledInSlashCommandsCheckBox());
        JPanel editorPanel = new JPanel(new BorderLayout(0, 5));
        editorPanel.add((Component)namePanel, "North");
        editorPanel.add((Component)this.textEditorPanel, "Center");
        editorPanel.add((Component)southPanel, "South");
        this.descriptionComponent = new JEditorPane();
        this.descriptionComponent.setEditorKit(HTMLEditorKitBuilder.simple());
        this.descriptionComponent.setText(PromptTemplateMacros.INSTANCE.getDescriptionHtml());
        this.descriptionComponent.setEditable(false);
        this.descriptionComponent.setCaret(new DefaultCaret(){

            @Override
            public boolean isVisible() {
                return false;
            }
        });
        this.descriptionComponent.setBackground(JBColor.PanelBackground);
        this.descriptionComponent.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        Splitter mySplitter = new Splitter(true, 0.7f);
        mySplitter.setFirstComponent((JComponent)editorPanel);
        mySplitter.setSecondComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.descriptionComponent, (boolean)true));
        this.myMainPanel.add((Component)mySplitter);
        this.myNameField.getDocument().addDocumentListener((javax.swing.event.DocumentListener)new DocumentAdapter(){

            protected void textChanged(javax.swing.event.DocumentEvent e) {
                if (PromptTemplateEditor.this.promptTemplate != null) {
                    PromptTemplateEditor.this.promptTemplate.setName(PromptTemplateEditor.this.myNameField.getText());
                    PromptTemplateEditor.this.onNameChanged();
                }
            }
        });
        this.myEnabledForChatCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (PromptTemplateEditor.this.promptTemplate != null) {
                    PromptTemplateEditor.this.promptTemplate.setEnabled(PromptTemplateEditor.this.myEnabledForChatCheckBox.isSelected());
                }
            }
        });
        this.myEnabledInSlashCommandsCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (PromptTemplateEditor.this.promptTemplate != null) {
                    PromptTemplateEditor.this.promptTemplate.setShowInSlashCommands(PromptTemplateEditor.this.myEnabledInSlashCommandsCheckBox.isSelected());
                }
            }
        });
        this.myMainPanel.setPreferredSize((Dimension)JBUI.size((int)400, (int)300));
        this.myMainPanel.revalidate();
        this.myMainPanel.repaint();
        return this.myMainPanel;
    }

    private boolean showEnabledInSlashCommandsCheckBox() {
        TransformService transformService = ModelProvider.Companion.activeModelProvider().getTransformService();
        return transformService.supportsFeature(TransformService.Feature.CUSTOM_SLASH_COMMAND);
    }

    private Editor createEditor(@Nullable PsiFile file, Boolean isViewer, String placeholder) {
        BuiltInPromptsProvider provider;
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document doc = this.createDocument(file);
        final Editor editor2 = isViewer != false ? editorFactory.createViewer(doc, this.myProject) : editorFactory.createEditor(doc, this.myProject);
        EditorSettings editorSettings = editor2.getSettings();
        editorSettings.setVirtualSpace(false);
        editorSettings.setLineMarkerAreaShown(false);
        editorSettings.setIndentGuidesShown(false);
        editorSettings.setLineNumbersShown(false);
        editorSettings.setAdditionalColumnsCount(3);
        editorSettings.setAdditionalLinesCount(3);
        editorSettings.setCaretRowShown(false);
        editorSettings.setUseSoftWraps(true);
        editorSettings.setPaintSoftWraps(true);
        editorSettings.setFoldingOutlineShown(true);
        ((EditorGutterComponentEx)editor2.getGutter()).setPaintBackground(false);
        ((EditorEx)editor2).setHighlighter(this.createHighlighter());
        ((EditorEx)editor2).getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (PromptTemplateEditor.this.promptTemplate != null) {
                    PromptTemplateEditor.this.promptTemplate.setText(editor2.getDocument().getText());
                }
            }
        });
        if (this.promptTemplate != null && (provider = this.promptTemplate.getGroup()) != null && "rules".equals(provider.getGroupId())) {
            placeholder = DEFAULT_RULES_TEXT_PLACEHOLDER;
        }
        ((EditorEx)editor2).setPlaceholder((CharSequence)placeholder);
        return editor2;
    }

    @NotNull
    private Document createDocument(@Nullable PsiFile file) {
        Document document2;
        Document document3 = document2 = file != null ? PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file) : null;
        return document2 != null ? document2 : EditorFactory.getInstance().createDocument((CharSequence)(this.promptTemplate == null ? "" : this.promptTemplate.getText()));
    }

    private void onNameChanged() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener changeListener : this.myChangeListeners) {
            changeListener.stateChanged(event);
        }
    }

    void addChangeListener(@NotNull ChangeListener listener2) {
        if (!this.myChangeListeners.contains(listener2)) {
            this.myChangeListeners.add(listener2);
        }
    }

    void removeChangeListener(ChangeListener listener2) {
        this.myChangeListeners.remove(listener2);
    }

    public void reset() {
        EditorFactory.getInstance().releaseEditor(this.myTemplateEditor);
        if (this.promptTemplate == null) {
            this.myTemplateEditor = this.createEditor(null, true, DEFAULT_PROMPTS_TEXT_PLACEHOLDER);
            this.myNameField.setText("");
            this.myNameField.setEnabled(false);
            this.myEnabledForChatCheckBox.setSelected(false);
            this.myEnabledForChatCheckBox.setEnabled(false);
            this.myEnabledInSlashCommandsCheckBox.setSelected(false);
            this.myEnabledInSlashCommandsCheckBox.setEnabled(false);
        } else if (this.promptTemplate.getGroup() == null) {
            this.myTemplateEditor = this.createEditor(this.createFile(this.promptTemplate.getText(), this.promptTemplate.getName()), false, DEFAULT_PROMPTS_TEXT_PLACEHOLDER);
            this.myNameField.setText(this.promptTemplate.getName());
            this.myNameField.setEnabled(true);
            this.myEnabledForChatCheckBox.setSelected(this.promptTemplate.getEnabled());
            this.myEnabledForChatCheckBox.setVisible(true);
            this.myEnabledForChatCheckBox.setEnabled(true);
            this.myEnabledInSlashCommandsCheckBox.setSelected(this.promptTemplate.getShowInSlashCommands());
            this.myEnabledInSlashCommandsCheckBox.setVisible(this.showEnabledInSlashCommandsCheckBox());
            this.myEnabledInSlashCommandsCheckBox.setEnabled(true);
            this.descriptionComponent.setText(PromptTemplateMacros.INSTANCE.getDescriptionHtml());
        } else {
            BuiltInPromptsProvider group2 = Objects.requireNonNull(this.promptTemplate.getGroup());
            BuiltInPromptsProvider.PromptDefinition definition = Objects.requireNonNull(this.promptTemplate.getPromptDefinition());
            this.myTemplateEditor = this.createEditor(this.createFile(this.promptTemplate.getText(), group2.getGroupId() + "." + definition.getId()), false, definition.getDefaultText());
            this.myNameField.setText(this.promptTemplate.getName());
            this.myNameField.setEnabled(false);
            this.myEnabledForChatCheckBox.setVisible(definition.getEnabledForChat());
            this.myEnabledForChatCheckBox.setSelected(definition.getEnabledForChat());
            this.myEnabledForChatCheckBox.setEnabled(false);
            this.myEnabledInSlashCommandsCheckBox.setVisible(definition.getEnabledForSlashCommands());
            this.myEnabledInSlashCommandsCheckBox.setSelected(definition.getEnabledForSlashCommands());
            this.myEnabledInSlashCommandsCheckBox.setEnabled(false);
            this.descriptionComponent.setText(group2.descriptionForEditor());
        }
        this.myTemplateEditor.getContentComponent().setFocusable(true);
        this.myTemplateEditor.getContentComponent().setFocusCycleRoot(false);
        this.textEditorPanel.removeAll();
        this.textEditorPanel.add(this.myTemplateEditor.getComponent());
    }

    @Nullable
    private PsiFile createFile(String text2, String name) {
        FileType fileType = this.myVelocityFileType;
        if (fileType == FileTypes.UNKNOWN) {
            return null;
        }
        return PsiFileFactory.getInstance((Project)this.myProject).createFileFromText(name + ".txt.ft", fileType, (CharSequence)text2, 0L, true);
    }

    public void dispose() {
        this.myMainPanel = null;
        if (this.myTemplateEditor != null && !this.myTemplateEditor.isDisposed()) {
            EditorFactory.getInstance().releaseEditor(this.myTemplateEditor);
            this.myTemplateEditor = null;
        }
    }

    private EditorHighlighter createHighlighter() {
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        return new LexerEditorHighlighter((SyntaxHighlighter)PromptTemplateHighlighter.createNew(this.promptTemplate), scheme);
    }

    void focusToNameField() {
        this.myNameField.selectAll();
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myNameField, true));
    }

    void focusToTextField() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myTemplateEditor.getContentComponent(), true));
    }
}

