/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.util;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.studiobot.AcceptedCitations;
import com.android.tools.idea.studiobot.Citation;
import com.intellij.openapi.util.TextRange;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\"\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u000f"}, d2={"Lcom/android/studio/ml/util/CitationUtils;", "", "()V", "getAcceptedCitationsForRange", "Lcom/android/tools/idea/studiobot/AcceptedCitations;", "text", "", "citations", "", "Lcom/android/tools/idea/studiobot/Citation;", "range", "Lcom/intellij/openapi/util/TextRange;", "getCitationForRange", "citation", "getCitationsForRange", "aiplugin.core.aicore"})
@StabilityInferred(parameters=1)
public final class CitationUtils {
    @NotNull
    public static final CitationUtils INSTANCE = new CitationUtils();
    public static final int $stable;

    private CitationUtils() {
    }

    @NotNull
    public final List<Citation> getCitationsForRange(@NotNull List<? extends Citation> citations2, @NotNull TextRange range) {
        List list;
        Intrinsics.checkNotNullParameter(citations2, (String)"citations");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        List $this$getCitationsForRange_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (Citation citation : citations2) {
            Citation newCitation = INSTANCE.getCitationForRange(citation, range);
            if (newCitation == null) continue;
            $this$getCitationsForRange_u24lambda_u240.add(newCitation);
        }
        return CollectionsKt.build((List)list);
    }

    @Nullable
    public final Citation getCitationForRange(@NotNull Citation citation, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)citation, (String)"citation");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        if (Intrinsics.areEqual((Object)citation.getRange(), (Object)TextRange.EMPTY_RANGE)) {
            return citation;
        }
        if (citation.getRange().intersects(range)) {
            return citation.withRange(Math.max(0, citation.getRange().getStartOffset() - range.getStartOffset()), Math.min(range.getLength(), citation.getRange().getEndOffset() - range.getStartOffset()));
        }
        return null;
    }

    @Nullable
    public final AcceptedCitations getAcceptedCitationsForRange(@NotNull String text2, @NotNull List<? extends Citation> citations2, @NotNull TextRange range) {
        AcceptedCitations acceptedCitations;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(citations2, (String)"citations");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        List<Citation> citationsWithinRange = this.getCitationsForRange(citations2, range);
        if (citationsWithinRange.isEmpty()) {
            acceptedCitations = null;
        } else {
            String string = text2.substring(range.getStartOffset(), range.getEndOffset());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String textWithinRange = string;
            acceptedCitations = new AcceptedCitations(textWithinRange, citationsWithinRange);
        }
        return acceptedCitations;
    }
}

