/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.agents.permissions;

import com.google.aiplugin.agents.BasicToolIcon;
import com.google.aiplugin.agents.ToolIcon;
import com.google.aiplugin.agents.permissions.FilePermissionKt;
import com.google.aiplugin.agents.permissions.FilePermissionRequest;
import com.google.aiplugin.agents.permissions.FilePermissionState;
import com.google.aiplugin.agents.permissions.Permission;
import com.google.aiplugin.agents.permissions.PermissionDecision;
import com.google.aiplugin.agents.permissions.PermissionRequest;
import com.google.aiplugin.agents.permissions.PermissionState;
import com.google.aiplugin.agents.tools.ToolContext;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 %2\u00020\u0001:\u0005%&'()B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\"\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0016\u0010\u0016\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cJ\u001e\u0010\u0016\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010!\u001a\u00020\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006*"}, d2={"Lcom/google/aiplugin/agents/permissions/FilePermission;", "Lcom/google/aiplugin/agents/permissions/Permission;", "fileOperations", "Lcom/google/aiplugin/agents/permissions/FilePermission$FileOperations;", "fileTypes", "Lcom/google/aiplugin/agents/permissions/FilePermission$FileTypes;", "id", "", "displayName", "hint", "icon", "Lcom/google/aiplugin/agents/ToolIcon;", "<init>", "(Lcom/google/aiplugin/agents/permissions/FilePermission$FileOperations;Lcom/google/aiplugin/agents/permissions/FilePermission$FileTypes;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/google/aiplugin/agents/ToolIcon;)V", "getFileOperations", "()Lcom/google/aiplugin/agents/permissions/FilePermission$FileOperations;", "getFileTypes", "()Lcom/google/aiplugin/agents/permissions/FilePermission$FileTypes;", "match", "Lcom/google/aiplugin/agents/permissions/PermissionDecision;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "request", "Lcom/google/aiplugin/agents/permissions/PermissionRequest;", "state", "Lcom/google/aiplugin/agents/permissions/PermissionState;", "Lcom/google/aiplugin/agents/permissions/FilePermissionRequest;", "file", "Ljava/io/File;", "requestRead", "requestWrite", "fileOperation", "Lcom/google/aiplugin/agents/permissions/FilePermission$FileOperation;", "defaultState", "Lcom/google/aiplugin/agents/permissions/FilePermissionState;", "getDefaultState", "()Lcom/google/aiplugin/agents/permissions/FilePermissionState;", "Companion", "FileOperation", "FileOperations", "FileTypes", "FileType", "aiplugin.agents.agents-core"})
public final class FilePermission
extends Permission {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileOperations fileOperations;
    @NotNull
    private final FileTypes fileTypes;
    @NotNull
    private final FilePermissionState defaultState;

    public FilePermission(@NotNull FileOperations fileOperations, @NotNull FileTypes fileTypes, @NotNull String id, @NotNull String displayName2, @NotNull String hint, @NotNull ToolIcon icon2) {
        Intrinsics.checkNotNullParameter((Object)fileOperations, (String)"fileOperations");
        Intrinsics.checkNotNullParameter((Object)fileTypes, (String)"fileTypes");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)displayName2, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)hint, (String)"hint");
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
        super(id, displayName2, hint, icon2);
        this.fileOperations = fileOperations;
        this.fileTypes = fileTypes;
        this.defaultState = new FilePermissionState(null, null, 3, null);
    }

    public /* synthetic */ FilePermission(FileOperations fileOperations, FileTypes fileTypes, String string, String string2, String string3, ToolIcon toolIcon, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            toolIcon = fileOperations.icon();
        }
        this(fileOperations, fileTypes, string, string2, string3, toolIcon);
    }

    @NotNull
    public final FileOperations getFileOperations() {
        return this.fileOperations;
    }

    @NotNull
    public final FileTypes getFileTypes() {
        return this.fileTypes;
    }

    @Override
    @Nullable
    public PermissionDecision match(@NotNull ToolContext context2, @NotNull PermissionRequest request2, @NotNull PermissionState state2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        if (!(request2 instanceof FilePermissionRequest) || !(state2 instanceof FilePermissionState)) {
            return null;
        }
        if (!this.fileOperations.contains(((FilePermissionRequest)request2).getOperation())) {
            return null;
        }
        File file = ((FilePermissionRequest)request2).getFile();
        if (!this.fileTypes.contains(((FilePermissionRequest)request2).getType())) {
            return null;
        }
        if (((FilePermissionState)state2).getExcluded().size() == 1 && Intrinsics.areEqual((Object)((FilePermissionState)state2).getExcluded().get(0).getPath(), (Object)"*")) {
            return PermissionDecision.DENIED;
        }
        if (((FilePermissionState)state2).getIncluded().size() == 1 && Intrinsics.areEqual((Object)((FilePermissionState)state2).getIncluded().get(0).getPath(), (Object)"*")) {
            return PermissionDecision.APPROVED;
        }
        for (File root : ((FilePermissionState)state2).getExcluded()) {
            if (!FileUtil.isAncestor((File)root, (File)file, (boolean)false)) continue;
            return PermissionDecision.DENIED;
        }
        for (File root : ((FilePermissionState)state2).getIncluded()) {
            if (!FileUtil.isAncestor((File)root, (File)file, (boolean)false)) continue;
            return PermissionDecision.APPROVED;
        }
        return null;
    }

    @NotNull
    public final FilePermissionRequest request(@NotNull ToolContext context2, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.fileOperations.getOperations().size() != 1) {
            throw new IllegalStateException(("This method can only be used on single-file operation permissions; was " + this.fileOperations.getOperations()).toString());
        }
        Object object = CollectionsKt.first((Iterable)this.fileOperations.getOperations());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
        return this.request(context2, file, (FileOperation)((Object)object));
    }

    @NotNull
    public final FilePermissionRequest requestRead(@NotNull ToolContext context2, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.request(context2, file, FileOperation.READ);
    }

    @NotNull
    public final FilePermissionRequest requestWrite(@NotNull ToolContext context2, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.request(context2, file, FileOperation.WRITE);
    }

    @NotNull
    public final FilePermissionRequest request(@NotNull ToolContext context2, @NotNull File file, @NotNull FileOperation fileOperation) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)fileOperation), (String)"fileOperation");
        return FilePermissionRequest.Companion.request(context2, file, fileOperation);
    }

    @Override
    @NotNull
    public FilePermissionState getDefaultState() {
        return this.defaultState;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000f\u00a8\u0006\u0011"}, d2={"Lcom/google/aiplugin/agents/permissions/FilePermission$Companion;", "", "<init>", "()V", "create", "Lcom/google/aiplugin/agents/permissions/FilePermission;", "operation", "Lcom/google/aiplugin/agents/permissions/FilePermission$FileOperation;", "fileType", "Lcom/google/aiplugin/agents/permissions/FilePermission$FileType;", "Lcom/google/aiplugin/agents/permissions/FilePermission$FileOperations;", "fileTypes", "Lcom/google/aiplugin/agents/permissions/FilePermission$FileTypes;", "operations", "displayName", "", "hint", "aiplugin.agents.agents-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FilePermission create(@NotNull FileOperation operation, @NotNull FileType fileType) {
            Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
            Intrinsics.checkNotNullParameter((Object)((Object)fileType), (String)"fileType");
            return this.create(operation, new FileTypes(fileType, true));
        }

        @NotNull
        public final FilePermission create(@NotNull FileOperations operation, @NotNull FileType fileType) {
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)((Object)fileType), (String)"fileType");
            return com.google.aiplugin.agents.permissions.FilePermission$Companion.create$default(this, operation, new FileTypes(fileType, true), null, null, 12, null);
        }

        @NotNull
        public final FilePermission create(@NotNull FileOperation operation, @NotNull FileTypes fileTypes) {
            Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
            Intrinsics.checkNotNullParameter((Object)fileTypes, (String)"fileTypes");
            return com.google.aiplugin.agents.permissions.FilePermission$Companion.create$default(this, new FileOperations(operation), fileTypes, null, null, 12, null);
        }

        @NotNull
        public final FilePermission create(@NotNull FileOperations operations, @NotNull FileTypes fileTypes, @NotNull String displayName2, @NotNull String hint) {
            Intrinsics.checkNotNullParameter((Object)operations, (String)"operations");
            Intrinsics.checkNotNullParameter((Object)fileTypes, (String)"fileTypes");
            Intrinsics.checkNotNullParameter((Object)displayName2, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)hint, (String)"hint");
            return new FilePermission(operations, fileTypes, "file." + operations.key() + "." + fileTypes.key(), displayName2, hint, null, 32, null);
        }

        public static /* synthetic */ FilePermission create$default(Companion companion, FileOperations fileOperations, FileTypes fileTypes, String string, String string2, int n, Object object) {
            if ((n & 4) != 0) {
                string = FilePermissionKt.access$constructDisplayName(fileOperations, fileTypes, false);
            }
            if ((n & 8) != 0) {
                string2 = FilePermissionKt.access$constructHint(fileOperations, fileTypes, false);
            }
            return companion.create(fileOperations, fileTypes, string, string2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u0013"}, d2={"Lcom/google/aiplugin/agents/permissions/FilePermission$FileOperation;", "", "verb", "", "gerund", "icon", "Lcom/google/aiplugin/agents/ToolIcon;", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Lcom/google/aiplugin/agents/ToolIcon;)V", "getVerb", "()Ljava/lang/String;", "getGerund", "getIcon", "()Lcom/google/aiplugin/agents/ToolIcon;", "READ", "WRITE", "DELETE", "RENAME", "LIST", "aiplugin.agents.agents-core"})
    public static final class FileOperation
    extends Enum<FileOperation> {
        @NotNull
        private final String verb;
        @NotNull
        private final String gerund;
        @NotNull
        private final ToolIcon icon;
        public static final /* enum */ FileOperation READ = new FileOperation("read", "reading", BasicToolIcon.READ);
        public static final /* enum */ FileOperation WRITE = new FileOperation("write", "writing", BasicToolIcon.EDIT);
        public static final /* enum */ FileOperation DELETE = new FileOperation("delete", "deleting", BasicToolIcon.DELETE);
        public static final /* enum */ FileOperation RENAME = new FileOperation("rename", "renaming", BasicToolIcon.EDIT);
        public static final /* enum */ FileOperation LIST = new FileOperation("list", "listing", BasicToolIcon.READ);
        private static final /* synthetic */ FileOperation[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private FileOperation(String verb, String gerund, ToolIcon icon2) {
            this.verb = verb;
            this.gerund = gerund;
            this.icon = icon2;
        }

        @NotNull
        public final String getVerb() {
            return this.verb;
        }

        @NotNull
        public final String getGerund() {
            return this.gerund;
        }

        @NotNull
        public final ToolIcon getIcon() {
            return this.icon;
        }

        public static FileOperation[] values() {
            return (FileOperation[])$VALUES.clone();
        }

        public static FileOperation valueOf(String value) {
            return Enum.valueOf(FileOperation.class, value);
        }

        @NotNull
        public static EnumEntries<FileOperation> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = fileOperationArray = new FileOperation[]{FileOperation.READ, FileOperation.WRITE, FileOperation.DELETE, FileOperation.RENAME, FileOperation.LIST};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\bB%\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0004\u0012\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u000b\"\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\fJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0012J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0006\u0010\u001a\u001a\u00020\u0012J\u000e\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\u0004J\u000e\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0000J\b\u0010\u001d\u001a\u00020\u0012H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lcom/google/aiplugin/agents/permissions/FilePermission$FileOperations;", "", "operations", "Ljava/util/EnumSet;", "Lcom/google/aiplugin/agents/permissions/FilePermission$FileOperation;", "<init>", "(Ljava/util/EnumSet;)V", "operation", "(Lcom/google/aiplugin/agents/permissions/FilePermission$FileOperation;)V", "first", "rest", "", "(Lcom/google/aiplugin/agents/permissions/FilePermission$FileOperation;[Lcom/google/aiplugin/agents/permissions/FilePermission$FileOperation;)V", "getOperations", "()Ljava/util/EnumSet;", "icon", "Lcom/google/aiplugin/agents/ToolIcon;", "verb", "", "capitalizedVerb", "verbWithExplanation", "equals", "", "other", "hashCode", "", "key", "contains", "containsAll", "toString", "Companion", "aiplugin.agents.agents-core"})
    public static final class FileOperations {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final EnumSet<FileOperation> operations;
        @NotNull
        private static final FileOperations READ_AND_LIST;
        @NotNull
        private static final FileOperations WRITE;
        @NotNull
        private static final FileOperations DELETE_AND_RENAME;
        @NotNull
        private static final FileOperations ALL;
        @NotNull
        private static final FileOperations READ_ONLY;
        @NotNull
        private static final FileOperations DELETE_ONLY;
        @NotNull
        private static final FileOperations RENAME_ONLY;

        public FileOperations(@NotNull EnumSet<FileOperation> operations) {
            Intrinsics.checkNotNullParameter(operations, (String)"operations");
            this.operations = operations;
        }

        @NotNull
        public final EnumSet<FileOperation> getOperations() {
            return this.operations;
        }

        public FileOperations(@NotNull FileOperation operation) {
            Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
            EnumSet<Enum> enumSet = EnumSet.of((Enum)operation);
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
            this(enumSet);
        }

        public FileOperations(@NotNull FileOperation first, FileOperation ... rest) {
            Intrinsics.checkNotNullParameter((Object)((Object)first), (String)"first");
            Intrinsics.checkNotNullParameter((Object)rest, (String)"rest");
            EnumSet<Enum[]> enumSet = EnumSet.of((Enum)first, (Enum[])Arrays.copyOf(rest, rest.length));
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
            this(enumSet);
        }

        @NotNull
        public final ToolIcon icon() {
            return ((FileOperation)((Object)CollectionsKt.first((Iterable)this.operations))).getIcon();
        }

        @NotNull
        public final String verb() {
            return Intrinsics.areEqual((Object)this, (Object)READ_AND_LIST) ? "read" : (Intrinsics.areEqual((Object)this, (Object)READ_ONLY) ? "read" : (Intrinsics.areEqual((Object)this, (Object)WRITE) ? "write" : (Intrinsics.areEqual((Object)this, (Object)DELETE_AND_RENAME) ? "delete or rename" : (Intrinsics.areEqual((Object)this, (Object)DELETE_ONLY) ? "delete" : (Intrinsics.areEqual((Object)this, (Object)ALL) ? "access" : CollectionsKt.joinToString$default((Iterable)this.operations, (CharSequence)"+", null, null, (int)0, null, FileOperations::verb$lambda$0, (int)30, null))))));
        }

        @NotNull
        public final String capitalizedVerb() {
            String verb = this.verb();
            String string = String.valueOf(verb.charAt(0));
            Intrinsics.checkNotNull((Object)string, (String)"null cannot be cast to non-null type java.lang.String");
            String string2 = string.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            String string3 = verb.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            return string2 + string3;
        }

        @Nullable
        public final String verbWithExplanation() {
            return Intrinsics.areEqual((Object)this, (Object)READ_AND_LIST) ? "read (and for directories, list)" : (Intrinsics.areEqual((Object)this, (Object)READ_ONLY) ? "read" : (Intrinsics.areEqual((Object)this, (Object)WRITE) ? "write" : (Intrinsics.areEqual((Object)this, (Object)DELETE_AND_RENAME) ? "delete or rename" : (Intrinsics.areEqual((Object)this, (Object)DELETE_ONLY) ? "delete" : (Intrinsics.areEqual((Object)this, (Object)ALL) ? "access (read, write, delete or rename)" : CollectionsKt.joinToString$default((Iterable)this.operations, (CharSequence)" or ", null, null, (int)0, null, FileOperations::verbWithExplanation$lambda$1, (int)30, null))))));
        }

        public boolean equals(@Nullable Object other) {
            FileOperations fileOperations = other instanceof FileOperations ? (FileOperations)other : null;
            return Intrinsics.areEqual(this.operations, fileOperations != null ? fileOperations.operations : null);
        }

        public int hashCode() {
            return this.operations.hashCode();
        }

        @NotNull
        public final String key() {
            return Intrinsics.areEqual((Object)this, (Object)READ_AND_LIST) ? "read+list" : (Intrinsics.areEqual((Object)this, (Object)READ_ONLY) ? "read" : (Intrinsics.areEqual((Object)this, (Object)WRITE) ? "write" : (Intrinsics.areEqual((Object)this, (Object)DELETE_AND_RENAME) ? "delete+rename" : (Intrinsics.areEqual((Object)this, (Object)DELETE_ONLY) ? "delete" : (Intrinsics.areEqual((Object)this, (Object)RENAME_ONLY) ? "rename" : (Intrinsics.areEqual((Object)this, (Object)ALL) ? "all" : CollectionsKt.joinToString$default((Iterable)this.operations, (CharSequence)"+", null, null, (int)0, null, FileOperations::key$lambda$2, (int)30, null)))))));
        }

        public final boolean contains(@NotNull FileOperation operation) {
            Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
            return this.operations.contains((Object)operation);
        }

        public final boolean containsAll(@NotNull FileOperations other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.operations.containsAll((Collection)other.operations);
        }

        @NotNull
        public String toString() {
            return this.verb();
        }

        private static final CharSequence verb$lambda$0(FileOperation it) {
            return it.getVerb();
        }

        private static final CharSequence verbWithExplanation$lambda$1(FileOperation it) {
            return it.getVerb();
        }

        private static final CharSequence key$lambda$2(FileOperation it) {
            return it.getVerb();
        }

        static {
            EnumSet<Enum> enumSet = EnumSet.of((Enum)FileOperation.READ, (Enum)FileOperation.LIST);
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
            READ_AND_LIST = new FileOperations(enumSet);
            EnumSet<Enum> enumSet2 = EnumSet.of((Enum)FileOperation.WRITE);
            Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"of(...)");
            WRITE = new FileOperations(enumSet2);
            EnumSet<Enum> enumSet3 = EnumSet.of((Enum)FileOperation.DELETE, (Enum)FileOperation.RENAME);
            Intrinsics.checkNotNullExpressionValue(enumSet3, (String)"of(...)");
            DELETE_AND_RENAME = new FileOperations(enumSet3);
            EnumSet<Enum> enumSet4 = EnumSet.of((Enum)FileOperation.READ, (Enum)FileOperation.WRITE, (Enum)FileOperation.LIST, (Enum)FileOperation.DELETE, (Enum)FileOperation.RENAME);
            Intrinsics.checkNotNullExpressionValue(enumSet4, (String)"of(...)");
            ALL = new FileOperations(enumSet4);
            EnumSet<Enum> enumSet5 = EnumSet.of((Enum)FileOperation.READ);
            Intrinsics.checkNotNullExpressionValue(enumSet5, (String)"of(...)");
            READ_ONLY = new FileOperations(enumSet5);
            EnumSet<Enum> enumSet6 = EnumSet.of((Enum)FileOperation.DELETE);
            Intrinsics.checkNotNullExpressionValue(enumSet6, (String)"of(...)");
            DELETE_ONLY = new FileOperations(enumSet6);
            EnumSet<Enum> enumSet7 = EnumSet.of((Enum)FileOperation.RENAME);
            Intrinsics.checkNotNullExpressionValue(enumSet7, (String)"of(...)");
            RENAME_ONLY = new FileOperations(enumSet7);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/google/aiplugin/agents/permissions/FilePermission$FileOperations$Companion;", "", "<init>", "()V", "READ_AND_LIST", "Lcom/google/aiplugin/agents/permissions/FilePermission$FileOperations;", "getREAD_AND_LIST", "()Lcom/google/aiplugin/agents/permissions/FilePermission$FileOperations;", "WRITE", "getWRITE", "DELETE_AND_RENAME", "getDELETE_AND_RENAME", "ALL", "getALL", "READ_ONLY", "getREAD_ONLY", "DELETE_ONLY", "getDELETE_ONLY", "RENAME_ONLY", "getRENAME_ONLY", "aiplugin.agents.agents-core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final FileOperations getREAD_AND_LIST() {
                return READ_AND_LIST;
            }

            @NotNull
            public final FileOperations getWRITE() {
                return WRITE;
            }

            @NotNull
            public final FileOperations getDELETE_AND_RENAME() {
                return DELETE_AND_RENAME;
            }

            @NotNull
            public final FileOperations getALL() {
                return ALL;
            }

            @NotNull
            public final FileOperations getREAD_ONLY() {
                return READ_ONLY;
            }

            @NotNull
            public final FileOperations getDELETE_ONLY() {
                return DELETE_ONLY;
            }

            @NotNull
            public final FileOperations getRENAME_ONLY() {
                return RENAME_ONLY;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\rB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\u000e"}, d2={"Lcom/google/aiplugin/agents/permissions/FilePermission$FileType;", "", "id", "", "displayName", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getDisplayName", "NORMAL", "EXECUTABLE", "SENSITIVE", "Companion", "aiplugin.agents.agents-core"})
    public static final class FileType
    extends Enum<FileType> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String id;
        @NotNull
        private final String displayName;
        public static final /* enum */ FileType NORMAL;
        public static final /* enum */ FileType EXECUTABLE;
        public static final /* enum */ FileType SENSITIVE;
        private static final /* synthetic */ FileType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private FileType(String id, String displayName2) {
            this.id = id;
            this.displayName = displayName2;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        public static FileType[] values() {
            return (FileType[])$VALUES.clone();
        }

        public static FileType valueOf(String value) {
            return Enum.valueOf(FileType.class, value);
        }

        @NotNull
        public static EnumEntries<FileType> getEntries() {
            return $ENTRIES;
        }

        static {
            NORMAL = new FileType("normal", "normal files");
            EXECUTABLE = new FileType("executable", "executable files");
            SENSITIVE = new FileType("sensitive", "sensitive files");
            $VALUES = fileTypeArray = new FileType[]{FileType.NORMAL, FileType.EXECUTABLE, FileType.SENSITIVE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u0010"}, d2={"Lcom/google/aiplugin/agents/permissions/FilePermission$FileType$Companion;", "", "<init>", "()V", "getFileType", "Lcom/google/aiplugin/agents/permissions/FilePermission$FileType;", "file", "Ljava/io/File;", "fileOperation", "Lcom/google/aiplugin/agents/permissions/FilePermission$FileOperation;", "isExecutableFile", "", "isExecutablePath", "path", "", "isSensitiveFile", "aiplugin.agents.agents-core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final FileType getFileType(@NotNull File file, @NotNull FileOperation fileOperation) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)((Object)fileOperation), (String)"fileOperation");
                return this.isSensitiveFile(file, fileOperation) ? SENSITIVE : (this.isExecutableFile(file) ? EXECUTABLE : NORMAL);
            }

            public final boolean isExecutableFile(@NotNull File file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (!SystemInfo.isWindows && file.canExecute()) {
                    return true;
                }
                String string = file.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                return this.isExecutablePath(string);
            }

            public final boolean isExecutablePath(@NotNull String path2) {
                Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                return StringsKt.endsWith$default((String)path2, (String)".gradle", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path2, (String)".kts", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path2, (String)".exe", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path2, (String)".sh", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path2, (String)".bat", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path2, (String)".cmd", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path2, (String)".jar", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path2, (String)"gradlew", (boolean)false, (int)2, null);
            }

            /*
             * Unable to fully structure code
             */
            public final boolean isSensitiveFile(@NotNull File file, @NotNull FileOperation fileOperation) {
                block63: {
                    block62: {
                        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                        Intrinsics.checkNotNullParameter((Object)fileOperation, (String)"fileOperation");
                        var4_4 = path = file.getPath();
                        if (var4_4 == null) break block62;
                        switch (var4_4.hashCode()) {
                            case -1929532184: {
                                if (!var4_4.equals("/etc/passwd")) {
                                    break;
                                }
                                ** GOTO lbl20
                            }
                            case -759817521: {
                                if (!var4_4.equals("/etc/sudoers")) {
                                    break;
                                }
                                ** GOTO lbl20
                            }
                            case -1837730966: {
                                if (!var4_4.equals("/etc/shadow")) {
                                    break;
                                }
                                ** GOTO lbl20
                            }
                            case 1001948404: {
                                if (!var4_4.equals("/etc/ssh/sshd_config")) break;
lbl20:
                                // 4 sources

                                return true;
                            }
                        }
                    }
                    Intrinsics.checkNotNull((Object)path);
                    if (StringsKt.contains$default((CharSequence)path, (CharSequence)"System32\\config\\SECURITY", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)path, (CharSequence)"Microsoft\\Credentials", (boolean)false, (int)2, null)) {
                        return true;
                    }
                    name = file.getName();
                    var5_5 = name;
                    if (var5_5 == null) break block63;
                    switch (var5_5.hashCode()) {
                        case 390371300: {
                            if (!var5_5.equals("google-services.json")) {
                                ** break;
                            }
                            ** GOTO lbl56
                        }
                        case -2128842196: {
                            if (!var5_5.equals("logins.json")) {
                                ** break;
                            }
                            ** GOTO lbl56
                        }
                        case 1813528104: {
                            if (var5_5.equals(".aiignore")) break;
                            ** break;
                        }
                        case -767068269: {
                            if (!var5_5.equals(".git-credentials")) {
                                ** break;
                            }
                            ** GOTO lbl56
                        }
                        case -1814986891: {
                            if (var5_5.equals(".geminiignore")) break;
                            ** break;
                        }
                        case 186219073: {
                            if (!var5_5.equals("Login Data")) {
                                ** break;
                            }
                            ** GOTO lbl56
                        }
                        case 1606199364: {
                            if (var5_5.equals(".aiexclude")) break;
                            ** break;
                        }
                        case 1208935600: {
                            if (!var5_5.equals("credentials.db")) ** break;
lbl56:
                            // 5 sources

                            return true;
                        }
                    }
                    if (fileOperation == FileOperation.WRITE || fileOperation == FileOperation.RENAME) {
                        return true;
                    }
                }
                Intrinsics.checkNotNull((Object)name);
                extension = StringsKt.substringAfterLast((String)name, (String)".", (String)"");
                var6_6 = extension;
                switch (var6_6.hashCode()) {
                    case 105298: {
                        if (!var6_6.equals("jks")) {
                            break;
                        }
                        ** GOTO lbl87
                    }
                    case 98789: {
                        if (!var6_6.equals("crt")) {
                            break;
                        }
                        ** GOTO lbl87
                    }
                    case 110872: {
                        if (!var6_6.equals("pem")) {
                            break;
                        }
                        ** GOTO lbl87
                    }
                    case 519601634: {
                        if (!var6_6.equals("keystore")) {
                            break;
                        }
                        ** GOTO lbl87
                    }
                    case 3286895: {
                        if (!var6_6.equals("kdbx")) {
                            break;
                        }
                        ** GOTO lbl87
                    }
                    case 106079: {
                        if (!var6_6.equals("key")) break;
lbl87:
                        // 6 sources

                        return true;
                    }
                }
                v0 = file.toPath().iterator();
                Intrinsics.checkNotNullExpressionValue(v0, (String)"iterator(...)");
                var6_6 = v0;
                block39: while (var6_6.hasNext()) {
                    pathComponent = (Path)var6_6.next();
                    var9_9 = name = pathComponent.toString();
                    tmp = -1;
                    switch (var9_9.hashCode()) {
                        case -314497661: {
                            if (var9_9.equals("private")) {
                                tmp = 1;
                            }
                            break;
                        }
                        case 1472740: {
                            if (var9_9.equals(".git")) {
                                tmp = 2;
                            }
                            break;
                        }
                        case -683415465: {
                            if (var9_9.equals("credential")) {
                                tmp = 3;
                            }
                            break;
                        }
                        case 1415456631: {
                            if (var9_9.equals(".gnupg")) {
                                tmp = 3;
                            }
                            break;
                        }
                        case 1467407: {
                            if (var9_9.equals(".aws")) {
                                tmp = 2;
                            }
                            break;
                        }
                        case -906277200: {
                            if (var9_9.equals("secret")) {
                                tmp = 3;
                            }
                            break;
                        }
                        case 919055324: {
                            if (var9_9.equals(".gcloud")) {
                                tmp = 2;
                            }
                            break;
                        }
                        case 1484570: {
                            if (var9_9.equals(".ssh")) {
                                tmp = 3;
                            }
                            break;
                        }
                    }
                    switch (tmp) {
                        case 1: {
                            if (StringsKt.startsWith$default((String)path, (String)"/private/var/folders/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)path, (String)"/private/var/tmp/", (boolean)false, (int)2, null)) continue block39;
                            return true;
                        }
                        case 3: {
                            return true;
                        }
                        case 2: {
                            if (fileOperation != FileOperation.WRITE && fileOperation != FileOperation.RENAME) continue block39;
                            return true;
                        }
                    }
                }
                return false;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0005\u0010\nJ\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eJ\u0013\u0010\u0010\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0006\u0010\u0014\u001a\u00020\u000eJ\u000e\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0004J\u000e\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0000J\b\u0010\u0018\u001a\u00020\u000eH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/google/aiplugin/agents/permissions/FilePermission$FileTypes;", "", "types", "Ljava/util/EnumSet;", "Lcom/google/aiplugin/agents/permissions/FilePermission$FileType;", "<init>", "(Ljava/util/EnumSet;)V", "fileType", "includeLowerRiskTypes", "", "(Lcom/google/aiplugin/agents/permissions/FilePermission$FileType;Z)V", "getTypes", "()Ljava/util/EnumSet;", "displayName", "", "displayNameWithExplanation", "equals", "other", "hashCode", "", "key", "contains", "type", "containsAll", "toString", "Companion", "aiplugin.agents.agents-core"})
    public static final class FileTypes {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final EnumSet<FileType> types;
        @NotNull
        private static final FileTypes NORMAL_ONLY = new FileTypes(FileType.NORMAL, false);
        @NotNull
        private static final FileTypes EXECUTABLE_ONLY = new FileTypes(FileType.EXECUTABLE, false);
        @NotNull
        private static final FileTypes SENSITIVE_ONLY = new FileTypes(FileType.SENSITIVE, false);
        @NotNull
        private static final FileTypes NORMAL_AND_EXECUTABLE;
        @NotNull
        private static final FileTypes NON_SENSITIVE;
        @NotNull
        private static final FileTypes ANY;

        public FileTypes(@NotNull EnumSet<FileType> types) {
            Intrinsics.checkNotNullParameter(types, (String)"types");
            this.types = types;
        }

        @NotNull
        public final EnumSet<FileType> getTypes() {
            return this.types;
        }

        public FileTypes(@NotNull FileType fileType, boolean includeLowerRiskTypes) {
            EnumSet<Enum> enumSet;
            Intrinsics.checkNotNullParameter((Object)((Object)fileType), (String)"fileType");
            if (includeLowerRiskTypes) {
                switch (WhenMappings.$EnumSwitchMapping$0[fileType.ordinal()]) {
                    case 1: {
                        enumSet = EnumSet.of((Enum)FileType.NORMAL, (Enum)FileType.EXECUTABLE, (Enum)FileType.SENSITIVE);
                        break;
                    }
                    case 2: {
                        enumSet = EnumSet.of((Enum)FileType.NORMAL, (Enum)FileType.EXECUTABLE);
                        break;
                    }
                    default: {
                        enumSet = EnumSet.of((Enum)fileType);
                        break;
                    }
                }
            } else {
                enumSet = EnumSet.of((Enum)fileType);
            }
            EnumSet<Enum> enumSet2 = enumSet;
            Intrinsics.checkNotNull(enumSet2);
            this(enumSet2);
        }

        @NotNull
        public final String displayName() {
            return Intrinsics.areEqual((Object)this, (Object)ANY) ? "any files" : (Intrinsics.areEqual((Object)this, (Object)NORMAL_ONLY) ? "source files" : (Intrinsics.areEqual((Object)this, (Object)EXECUTABLE_ONLY) ? "executable files" : (Intrinsics.areEqual((Object)this, (Object)NORMAL_AND_EXECUTABLE) ? "normal and executable files" : (Intrinsics.areEqual((Object)this, (Object)SENSITIVE_ONLY) ? "sensitive files" : CollectionsKt.joinToString$default((Iterable)this.types, (CharSequence)" and ", null, null, (int)0, null, FileTypes::displayName$lambda$0, (int)30, null)))));
        }

        @Nullable
        public final String displayNameWithExplanation() {
            return Intrinsics.areEqual((Object)this, (Object)ANY) ? this.displayName() + " (including sensitive files)" : (Intrinsics.areEqual((Object)this, (Object)NORMAL_ONLY) ? this.displayName() + " (and other plain files, but not executable files)" : (Intrinsics.areEqual((Object)this, (Object)EXECUTABLE_ONLY) ? this.displayName() + " (such as build.gradle.kts files)" : (Intrinsics.areEqual((Object)this, (Object)NORMAL_AND_EXECUTABLE) ? this.displayName() : (Intrinsics.areEqual((Object)this, (Object)SENSITIVE_ONLY) ? this.displayName() + " (such as .keystore, ~/.ssh/, etc.)" : null))));
        }

        public boolean equals(@Nullable Object other) {
            FileTypes fileTypes = other instanceof FileTypes ? (FileTypes)other : null;
            return Intrinsics.areEqual(this.types, fileTypes != null ? fileTypes.types : null);
        }

        public int hashCode() {
            return this.types.hashCode();
        }

        @NotNull
        public final String key() {
            return Intrinsics.areEqual((Object)this, (Object)ANY) ? "any" : (Intrinsics.areEqual((Object)this, (Object)NORMAL_ONLY) ? "normal" : (Intrinsics.areEqual((Object)this, (Object)NORMAL_AND_EXECUTABLE) ? "non-sensitive" : (Intrinsics.areEqual((Object)this, (Object)SENSITIVE_ONLY) ? "sensitive" : CollectionsKt.joinToString$default((Iterable)this.types, (CharSequence)"-", null, null, (int)0, null, FileTypes::key$lambda$1, (int)30, null))));
        }

        public final boolean contains(@NotNull FileType type2) {
            Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
            return this.types.contains((Object)type2);
        }

        public final boolean containsAll(@NotNull FileTypes other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.types.containsAll((Collection)other.types);
        }

        @NotNull
        public String toString() {
            return this.displayName();
        }

        private static final CharSequence displayName$lambda$0(FileType it) {
            return it.getDisplayName();
        }

        private static final CharSequence key$lambda$1(FileType it) {
            return it.getId();
        }

        static {
            EnumSet<Enum> enumSet = EnumSet.of((Enum)FileType.NORMAL, (Enum)FileType.EXECUTABLE);
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
            NON_SENSITIVE = NORMAL_AND_EXECUTABLE = new FileTypes(enumSet);
            EnumSet<Enum> enumSet2 = EnumSet.of((Enum)FileType.NORMAL, (Enum)FileType.EXECUTABLE, (Enum)FileType.SENSITIVE);
            Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"of(...)");
            ANY = new FileTypes(enumSet2);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/google/aiplugin/agents/permissions/FilePermission$FileTypes$Companion;", "", "<init>", "()V", "NORMAL_ONLY", "Lcom/google/aiplugin/agents/permissions/FilePermission$FileTypes;", "getNORMAL_ONLY", "()Lcom/google/aiplugin/agents/permissions/FilePermission$FileTypes;", "EXECUTABLE_ONLY", "getEXECUTABLE_ONLY", "SENSITIVE_ONLY", "getSENSITIVE_ONLY", "NORMAL_AND_EXECUTABLE", "getNORMAL_AND_EXECUTABLE", "NON_SENSITIVE", "getNON_SENSITIVE", "ANY", "getANY", "aiplugin.agents.agents-core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final FileTypes getNORMAL_ONLY() {
                return NORMAL_ONLY;
            }

            @NotNull
            public final FileTypes getEXECUTABLE_ONLY() {
                return EXECUTABLE_ONLY;
            }

            @NotNull
            public final FileTypes getSENSITIVE_ONLY() {
                return SENSITIVE_ONLY;
            }

            @NotNull
            public final FileTypes getNORMAL_AND_EXECUTABLE() {
                return NORMAL_AND_EXECUTABLE;
            }

            @NotNull
            public final FileTypes getNON_SENSITIVE() {
                return NON_SENSITIVE;
            }

            @NotNull
            public final FileTypes getANY() {
                return ANY;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[FileType.values().length];
                try {
                    nArray[FileType.SENSITIVE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FileType.EXECUTABLE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

