/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.agents.tools.analyze;

import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.daemon.impl.AnnotationSessionImpl;
import com.intellij.diagnostic.PluginException;
import com.intellij.lang.ExternalLanguageAnnotators;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ExternalAnnotatorRunner {
    private static final Logger LOG = Logger.getInstance(ExternalAnnotatorRunner.class);
    private final List<MyData<?, ?>> myAnnotationData = Collections.synchronizedList(new ArrayList());

    ExternalAnnotatorRunner() {
    }

    public List<@NotNull Annotation> analyze(@NotNull PsiFile psiFile2, @Nullable Editor editor2) {
        List annotators = ExternalLanguageAnnotators.allForFile((Language)psiFile2.getLanguage(), (PsiFile)psiFile2);
        boolean errorFound = false;
        ReadAction.run(() -> {
            for (ExternalAnnotator annotator : annotators) {
                Object collectedInfo = null;
                try {
                    collectedInfo = editor2 == null ? annotator.collectInformation(psiFile2) : annotator.collectInformation(psiFile2, editor2, errorFound);
                }
                catch (IndexNotReadyException indexNotReadyException) {
                }
                catch (Throwable t) {
                    ExternalAnnotatorRunner.processError(t, annotator, psiFile2);
                }
                if (collectedInfo == null) continue;
                this.myAnnotationData.add(new MyData(annotator, psiFile2, collectedInfo));
            }
        });
        this.doAnnotate();
        ReadAction.run(() -> {
            ProgressManager.checkCanceled();
            this.doApply();
        });
        return this.myAnnotationData.stream().flatMap(data2 -> ContainerUtil.notNullize((List)data2.annotationHolder).stream()).toList();
    }

    private void doAnnotate() {
        for (MyData<?, ?> data2 : this.myAnnotationData) {
            ExternalAnnotatorRunner.doAnnotate(data2);
        }
    }

    private static <K, V> void doAnnotate(@NotNull MyData<K, V> data2) {
        try {
            AnnotationSessionImpl.computeWithSession((PsiFile)data2.psiRoot, (boolean)false, data2.annotator, annotationHolder -> {
                data2.annotationHolder = (AnnotationHolderImpl)annotationHolder;
                data2.annotationResult = data2.annotator.doAnnotate(data2.collectedInfo);
                return null;
            });
        }
        catch (IndexNotReadyException indexNotReadyException) {
        }
        catch (Throwable t) {
            ExternalAnnotatorRunner.processError(t, data2.annotator, data2.psiRoot);
        }
    }

    private void doApply() {
        for (MyData<?, ?> data2 : this.myAnnotationData) {
            ExternalAnnotatorRunner.doApply(data2);
        }
    }

    private static <K, V> void doApply(@NotNull MyData<K, V> data2) {
        if (data2.annotationResult != null && data2.psiRoot.isValid()) {
            try {
                data2.annotationHolder.applyExternalAnnotatorWithContext(data2.psiRoot, data2.annotationResult);
            }
            catch (Throwable t) {
                ExternalAnnotatorRunner.processError(t, data2.annotator, data2.psiRoot);
            }
        }
    }

    private static void processError(@NotNull Throwable t, @NotNull ExternalAnnotator<?, ?> annotator, @NotNull PsiFile root) {
        if (t instanceof ProcessCanceledException) {
            ProcessCanceledException pce = (ProcessCanceledException)t;
            throw pce;
        }
        VirtualFile file = root.getVirtualFile();
        String path2 = file != null ? file.getPath() : root.getName();
        String message = "annotator: " + String.valueOf(annotator) + " (" + String.valueOf(annotator.getClass()) + ")";
        PluginException pe = PluginException.createByClass((String)message, (Throwable)t, annotator.getClass());
        LOG.error("ExternalAnnotatorrunner: ", (Throwable)pe, new Attachment[]{new Attachment("root_path.txt", path2)});
    }

    private static final class MyData<K, V> {
        @NotNull
        final ExternalAnnotator<K, V> annotator;
        @NotNull
        final PsiFile psiRoot;
        @NotNull
        final K collectedInfo;
        volatile V annotationResult;
        volatile AnnotationHolderImpl annotationHolder;

        MyData(@NotNull ExternalAnnotator<K, V> annotator, @NotNull PsiFile psiRoot, @NotNull K collectedInfo) {
            this.annotator = annotator;
            this.psiRoot = psiRoot;
            this.collectedInfo = collectedInfo;
        }
    }
}

