/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.agents.tools.search;

import com.android.tools.idea.studiobot.AiExcludeService;
import com.google.aiplugin.agents.BasicToolIcon;
import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolArgument;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.google.aiplugin.agents.tools.search.ResolveSymbolTool$Args$;
import com.google.gson.Gson;
import com.intellij.ide.actions.QualifiedNameProviderUtil;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ReadConstraint;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.Map;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KParameter;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ToolDescription(summary="Resolves a specific symbol reference to its declaration", examples={"resolve_symbol(symbol = \"foo\", contextSnippet = \"val result = foo()\", contextFile = \"/path/to/src/File.kt\")"})
@ToolResult(description="If the declaration is found, the tool returns the absolute path of the containing file as well as the full text of the declaration (including Javadoc).")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0016\u0017\u0018B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/google/aiplugin/agents/tools/search/ResolveSymbolTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/google/aiplugin/agents/tools/search/ResolveSymbolTool$Args;", "fileSystem", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFileSystem;)V", "name", "", "getName", "()Ljava/lang/String;", "icon", "Lcom/google/aiplugin/agents/BasicToolIcon;", "getIcon", "()Lcom/google/aiplugin/agents/BasicToolIcon;", "getRunningDisplayText", "args", "getCompletedDisplayText", "createHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "Args", "Result", "Handler", "aiplugin.agents.agents-core"})
public final class ResolveSymbolTool
implements Tool<Args> {
    @NotNull
    private final VirtualFileSystem fileSystem;
    @NotNull
    private final String name;
    @NotNull
    private final BasicToolIcon icon;

    public ResolveSymbolTool(@NotNull VirtualFileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.fileSystem = fileSystem;
        this.name = "resolve_symbol";
        this.icon = BasicToolIcon.SEARCH;
    }

    public /* synthetic */ ResolveSymbolTool(VirtualFileSystem virtualFileSystem, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
            virtualFileSystem = (VirtualFileSystem)localFileSystem;
        }
        this(virtualFileSystem);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public BasicToolIcon getIcon() {
        return this.icon;
    }

    @Override
    @NotNull
    public String getRunningDisplayText(@NotNull Args args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Finding declaration of '" + args.getSymbol() + "'";
    }

    @Override
    @NotNull
    public String getCompletedDisplayText(@NotNull Args args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Found declaration of '" + args.getSymbol() + "'";
    }

    @Override
    @NotNull
    public ToolHandler createHandler(@NotNull ToolContext context2, @NotNull Args args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new Handler(context2, this.fileSystem, args);
    }

    @Override
    @NotNull
    public String getDescription() {
        return Tool.super.getDescription();
    }

    @Override
    @Nullable
    public String getStatusMessage() {
        return Tool.super.getStatusMessage();
    }

    @Override
    @Nullable
    public ToolHandler restoreHandler(@NotNull Project project2, @NotNull Args args, @NotNull Response response2) {
        return Tool.super.restoreHandler(project2, args, response2);
    }

    @Override
    @NotNull
    public ToolDescription getToolDescription() {
        return Tool.super.getToolDescription();
    }

    @Override
    @Nullable
    public ToolResult getToolResult() {
        return Tool.super.getToolResult();
    }

    @Override
    @Nullable
    public Map<KParameter, ToolArgument> getToolArguments() {
        return Tool.super.getToolArguments();
    }

    public ResolveSymbolTool() {
        this(null, 1, null);
    }

    @Serializable
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 #2\u00020\u0001:\u0002\"#B%\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007B9\b\u0010\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0006\u0010\fJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00032\b\b\u0003\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\tH\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001J%\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0001\u00a2\u0006\u0002\b!R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006$"}, d2={"Lcom/google/aiplugin/agents/tools/search/ResolveSymbolTool$Args;", "", "symbol", "", "contextSnippet", "contextFile", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getSymbol", "()Ljava/lang/String;", "getContextSnippet", "getContextFile", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$aiplugin_agents_agents_core", "$serializer", "Companion", "aiplugin.agents.agents-core"})
    public static final class Args {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String symbol;
        @NotNull
        private final String contextSnippet;
        @NotNull
        private final String contextFile;

        public Args(@ToolArgument(description="Name of the symbol to search (usually a variable or function name)") @NotNull String symbol, @ToolArgument(description="A small snippet of surrounding text to help identify a specific symbol within a file") @NotNull String contextSnippet, @ToolArgument(description="Absolute path of the file in which the symbol reference resides") @NotNull String contextFile) {
            Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
            Intrinsics.checkNotNullParameter((Object)contextSnippet, (String)"contextSnippet");
            Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
            this.symbol = symbol;
            this.contextSnippet = contextSnippet;
            this.contextFile = contextFile;
        }

        @NotNull
        public final String getSymbol() {
            return this.symbol;
        }

        @NotNull
        public final String getContextSnippet() {
            return this.contextSnippet;
        }

        @NotNull
        public final String getContextFile() {
            return this.contextFile;
        }

        @NotNull
        public final String component1() {
            return this.symbol;
        }

        @NotNull
        public final String component2() {
            return this.contextSnippet;
        }

        @NotNull
        public final String component3() {
            return this.contextFile;
        }

        @NotNull
        public final Args copy(@ToolArgument(description="Name of the symbol to search (usually a variable or function name)") @NotNull String symbol, @ToolArgument(description="A small snippet of surrounding text to help identify a specific symbol within a file") @NotNull String contextSnippet, @ToolArgument(description="Absolute path of the file in which the symbol reference resides") @NotNull String contextFile) {
            Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
            Intrinsics.checkNotNullParameter((Object)contextSnippet, (String)"contextSnippet");
            Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
            return new Args(symbol, contextSnippet, contextFile);
        }

        public static /* synthetic */ Args copy$default(Args args, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = args.symbol;
            }
            if ((n & 2) != 0) {
                string2 = args.contextSnippet;
            }
            if ((n & 4) != 0) {
                string3 = args.contextFile;
            }
            return args.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "Args(symbol=" + this.symbol + ", contextSnippet=" + this.contextSnippet + ", contextFile=" + this.contextFile + ")";
        }

        public int hashCode() {
            int result2 = this.symbol.hashCode();
            result2 = result2 * 31 + this.contextSnippet.hashCode();
            result2 = result2 * 31 + this.contextFile.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Args)) {
                return false;
            }
            Args args = (Args)other;
            if (!Intrinsics.areEqual((Object)this.symbol, (Object)args.symbol)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.contextSnippet, (Object)args.contextSnippet)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.contextFile, (Object)args.contextFile);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$aiplugin_agents_agents_core(Args self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeStringElement(serialDesc, 0, self.symbol);
            output.encodeStringElement(serialDesc, 1, self.contextSnippet);
            output.encodeStringElement(serialDesc, 2, self.contextFile);
        }

        public /* synthetic */ Args(int seen0, String symbol, String contextSnippet, String contextFile, SerializationConstructorMarker serializationConstructorMarker) {
            if (7 != (7 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)7, (SerialDescriptor)Args$$serializer.INSTANCE.getDescriptor());
            }
            this.symbol = symbol;
            this.contextSnippet = contextSnippet;
            this.contextFile = contextFile;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/google/aiplugin/agents/tools/search/ResolveSymbolTool$Args$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/google/aiplugin/agents/tools/search/ResolveSymbolTool$Args;", "aiplugin.agents.agents-core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Args> serializer() {
                return (KSerializer)Args$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u000e\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u000fH\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lcom/google/aiplugin/agents/tools/search/ResolveSymbolTool$Handler;", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "fileSystem", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "args", "Lcom/google/aiplugin/agents/tools/search/ResolveSymbolTool$Args;", "<init>", "(Lcom/google/aiplugin/agents/tools/ToolContext;Lcom/intellij/openapi/vfs/VirtualFileSystem;Lcom/google/aiplugin/agents/tools/search/ResolveSymbolTool$Args;)V", "getContext", "()Lcom/google/aiplugin/agents/tools/ToolContext;", "getArgs", "()Lcom/google/aiplugin/agents/tools/search/ResolveSymbolTool$Args;", "handle", "Lcom/google/aiplugin/agents/Response;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "doResolveSymbol", "aiplugin.agents.agents-core"})
    public static final class Handler
    implements ToolHandler {
        @NotNull
        private final ToolContext context;
        @NotNull
        private final VirtualFileSystem fileSystem;
        @NotNull
        private final Args args;

        public Handler(@NotNull ToolContext context2, @NotNull VirtualFileSystem fileSystem, @NotNull Args args) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.context = context2;
            this.fileSystem = fileSystem;
            this.args = args;
        }

        @NotNull
        public final ToolContext getContext() {
            return this.context;
        }

        @NotNull
        public final Args getArgs() {
            return this.args;
        }

        @Override
        @Nullable
        public Object handle(@NotNull Continuation<? super Response> $completion) {
            ReadConstraint inSmartMode = ReadConstraint.Companion.inSmartMode(this.context.getProject());
            ReadConstraint withDocumentsCommitted = ReadConstraint.Companion.withDocumentsCommitted(this.context.getProject());
            ReadConstraint[] readConstraintArray = new ReadConstraint[]{inSmartMode, withDocumentsCommitted};
            return CoroutinesKt.constrainedReadAction((ReadConstraint[])readConstraintArray, () -> Handler.handle$lambda$0(this), $completion);
        }

        @RequiresReadLock
        private final Response doResolveSymbol() {
            Object object;
            String fqName;
            String string;
            String text2;
            PsiElement declaration;
            PsiFile psiFile2;
            PsiElement rawDeclaration;
            if (this.context.getProject().isDisposed()) {
                return new Response(null, "project is closed", null, null, null, 29, null);
            }
            VirtualFile vFile = this.fileSystem.findFileByPath(this.args.getContextFile());
            if (vFile == null) {
                return new Response(null, "context file not found", null, null, null, 29, null);
            }
            AiExcludeService aiExcludeService2 = AiExcludeService.Companion.getInstance(this.context.getProject());
            if (aiExcludeService2.isFileExcluded(vFile)) {
                return new Response(null, "context file blocked by aiexclude", null, null, null, 29, null);
            }
            if (!GlobalSearchScope.allScope((Project)this.context.getProject()).contains(vFile)) {
                return new Response(null, "context file is outside the project", null, null, null, 29, null);
            }
            PsiFile psiFile3 = VirtualFileUtil.findPsiFile((VirtualFile)vFile, (Project)this.context.getProject());
            if (psiFile3 == null) {
                return new Response(null, "context file AST not found", null, null, null, 29, null);
            }
            Document document2 = psiFile3.getFileDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getFileDocument(...)");
            Document document3 = document2;
            CharSequence charSequence = document3.getCharsSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
            int snippetOffset = StringsKt.indexOf$default((CharSequence)charSequence, (String)this.args.getContextSnippet(), (int)0, (boolean)false, (int)6, null);
            if (snippetOffset < 0) {
                return new Response(null, "context snippet not found in file", null, null, null, 29, null);
            }
            int offsetInSnippet = StringsKt.indexOf$default((CharSequence)this.args.getContextSnippet(), (String)this.args.getSymbol(), (int)0, (boolean)false, (int)6, null);
            if (offsetInSnippet < 0) {
                return new Response(null, "symbol not found in context snippet", null, null, null, 29, null);
            }
            int symbolOffset = snippetOffset + offsetInSnippet;
            PsiReference psiReference = psiFile3.findReferenceAt(symbolOffset);
            Object object2 = rawDeclaration = psiReference != null ? psiReference.resolve() : null;
            if (rawDeclaration == null) {
                return new Response(null, "symbol resolution failed", null, null, null, 29, null);
            }
            PsiElement psiElement = rawDeclaration.getNavigationElement();
            if (psiElement == null) {
                psiElement = rawDeclaration;
            }
            VirtualFile declarationFile = (psiFile2 = (declaration = psiElement).getContainingFile()) != null && (psiFile2 = psiFile2.getViewProvider()) != null ? psiFile2.getVirtualFile() : null;
            if (declarationFile == null) {
                v6 = "<unknown>";
            } else if (aiExcludeService2.isFileExcluded(declarationFile)) {
                v6 = "<blocked_by_aiexclude>";
            } else {
                v6 = declaration.getText();
                if (v6 == null) {
                    v6 = text2 = "<unknown>";
                }
            }
            if ((string = QualifiedNameProviderUtil.getQualifiedName((PsiElement)rawDeclaration)) == null) {
                string = fqName = "<unknown>";
            }
            if ((object = declarationFile) == null || (object = object.getPath()) == null) {
                object = "<unknown>";
            }
            Result result2 = new Result((String)object, fqName, text2);
            return new Response(new Gson().toJson((Object)result2), null, null, null, null, 30, null);
        }

        private static final Response handle$lambda$0(Handler this$0) {
            return this$0.doResolveSymbol();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/google/aiplugin/agents/tools/search/ResolveSymbolTool$Result;", "", "containingFile", "", "fullyQualifiedName", "text", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getContainingFile", "()Ljava/lang/String;", "getFullyQualifiedName", "getText", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "aiplugin.agents.agents-core"})
    public static final class Result {
        @NotNull
        private final String containingFile;
        @NotNull
        private final String fullyQualifiedName;
        @NotNull
        private final String text;

        public Result(@NotNull String containingFile, @NotNull String fullyQualifiedName, @NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)containingFile, (String)"containingFile");
            Intrinsics.checkNotNullParameter((Object)fullyQualifiedName, (String)"fullyQualifiedName");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            this.containingFile = containingFile;
            this.fullyQualifiedName = fullyQualifiedName;
            this.text = text2;
        }

        @NotNull
        public final String getContainingFile() {
            return this.containingFile;
        }

        @NotNull
        public final String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final String component1() {
            return this.containingFile;
        }

        @NotNull
        public final String component2() {
            return this.fullyQualifiedName;
        }

        @NotNull
        public final String component3() {
            return this.text;
        }

        @NotNull
        public final Result copy(@NotNull String containingFile, @NotNull String fullyQualifiedName, @NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)containingFile, (String)"containingFile");
            Intrinsics.checkNotNullParameter((Object)fullyQualifiedName, (String)"fullyQualifiedName");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            return new Result(containingFile, fullyQualifiedName, text2);
        }

        public static /* synthetic */ Result copy$default(Result result2, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = result2.containingFile;
            }
            if ((n & 2) != 0) {
                string2 = result2.fullyQualifiedName;
            }
            if ((n & 4) != 0) {
                string3 = result2.text;
            }
            return result2.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "Result(containingFile=" + this.containingFile + ", fullyQualifiedName=" + this.fullyQualifiedName + ", text=" + this.text + ")";
        }

        public int hashCode() {
            int result2 = this.containingFile.hashCode();
            result2 = result2 * 31 + this.fullyQualifiedName.hashCode();
            result2 = result2 * 31 + this.text.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result2 = (Result)other;
            if (!Intrinsics.areEqual((Object)this.containingFile, (Object)result2.containingFile)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.fullyQualifiedName, (Object)result2.fullyQualifiedName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.text, (Object)result2.text);
        }
    }
}

