/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.mcp.auth;

import androidx.compose.runtime.internal.StabilityInferred;
import com.google.aiplugin.mcp.auth.AuthMetadata;
import com.google.aiplugin.mcp.auth.AuthorizationCodeHolder;
import com.google.aiplugin.mcp.auth.McpLoginStateKt;
import com.google.aiplugin.mcp.auth.McpUiFacade;
import com.google.aiplugin.mcp.auth.OAuthServer;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.auth.openidconnect.IdToken;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 $2\u00020\u0001:\u0002#$B+\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\n\u0010\u000eJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\tH\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J$\u0010\u001b\u001a\u00020\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006%"}, d2={"Lcom/google/aiplugin/mcp/auth/McpLoginState;", "", "transport", "Lcom/google/api/client/http/HttpTransport;", "oAuthServer", "Lcom/google/aiplugin/mcp/auth/OAuthServer;", "authMetadata", "Lcom/google/aiplugin/mcp/auth/AuthMetadata;", "email", "", "<init>", "(Lcom/google/api/client/http/HttpTransport;Lcom/google/aiplugin/mcp/auth/OAuthServer;Lcom/google/aiplugin/mcp/auth/AuthMetadata;Ljava/lang/String;)V", "authResponse", "Lcom/google/api/client/auth/oauth2/TokenResponse;", "(Lcom/google/api/client/http/HttpTransport;Lcom/google/aiplugin/mcp/auth/OAuthServer;Lcom/google/aiplugin/mcp/auth/AuthMetadata;Lcom/google/api/client/auth/oauth2/TokenResponse;)V", "getEmail", "()Ljava/lang/String;", "oAuthData", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/google/aiplugin/mcp/auth/McpLoginState$OAuthData;", "getOAuthData", "()Ljava/util/concurrent/atomic/AtomicReference;", "isLoggedIn", "", "fetchAccessToken", "getCredential", "Lcom/google/api/client/auth/oauth2/Credential;", "makeCredential", "accessToken", "refreshToken", "accessTokenExpiryTimeInSeconds", "", "updateUserCredentials", "", "tokenResponse", "OAuthData", "Companion", "aiplugin.mcp.client.sdkcompat"})
@StabilityInferred(parameters=0)
public class McpLoginState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HttpTransport transport;
    @NotNull
    private final OAuthServer oAuthServer;
    @NotNull
    private final AuthMetadata authMetadata;
    @Nullable
    private final String email;
    @NotNull
    private final AtomicReference<OAuthData> oAuthData;
    public static final int $stable = 8;
    @NotNull
    private static final JsonFactory jsonFactory = (JsonFactory)new GsonFactory();

    @VisibleForTesting
    public McpLoginState(@NotNull HttpTransport transport, @NotNull OAuthServer oAuthServer, @NotNull AuthMetadata authMetadata, @Nullable String email) {
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        Intrinsics.checkNotNullParameter((Object)oAuthServer, (String)"oAuthServer");
        Intrinsics.checkNotNullParameter((Object)authMetadata, (String)"authMetadata");
        this.transport = transport;
        this.oAuthServer = oAuthServer;
        this.authMetadata = authMetadata;
        this.email = email;
        this.oAuthData = new AtomicReference<Object>(null);
    }

    @Nullable
    public String getEmail() {
        return this.email;
    }

    public McpLoginState(@NotNull HttpTransport transport, @NotNull OAuthServer oAuthServer, @NotNull AuthMetadata authMetadata, @NotNull TokenResponse authResponse) {
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        Intrinsics.checkNotNullParameter((Object)oAuthServer, (String)"oAuthServer");
        Intrinsics.checkNotNullParameter((Object)authMetadata, (String)"authMetadata");
        Intrinsics.checkNotNullParameter((Object)authResponse, (String)"authResponse");
        this(transport, oAuthServer, authMetadata, McpLoginState.Companion.extractEmail(authResponse));
        this.updateUserCredentials(authResponse);
    }

    @NotNull
    protected final AtomicReference<OAuthData> getOAuthData() {
        return this.oAuthData;
    }

    public boolean isLoggedIn() {
        return this.oAuthData.get() != null;
    }

    @Nullable
    public String fetchAccessToken() {
        OAuthData oAuthData = this.oAuthData.get();
        if (oAuthData == null) {
            return null;
        }
        OAuthData lastOAuthData = oAuthData;
        Credential credential = lastOAuthData.getCredential();
        if (credential.getExpiresInSeconds() <= 30L) {
            lastOAuthData.getCredential().refreshToken();
        }
        return credential.getAccessToken();
    }

    @Nullable
    public Credential getCredential() {
        OAuthData oAuthData = this.oAuthData.get();
        return oAuthData != null ? oAuthData.getCredential() : null;
    }

    private final Credential makeCredential(String accessToken, String refreshToken, long accessTokenExpiryTimeInSeconds) {
        Credential.Builder builder;
        Credential.Builder $this$makeCredential_u24lambda_u240 = builder = new Credential.Builder(BearerToken.authorizationHeaderAccessMethod());
        boolean bl = false;
        $this$makeCredential_u24lambda_u240.setTokenServerEncodedUrl(this.authMetadata.getTokenEndpoint());
        $this$makeCredential_u24lambda_u240.setJsonFactory(jsonFactory);
        $this$makeCredential_u24lambda_u240.setTransport(this.transport);
        $this$makeCredential_u24lambda_u240.setClientAuthentication((HttpExecuteInterceptor)new ClientParametersAuthentication(this.authMetadata.getClientId(), this.authMetadata.getClientSecret()));
        Credential credential = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)credential, (String)"build(...)");
        Credential cred = credential;
        cred.setAccessToken(accessToken);
        cred.setRefreshToken(refreshToken);
        cred.setExpiresInSeconds(Long.valueOf(accessTokenExpiryTimeInSeconds));
        return cred;
    }

    private final void updateUserCredentials(TokenResponse tokenResponse) {
        String string = tokenResponse.getAccessToken();
        String string2 = tokenResponse.getRefreshToken();
        Long l2 = tokenResponse.getExpiresInSeconds();
        Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"getExpiresInSeconds(...)");
        OAuthData newOAuthData = new OAuthData(this.makeCredential(string, string2, ((Number)l2).longValue()));
        this.oAuthData.updateAndGet(arg_0 -> McpLoginState.updateUserCredentials$lambda$1(newOAuthData, arg_0));
    }

    private static final OAuthData updateUserCredentials$lambda$1(OAuthData $newOAuthData, OAuthData it) {
        return $newOAuthData;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/google/aiplugin/mcp/auth/McpLoginState$Companion;", "", "<init>", "()V", "jsonFactory", "Lcom/google/api/client/json/JsonFactory;", "getJsonFactory$aiplugin_mcp_client_sdkcompat", "()Lcom/google/api/client/json/JsonFactory;", "extractEmail", "", "authResponse", "Lcom/google/api/client/auth/oauth2/TokenResponse;", "loginAndCreate", "Lcom/google/aiplugin/mcp/auth/McpLoginState;", "authMetadata", "Lcom/google/aiplugin/mcp/auth/AuthMetadata;", "transport", "Lcom/google/api/client/http/HttpTransport;", "oAuthServer", "Lcom/google/aiplugin/mcp/auth/OAuthServer;", "aiplugin.mcp.client.sdkcompat"})
    @SourceDebugExtension(value={"SMAP\nMcpLoginState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpLoginState.kt\ncom/google/aiplugin/mcp/auth/McpLoginState$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,165:1\n1#2:166\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JsonFactory getJsonFactory$aiplugin_mcp_client_sdkcompat() {
            return jsonFactory;
        }

        private final String extractEmail(TokenResponse authResponse) {
            Object object = authResponse.get((Object)"id_token");
            String string = object instanceof String ? (String)object : null;
            if (string == null) {
                return null;
            }
            String idToken = string;
            try {
                IdToken.Payload payload = IdToken.parse((JsonFactory)this.getJsonFactory$aiplugin_mcp_client_sdkcompat(), (String)idToken).getPayload();
                object = payload.get((Object)"email");
                return object instanceof String ? (String)object : null;
            }
            catch (IOException e) {
                McpLoginStateKt.access$getLogger().warn("Couldn't parse JWS", (Throwable)e);
                return null;
            }
        }

        @Nullable
        public final McpLoginState loginAndCreate(@NotNull AuthMetadata authMetadata, @NotNull HttpTransport transport, @NotNull OAuthServer oAuthServer) {
            Intrinsics.checkNotNullParameter((Object)authMetadata, (String)"authMetadata");
            Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
            Intrinsics.checkNotNullParameter((Object)oAuthServer, (String)"oAuthServer");
            Ref.ObjectRef loginState = new Ref.ObjectRef();
            McpUiFacade uiFacade = new McpUiFacade(authMetadata.getClientId(), authMetadata.getAuthorizationEndpoint());
            boolean success = uiFacade.interactWithBrowser(CollectionsKt.toList((Iterable)authMetadata.getScopes()), (Function1<? super AuthorizationCodeHolder, ? extends Credential>)((Function1)arg_0 -> Companion.loginAndCreate$lambda$1(oAuthServer, transport, authMetadata, loginState, arg_0)));
            return success ? (McpLoginState)loginState.element : null;
        }

        private static final Credential loginAndCreate$lambda$1(OAuthServer $oAuthServer, HttpTransport $transport, AuthMetadata $authMetadata, Ref.ObjectRef $loginState, AuthorizationCodeHolder authorizationCodeHolder) {
            McpLoginState mcpLoginState;
            Intrinsics.checkNotNullParameter((Object)authorizationCodeHolder, (String)"authorizationCodeHolder");
            TokenResponse authResponse = $oAuthServer.getToken(authorizationCodeHolder);
            McpLoginState it = mcpLoginState = new McpLoginState($transport, $oAuthServer, $authMetadata, authResponse);
            boolean bl = false;
            $loginState.element = it;
            return mcpLoginState.getCredential();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/google/aiplugin/mcp/auth/McpLoginState$OAuthData;", "", "credential", "Lcom/google/api/client/auth/oauth2/Credential;", "<init>", "(Lcom/google/api/client/auth/oauth2/Credential;)V", "getCredential", "()Lcom/google/api/client/auth/oauth2/Credential;", "aiplugin.mcp.client.sdkcompat"})
    @StabilityInferred(parameters=0)
    public static class OAuthData {
        @NotNull
        private final Credential credential;
        public static final int $stable = 8;

        public OAuthData(@NotNull Credential credential) {
            Intrinsics.checkNotNullParameter((Object)credential, (String)"credential");
            this.credential = credential;
        }

        @NotNull
        public final Credential getCredential() {
            return this.credential;
        }
    }
}

