/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.rag.bm25;

import com.android.studio.ml.MetricsReporter;
import com.android.studio.ml.RagEvent;
import com.android.studio.ml.bot.StudioBotFlags;
import com.google.aiplugin.agents.BasicToolIcon;
import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolArgument;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.google.aiplugin.rag.bm25.Bm25Indexer;
import com.google.aiplugin.rag.bm25.Bm25IndexerImpl;
import com.google.aiplugin.rag.bm25.Bm25SearchTool$Args$;
import com.google.aiplugin.rag.bm25.CodeAnalyzer;
import com.google.aiplugin.rag.internal.IndexerMode;
import com.google.aiplugin.rag.internal.RagIndexer;
import com.google.aiplugin.rag.internal.RagReranker;
import com.google.aiplugin.rag.internal.RagSearchToolResult;
import com.google.aiplugin.rag.lucene.LuceneIndexWriterManagerService;
import com.google.gson.Gson;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.Closeable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KParameter;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.similarities.BM25Similarity;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ToolDescription(summary="Searches an index of the user's code base", description="The index is created by Lucene, and contains a field for the file name and one for its contents.", instructions="Use this tool when answering the user's query requires first searching through the codebase\nin natural language. When using this tool, if there are not enough results, consider widening the\nsearch terms and search again. Once relevant files are found, use read_file tool to read those files\nas appropriate.", examples={})
@ToolResult(description="Returns up to 50 file paths that match the given query.")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u001a\u001b\u001cB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\"\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Lcom/google/aiplugin/rag/bm25/Bm25SearchTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/google/aiplugin/rag/bm25/Bm25SearchTool$Args;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "icon", "Lcom/google/aiplugin/agents/BasicToolIcon;", "getIcon", "()Lcom/google/aiplugin/agents/BasicToolIcon;", "getRunningDisplayText", "args", "getCompletedDisplayText", "createHandler", "Lcom/google/aiplugin/rag/bm25/Bm25SearchTool$Handler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "restoreHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "project", "Lcom/intellij/openapi/project/Project;", "response", "Lcom/google/aiplugin/agents/Response;", "Args", "Handler", "Companion", "aiplugin.rag.indexer"})
public class Bm25SearchTool
implements Tool<Args> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final BasicToolIcon icon = BasicToolIcon.SEARCH;

    public Bm25SearchTool() {
        this.name = "code_search";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public BasicToolIcon getIcon() {
        return this.icon;
    }

    @Override
    @NotNull
    public String getRunningDisplayText(@NotNull Args args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Searching the codebase";
    }

    @Override
    @NotNull
    public String getCompletedDisplayText(@NotNull Args args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Searched the codebase";
    }

    @NotNull
    public Handler createHandler(@NotNull ToolContext context2, @NotNull Args args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new Handler(context2, args);
    }

    @Override
    @Nullable
    public ToolHandler restoreHandler(@NotNull Project project2, @NotNull Args args, @NotNull Response response2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        return null;
    }

    @Override
    @Nullable
    public String getStatusMessage() {
        return Tool.super.getStatusMessage();
    }

    @Override
    @Nullable
    public Map<KParameter, ToolArgument> getToolArguments() {
        return Tool.super.getToolArguments();
    }

    @Override
    @NotNull
    public ToolDescription getToolDescription() {
        return Tool.super.getToolDescription();
    }

    @Override
    @Nullable
    public ToolResult getToolResult() {
        return Tool.super.getToolResult();
    }

    @Override
    @NotNull
    public String getDescription() {
        return Tool.super.getDescription();
    }

    @Serializable
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001d\u001eB\u0017\u0012\u000e\b\u0001\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B+\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\u000f\u001a\u00020\u00002\u000e\b\u0003\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\bH\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0004H\u00d6\u0001J%\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0001\u00a2\u0006\u0002\b\u001cR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001f"}, d2={"Lcom/google/aiplugin/rag/bm25/Bm25SearchTool$Args;", "", "terms", "", "", "<init>", "(Ljava/util/List;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/util/List;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getTerms", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$aiplugin_rag_indexer", "$serializer", "Companion", "aiplugin.rag.indexer"})
    public static final class Args {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final List<String> terms;
        @JvmField
        @NotNull
        private static final Lazy<KSerializer<Object>>[] $childSerializers;

        public Args(@ToolArgument(description="List of string terms that should be present in the file content.") @NotNull List<String> terms) {
            Intrinsics.checkNotNullParameter(terms, (String)"terms");
            this.terms = terms;
        }

        @NotNull
        public final List<String> getTerms() {
            return this.terms;
        }

        @NotNull
        public final List<String> component1() {
            return this.terms;
        }

        @NotNull
        public final Args copy(@ToolArgument(description="List of string terms that should be present in the file content.") @NotNull List<String> terms) {
            Intrinsics.checkNotNullParameter(terms, (String)"terms");
            return new Args(terms);
        }

        public static /* synthetic */ Args copy$default(Args args, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = args.terms;
            }
            return args.copy(list);
        }

        @NotNull
        public String toString() {
            return "Args(terms=" + this.terms + ")";
        }

        public int hashCode() {
            return ((Object)this.terms).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Args)) {
                return false;
            }
            Args args = (Args)other;
            return Intrinsics.areEqual(this.terms, args.terms);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$aiplugin_rag_indexer(Args self, CompositeEncoder output, SerialDescriptor serialDesc) {
            Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
            output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)lazyArray[0].getValue(), self.terms);
        }

        public /* synthetic */ Args(int seen0, List terms, SerializationConstructorMarker serializationConstructorMarker) {
            if (1 != (1 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)Args$$serializer.INSTANCE.getDescriptor());
            }
            this.terms = terms;
        }

        public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            Lazy[] lazyArray = new Lazy[]{LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)StringSerializer.INSTANCE))};
            $childSerializers = lazyArray;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/google/aiplugin/rag/bm25/Bm25SearchTool$Args$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/google/aiplugin/rag/bm25/Bm25SearchTool$Args;", "aiplugin.rag.indexer"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Args> serializer() {
                return (KSerializer)Args$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\u0006\u0010\r\u001a\u00020\u00052\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ2\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0014\u0010\u0014\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0016\u0012\u0004\u0012\u0002H\u00110\u0015H\u0082\b\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/google/aiplugin/rag/bm25/Bm25SearchTool$Companion;", "", "<init>", "()V", "buildSearchQuery", "Lorg/apache/lucene/search/Query;", "terms", "", "", "analyzer", "Lorg/apache/lucene/analysis/Analyzer;", "bm25Search", "", "query", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "withIndex", "T", "indexPath", "Ljava/nio/file/Path;", "block", "Lkotlin/Function1;", "Lorg/apache/lucene/index/DirectoryReader;", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "aiplugin.rag.indexer"})
    @SourceDebugExtension(value={"SMAP\nBm25SearchTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Bm25SearchTool.kt\ncom/google/aiplugin/rag/bm25/Bm25SearchTool$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,165:1\n158#1,2:166\n161#1:173\n162#1:175\n1#2:168\n1#2:174\n11228#3:169\n11563#3,3:170\n*S KotlinDebug\n*F\n+ 1 Bm25SearchTool.kt\ncom/google/aiplugin/rag/bm25/Bm25SearchTool$Companion\n*L\n139#1:166,2\n139#1:173\n139#1:175\n139#1:174\n147#1:169\n147#1:170,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Query buildSearchQuery(List<String> terms, Analyzer analyzer) {
            BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
            String query = CollectionsKt.joinToString$default((Iterable)terms, (CharSequence)" OR ", null, null, (int)0, null, Companion::buildSearchQuery$lambda$0, (int)30, null);
            Query filePathQuery = new QueryParser("vfile.path", analyzer).parse(query);
            booleanQuery.add(filePathQuery, BooleanClause.Occur.SHOULD);
            Query contentQuery = new QueryParser("vfile.contents", analyzer).parse(query);
            booleanQuery.add(contentQuery, BooleanClause.Occur.SHOULD);
            BooleanQuery booleanQuery2 = booleanQuery.build();
            Intrinsics.checkNotNullExpressionValue((Object)booleanQuery2, (String)"build(...)");
            return (Query)booleanQuery2;
        }

        static /* synthetic */ Query buildSearchQuery$default(Companion companion, List list, Analyzer analyzer, int n, Object object) {
            if ((n & 2) != 0) {
                analyzer = new CodeAnalyzer(null, 1, null);
            }
            return companion.buildSearchQuery(list, analyzer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final List<Integer> bm25Search(@NotNull Query query, @Nullable Logger logger) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            RagIndexer ragIndexer = RagIndexer.Companion.getInstance();
            Bm25Indexer bm25Indexer = ragIndexer instanceof Bm25Indexer ? (Bm25Indexer)ragIndexer : null;
            if (bm25Indexer == null) {
                return CollectionsKt.emptyList();
            }
            Bm25Indexer bm25IndexerService = bm25Indexer;
            try {
                List list;
                object = this;
                Path indexPath$iv = bm25IndexerService.getIndexDirectory();
                boolean $i$f$withIndex = false;
                if (StudioBotFlags.Companion.getInstance().useLucindexForRag()) {
                    Closeable closeable = (Closeable)LuceneIndexWriterManagerService.Companion.getInstance().getIndexReader(indexPath$iv);
                    Throwable throwable = null;
                    try {
                        List list2;
                        DirectoryReader index = (DirectoryReader)closeable;
                        boolean bl = false;
                        if (index == null) {
                            list2 = CollectionsKt.emptyList();
                        } else {
                            void $this$mapTo$iv$iv;
                            IndexSearcher indexSearcher;
                            Logger logger2 = logger;
                            if (logger2 != null) {
                                logger2.debug("Searching index version " + index.getVersion() + ", #docs " + index.numDocs());
                            }
                            IndexSearcher it = indexSearcher = new IndexSearcher((IndexReader)index);
                            boolean bl2 = false;
                            it.setSimilarity((Similarity)new BM25Similarity());
                            IndexSearcher searcher = indexSearcher;
                            int maxHits = 200;
                            Intrinsics.checkNotNullExpressionValue((Object)searcher.search((Query)query, (int)maxHits).scoreDocs, (String)"scoreDocs");
                            Object[] $this$map$iv = searcher.search((Query)query, (int)maxHits).scoreDocs;
                            boolean $i$f$map = false;
                            Object[] objectArray = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                            boolean $i$f$mapTo = false;
                            for (void item$iv$iv : $this$mapTo$iv$iv) {
                                void scoreDoc;
                                ScoreDoc scoreDoc2 = (ScoreDoc)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl3 = false;
                                collection.add(Bm25IndexerImpl.Companion.getFileIdForDoc$aiplugin_rag_indexer(searcher, scoreDoc.doc));
                            }
                            list2 = (List)destination$iv$iv;
                        }
                        List list3 = list2;
                        list = list3;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                Closeable closeable = (Closeable)FSDirectory.open((Path)indexPath$iv);
                Throwable throwable = null;
                try {
                    List list4;
                    FSDirectory dir$iv = (FSDirectory)closeable;
                    boolean bl = false;
                    Closeable closeable2 = (Closeable)DirectoryReader.open((Directory)((Directory)dir$iv));
                    Throwable throwable3 = null;
                    try {
                        List list5;
                        DirectoryReader index = (DirectoryReader)closeable2;
                        boolean bl4 = false;
                        if (index == null) {
                            list5 = CollectionsKt.emptyList();
                        } else {
                            IndexSearcher maxHits;
                            Logger logger3 = logger;
                            if (logger3 != null) {
                                logger3.debug("Searching index version " + index.getVersion() + ", #docs " + index.numDocs());
                            }
                            IndexSearcher it = maxHits = new IndexSearcher((IndexReader)index);
                            boolean bl5 = false;
                            it.setSimilarity((Similarity)new BM25Similarity());
                            IndexSearcher searcher = maxHits;
                            int maxHits2 = 200;
                            Intrinsics.checkNotNullExpressionValue((Object)searcher.search((Query)query, (int)maxHits2).scoreDocs, (String)"scoreDocs");
                            Object[] $this$map$iv = searcher.search((Query)query, (int)maxHits2).scoreDocs;
                            boolean $i$f$map = false;
                            Object[] $this$mapTo$iv$iv = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                            boolean $i$f$mapTo = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                ScoreDoc scoreDoc = (ScoreDoc)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl6 = false;
                                collection.add(Bm25IndexerImpl.Companion.getFileIdForDoc$aiplugin_rag_indexer(searcher, scoreDoc.doc));
                            }
                            list5 = (List)destination$iv$iv;
                        }
                        list4 = list5;
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable3);
                    }
                    List list6 = list4;
                    list = list6;
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                object = list;
            }
            catch (Exception e) {
                Logger logger4 = logger;
                if (logger4 != null) {
                    logger4.warn("Error opening lucene index", (Throwable)e);
                }
                object = CollectionsKt.emptyList();
            }
            return object;
        }

        public static /* synthetic */ List bm25Search$default(Companion companion, Query query, Logger logger, int n, Object object) {
            if ((n & 2) != 0) {
                logger = null;
            }
            return companion.bm25Search(query, logger);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final <T> T withIndex(Path indexPath, Function1<? super DirectoryReader, ? extends T> block) {
            Object object;
            boolean $i$f$withIndex = false;
            if (StudioBotFlags.Companion.getInstance().useLucindexForRag()) {
                Closeable closeable = (Closeable)LuceneIndexWriterManagerService.Companion.getInstance().getIndexReader(indexPath);
                Throwable throwable = null;
                try {
                    Object object2 = block.invoke((Object)closeable);
                    object = object2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    InlineMarker.finallyStart((int)1);
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    InlineMarker.finallyEnd((int)1);
                }
            }
            Closeable closeable = (Closeable)FSDirectory.open((Path)indexPath);
            Throwable throwable = null;
            try {
                Object object3;
                FSDirectory dir = (FSDirectory)closeable;
                boolean bl = false;
                Closeable closeable2 = (Closeable)DirectoryReader.open((Directory)((Directory)dir));
                Throwable throwable3 = null;
                try {
                    object3 = block.invoke((Object)closeable2);
                }
                catch (Throwable throwable4) {
                    throwable3 = throwable4;
                    throw throwable4;
                }
                finally {
                    InlineMarker.finallyStart((int)1);
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable3);
                    InlineMarker.finallyEnd((int)1);
                }
                Object object4 = object3;
                object = object4;
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                InlineMarker.finallyEnd((int)1);
            }
            return (T)object;
        }

        private static final CharSequence buildSearchQuery$lambda$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            String string = QueryParser.escape((String)it);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escape(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0011\u001a\u00020\u0012H\u0096@\u00a2\u0006\u0002\u0010\u0013R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/google/aiplugin/rag/bm25/Bm25SearchTool$Handler;", "Lcom/google/aiplugin/agents/ToolHandler;", "Lcom/google/aiplugin/rag/internal/RagReranker;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "args", "Lcom/google/aiplugin/rag/bm25/Bm25SearchTool$Args;", "<init>", "(Lcom/google/aiplugin/agents/tools/ToolContext;Lcom/google/aiplugin/rag/bm25/Bm25SearchTool$Args;)V", "getContext", "()Lcom/google/aiplugin/agents/tools/ToolContext;", "getArgs", "()Lcom/google/aiplugin/rag/bm25/Bm25SearchTool$Args;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "handle", "Lcom/google/aiplugin/agents/Response;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "aiplugin.rag.indexer"})
    @SourceDebugExtension(value={"SMAP\nBm25SearchTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Bm25SearchTool.kt\ncom/google/aiplugin/rag/bm25/Bm25SearchTool$Handler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,165:1\n24#2:166\n1563#3:167\n1634#3,3:168\n*S KotlinDebug\n*F\n+ 1 Bm25SearchTool.kt\ncom/google/aiplugin/rag/bm25/Bm25SearchTool$Handler\n*L\n85#1:166\n103#1:167\n103#1:168,3\n*E\n"})
    public static class Handler
    implements ToolHandler,
    RagReranker {
        @NotNull
        private final ToolContext context;
        @NotNull
        private final Args args;
        @NotNull
        private final Logger logger;

        public Handler(@NotNull ToolContext context2, @NotNull Args args) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.context = context2;
            this.args = args;
            Handler $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(Handler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            this.logger = logger;
        }

        @NotNull
        public final ToolContext getContext() {
            return this.context;
        }

        @NotNull
        public final Args getArgs() {
            return this.args;
        }

        @Override
        @NotNull
        public Logger getLogger() {
            return this.logger;
        }

        @Override
        @Nullable
        public Object handle(@NotNull Continuation<? super Response> $completion) {
            return Handler.handle$suspendImpl(this, $completion);
        }

        static /* synthetic */ Object handle$suspendImpl(Handler $this, Continuation<? super Response> $completion) {
            if (!(RagIndexer.Companion.getInstance() instanceof Bm25Indexer)) {
                $this.getLogger().warn("Bm25 Indexer is not active");
                MetricsReporter.Companion.getInstance().logRagEvent(new RagEvent.RagToolMetrics("IndexerInactive(" + IndexerMode.BM25.getModeName() + ")", 0, 0, 0, 0L, 30, null));
                return new Response(null, "code search is disabled", null, null, null, 29, null);
            }
            return CoroutinesKt.readAction(() -> Handler.handle$lambda$1($this), $completion);
        }

        @Override
        @Nullable
        public <T> Object rerank(@NotNull List<Integer> fileIds, @NotNull Function1<? super Integer, ? extends T> converter, @NotNull List<? extends Function2<? super List<? extends T>, ? super Continuation<? super List<? extends T>>, ? extends Object>> rankers, int topK, @NotNull Continuation<? super List<? extends T>> $completion) {
            return RagReranker.super.rerank(fileIds, converter, rankers, topK, $completion);
        }

        @Override
        @Nullable
        public Object rerankInVirtualFileId(@NotNull List<Integer> fileIds, @NotNull Project project2, @NotNull List<? extends Function2<? super List<? extends VirtualFile>, ? super Continuation<? super List<? extends VirtualFile>>, ? extends Object>> rankers, int topK, @NotNull Continuation<? super List<? extends VirtualFile>> $completion) {
            return RagReranker.super.rerankInVirtualFileId(fileIds, project2, rankers, topK, $completion);
        }

        @Override
        @Nullable
        public Object rerankInVirtualFiles(@NotNull List<? extends VirtualFile> files2, @NotNull Project project2, @NotNull List<? extends Function2<? super List<? extends VirtualFile>, ? super Continuation<? super List<? extends VirtualFile>>, ? extends Object>> rankers, int topK, @NotNull Continuation<? super List<? extends VirtualFile>> $completion) {
            return RagReranker.super.rerankInVirtualFiles(files2, project2, rankers, topK, $completion);
        }

        /*
         * WARNING - void declaration
         */
        private static final Response handle$lambda$1(Handler this$0) {
            void $this$mapTo$iv$iv;
            Query query = com.google.aiplugin.rag.bm25.Bm25SearchTool$Companion.buildSearchQuery$default(Companion, this$0.args.getTerms(), null, 2, null);
            List<Integer> docIds = Companion.bm25Search(query, this$0.getLogger());
            Cancellation.ensureActive();
            List projectFiles2 = (List)com.intellij.openapi.progress.CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends VirtualFile>>, Object>(this$0, docIds, null){
                int label;
                final /* synthetic */ Handler this$0;
                final /* synthetic */ List<Integer> $docIds;
                {
                    this.this$0 = $receiver;
                    this.$docIds = $docIds;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = RagReranker.rerankInVirtualFileId$default(this.this$0, this.$docIds, this.this$0.getContext().getProject(), null, 0, (Continuation)this, 12, null);
                            if (object3 != object2) return object3;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super List<? extends VirtualFile>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
            Cancellation.ensureActive();
            Iterable $this$map$iv = projectFiles2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFile virtualFile2 = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                collection.add(string);
            }
            List list = (List)destination$iv$iv;
            RagSearchToolResult result2 = new RagSearchToolResult(list);
            return new Response(new Gson().toJson((Object)result2), null, null, null, null, 30, null);
        }
    }
}

