/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.rag.bm25;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.util.AttributeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001c\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001aH\u0002R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \b*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \b*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/google/aiplugin/rag/bm25/CamelCaseSplitterFilter;", "Lorg/apache/lucene/analysis/TokenFilter;", "input", "Lorg/apache/lucene/analysis/TokenStream;", "<init>", "(Lorg/apache/lucene/analysis/TokenStream;)V", "termAtt", "Lorg/apache/lucene/analysis/tokenattributes/CharTermAttribute;", "kotlin.jvm.PlatformType", "posIncAtt", "Lorg/apache/lucene/analysis/tokenattributes/PositionIncrementAttribute;", "posLenAtt", "Lorg/apache/lucene/analysis/tokenattributes/PositionLengthAttribute;", "keywordAtt", "Lorg/apache/lucene/analysis/tokenattributes/KeywordAttribute;", "bufferedTokens", "Ljava/util/LinkedList;", "Lcom/google/aiplugin/rag/bm25/CamelCaseSplitterFilter$BufferedToken;", "originalTokenState", "Lorg/apache/lucene/util/AttributeSource$State;", "incrementToken", "", "reset", "", "splitCamelCase", "", "", "term", "BufferedToken", "Companion", "aiplugin.rag.indexer"})
@SourceDebugExtension(value={"SMAP\nCamelCaseSplitterFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CamelCaseSplitterFilter.kt\ncom/google/aiplugin/rag/bm25/CamelCaseSplitterFilter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,186:1\n1#2:187\n1088#3,2:188\n975#3:190\n1046#3,3:191\n1878#4,3:194\n*S KotlinDebug\n*F\n+ 1 CamelCaseSplitterFilter.kt\ncom/google/aiplugin/rag/bm25/CamelCaseSplitterFilter\n*L\n79#1:188,2\n136#1:190\n136#1:191,3\n140#1:194,3\n*E\n"})
public final class CamelCaseSplitterFilter
extends TokenFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final CharTermAttribute termAtt;
    private final PositionIncrementAttribute posIncAtt;
    private final PositionLengthAttribute posLenAtt;
    private final KeywordAttribute keywordAtt;
    @NotNull
    private final LinkedList<BufferedToken> bufferedTokens;
    @Nullable
    private AttributeSource.State originalTokenState;

    public CamelCaseSplitterFilter(@NotNull TokenStream input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        super(input);
        this.termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        this.posIncAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
        this.posLenAtt = (PositionLengthAttribute)this.addAttribute(PositionLengthAttribute.class);
        this.keywordAtt = (KeywordAttribute)this.addAttribute(KeywordAttribute.class);
        this.bufferedTokens = new LinkedList();
    }

    public boolean incrementToken() throws IOException {
        boolean bl;
        String term;
        block8: {
            if (!((Collection)this.bufferedTokens).isEmpty()) {
                this.clearAttributes();
                AttributeSource.State state2 = this.originalTokenState;
                if (state2 != null) {
                    AttributeSource.State it = state2;
                    boolean bl2 = false;
                    this.restoreState(it);
                }
                BufferedToken buffered = this.bufferedTokens.removeFirst();
                this.termAtt.setEmpty().append(buffered.getTerm());
                this.posIncAtt.setPositionIncrement(buffered.getPosInc());
                this.posLenAtt.setPositionLength(buffered.getPosLen());
                return true;
            }
            if (!this.input.incrementToken()) {
                return false;
            }
            if (this.keywordAtt.isKeyword()) {
                return true;
            }
            term = this.termAtt.toString();
            CharSequence $this$any$iv = term;
            boolean $i$f$any = false;
            for (int bl2 = 0; bl2 < $this$any$iv.length(); ++bl2) {
                char element$iv;
                char it = element$iv = $this$any$iv.charAt(bl2);
                boolean bl3 = false;
                if (!(!Character.isLetter(it))) continue;
                bl = true;
                break block8;
            }
            bl = false;
        }
        if (bl) {
            return true;
        }
        List<String> subwords = this.splitCamelCase(term);
        if (subwords.size() > 1) {
            this.originalTokenState = this.captureState();
            int originalPosInc = this.posIncAtt.getPositionIncrement();
            this.bufferedTokens.add(new BufferedToken(term, originalPosInc, subwords.size()));
            int currentOffset = 0;
            boolean firstSubword = true;
            for (String subword : subwords) {
                int posInc = firstSubword ? 0 : 1;
                this.bufferedTokens.add(new BufferedToken(subword, posInc, 1));
                currentOffset += subword.length();
                firstSubword = false;
            }
            return this.incrementToken();
        }
        return true;
    }

    public void reset() throws IOException {
        super.reset();
        this.bufferedTokens.clear();
        this.originalTokenState = null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> splitCamelCase(String term) {
        void $this$mapTo$iv$iv;
        int n;
        if (((CharSequence)term).length() == 0) {
            return CollectionsKt.emptyList();
        }
        List parts = new ArrayList();
        int wordStart = 0;
        CharSequence $this$map$iv = term;
        boolean $i$f$map = false;
        CharSequence charSequence = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length());
        boolean $i$f$mapTo = false;
        for (n = 0; n < $this$mapTo$iv$iv.length(); ++n) {
            void it;
            char item$iv$iv;
            char c = item$iv$iv = $this$mapTo$iv$iv.charAt(n);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(CamelCaseSplitterFilter.Companion.getType((char)it));
        }
        List charTypes = (List)destination$iv$iv;
        Iterable $this$forEachIndexed$iv = CollectionsKt.zipWithNext((Iterable)charTypes);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pair pair = (Pair)item$iv;
            int i2 = n;
            boolean bl = false;
            Companion.CharType prevType = (Companion.CharType)((Object)pair.component1());
            Companion.CharType currentType = (Companion.CharType)((Object)pair.component2());
            if (prevType == Companion.CharType.LOWER && currentType == Companion.CharType.UPPER) {
                String string = term.substring(wordStart, i2 + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                parts.add(string);
                wordStart = i2 + 1;
                continue;
            }
            if (prevType != Companion.CharType.UPPER || currentType != Companion.CharType.LOWER || i2 - wordStart <= 1) continue;
            String string = term.substring(wordStart, i2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            parts.add(string);
            wordStart = i2;
        }
        if (wordStart < term.length()) {
            String string = term.substring(wordStart);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            parts.add(string);
        }
        return parts;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/google/aiplugin/rag/bm25/CamelCaseSplitterFilter$BufferedToken;", "", "term", "", "posInc", "", "posLen", "<init>", "(Ljava/lang/String;II)V", "getTerm", "()Ljava/lang/String;", "getPosInc", "()I", "getPosLen", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "aiplugin.rag.indexer"})
    private static final class BufferedToken {
        @NotNull
        private final String term;
        private final int posInc;
        private final int posLen;

        public BufferedToken(@NotNull String term, int posInc, int posLen) {
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            this.term = term;
            this.posInc = posInc;
            this.posLen = posLen;
        }

        @NotNull
        public final String getTerm() {
            return this.term;
        }

        public final int getPosInc() {
            return this.posInc;
        }

        public final int getPosLen() {
            return this.posLen;
        }

        @NotNull
        public final String component1() {
            return this.term;
        }

        public final int component2() {
            return this.posInc;
        }

        public final int component3() {
            return this.posLen;
        }

        @NotNull
        public final BufferedToken copy(@NotNull String term, int posInc, int posLen) {
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            return new BufferedToken(term, posInc, posLen);
        }

        public static /* synthetic */ BufferedToken copy$default(BufferedToken bufferedToken, String string, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = bufferedToken.term;
            }
            if ((n3 & 2) != 0) {
                n = bufferedToken.posInc;
            }
            if ((n3 & 4) != 0) {
                n2 = bufferedToken.posLen;
            }
            return bufferedToken.copy(string, n, n2);
        }

        @NotNull
        public String toString() {
            return "BufferedToken(term=" + this.term + ", posInc=" + this.posInc + ", posLen=" + this.posLen + ")";
        }

        public int hashCode() {
            int result2 = this.term.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.posInc);
            result2 = result2 * 31 + Integer.hashCode(this.posLen);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BufferedToken)) {
                return false;
            }
            BufferedToken bufferedToken = (BufferedToken)other;
            if (!Intrinsics.areEqual((Object)this.term, (Object)bufferedToken.term)) {
                return false;
            }
            if (this.posInc != bufferedToken.posInc) {
                return false;
            }
            return this.posLen == bufferedToken.posLen;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/google/aiplugin/rag/bm25/CamelCaseSplitterFilter$Companion;", "", "<init>", "()V", "getType", "Lcom/google/aiplugin/rag/bm25/CamelCaseSplitterFilter$Companion$CharType;", "ch", "", "CharType", "aiplugin.rag.indexer"})
    public static final class Companion {
        private Companion() {
        }

        private final CharType getType(char ch) {
            return Character.isUpperCase(ch) ? CharType.UPPER : (Character.isLowerCase(ch) ? CharType.LOWER : CharType.OTHER);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/google/aiplugin/rag/bm25/CamelCaseSplitterFilter$Companion$CharType;", "", "<init>", "(Ljava/lang/String;I)V", "UPPER", "LOWER", "OTHER", "aiplugin.rag.indexer"})
        private static final class CharType
        extends Enum<CharType> {
            public static final /* enum */ CharType UPPER = new CharType();
            public static final /* enum */ CharType LOWER = new CharType();
            public static final /* enum */ CharType OTHER = new CharType();
            private static final /* synthetic */ CharType[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static CharType[] values() {
                return (CharType[])$VALUES.clone();
            }

            public static CharType valueOf(String value) {
                return Enum.valueOf(CharType.class, value);
            }

            @NotNull
            public static EnumEntries<CharType> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = charTypeArray = new CharType[]{CharType.UPPER, CharType.LOWER, CharType.OTHER};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }
}

