/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.rag.internal;

import com.google.aiplugin.rag.internal.IndexerMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0007J\f\u0010\u0012\u001a\u00020\u0007*\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000fR\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/google/aiplugin/rag/internal/IndexerModeProvider;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "currentMode", "Lcom/google/aiplugin/rag/internal/IndexerMode;", "getCurrentMode", "()Lcom/google/aiplugin/rag/internal/IndexerMode;", "overrideMode", "Lcom/intellij/openapi/Disposable;", "newMode", "isBm25Mode", "", "()Z", "isEmbeddingMode", "DEFAULT_MODE", "orDefaultInProduction", "RAG_INDEX_PROPERTY_KEY", "", "COMMON_DESCRIPTION", "aiplugin.rag.indexer"})
@SourceDebugExtension(value={"SMAP\nIndexerModeProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexerModeProvider.kt\ncom/google/aiplugin/rag/internal/IndexerModeProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,96:1\n24#2:97\n*S KotlinDebug\n*F\n+ 1 IndexerModeProvider.kt\ncom/google/aiplugin/rag/internal/IndexerModeProvider\n*L\n25#1:97\n*E\n"})
public final class IndexerModeProvider {
    @NotNull
    public static final IndexerModeProvider INSTANCE;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final IndexerMode DEFAULT_MODE;
    @NotNull
    public static final String RAG_INDEX_PROPERTY_KEY = "gemini.rag.index";
    @NotNull
    public static final String COMMON_DESCRIPTION = "Use this tool when answering the user's query requires first searching through the codebase\nin natural language. When using this tool, if there are not enough results, consider widening the\nsearch terms and search again. Once relevant files are found, use read_file tool to read those files\nas appropriate.";

    private IndexerModeProvider() {
    }

    @NotNull
    public final IndexerMode getCurrentMode() {
        String string = System.getProperty(RAG_INDEX_PROPERTY_KEY);
        if (string == null) {
            return DEFAULT_MODE;
        }
        String ragIndexer = string;
        String string2 = ragIndexer;
        return Intrinsics.areEqual((Object)string2, (Object)IndexerMode.BM25.getModeName()) ? IndexerMode.BM25 : (Intrinsics.areEqual((Object)string2, (Object)IndexerMode.EMBEDDING.getModeName()) ? this.orDefaultInProduction(IndexerMode.EMBEDDING) : IndexerMode.NONE);
    }

    @TestOnly
    @NotNull
    public final Disposable overrideMode(@NotNull IndexerMode newMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)newMode), (String)"newMode");
        String oldMode = System.setProperty(RAG_INDEX_PROPERTY_KEY, newMode.getModeName());
        return () -> IndexerModeProvider.overrideMode$lambda$0(oldMode);
    }

    public final boolean isBm25Mode() {
        return this.getCurrentMode() == IndexerMode.BM25;
    }

    public final boolean isEmbeddingMode() {
        return this.getCurrentMode() == IndexerMode.EMBEDDING;
    }

    private final IndexerMode orDefaultInProduction(IndexerMode $this$orDefaultInProduction) {
        IndexerMode indexerMode;
        if (ApplicationManager.getApplication().isInternal()) {
            logger.info("It is in dev mode (or dogfood). " + $this$orDefaultInProduction.getModeName() + " RAG will be used.");
            indexerMode = $this$orDefaultInProduction;
        } else {
            logger.warn("Embedding RAG is not available now. Instead, " + DEFAULT_MODE.getModeName() + " RAG will be used.");
            indexerMode = DEFAULT_MODE;
        }
        return indexerMode;
    }

    private static final void overrideMode$lambda$0(String $oldMode) {
        String string = $oldMode == null ? System.clearProperty(RAG_INDEX_PROPERTY_KEY) : System.setProperty(RAG_INDEX_PROPERTY_KEY, $oldMode);
    }

    static {
        IndexerModeProvider $this$thisLogger$iv = INSTANCE = new IndexerModeProvider();
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(IndexerModeProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        IndexerModeProvider.logger = logger;
        DEFAULT_MODE = IndexerMode.BM25;
    }
}

