/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.rag.internal;

import com.google.aiplugin.rag.bm25.Bm25IndexerImpl;
import com.google.aiplugin.rag.embedding.EmbeddingIndexerImpl;
import com.google.aiplugin.rag.internal.IndexerMode;
import com.google.aiplugin.rag.internal.IndexerModeProvider;
import com.google.aiplugin.rag.internal.RagIndexer;
import com.google.aiplugin.rag.internal.RagIndexerFactory;
import com.google.aiplugin.rag.internal.RagIndexerProvider;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.StackOverflowPreventedException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0002\u0018\u0019B#\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\u0014\u001a\u0004\u0018\u00010\u0011H\u0002J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lcom/google/aiplugin/rag/internal/RagIndexerProviderImpl;", "Lcom/google/aiplugin/rag/internal/RagIndexerProvider;", "Lcom/intellij/openapi/Disposable$Default;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "factorySelector", "Lkotlin/Function0;", "Lcom/google/aiplugin/rag/internal/RagIndexerFactory;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lkotlin/jvm/functions/Function0;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "indexerState", "Lcom/google/aiplugin/rag/internal/RagIndexerProviderImpl$IndexerState;", "indexerStateLock", "", "indexer", "Lcom/google/aiplugin/rag/internal/RagIndexer;", "getIndexer", "()Lcom/google/aiplugin/rag/internal/RagIndexer;", "createIndexer", "rebuildIndexerIfNecessary", "", "clearState", "IndexerState", "Companion", "aiplugin.rag.indexer"})
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nRagIndexerProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RagIndexerProvider.kt\ncom/google/aiplugin/rag/internal/RagIndexerProviderImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n24#2:142\n1#3:143\n*S KotlinDebug\n*F\n+ 1 RagIndexerProvider.kt\ncom/google/aiplugin/rag/internal/RagIndexerProviderImpl\n*L\n51#1:142\n*E\n"})
public final class RagIndexerProviderImpl
implements RagIndexerProvider,
Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final Function0<RagIndexerFactory> factorySelector;
    @NotNull
    private final Logger logger;
    @NotNull
    private volatile IndexerState indexerState;
    @NotNull
    private final Object indexerStateLock;
    @NotNull
    private static final String LAST_INDEXER_KEY_PROPERTY = "com.google.aiplugin.rag.indexer.implementation";

    @JvmOverloads
    public RagIndexerProviderImpl(@NotNull CoroutineScope coroutineScope, @NotNull Function0<? extends RagIndexerFactory> factorySelector) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter(factorySelector, (String)"factorySelector");
        this.coroutineScope = coroutineScope;
        this.factorySelector = factorySelector;
        RagIndexerProviderImpl $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(RagIndexerProviderImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.indexerState = IndexerState.NotReady.INSTANCE;
        this.indexerStateLock = new Object();
    }

    public /* synthetic */ RagIndexerProviderImpl(CoroutineScope coroutineScope, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function0 = RagIndexerProviderImpl::_init_$lambda$0;
        }
        this(coroutineScope, (Function0<? extends RagIndexerFactory>)function0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public RagIndexer getIndexer() {
        IndexerState.Ready ready;
        Object object = this.indexerState;
        IndexerState.Ready ready2 = ready = object instanceof IndexerState.Ready ? (IndexerState.Ready)object : null;
        if (ready != null) {
            IndexerState.Ready it = ready;
            boolean bl = false;
            return it.getIndexer();
        }
        object = this.indexerStateLock;
        synchronized (object) {
            RagIndexer ragIndexer;
            boolean bl = false;
            IndexerState state2 = this.indexerState;
            if (state2 instanceof IndexerState.Ready) {
                ragIndexer = ((IndexerState.Ready)state2).getIndexer();
            } else {
                if (state2 instanceof IndexerState.UnderConstruction) {
                    throw new StackOverflowPreventedException("Tried to access RagIndexer.getInstance() while RagIndexer under construction");
                }
                if (state2 instanceof IndexerState.NotReady) {
                    this.indexerState = IndexerState.UnderConstruction.INSTANCE;
                    RagIndexer indexer2 = this.createIndexer();
                    if (indexer2 instanceof Disposable) {
                        Disposer.register((Disposable)((Disposable)this), (Disposable)((Disposable)indexer2));
                    }
                    this.rebuildIndexerIfNecessary(indexer2);
                    this.indexerState = new IndexerState.Ready(indexer2);
                    ragIndexer = indexer2;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            RagIndexer ragIndexer2 = ragIndexer;
            return ragIndexer2;
        }
    }

    private final RagIndexer createIndexer() {
        RagIndexer ragIndexer;
        RagIndexerFactory factory = (RagIndexerFactory)this.factorySelector.invoke();
        this.logger.info("Selected RagIndexer: " + factory);
        try {
            RagIndexerFactory ragIndexerFactory = factory;
            ragIndexer = ragIndexerFactory != null ? ragIndexerFactory.createIndexer(this.coroutineScope) : null;
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException || e instanceof StackOverflowPreventedException) {
                throw e;
            }
            this.logger.warn("Factory " + factory + " could not create a RagIndexer", (Throwable)e);
            ragIndexer = null;
        }
        return ragIndexer;
    }

    private final void rebuildIndexerIfNecessary(RagIndexer indexer2) {
        String string;
        RagIndexer ragIndexer = indexer2;
        if (ragIndexer != null) {
            RagIndexer it = ragIndexer;
            boolean bl = false;
            string = Reflection.getOrCreateKotlinClass(it.getClass()).getQualifiedName() + "/v" + it.getVersion();
        } else {
            string = null;
        }
        String currentKey = string;
        String previousKey = PropertiesComponent.getInstance().getValue(LAST_INDEXER_KEY_PROPERTY);
        if (!Intrinsics.areEqual((Object)previousKey, (Object)currentKey)) {
            this.logger.info("RagIndexer changed from " + previousKey + " to " + currentKey + " - requesting rebuild");
            RagIndexer ragIndexer2 = indexer2;
            if (ragIndexer2 != null) {
                ragIndexer2.requestIndexRebuild();
            }
            PropertiesComponent.getInstance().setValue(LAST_INDEXER_KEY_PROPERTY, currentKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void clearState() {
        Object object = this.indexerStateLock;
        synchronized (object) {
            boolean bl = false;
            IndexerState state2 = this.indexerState;
            if (state2 instanceof IndexerState.Ready) {
                RagIndexer ragIndexer = ((IndexerState.Ready)state2).getIndexer();
                Disposable disposable = ragIndexer instanceof Disposable ? (Disposable)ragIndexer : null;
                if (disposable != null) {
                    Disposable it = disposable;
                    boolean bl2 = false;
                    Disposer.dispose((Disposable)it);
                }
                this.indexerState = IndexerState.NotReady.INSTANCE;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @JvmOverloads
    public RagIndexerProviderImpl(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this(coroutineScope, null, 2, null);
    }

    private static final RagIndexerFactory _init_$lambda$0() {
        return RagIndexerProviderImpl.Companion.selectFactory();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/google/aiplugin/rag/internal/RagIndexerProviderImpl$Companion;", "", "<init>", "()V", "LAST_INDEXER_KEY_PROPERTY", "", "clearState", "", "selectFactory", "Lcom/google/aiplugin/rag/internal/RagIndexerFactory;", "aiplugin.rag.indexer"})
    @SourceDebugExtension(value={"SMAP\nRagIndexerProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RagIndexerProvider.kt\ncom/google/aiplugin/rag/internal/RagIndexerProviderImpl$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,141:1\n53#2:142\n*S KotlinDebug\n*F\n+ 1 RagIndexerProvider.kt\ncom/google/aiplugin/rag/internal/RagIndexerProviderImpl$Companion\n*L\n130#1:142\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @TestOnly
        public final void clearState() {
            block0: {
                boolean $i$f$serviceIfCreated = false;
                Application application = ApplicationManager.getApplication();
                Object object = application != null ? application.getServiceIfCreated(RagIndexerProvider.class) : null;
                RagIndexerProviderImpl ragIndexerProviderImpl = object instanceof RagIndexerProviderImpl ? (RagIndexerProviderImpl)object : null;
                if (ragIndexerProviderImpl == null) break block0;
                ragIndexerProviderImpl.clearState();
            }
        }

        private final RagIndexerFactory selectFactory() {
            return switch (WhenMappings.$EnumSwitchMapping$0[IndexerModeProvider.INSTANCE.getCurrentMode().ordinal()]) {
                case 1 -> Bm25IndexerImpl.Companion;
                case 2 -> EmbeddingIndexerImpl.Companion;
                case 3 -> null;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[IndexerMode.values().length];
                try {
                    nArray[IndexerMode.BM25.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IndexerMode.EMBEDDING.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IndexerMode.NONE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\u0007\b\t\u00a8\u0006\n"}, d2={"Lcom/google/aiplugin/rag/internal/RagIndexerProviderImpl$IndexerState;", "", "<init>", "()V", "Ready", "UnderConstruction", "NotReady", "Lcom/google/aiplugin/rag/internal/RagIndexerProviderImpl$IndexerState$NotReady;", "Lcom/google/aiplugin/rag/internal/RagIndexerProviderImpl$IndexerState$Ready;", "Lcom/google/aiplugin/rag/internal/RagIndexerProviderImpl$IndexerState$UnderConstruction;", "aiplugin.rag.indexer"})
    private static abstract sealed class IndexerState {
        private IndexerState() {
        }

        public /* synthetic */ IndexerState(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lcom/google/aiplugin/rag/internal/RagIndexerProviderImpl$IndexerState$NotReady;", "Lcom/google/aiplugin/rag/internal/RagIndexerProviderImpl$IndexerState;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "aiplugin.rag.indexer"})
        public static final class NotReady
        extends IndexerState {
            @NotNull
            public static final NotReady INSTANCE = new NotReady();

            private NotReady() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "NotReady";
            }

            public int hashCode() {
                return -1308107002;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NotReady)) {
                    return false;
                }
                NotReady cfr_ignored_0 = (NotReady)other;
                return true;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\t\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/google/aiplugin/rag/internal/RagIndexerProviderImpl$IndexerState$Ready;", "Lcom/google/aiplugin/rag/internal/RagIndexerProviderImpl$IndexerState;", "indexer", "Lcom/google/aiplugin/rag/internal/RagIndexer;", "<init>", "(Lcom/google/aiplugin/rag/internal/RagIndexer;)V", "getIndexer", "()Lcom/google/aiplugin/rag/internal/RagIndexer;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "aiplugin.rag.indexer"})
        public static final class Ready
        extends IndexerState {
            @Nullable
            private final RagIndexer indexer;

            public Ready(@Nullable RagIndexer indexer2) {
                super(null);
                this.indexer = indexer2;
            }

            @Nullable
            public final RagIndexer getIndexer() {
                return this.indexer;
            }

            @Nullable
            public final RagIndexer component1() {
                return this.indexer;
            }

            @NotNull
            public final Ready copy(@Nullable RagIndexer indexer2) {
                return new Ready(indexer2);
            }

            public static /* synthetic */ Ready copy$default(Ready ready, RagIndexer ragIndexer, int n, Object object) {
                if ((n & 1) != 0) {
                    ragIndexer = ready.indexer;
                }
                return ready.copy(ragIndexer);
            }

            @NotNull
            public String toString() {
                return "Ready(indexer=" + this.indexer + ")";
            }

            public int hashCode() {
                return this.indexer == null ? 0 : this.indexer.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Ready)) {
                    return false;
                }
                Ready ready = (Ready)other;
                return Intrinsics.areEqual((Object)this.indexer, (Object)ready.indexer);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lcom/google/aiplugin/rag/internal/RagIndexerProviderImpl$IndexerState$UnderConstruction;", "Lcom/google/aiplugin/rag/internal/RagIndexerProviderImpl$IndexerState;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "aiplugin.rag.indexer"})
        public static final class UnderConstruction
        extends IndexerState {
            @NotNull
            public static final UnderConstruction INSTANCE = new UnderConstruction();

            private UnderConstruction() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "UnderConstruction";
            }

            public int hashCode() {
                return -150146029;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof UnderConstruction)) {
                    return false;
                }
                UnderConstruction cfr_ignored_0 = (UnderConstruction)other;
                return true;
            }
        }
    }
}

