/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.rag.lucene;

import com.google.aiplugin.rag.lucene.LuceneIndexWriterManagerService;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.PathKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.NoSuchFileException;
import kotlin.jvm.JvmInline;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import net.jcip.annotations.GuardedBy;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockObtainFailedException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service(value={Service.Level.APP})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\b\u0007\u0018\u0000 B2\u00020\u0001:\u0004@ABCB\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0019\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u000eH\u0003\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u001bJ\u001f\u0010\"\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b#\u0010$J'\u0010%\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'H\u0002\u00a2\u0006\u0004\b(\u0010)J\u001f\u0010*\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u0016H\u0003\u00a2\u0006\u0004\b,\u0010-J\u0010\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010\u0017\u001a\u00020\u001cJ\u000e\u00100\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u001cJ\u0017\u00101\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u000eH\u0003\u00a2\u0006\u0004\b2\u00103J\u001f\u00104\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u00105\u001a\u00020\u001eH\u0003\u00a2\u0006\u0004\b6\u00107J\u001b\u00108\u001a\u00020 *\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b9\u0010:J\b\u0010;\u001a\u00020 H\u0016J\u0010\u0010<\u001a\u00020=2\u0006\u0010\u0017\u001a\u00020\u001cH\u0007J\u000e\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00110?H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00110\r8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/google/aiplugin/rag/lucene/LuceneIndexWriterManagerService;", "Lcom/intellij/openapi/Disposable;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "backgroundDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lkotlinx/coroutines/CoroutineDispatcher;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "openWriters", "", "Lcom/google/aiplugin/rag/lucene/LuceneIndexWriterManagerService$IndexPath;", "Lcom/google/aiplugin/rag/lucene/LuceneIndexWriterManagerService$WriterState;", "openDirectories", "Lorg/apache/lucene/store/FSDirectory;", "readerOpenCount", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/concurrent/atomic/AtomicInteger;", "getNonClosingState", "Lcom/google/aiplugin/rag/lucene/LuceneIndexWriterManagerService$WriterState$Open;", "path", "getNonClosingState-tPhwAYU", "(Ljava/nio/file/Path;)Lcom/google/aiplugin/rag/lucene/LuceneIndexWriterManagerService$WriterState$Open;", "getIndexWriter", "Lorg/apache/lucene/index/IndexWriter;", "Ljava/nio/file/Path;", "indexWriterConfig", "Lorg/apache/lucene/index/IndexWriterConfig;", "releaseIndexWriter", "", "writer", "handleIndexWriterTragedy", "handleIndexWriterTragedy-ONbGO2s", "(Ljava/nio/file/Path;Lorg/apache/lucene/index/IndexWriter;)V", "closeWriter", "shouldRollback", "", "closeWriter-ewfwj50", "(Ljava/nio/file/Path;Lorg/apache/lucene/index/IndexWriter;Z)V", "startAsyncWriterRollback", "state", "startAsyncWriterRollback-ONbGO2s", "(Ljava/nio/file/Path;Lcom/google/aiplugin/rag/lucene/LuceneIndexWriterManagerService$WriterState$Open;)V", "getIndexReader", "Lorg/apache/lucene/index/DirectoryReader;", "clearIndexData", "getOrOpenDirectory", "getOrOpenDirectory-tPhwAYU", "(Ljava/nio/file/Path;)Lorg/apache/lucene/store/FSDirectory;", "openIndexWriter", "iwc", "openIndexWriter-ONbGO2s", "(Ljava/nio/file/Path;Lorg/apache/lucene/index/IndexWriterConfig;)Lorg/apache/lucene/index/IndexWriter;", "ensureOpen", "ensureOpen-MOD7d2M", "(Lorg/apache/lucene/index/IndexWriter;Ljava/nio/file/Path;)V", "dispose", "getAndClearReaderCount", "", "getOpenDirectories", "", "WriterState", "IndexPath", "Companion", "TragedyReportingIndexWriter", "aiplugin.rag.indexer"})
@SourceDebugExtension(value={"SMAP\nLuceneIndexWriterManagerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuceneIndexWriterManagerService.kt\ncom/google/aiplugin/rag/lucene/LuceneIndexWriterManagerService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,416:1\n24#2:417\n1#3:418\n*S KotlinDebug\n*F\n+ 1 LuceneIndexWriterManagerService.kt\ncom/google/aiplugin/rag/lucene/LuceneIndexWriterManagerService\n*L\n102#1:417\n*E\n"})
public final class LuceneIndexWriterManagerService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final CoroutineDispatcher backgroundDispatcher;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ReentrantLock lock;
    @GuardedBy(value="lock")
    @NotNull
    private final Map<IndexPath, WriterState> openWriters;
    @GuardedBy(value="lock")
    @NotNull
    private final Map<IndexPath, FSDirectory> openDirectories;
    @NotNull
    private final ConcurrentHashMap<IndexPath, AtomicInteger> readerOpenCount;

    @JvmOverloads
    public LuceneIndexWriterManagerService(@NotNull CoroutineScope coroutineScope, @NotNull CoroutineDispatcher backgroundDispatcher) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)backgroundDispatcher, (String)"backgroundDispatcher");
        this.coroutineScope = coroutineScope;
        this.backgroundDispatcher = backgroundDispatcher;
        LuceneIndexWriterManagerService $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(LuceneIndexWriterManagerService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.lock = new ReentrantLock();
        this.openWriters = new LinkedHashMap();
        this.openDirectories = new LinkedHashMap();
        this.readerOpenCount = new ConcurrentHashMap();
    }

    public /* synthetic */ LuceneIndexWriterManagerService(CoroutineScope coroutineScope, CoroutineDispatcher coroutineDispatcher, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            coroutineDispatcher = Dispatchers.getIO();
        }
        this(coroutineScope, coroutineDispatcher);
    }

    @GuardedBy(value="lock")
    private final WriterState.Open getNonClosingState-tPhwAYU(Path path2) {
        while (true) {
            WriterState state2;
            if ((state2 = this.openWriters.get(IndexPath.box-impl(path2))) == null) {
                return null;
            }
            if (state2 instanceof WriterState.Open) {
                return (WriterState.Open)state2;
            }
            if (!(state2 instanceof WriterState.Closing)) break;
            this.logger.info("Waiting for writer for " + path2 + " to close...");
            ((WriterState.Closing)state2).getCondition().await();
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final IndexWriter getIndexWriter(@NotNull Path path2, @NotNull IndexWriterConfig indexWriterConfig) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)indexWriterConfig, (String)"indexWriterConfig");
        Path indexPath = IndexPath.Companion.from-TJngbUw(path2);
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            WriterState.Open open = this.getNonClosingState-tPhwAYU(indexPath);
            if (open == null) {
                WriterState.Open open2;
                WriterState.Open it = open2 = new WriterState.Open(this.openIndexWriter-ONbGO2s(indexPath, indexWriterConfig), 0);
                boolean bl2 = false;
                this.openWriters.put(IndexPath.box-impl(indexPath), it);
                open = open2;
            }
            WriterState.Open state2 = open;
            this.ensureOpen-MOD7d2M(state2.getWriter(), indexPath);
            int n = state2.getRefCount();
            state2.setRefCount(n + 1);
            IndexWriter indexWriter = state2.getWriter();
            return indexWriter;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releaseIndexWriter(@NotNull Path path2, @NotNull IndexWriter writer) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Path indexPath = IndexPath.Companion.from-TJngbUw(path2);
        Lock lock = this.lock;
        lock.lock();
        try {
            WriterState state2;
            boolean bl = false;
            WriterState writerState = state2 = this.openWriters.get(IndexPath.box-impl(indexPath));
            if ((writerState != null ? writerState.getWriter() : null) != writer) {
                if (!(!writer.isOpen() || state2 instanceof WriterState.Closing)) {
                    boolean bl2 = false;
                    String string = "Unknown IndexWriter for " + path2 + " is still open";
                    throw new IllegalArgumentException(string.toString());
                }
                return;
            }
            if (state2 instanceof WriterState.Open) {
                WriterState.Open open = (WriterState.Open)state2;
                open.setRefCount(open.getRefCount() + -1);
                if (open.getRefCount() == 0) {
                    try {
                        this.closeWriter-ewfwj50(indexPath, ((WriterState.Open)state2).getWriter(), false);
                    }
                    finally {
                        this.openWriters.remove(IndexPath.box-impl(indexPath));
                    }
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleIndexWriterTragedy-ONbGO2s(Path path2, IndexWriter writer) {
        Lock lock = this.lock;
        lock.lock();
        try {
            WriterState state2;
            boolean bl = false;
            WriterState writerState = state2 = this.openWriters.get(IndexPath.box-impl(path2));
            if ((writerState != null ? writerState.getWriter() : null) != writer) {
                this.logger.warn("Tried to handle tragedy for unknown IndexWriter for " + path2);
                return;
            }
            if (state2 instanceof WriterState.Open) {
                this.startAsyncWriterRollback-ONbGO2s(path2, (WriterState.Open)state2);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final void closeWriter-ewfwj50(Path path2, IndexWriter writer, boolean shouldRollback) {
        try {
            if (shouldRollback) {
                writer.rollback();
            } else {
                writer.close();
            }
        }
        catch (NoSuchFileException e) {
            this.logger.warn("IndexWriter for " + path2 + " was already deleted", (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error("Could not close IndexWriter", (Throwable)e);
        }
    }

    @GuardedBy(value="lock")
    private final void startAsyncWriterRollback-ONbGO2s(Path path2, WriterState.Open state2) {
        WriterState.Closing closing;
        if (!(this.openWriters.get(IndexPath.box-impl(path2)) == state2)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Ref.ObjectRef newState = new Ref.ObjectRef();
        Condition condition = this.lock.newCondition();
        IndexWriter writer = state2.getWriter();
        Job job2 = BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, (CoroutineStart)CoroutineStart.LAZY, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, path2, writer, condition, (Ref.ObjectRef<WriterState.Closing>)newState, null){
            int label;
            final /* synthetic */ LuceneIndexWriterManagerService this$0;
            final /* synthetic */ Path $path;
            final /* synthetic */ IndexWriter $writer;
            final /* synthetic */ Condition $condition;
            final /* synthetic */ Ref.ObjectRef<WriterState.Closing> $newState;
            {
                this.this$0 = $receiver;
                this.$path = $path;
                this.$writer = $writer;
                this.$condition = $condition;
                this.$newState = $newState;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)LuceneIndexWriterManagerService.access$getBackgroundDispatcher$p(this.this$0)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$path, this.$writer, this.$condition, this.$newState, null){
                            int label;
                            final /* synthetic */ LuceneIndexWriterManagerService this$0;
                            final /* synthetic */ Path $path;
                            final /* synthetic */ IndexWriter $writer;
                            final /* synthetic */ Condition $condition;
                            final /* synthetic */ Ref.ObjectRef<WriterState.Closing> $newState;
                            {
                                this.this$0 = $receiver;
                                this.$path = $path;
                                this.$writer = $writer;
                                this.$condition = $condition;
                                this.$newState = $newState;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        try {
                                            LuceneIndexWriterManagerService.access$closeWriter-ewfwj50(this.this$0, this.$path, this.$writer, true);
                                        }
                                        catch (Throwable throwable) {
                                            Lock lock = LuceneIndexWriterManagerService.access$getLock$p(this.this$0);
                                            Condition condition = this.$condition;
                                            LuceneIndexWriterManagerService luceneIndexWriterManagerService = this.this$0;
                                            Path path2 = this.$path;
                                            Ref.ObjectRef<WriterState.Closing> objectRef = this.$newState;
                                            lock.lock();
                                            try {
                                                WriterState.Closing closing;
                                                boolean bl = false;
                                                condition.signalAll();
                                                Map map2 = LuceneIndexWriterManagerService.access$getOpenWriters$p(luceneIndexWriterManagerService);
                                                IndexPath indexPath = IndexPath.box-impl(path2);
                                                if (objectRef.element == null) {
                                                    Intrinsics.throwUninitializedPropertyAccessException((String)"newState");
                                                    closing = null;
                                                } else {
                                                    closing = (WriterState.Closing)objectRef.element;
                                                }
                                                boolean bl2 = map2.remove(indexPath, closing);
                                            }
                                            finally {
                                                lock.unlock();
                                            }
                                            throw throwable;
                                        }
                                        Lock lock = LuceneIndexWriterManagerService.access$getLock$p(this.this$0);
                                        Condition condition = this.$condition;
                                        LuceneIndexWriterManagerService luceneIndexWriterManagerService = this.this$0;
                                        Path path3 = this.$path;
                                        Ref.ObjectRef<WriterState.Closing> objectRef = this.$newState;
                                        lock.lock();
                                        try {
                                            WriterState.Closing closing;
                                            boolean bl = false;
                                            condition.signalAll();
                                            Map map3 = LuceneIndexWriterManagerService.access$getOpenWriters$p(luceneIndexWriterManagerService);
                                            IndexPath indexPath = IndexPath.box-impl(path3);
                                            if (objectRef.element == null) {
                                                Intrinsics.throwUninitializedPropertyAccessException((String)"newState");
                                                closing = null;
                                            } else {
                                                closing = (WriterState.Closing)objectRef.element;
                                            }
                                            boolean bl3 = map3.remove(indexPath, closing);
                                        }
                                        finally {
                                            lock.unlock();
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        Intrinsics.checkNotNull((Object)condition);
        newState.element = new WriterState.Closing(writer, condition, job2);
        IndexPath indexPath = IndexPath.box-impl(path2);
        if (newState.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"newState");
            closing = null;
        } else {
            closing = (WriterState.Closing)newState.element;
        }
        this.openWriters.put(indexPath, closing);
        job2.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final DirectoryReader getIndexReader(@NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Path indexPath = IndexPath.Companion.from-TJngbUw(path2);
        this.readerOpenCount.computeIfAbsent(IndexPath.box-impl(indexPath), arg_0 -> LuceneIndexWriterManagerService.getIndexReader$lambda$5(getIndexReader.1.INSTANCE, arg_0)).incrementAndGet();
        Lock lock = this.lock;
        lock.lock();
        try {
            WriterState.Open openState;
            boolean bl = false;
            WriterState writerState = this.openWriters.get(IndexPath.box-impl(indexPath));
            WriterState.Open open = openState = writerState instanceof WriterState.Open ? (WriterState.Open)writerState : null;
            if (openState != null) {
                DirectoryReader directoryReader = DirectoryReader.open((IndexWriter)openState.getWriter());
                return directoryReader;
            }
            FSDirectory indexDir = this.getOrOpenDirectory-tPhwAYU(indexPath);
            DirectoryReader directoryReader = DirectoryReader.indexExists((Directory)((Directory)indexDir)) ? DirectoryReader.open((Directory)((Directory)indexDir)) : null;
            return directoryReader;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearIndexData(@NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Path indexPath = IndexPath.Companion.from-TJngbUw(path2);
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            WriterState.Open state2 = this.getNonClosingState-tPhwAYU(indexPath);
            if (state2 != null) {
                this.closeWriter-ewfwj50(indexPath, state2.getWriter(), true);
                this.openWriters.remove(IndexPath.box-impl(indexPath), state2);
            }
            boolean bl2 = FileUtil.deleteWithRenamingIfExists((Path)indexPath);
        }
        finally {
            lock.unlock();
        }
    }

    @GuardedBy(value="lock")
    private final FSDirectory getOrOpenDirectory-tPhwAYU(Path path2) {
        FSDirectory fSDirectory = this.openDirectories.computeIfAbsent(IndexPath.box-impl(path2), arg_0 -> LuceneIndexWriterManagerService.getOrOpenDirectory_tPhwAYU$lambda$8(getOrOpenDirectory.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)fSDirectory, (String)"computeIfAbsent(...)");
        return fSDirectory;
    }

    @GuardedBy(value="lock")
    private final IndexWriter openIndexWriter-ONbGO2s(Path path2, IndexWriterConfig iwc) {
        IndexWriter indexWriter;
        FSDirectory fsDir = this.getOrOpenDirectory-tPhwAYU(path2);
        iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        try {
            indexWriter = new TragedyReportingIndexWriter(path2, (Directory)fsDir, iwc, null);
        }
        catch (LockObtainFailedException e) {
            this.logger.warn("Could not obtain lock on index " + path2, (Throwable)e);
            Path path3 = path2.resolve("write.lock");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
            boolean deleted = Files.deleteIfExists(path3);
            this.logger.info("Lock write.lock deleted: " + deleted);
            indexWriter = new TragedyReportingIndexWriter(path2, (Directory)fsDir, iwc, null);
        }
        return indexWriter;
    }

    private final void ensureOpen-MOD7d2M(IndexWriter $this$ensureOpen_u2dMOD7d2M, Path path2) {
        if (!$this$ensureOpen_u2dMOD7d2M.isOpen()) {
            boolean bl = false;
            String string = "IndexWriter for " + path2 + " already closed";
            throw new IllegalStateException(string.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            for (Map.Entry<IndexPath, WriterState> entry : this.openWriters.entrySet()) {
                Path path2 = entry.getKey().unbox-impl();
                WriterState state2 = entry.getValue();
                WriterState writerState = state2;
                if (writerState instanceof WriterState.Open) {
                    ((WriterState.Open)state2).getWriter().close();
                    continue;
                }
                if (writerState instanceof WriterState.Closing) {
                    Job.DefaultImpls.cancel$default((Job)((WriterState.Closing)state2).getJob(), null, (int)1, null);
                    this.closeWriter-ewfwj50(path2, ((WriterState.Closing)state2).getWriter(), true);
                    ((WriterState.Closing)state2).getCondition().signalAll();
                    continue;
                }
                throw new NoWhenBranchMatchedException();
            }
            this.openWriters.clear();
            for (FSDirectory directory : this.openDirectories.values()) {
                directory.close();
            }
            this.openDirectories.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @TestOnly
    public final int getAndClearReaderCount(@NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        AtomicInteger atomicInteger = this.readerOpenCount.get(IndexPath.box-impl(IndexPath.Companion.from-TJngbUw(path2)));
        return atomicInteger != null ? atomicInteger.getAndSet(0) : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    @NotNull
    public final List<FSDirectory> getOpenDirectories() {
        List list;
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            list = CollectionsKt.toList((Iterable)this.openDirectories.values());
        }
        finally {
            lock.unlock();
        }
        return list;
    }

    @JvmOverloads
    public LuceneIndexWriterManagerService(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this(coroutineScope, null, 2, null);
    }

    private static final AtomicInteger getIndexReader$lambda$5(Function1 $tmp0, Object p0) {
        return (AtomicInteger)$tmp0.invoke(p0);
    }

    private static final FSDirectory getOrOpenDirectory_tPhwAYU$lambda$8(Function1 $tmp0, Object p0) {
        return (FSDirectory)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final LuceneIndexWriterManagerService getInstance() {
        return Companion.getInstance();
    }

    public static final /* synthetic */ CoroutineDispatcher access$getBackgroundDispatcher$p(LuceneIndexWriterManagerService $this) {
        return $this.backgroundDispatcher;
    }

    public static final /* synthetic */ void access$closeWriter-ewfwj50(LuceneIndexWriterManagerService $this, Path path2, IndexWriter writer, boolean shouldRollback) {
        $this.closeWriter-ewfwj50(path2, writer, shouldRollback);
    }

    public static final /* synthetic */ ReentrantLock access$getLock$p(LuceneIndexWriterManagerService $this) {
        return $this.lock;
    }

    public static final /* synthetic */ Map access$getOpenWriters$p(LuceneIndexWriterManagerService $this) {
        return $this.openWriters;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/google/aiplugin/rag/lucene/LuceneIndexWriterManagerService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/google/aiplugin/rag/lucene/LuceneIndexWriterManagerService;", "aiplugin.rag.indexer"})
    @SourceDebugExtension(value={"SMAP\nLuceneIndexWriterManagerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuceneIndexWriterManagerService.kt\ncom/google/aiplugin/rag/lucene/LuceneIndexWriterManagerService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,416:1\n40#2,3:417\n*S KotlinDebug\n*F\n+ 1 LuceneIndexWriterManagerService.kt\ncom/google/aiplugin/rag/lucene/LuceneIndexWriterManagerService$Companion\n*L\n393#1:417,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final LuceneIndexWriterManagerService getInstance() {
            boolean $i$f$service = false;
            Class<LuceneIndexWriterManagerService> serviceClass$iv = LuceneIndexWriterManagerService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (LuceneIndexWriterManagerService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @JvmInline
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0083@\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u000eH\u00d6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0088\u0001\u0002\u00a8\u0006\u0016"}, d2={"Lcom/google/aiplugin/rag/lucene/LuceneIndexWriterManagerService$IndexPath;", "", "nioPath", "Ljava/nio/file/Path;", "constructor-impl", "(Ljava/nio/file/Path;)Ljava/nio/file/Path;", "getNioPath", "()Ljava/nio/file/Path;", "equals", "", "other", "equals-impl", "(Ljava/nio/file/Path;Ljava/lang/Object;)Z", "hashCode", "", "hashCode-impl", "(Ljava/nio/file/Path;)I", "toString", "", "toString-impl", "(Ljava/nio/file/Path;)Ljava/lang/String;", "Companion", "aiplugin.rag.indexer"})
    private static final class IndexPath {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Path nioPath;

        @NotNull
        public final Path getNioPath() {
            return this.nioPath;
        }

        public static String toString-impl(Path arg0) {
            return "IndexPath(nioPath=" + arg0 + ")";
        }

        public String toString() {
            return IndexPath.toString-impl(this.nioPath);
        }

        public static int hashCode-impl(Path arg0) {
            return ((Object)arg0).hashCode();
        }

        public int hashCode() {
            return IndexPath.hashCode-impl(this.nioPath);
        }

        public static boolean equals-impl(Path arg0, Object other) {
            if (!(other instanceof IndexPath)) {
                return false;
            }
            return Intrinsics.areEqual((Object)arg0, (Object)((IndexPath)other).unbox-impl());
        }

        public boolean equals(Object other) {
            return IndexPath.equals-impl(this.nioPath, other);
        }

        private /* synthetic */ IndexPath(Path nioPath) {
            this.nioPath = nioPath;
        }

        private static Path constructor-impl(Path nioPath) {
            return nioPath;
        }

        public static final /* synthetic */ IndexPath box-impl(Path v) {
            return new IndexPath(v);
        }

        public final /* synthetic */ Path unbox-impl() {
            return this.nioPath;
        }

        public static final boolean equals-impl0(Path p1, Path p2) {
            return Intrinsics.areEqual((Object)p1, (Object)p2);
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/google/aiplugin/rag/lucene/LuceneIndexWriterManagerService$IndexPath$Companion;", "", "<init>", "()V", "from", "Lcom/google/aiplugin/rag/lucene/LuceneIndexWriterManagerService$IndexPath;", "path", "Ljava/nio/file/Path;", "from-TJngbUw", "(Ljava/nio/file/Path;)Ljava/nio/file/Path;", "aiplugin.rag.indexer"})
        @SourceDebugExtension(value={"SMAP\nLuceneIndexWriterManagerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuceneIndexWriterManagerService.kt\ncom/google/aiplugin/rag/lucene/LuceneIndexWriterManagerService$IndexPath$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,416:1\n1#2:417\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Path from-TJngbUw(@NotNull Path path2) {
                Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    PathKt.createDirectories((Path)path2);
                }
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (!Files.isDirectory(path2, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                    boolean bl = false;
                    String string = "Cannot open non-directory path " + path2 + " as a Lucene index";
                    throw new IllegalStateException(string.toString());
                }
                Path path3 = path2.toRealPath(new LinkOption[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"toRealPath(...)");
                return IndexPath.constructor-impl(path3);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u0010\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/google/aiplugin/rag/lucene/LuceneIndexWriterManagerService$TragedyReportingIndexWriter;", "Lorg/apache/lucene/index/IndexWriter;", "path", "Lcom/google/aiplugin/rag/lucene/LuceneIndexWriterManagerService$IndexPath;", "directory", "Lorg/apache/lucene/store/Directory;", "indexWriterConfig", "Lorg/apache/lucene/index/IndexWriterConfig;", "<init>", "(Lcom/google/aiplugin/rag/lucene/LuceneIndexWriterManagerService;Ljava/nio/file/Path;Lorg/apache/lucene/store/Directory;Lorg/apache/lucene/index/IndexWriterConfig;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "Ljava/nio/file/Path;", "isTragedySet", "Ljava/util/concurrent/atomic/AtomicBoolean;", "onTragicEvent", "", "tragedy", "", "location", "", "aiplugin.rag.indexer"})
    private final class TragedyReportingIndexWriter
    extends IndexWriter {
        @NotNull
        private final Path path;
        @NotNull
        private final AtomicBoolean isTragedySet;

        private TragedyReportingIndexWriter(Path path2, Directory directory, IndexWriterConfig indexWriterConfig) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            Intrinsics.checkNotNullParameter((Object)indexWriterConfig, (String)"indexWriterConfig");
            super(directory, indexWriterConfig);
            this.path = path2;
            this.isTragedySet = new AtomicBoolean(false);
        }

        public void onTragicEvent(@Nullable Throwable tragedy, @Nullable String location) {
            LuceneIndexWriterManagerService.this.logger.warn("Unexpected tragic event in IndexWriter: " + location, tragedy);
            super.onTragicEvent(tragedy, location);
            if (!this.isTragedySet.getAndSet(true)) {
                LuceneIndexWriterManagerService.this.handleIndexWriterTragedy-ONbGO2s(this.path, this);
            }
        }

        public /* synthetic */ TragedyReportingIndexWriter(Path path2, Directory directory, IndexWriterConfig indexWriterConfig, DefaultConstructorMarker $constructor_marker) {
            this(path2, directory, indexWriterConfig);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\b\tB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0002\n\u000b\u00a8\u0006\f"}, d2={"Lcom/google/aiplugin/rag/lucene/LuceneIndexWriterManagerService$WriterState;", "", "<init>", "()V", "writer", "Lorg/apache/lucene/index/IndexWriter;", "getWriter", "()Lorg/apache/lucene/index/IndexWriter;", "Open", "Closing", "Lcom/google/aiplugin/rag/lucene/LuceneIndexWriterManagerService$WriterState$Closing;", "Lcom/google/aiplugin/rag/lucene/LuceneIndexWriterManagerService$WriterState$Open;", "aiplugin.rag.indexer"})
    private static abstract sealed class WriterState {
        private WriterState() {
        }

        @NotNull
        public abstract IndexWriter getWriter();

        public /* synthetic */ WriterState(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/google/aiplugin/rag/lucene/LuceneIndexWriterManagerService$WriterState$Closing;", "Lcom/google/aiplugin/rag/lucene/LuceneIndexWriterManagerService$WriterState;", "writer", "Lorg/apache/lucene/index/IndexWriter;", "condition", "Ljava/util/concurrent/locks/Condition;", "job", "Lkotlinx/coroutines/Job;", "<init>", "(Lorg/apache/lucene/index/IndexWriter;Ljava/util/concurrent/locks/Condition;Lkotlinx/coroutines/Job;)V", "getWriter", "()Lorg/apache/lucene/index/IndexWriter;", "getCondition", "()Ljava/util/concurrent/locks/Condition;", "getJob", "()Lkotlinx/coroutines/Job;", "aiplugin.rag.indexer"})
        public static final class Closing
        extends WriterState {
            @NotNull
            private final IndexWriter writer;
            @NotNull
            private final Condition condition;
            @NotNull
            private final Job job;

            public Closing(@NotNull IndexWriter writer, @NotNull Condition condition, @NotNull Job job2) {
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
                Intrinsics.checkNotNullParameter((Object)job2, (String)"job");
                super(null);
                this.writer = writer;
                this.condition = condition;
                this.job = job2;
            }

            @Override
            @NotNull
            public IndexWriter getWriter() {
                return this.writer;
            }

            @NotNull
            public final Condition getCondition() {
                return this.condition;
            }

            @NotNull
            public final Job getJob() {
                return this.job;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/google/aiplugin/rag/lucene/LuceneIndexWriterManagerService$WriterState$Open;", "Lcom/google/aiplugin/rag/lucene/LuceneIndexWriterManagerService$WriterState;", "writer", "Lorg/apache/lucene/index/IndexWriter;", "refCount", "", "<init>", "(Lorg/apache/lucene/index/IndexWriter;I)V", "getWriter", "()Lorg/apache/lucene/index/IndexWriter;", "getRefCount", "()I", "setRefCount", "(I)V", "aiplugin.rag.indexer"})
        public static final class Open
        extends WriterState {
            @NotNull
            private final IndexWriter writer;
            private int refCount;

            public Open(@NotNull IndexWriter writer, int refCount) {
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                super(null);
                this.writer = writer;
                this.refCount = refCount;
            }

            @Override
            @NotNull
            public IndexWriter getWriter() {
                return this.writer;
            }

            public final int getRefCount() {
                return this.refCount;
            }

            public final void setRefCount(int n) {
                this.refCount = n;
            }
        }
    }
}

