/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.intellij.analytics;

import com.google.cloud.tools.intellij.analytics.IdeSessionIndexSerializer;
import java.time.LocalDate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/google/cloud/tools/intellij/analytics/IdeSessionIndex;", "", "date", "Ljava/time/LocalDate;", "count", "", "<init>", "(Ljava/time/LocalDate;I)V", "getDate", "()Ljava/time/LocalDate;", "getCount", "()I", "toString", "", "component1", "component2", "copy", "equals", "", "other", "hashCode", "aiplugin.cloudcode-core"})
public final class IdeSessionIndex {
    @NotNull
    private final LocalDate date;
    private final int count;

    public IdeSessionIndex(@NotNull LocalDate date, int count) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        this.date = date;
        this.count = count;
    }

    @NotNull
    public final LocalDate getDate() {
        return this.date;
    }

    public final int getCount() {
        return this.count;
    }

    @NotNull
    public String toString() {
        String dateString = IdeSessionIndexSerializer.Companion.getDATE_FORMAT().format(this.date);
        String countString = StringsKt.padStart((String)String.valueOf(this.count), (int)4, (char)'0');
        return dateString + "_" + countString;
    }

    @NotNull
    public final LocalDate component1() {
        return this.date;
    }

    public final int component2() {
        return this.count;
    }

    @NotNull
    public final IdeSessionIndex copy(@NotNull LocalDate date, int count) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return new IdeSessionIndex(date, count);
    }

    public static /* synthetic */ IdeSessionIndex copy$default(IdeSessionIndex ideSessionIndex, LocalDate localDate, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            localDate = ideSessionIndex.date;
        }
        if ((n2 & 2) != 0) {
            n = ideSessionIndex.count;
        }
        return ideSessionIndex.copy(localDate, n);
    }

    public int hashCode() {
        int result2 = this.date.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.count);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IdeSessionIndex)) {
            return false;
        }
        IdeSessionIndex ideSessionIndex = (IdeSessionIndex)other;
        if (!Intrinsics.areEqual((Object)this.date, (Object)ideSessionIndex.date)) {
            return false;
        }
        return this.count == ideSessionIndex.count;
    }
}

