/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.aiplugin.editor.prediction;

import com.google.tools.aiplugin.editor.prediction.Diff;
import com.google.tools.aiplugin.editor.prediction.DiffChunk;
import com.google.tools.aiplugin.editor.prediction.DiffKt;
import com.google.tools.aiplugin.editor.prediction.DiffLine;
import com.google.tools.aiplugin.editor.prediction.Differ;
import com.google.tools.aiplugin.editor.prediction.FileHeader;
import com.google.tools.aiplugin.editor.prediction.LineType;
import java.text.ParsePosition;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.datetime.ConvertersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u0000 ,2\u00020\u0001:\u0003,-.B+\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00100\u0018J\b\u0010\u0019\u001a\u00020\u0015H\u0016J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0003J\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0003H\u0002J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000J\u0016\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015J\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u0011\u001a\u00020\u0000J$\u0010#\u001a\u00020\u00132\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00032\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0003H\u0002J\u001a\u0010&\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u00030'H\u0002J\u0006\u0010(\u001a\u00020\u0010J\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020+0*R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006/"}, d2={"Lcom/google/tools/aiplugin/editor/prediction/Diff;", "", "chunks", "", "Lcom/google/tools/aiplugin/editor/prediction/DiffChunk;", "oldFile", "Lcom/google/tools/aiplugin/editor/prediction/FileHeader;", "newFile", "<init>", "(Ljava/util/List;Lcom/google/tools/aiplugin/editor/prediction/FileHeader;Lcom/google/tools/aiplugin/editor/prediction/FileHeader;)V", "getOldFile", "()Lcom/google/tools/aiplugin/editor/prediction/FileHeader;", "getNewFile", "getChunks", "()Ljava/util/List;", "equals", "", "other", "hashCode", "", "apply", "", "document", "compare", "Lkotlin/Function2;", "toString", "flatten", "Lcom/google/tools/aiplugin/editor/prediction/Diff$SingleDiffChunk;", "reconstruct", "flattened", "squash", "repair", "path", "contains", "Lcom/google/tools/aiplugin/editor/prediction/Diff$ContainsResult;", "chunkContains", "larger", "smaller", "getNonEmptyModifications", "", "isCreate", "countDeltas", "Lkotlin/Pair;", "", "Companion", "SingleDiffChunk", "ContainsResult", "aiplugin.editor.prediction"})
@SourceDebugExtension(value={"SMAP\nDiff.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Diff.kt\ncom/google/tools/aiplugin/editor/prediction/Diff\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,690:1\n1056#2:691\n774#2:692\n865#2,2:693\n774#2:695\n865#2,2:696\n1563#2:698\n1634#2,3:699\n1056#2:702\n774#2:704\n865#2,2:705\n1491#2:707\n1516#2,3:708\n1519#2,3:718\n774#2:721\n865#2,2:722\n774#2:724\n865#2,2:725\n1#3:703\n382#4,7:711\n*S KotlinDebug\n*F\n+ 1 Diff.kt\ncom/google/tools/aiplugin/editor/prediction/Diff\n*L\n275#1:691\n284#1:692\n284#1:693,2\n296#1:695\n296#1:696,2\n297#1:698\n297#1:699,3\n319#1:702\n636#1:704\n636#1:705,2\n637#1:707\n637#1:708,3\n637#1:718,3\n645#1:721\n645#1:722,2\n646#1:724\n646#1:725,2\n637#1:711,7\n*E\n"})
public final class Diff {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileHeader oldFile;
    @NotNull
    private final FileHeader newFile;
    @NotNull
    private final List<DiffChunk> chunks;
    @NotNull
    private static final DateTimeFormatter dateTimeFormat;
    @NotNull
    private static final Regex fileRegex;
    @NotNull
    private static final Regex hunkHeaderRegex;

    @NotNull
    public final FileHeader getOldFile() {
        return this.oldFile;
    }

    @NotNull
    public final FileHeader getNewFile() {
        return this.newFile;
    }

    @NotNull
    public final List<DiffChunk> getChunks() {
        return this.chunks;
    }

    public Diff(@NotNull List<DiffChunk> chunks, @NotNull FileHeader oldFile, @NotNull FileHeader newFile) {
        Intrinsics.checkNotNullParameter(chunks, (String)"chunks");
        Intrinsics.checkNotNullParameter((Object)oldFile, (String)"oldFile");
        Intrinsics.checkNotNullParameter((Object)newFile, (String)"newFile");
        this.chunks = chunks;
        this.oldFile = oldFile;
        this.newFile = newFile;
    }

    public /* synthetic */ Diff(List list, FileHeader fileHeader, FileHeader fileHeader2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            fileHeader = new FileHeader(null, null, 0L, 7, null);
        }
        if ((n & 4) != 0) {
            fileHeader2 = new FileHeader(null, null, 0L, 7, null);
        }
        this(list, fileHeader, fileHeader2);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.google.tools.aiplugin.editor.prediction.Diff");
        Diff cfr_ignored_0 = (Diff)other;
        if (!Intrinsics.areEqual((Object)this.oldFile, (Object)((Diff)other).oldFile)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.newFile, (Object)((Diff)other).newFile)) {
            return false;
        }
        return Intrinsics.areEqual(this.chunks, ((Diff)other).chunks);
    }

    public int hashCode() {
        int result2 = this.oldFile.hashCode();
        result2 = 31 * result2 + this.newFile.hashCode();
        result2 = 31 * result2 + ((Object)this.chunks).hashCode();
        return result2;
    }

    @NotNull
    public final String apply(@NotNull String document2) throws IllegalStateException {
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        return this.apply(document2, (Function2<? super String, ? super String, Boolean>)((Function2)apply.1.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String apply(@NotNull String document2, @NotNull Function2<? super String, ? super String, Boolean> compare) throws IllegalStateException {
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        Intrinsics.checkNotNullParameter(compare, (String)"compare");
        List<String> lines = Differ.INSTANCE.splitWithNewLines(document2);
        List result2 = new ArrayList();
        int index = 0;
        Iterable $this$sortedBy$iv = this.chunks;
        boolean $i$f$sortedBy = false;
        for (DiffChunk chunk : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                DiffChunk it = (DiffChunk)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getOldStart());
                it = (DiffChunk)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getOldStart()));
            }
        })) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            void $this$filterTo$iv$iv2;
            while (index < chunk.getOldStart() - 1) {
                if (index >= lines.size()) {
                    throw new IllegalStateException("Document shorter than expected");
                }
                result2.add(lines.get(index));
                ++index;
            }
            Iterable $this$filter$iv = chunk.getLines();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                DiffLine it = (DiffLine)element$iv$iv;
                boolean bl = false;
                if (!(it.getType() != LineType.ADDED)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List check = (List)destination$iv$iv;
            for (DiffLine line : check) {
                if (index >= lines.size()) {
                    throw new IllegalStateException("Expected line:\n" + line.getContent() + "\nGot end of document");
                }
                if (!((Boolean)compare.invoke((Object)line.getContent(), (Object)lines.get(index))).booleanValue()) {
                    throw new IllegalStateException("Expected at line " + index + ":\n[" + line.getContent() + "]\nFound:\n[" + lines.get(index) + "]");
                }
                ++index;
            }
            Iterable $this$filter$iv2 = chunk.getLines();
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DiffLine it = (DiffLine)element$iv$iv;
                boolean bl = false;
                if (!(it.getType() != LineType.REMOVED)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List emit2 = (List)destination$iv$iv2;
            $this$filter$iv2 = emit2;
            List list = result2;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                DiffLine it = (DiffLine)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it.getContent());
            }
            list.addAll((List)destination$iv$iv2);
        }
        result2.addAll((Collection)lines.subList(index, lines.size()));
        return CollectionsKt.joinToString$default((Iterable)result2, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!Intrinsics.areEqual((Object)this.oldFile.getPath(), (Object)"/dev/null") || !Intrinsics.areEqual((Object)this.newFile.getPath(), (Object)"/dev/null")) {
            sb.append("--- " + Diff.toString$headerLine(this.oldFile)).append('\n');
            sb.append("+++ " + Diff.toString$headerLine(this.newFile)).append('\n');
        }
        Iterable $this$sortedBy$iv = this.chunks;
        boolean $i$f$sortedBy = false;
        for (DiffChunk chunk : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                DiffChunk it = (DiffChunk)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getOldStart());
                it = (DiffChunk)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getOldStart()));
            }
        })) {
            sb.append("@@ -" + chunk.getOldStart() + "," + chunk.getOldLength() + " +" + chunk.getNewStart() + "," + chunk.getNewLength() + " @@\n");
            for (DiffLine line : chunk.getLines()) {
                switch (WhenMappings.$EnumSwitchMapping$0[line.getType().ordinal()]) {
                    case 1: {
                        StringBuilder stringBuilder = sb.append(' ').append(line.getContent());
                        break;
                    }
                    case 2: {
                        StringBuilder stringBuilder = sb.append('+').append(line.getContent());
                        break;
                    }
                    case 3: {
                        StringBuilder stringBuilder = sb.append('-').append(line.getContent());
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                if (StringsKt.endsWith$default((CharSequence)line.getContent(), (char)'\n', (boolean)false, (int)2, null)) continue;
                sb.append("\n\\ No newline at end of file\n");
            }
        }
        if (this.chunks.isEmpty()) {
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return StringsKt.removeSuffix((String)string, (CharSequence)"\n");
    }

    @NotNull
    public final List<SingleDiffChunk> flatten() {
        List singleChunks = new ArrayList();
        for (DiffChunk chunk : this.chunks) {
            int currentOld = chunk.getOldStart();
            int currentNew = chunk.getNewStart();
            block6: for (DiffLine line : chunk.getLines()) {
                switch (WhenMappings.$EnumSwitchMapping$0[line.getType().ordinal()]) {
                    case 1: {
                        singleChunks.add(new SingleDiffChunk(line.getType(), line.getContent(), currentOld, 1, currentNew, 1));
                        ++currentOld;
                        ++currentNew;
                        continue block6;
                    }
                    case 3: {
                        singleChunks.add(new SingleDiffChunk(line.getType(), line.getContent(), currentOld, 1, currentNew, 0));
                        ++currentOld;
                        continue block6;
                    }
                    case 2: {
                        singleChunks.add(new SingleDiffChunk(line.getType(), line.getContent(), currentOld, 0, currentNew, 1));
                        ++currentNew;
                        continue block6;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
        }
        return singleChunks;
    }

    private final List<DiffChunk> reconstruct(List<SingleDiffChunk> flattened) {
        if (flattened.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List ret = new ArrayList();
        SingleDiffChunk first = flattened.get(0);
        int oldStart = first.getOldStart();
        int oldLength = first.getOldLength();
        int newStart = first.getNewStart();
        int newLength = first.getNewLength();
        Object[] objectArray = new DiffLine[]{new DiffLine(first.getType(), first.getContent())};
        List lines = CollectionsKt.mutableListOf((Object[])objectArray);
        int ix = 1;
        int n = CollectionsKt.getLastIndex(flattened);
        if (ix <= n) {
            while (true) {
                SingleDiffChunk line;
                if ((line = flattened.get(ix)).getOldStart() == oldStart + oldLength && line.getNewStart() == newStart + newLength) {
                    oldLength += line.getOldLength();
                    newLength += line.getNewLength();
                    lines.add(new DiffLine(line.getType(), line.getContent()));
                } else {
                    ret.add(new DiffChunk(oldStart, oldLength, newStart, newLength, lines));
                    oldStart = line.getOldStart();
                    oldLength = line.getOldLength();
                    newStart = line.getNewStart();
                    newLength = line.getNewLength();
                    Object[] objectArray2 = new DiffLine[]{new DiffLine(line.getType(), line.getContent())};
                    lines = CollectionsKt.mutableListOf((Object[])objectArray2);
                }
                if (ix == n) break;
                ++ix;
            }
        }
        ret.add(new DiffChunk(oldStart, oldLength, newStart, newLength, lines));
        return ret;
    }

    @NotNull
    public final Diff squash(@NotNull Diff other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        List<SingleDiffChunk> flat1 = this.flatten();
        List<SingleDiffChunk> flat2 = other.flatten();
        List squashed = new ArrayList();
        int ix1 = 0;
        int ix2 = 0;
        int source = 1;
        int dest = 1;
        while (true) {
            SingleDiffChunk line1;
            if (ix1 < flat1.size() && (ix2 >= flat2.size() || flat1.get(ix1).getNewStart() < flat2.get(ix2).getOldStart() || flat1.get(ix1).getNewStart() == flat2.get(ix2).getOldStart() && flat1.get(ix1).getNewLength() < flat2.get(ix2).getOldLength() || flat1.get(ix1).getNewStart() == flat2.get(ix2).getOldStart() && flat1.get(ix1).getNewLength() == 0 && flat2.get(ix2).getOldLength() == 0)) {
                line1 = flat1.get(ix1);
                int skipped = line1.getOldStart() - source;
                source += skipped;
                squashed.add(new SingleDiffChunk(line1.getType(), line1.getContent(), line1.getOldStart(), line1.getOldLength(), dest += skipped, line1.getNewLength()));
                source += line1.getOldLength();
                dest += line1.getNewLength();
                ++ix1;
                continue;
            }
            if (ix2 < flat2.size() && (ix1 >= flat1.size() || flat1.get(ix1).getNewStart() > flat2.get(ix2).getOldStart() || flat1.get(ix1).getNewStart() == flat2.get(ix2).getOldStart() && flat1.get(ix1).getNewLength() > flat2.get(ix2).getOldLength())) {
                SingleDiffChunk line2 = flat2.get(ix2);
                int skipped = line2.getNewStart() - dest;
                dest += skipped;
                squashed.add(new SingleDiffChunk(line2.getType(), line2.getContent(), source += skipped, line2.getOldLength(), line2.getNewStart(), line2.getNewLength()));
                source += line2.getOldLength();
                dest += line2.getNewLength();
                ++ix2;
                continue;
            }
            if (ix1 >= flat1.size() || ix2 >= flat2.size()) break;
            line1 = flat1.get(ix1);
            SingleDiffChunk line2 = flat2.get(ix2);
            int skipped = line1.getOldStart() - source;
            source += skipped + line1.getOldLength();
            dest += skipped + line2.getNewLength();
            if (!line1.getContent().equals(line2.getContent())) {
                throw new IllegalStateException("Diff1 and Diff2 are not compatible");
            }
            if (line1.getType() == LineType.CONTEXT && line2.getType() == LineType.CONTEXT) {
                squashed.add(new SingleDiffChunk(LineType.CONTEXT, line1.getContent(), line1.getOldStart(), line1.getOldLength(), line2.getNewStart(), line2.getNewLength()));
            } else if (line1.getType() == LineType.CONTEXT && line2.getType() == LineType.REMOVED) {
                squashed.add(new SingleDiffChunk(LineType.REMOVED, line1.getContent(), line1.getOldStart(), line1.getOldLength(), line2.getNewStart(), line2.getNewLength()));
            } else if (line1.getType() == LineType.ADDED && line2.getType() == LineType.CONTEXT) {
                squashed.add(new SingleDiffChunk(LineType.ADDED, line1.getContent(), line1.getOldStart(), line1.getOldLength(), line2.getNewStart(), line2.getNewLength()));
            } else if (line1.getType() != LineType.ADDED || line2.getType() == LineType.REMOVED) {
                // empty if block
            }
            ++ix1;
            ++ix2;
        }
        return new Diff(this.reconstruct(squashed), this.oldFile, other.newFile);
    }

    @NotNull
    public final Diff repair(@NotNull String path2, @NotNull String document2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        List<String> docLines = Differ.INSTANCE.splitWithNewLines(document2);
        int base = 0;
        int delta = 0;
        List chunks = new ArrayList();
        for (DiffChunk chunk : this.chunks) {
            List lines = new ArrayList();
            String largestLine = "";
            int largestLineOldOffset = -1;
            int oldLength = 0;
            int newLength = 0;
            int lastDelta = delta;
            for (DiffLine line : chunk.getLines()) {
                if (((CharSequence)((Object)StringsKt.trim((CharSequence)line.getContent())).toString()).length() == 0 && lines.isEmpty()) continue;
                if (line.getType() == LineType.CONTEXT && ((Object)StringsKt.trim((CharSequence)line.getContent())).toString().length() > largestLine.length()) {
                    largestLine = line.getContent();
                    largestLineOldOffset = oldLength;
                }
                switch (WhenMappings.$EnumSwitchMapping$0[line.getType().ordinal()]) {
                    case 1: {
                        ++oldLength;
                        ++newLength;
                        break;
                    }
                    case 2: {
                        ++delta;
                        ++newLength;
                        break;
                    }
                    case 3: {
                        --delta;
                        ++oldLength;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                lines.add(line);
            }
            if (largestLineOldOffset == -1) {
                throw new IllegalStateException("Cannot find any context line to use.");
            }
            while (base < docLines.size() && !Intrinsics.areEqual((Object)docLines.get(base), (Object)largestLine)) {
                ++base;
            }
            if (base < docLines.size()) {
                int source = base + 1 - largestLineOldOffset;
                DiffChunk newChunk = new DiffChunk(source, oldLength, source + lastDelta, newLength, lines);
                chunks.add(newChunk);
                continue;
            }
            throw new IllegalStateException("Cannot find CONTEXT line:\n" + largestLine);
        }
        return new Diff(chunks, new FileHeader(path2, null, 0L, 6, null), new FileHeader(path2, null, 0L, 6, null));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ContainsResult contains(@NotNull Diff other) {
        int n;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Map<Integer, List<SingleDiffChunk>> flattened = this.getNonEmptyModifications();
        Map<Integer, List<SingleDiffChunk>> otherFlattened = other.getNonEmptyModifications();
        int score = 0;
        for (Map.Entry<Integer, List<SingleDiffChunk>> chunk : flattened.entrySet()) {
            List<SingleDiffChunk> targetChunk;
            if (otherFlattened.get(chunk.getKey()) == null) continue;
            score += this.chunkContains(chunk.getValue(), targetChunk);
        }
        Iterable iterable = otherFlattened.values();
        int n2 = score;
        int n3 = 0;
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            void it;
            Object t = iterator.next();
            List list = (List)t;
            n = n3;
            boolean bl = false;
            int n4 = it.size();
            n3 = n + n4;
        }
        int n5 = n = n3;
        int n6 = n2;
        return new ContainsResult(n6, n5);
    }

    private final int chunkContains(List<SingleDiffChunk> larger, List<SingleDiffChunk> smaller) {
        int j = 0;
        int score = 0;
        int n = larger.size();
        for (int i2 = 0; i2 < n; ++i2) {
            if (smaller.get(j).getType() == larger.get(i2).getType() && Intrinsics.areEqual((Object)smaller.get(j).getContent(), (Object)larger.get(i2).getContent())) {
                ++score;
            }
            if (score > 0 && ++j >= smaller.size()) break;
        }
        return score;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Integer, List<SingleDiffChunk>> getNonEmptyModifications() {
        void $this$groupByTo$iv$iv;
        SingleDiffChunk it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.flatten();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (SingleDiffChunk)element$iv$iv;
            boolean bl = false;
            if (!(it.getType() != LineType.CONTEXT && !StringsKt.isBlank((CharSequence)it.getContent()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (SingleDiffChunk)element$iv$iv;
            boolean bl = false;
            Integer key$iv$iv = it.getOldStart();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        return destination$iv$iv;
    }

    public final boolean isCreate() {
        return Intrinsics.areEqual((Object)this.oldFile.getPath(), (Object)"/dev/null");
    }

    @NotNull
    public final Pair<Long, Long> countDeltas() {
        SingleDiffChunk it;
        Iterable $this$filterTo$iv$iv;
        List<SingleDiffChunk> flat = this.flatten();
        Iterable $this$filter$iv = flat;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (SingleDiffChunk)element$iv$iv;
            boolean bl = false;
            if (!(it.getType() == LineType.REMOVED)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = flat;
        Long l2 = ((List)destination$iv$iv).size();
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (SingleDiffChunk)element$iv$iv;
            boolean bl = false;
            if (!(it.getType() == LineType.ADDED)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return TuplesKt.to((Object)l2, (Object)((List)destination$iv$iv).size());
    }

    private static final String toString$headerLine(FileHeader line) {
        String date = !Intrinsics.areEqual((Object)line.getTime(), (Object)DiffKt.getEPOCH(kotlinx.datetime.Instant.Companion)) ? DiffKt.access$format(line.getTime(), dateTimeFormat) : "";
        String stamp = line.getStamp() >= 0L ? String.valueOf(line.getStamp()) : "";
        return ((Object)StringsKt.trim((CharSequence)(line.getPath() + " " + date + " " + stamp))).toString();
    }

    static {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSS Z");
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(...)");
        dateTimeFormat = dateTimeFormatter;
        fileRegex = new Regex("^(\\+\\+\\+|---)\\s+(\\S+)(\\s+.+)?$");
        hunkHeaderRegex = new Regex("^@@ -(\\d+),?(\\d*) \\+(\\d+),?(\\d*) @@.*");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J*\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0016J\u0016\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/google/tools/aiplugin/editor/prediction/Diff$Companion;", "", "<init>", "()V", "dateTimeFormat", "Ljava/time/format/DateTimeFormatter;", "getDateTimeFormat", "()Ljava/time/format/DateTimeFormatter;", "fileRegex", "Lkotlin/text/Regex;", "getFileRegex", "()Lkotlin/text/Regex;", "hunkHeaderRegex", "getHunkHeaderRegex", "parseDiff", "Lcom/google/tools/aiplugin/editor/prediction/Diff;", "diffText", "", "calculateDiff", "docBefore", "docAfter", "oldFile", "Lcom/google/tools/aiplugin/editor/prediction/FileHeader;", "newFile", "createFile", "header", "content", "aiplugin.editor.prediction"})
    @SourceDebugExtension(value={"SMAP\nDiff.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Diff.kt\ncom/google/tools/aiplugin/editor/prediction/Diff$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,690:1\n1#2:691\n1869#3,2:692\n1869#3,2:694\n1573#3:696\n1604#3,4:697\n1563#3:701\n1634#3,3:702\n*S KotlinDebug\n*F\n+ 1 Diff.kt\ncom/google/tools/aiplugin/editor/prediction/Diff$Companion\n*L\n194#1:692,2\n195#1:694,2\n213#1:696\n213#1:697,4\n219#1:701\n219#1:702,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DateTimeFormatter getDateTimeFormat() {
            return dateTimeFormat;
        }

        @NotNull
        public final Regex getFileRegex() {
            return fileRegex;
        }

        @NotNull
        public final Regex getHunkHeaderRegex() {
            return hunkHeaderRegex;
        }

        @NotNull
        public final Diff parseDiff(@NotNull String diffText) {
            Intrinsics.checkNotNullParameter((Object)diffText, (String)"diffText");
            List parsedChunks = new ArrayList();
            List lines = StringsKt.lines((CharSequence)diffText);
            FileHeader oldFile = null;
            oldFile = new FileHeader(null, null, 0L, 7, null);
            FileHeader newFile = null;
            newFile = new FileHeader(null, null, 0L, 7, null);
            int i2 = 0;
            while (i2 < lines.size()) {
                String line = (String)lines.get(i2);
                MatchResult match = Regex.find$default((Regex)this.getHunkHeaderRegex(), (CharSequence)line, (int)0, (int)2, null);
                if (match != null) {
                    CharSequence charSequence;
                    CharSequence charSequence2;
                    List groups = match.getDestructured().toList();
                    int oldStart = Integer.parseInt((String)groups.get(0));
                    CharSequence charSequence3 = (CharSequence)groups.get(1);
                    if (charSequence3.length() == 0) {
                        boolean bl = false;
                        charSequence2 = "1";
                    } else {
                        charSequence2 = charSequence3;
                    }
                    int oldLength = Integer.parseInt((String)charSequence2);
                    int newStart = Integer.parseInt((String)groups.get(2));
                    CharSequence charSequence4 = (CharSequence)groups.get(3);
                    if (charSequence4.length() == 0) {
                        boolean bl = false;
                        charSequence = "1";
                    } else {
                        charSequence = charSequence4;
                    }
                    int newLength = Integer.parseInt((String)charSequence);
                    ++i2;
                    List chunkLines = new ArrayList();
                    while (i2 < lines.size() && !StringsKt.startsWith$default((String)((String)lines.get(i2)), (String)"@@", (boolean)false, (int)2, null) && (String)CollectionsKt.getOrNull((List)lines, (int)i2) != null) {
                        String chunkLine;
                        int skip = 0;
                        String newLine = "\n";
                        if (i2 < lines.size() - 1 && StringsKt.startsWith$default((CharSequence)((CharSequence)lines.get(i2 + 1)), (char)'\\', (boolean)false, (int)2, null)) {
                            newLine = "";
                            ++skip;
                        }
                        if (StringsKt.startsWith$default((CharSequence)chunkLine, (char)'+', (boolean)false, (int)2, null)) {
                            String string = chunkLine.substring(1);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                            v3 = chunkLines.add(new DiffLine(LineType.ADDED, string + newLine));
                        } else if (StringsKt.startsWith$default((CharSequence)chunkLine, (char)'-', (boolean)false, (int)2, null)) {
                            String string = chunkLine.substring(1);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                            v3 = chunkLines.add(new DiffLine(LineType.REMOVED, string + newLine));
                        } else if (StringsKt.startsWith$default((CharSequence)chunkLine, (char)' ', (boolean)false, (int)2, null)) {
                            String string = chunkLine.substring(1);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                            v3 = chunkLines.add(new DiffLine(LineType.CONTEXT, string + newLine));
                        } else {
                            if (!StringsKt.startsWith$default((CharSequence)chunkLine, (char)'\\', (boolean)false, (int)2, null)) break;
                            throw new IllegalStateException("No new line marker invalid");
                        }
                        i2 += 1 + skip;
                    }
                    parsedChunks.add(new DiffChunk(oldStart, oldLength, newStart, newLength, chunkLines));
                    continue;
                }
                if (this.getFileRegex().matchEntire((CharSequence)line) != null) {
                    Object object;
                    MatchResult it;
                    boolean bl = false;
                    MatchResult.Destructured destructured = it.getDestructured();
                    String state2 = (String)destructured.getMatch().getGroupValues().get(1);
                    String rawPath = (String)destructured.getMatch().getGroupValues().get(2);
                    String rawRemainder = (String)destructured.getMatch().getGroupValues().get(3);
                    ParsePosition parsePosition = new ParsePosition(0);
                    String path2 = ((Object)StringsKt.trim((CharSequence)rawPath)).toString();
                    String remainder = ((Object)StringsKt.trim((CharSequence)rawRemainder)).toString();
                    Companion $this$parseDiff_u24lambda_u244_u24lambda_u242 = Companion;
                    boolean bl2 = false;
                    try {
                        Instant instant = Instant.from($this$parseDiff_u24lambda_u244_u24lambda_u242.getDateTimeFormat().parse((CharSequence)remainder, parsePosition));
                        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"from(...)");
                        object = ConvertersKt.toKotlinInstant((Instant)instant);
                    }
                    catch (Exception exception) {
                        object = DiffKt.getEPOCH(kotlinx.datetime.Instant.Companion);
                    }
                    kotlinx.datetime.Instant timestamp = object;
                    String string = remainder.substring(parsePosition.getIndex());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    Object it2 = object = ((Object)StringsKt.trim((CharSequence)string)).toString();
                    boolean bl3 = false;
                    Object object2 = !StringsKt.isBlank((CharSequence)((CharSequence)it2)) ? object : null;
                    long filestamp = object2 != null ? Long.parseLong((String)object2) : -1L;
                    FileHeader header = new FileHeader(path2, timestamp, filestamp);
                    if (Intrinsics.areEqual((Object)state2, (Object)"---")) {
                        oldFile = header;
                    } else if (Intrinsics.areEqual((Object)state2, (Object)"+++")) {
                        newFile = header;
                    }
                }
                ++i2;
            }
            return new Diff(parsedChunks, oldFile, newFile);
        }

        @NotNull
        public final Diff calculateDiff(@NotNull String docBefore, @NotNull String docAfter, @NotNull FileHeader oldFile, @NotNull FileHeader newFile) {
            String it;
            int lastDiffAfter;
            int firstDiff;
            Intrinsics.checkNotNullParameter((Object)docBefore, (String)"docBefore");
            Intrinsics.checkNotNullParameter((Object)docAfter, (String)"docAfter");
            Intrinsics.checkNotNullParameter((Object)oldFile, (String)"oldFile");
            Intrinsics.checkNotNullParameter((Object)newFile, (String)"newFile");
            List<String> beforeLines = Differ.INSTANCE.splitWithNewLines(docBefore);
            List<String> afterLines = Differ.INSTANCE.splitWithNewLines(docAfter);
            for (firstDiff = 0; firstDiff < beforeLines.size() && firstDiff < afterLines.size() && Intrinsics.areEqual((Object)beforeLines.get(firstDiff), (Object)afterLines.get(firstDiff)); ++firstDiff) {
            }
            int lastDiffBefore = beforeLines.size() - 1;
            for (lastDiffAfter = afterLines.size() - 1; lastDiffBefore >= firstDiff && lastDiffAfter >= firstDiff && Intrinsics.areEqual((Object)beforeLines.get(lastDiffBefore), (Object)afterLines.get(lastDiffAfter)); --lastDiffBefore, --lastDiffAfter) {
            }
            List<String> removed2 = beforeLines.subList(firstDiff, lastDiffBefore + 1);
            List<String> added = afterLines.subList(firstDiff, lastDiffAfter + 1);
            if (removed2.isEmpty() && added.isEmpty()) {
                return new Diff(CollectionsKt.emptyList(), oldFile, newFile);
            }
            List diffLines = new ArrayList();
            Iterable $this$forEach$iv = removed2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (String)element$iv;
                boolean bl = false;
                diffLines.add(new DiffLine(LineType.REMOVED, it));
            }
            $this$forEach$iv = added;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (String)element$iv;
                boolean bl = false;
                diffLines.add(new DiffLine(LineType.ADDED, it));
            }
            List chunks = CollectionsKt.listOf((Object)new DiffChunk(firstDiff + 1, removed2.size(), firstDiff + 1, added.size(), diffLines));
            return new Diff(chunks, oldFile, newFile);
        }

        public static /* synthetic */ Diff calculateDiff$default(Companion companion, String string, String string2, FileHeader fileHeader, FileHeader fileHeader2, int n, Object object) {
            if ((n & 4) != 0) {
                fileHeader = new FileHeader(null, null, 0L, 7, null);
            }
            if ((n & 8) != 0) {
                fileHeader2 = new FileHeader(null, null, 0L, 7, null);
            }
            return companion.calculateDiff(string, string2, fileHeader, fileHeader2);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Diff createFile(@NotNull FileHeader header, @NotNull String content2) {
            Collection<DiffLine> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$mapIndexedTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)header, (String)"header");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            List split = StringsKt.lines((CharSequence)content2);
            Iterable $this$mapIndexed$iv = split;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
                void s;
                void i2;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv$iv2;
                int n2 = n;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(i2 < split.size() - 1 ? (String)s + "\n" : s);
            }
            List lines = (List)destination$iv$iv;
            if (StringsKt.endsWith$default((String)content2, (String)"\n", (boolean)false, (int)2, null)) {
                lines = lines.subList(0, lines.size() - 1);
            }
            $this$mapIndexed$iv = lines;
            int n = lines.size();
            int n3 = 1;
            int n4 = 0;
            int n5 = 1;
            boolean $i$f$map = false;
            $this$mapIndexedTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Object item$iv$iv2;
                item$iv$iv2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new DiffLine(LineType.ADDED, (String)it));
            }
            Collection<DiffLine> collection3 = collection = (List)destination$iv$iv;
            int n6 = n;
            int n7 = n3;
            int n8 = n4;
            int n9 = n5;
            FileHeader fileHeader = header;
            FileHeader fileHeader2 = new FileHeader("/dev/null", DiffKt.getEPOCH(kotlinx.datetime.Instant.Companion), -1L);
            List list = CollectionsKt.listOf((Object)new DiffChunk(n9, n8, n7, n6, (List<DiffLine>)collection3));
            return new Diff(list, fileHeader2, fileHeader);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/google/tools/aiplugin/editor/prediction/Diff$ContainsResult;", "", "accepted", "", "total", "<init>", "(II)V", "getAccepted", "()I", "getTotal", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "aiplugin.editor.prediction"})
    public static final class ContainsResult {
        private final int accepted;
        private final int total;

        public ContainsResult(int accepted, int total) {
            this.accepted = accepted;
            this.total = total;
        }

        public final int getAccepted() {
            return this.accepted;
        }

        public final int getTotal() {
            return this.total;
        }

        public final int component1() {
            return this.accepted;
        }

        public final int component2() {
            return this.total;
        }

        @NotNull
        public final ContainsResult copy(int accepted, int total) {
            return new ContainsResult(accepted, total);
        }

        public static /* synthetic */ ContainsResult copy$default(ContainsResult containsResult, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = containsResult.accepted;
            }
            if ((n3 & 2) != 0) {
                n2 = containsResult.total;
            }
            return containsResult.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "ContainsResult(accepted=" + this.accepted + ", total=" + this.total + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.accepted);
            result2 = result2 * 31 + Integer.hashCode(this.total);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ContainsResult)) {
                return false;
            }
            ContainsResult containsResult = (ContainsResult)other;
            if (this.accepted != containsResult.accepted) {
                return false;
            }
            return this.total == containsResult.total;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003JE\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020\u0007H\u00d6\u0001J\t\u0010!\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012\u00a8\u0006\""}, d2={"Lcom/google/tools/aiplugin/editor/prediction/Diff$SingleDiffChunk;", "", "type", "Lcom/google/tools/aiplugin/editor/prediction/LineType;", "content", "", "oldStart", "", "oldLength", "newStart", "newLength", "<init>", "(Lcom/google/tools/aiplugin/editor/prediction/LineType;Ljava/lang/String;IIII)V", "getType", "()Lcom/google/tools/aiplugin/editor/prediction/LineType;", "getContent", "()Ljava/lang/String;", "getOldStart", "()I", "getOldLength", "getNewStart", "getNewLength", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "aiplugin.editor.prediction"})
    public static final class SingleDiffChunk {
        @NotNull
        private final LineType type;
        @NotNull
        private final String content;
        private final int oldStart;
        private final int oldLength;
        private final int newStart;
        private final int newLength;

        public SingleDiffChunk(@NotNull LineType type2, @NotNull String content2, int oldStart, int oldLength, int newStart, int newLength) {
            Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            this.type = type2;
            this.content = content2;
            this.oldStart = oldStart;
            this.oldLength = oldLength;
            this.newStart = newStart;
            this.newLength = newLength;
        }

        @NotNull
        public final LineType getType() {
            return this.type;
        }

        @NotNull
        public final String getContent() {
            return this.content;
        }

        public final int getOldStart() {
            return this.oldStart;
        }

        public final int getOldLength() {
            return this.oldLength;
        }

        public final int getNewStart() {
            return this.newStart;
        }

        public final int getNewLength() {
            return this.newLength;
        }

        @NotNull
        public final LineType component1() {
            return this.type;
        }

        @NotNull
        public final String component2() {
            return this.content;
        }

        public final int component3() {
            return this.oldStart;
        }

        public final int component4() {
            return this.oldLength;
        }

        public final int component5() {
            return this.newStart;
        }

        public final int component6() {
            return this.newLength;
        }

        @NotNull
        public final SingleDiffChunk copy(@NotNull LineType type2, @NotNull String content2, int oldStart, int oldLength, int newStart, int newLength) {
            Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            return new SingleDiffChunk(type2, content2, oldStart, oldLength, newStart, newLength);
        }

        public static /* synthetic */ SingleDiffChunk copy$default(SingleDiffChunk singleDiffChunk, LineType lineType, String string, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                lineType = singleDiffChunk.type;
            }
            if ((n5 & 2) != 0) {
                string = singleDiffChunk.content;
            }
            if ((n5 & 4) != 0) {
                n = singleDiffChunk.oldStart;
            }
            if ((n5 & 8) != 0) {
                n2 = singleDiffChunk.oldLength;
            }
            if ((n5 & 0x10) != 0) {
                n3 = singleDiffChunk.newStart;
            }
            if ((n5 & 0x20) != 0) {
                n4 = singleDiffChunk.newLength;
            }
            return singleDiffChunk.copy(lineType, string, n, n2, n3, n4);
        }

        @NotNull
        public String toString() {
            return "SingleDiffChunk(type=" + this.type + ", content=" + this.content + ", oldStart=" + this.oldStart + ", oldLength=" + this.oldLength + ", newStart=" + this.newStart + ", newLength=" + this.newLength + ")";
        }

        public int hashCode() {
            int result2 = this.type.hashCode();
            result2 = result2 * 31 + this.content.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.oldStart);
            result2 = result2 * 31 + Integer.hashCode(this.oldLength);
            result2 = result2 * 31 + Integer.hashCode(this.newStart);
            result2 = result2 * 31 + Integer.hashCode(this.newLength);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SingleDiffChunk)) {
                return false;
            }
            SingleDiffChunk singleDiffChunk = (SingleDiffChunk)other;
            if (this.type != singleDiffChunk.type) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.content, (Object)singleDiffChunk.content)) {
                return false;
            }
            if (this.oldStart != singleDiffChunk.oldStart) {
                return false;
            }
            if (this.oldLength != singleDiffChunk.oldLength) {
                return false;
            }
            if (this.newStart != singleDiffChunk.newStart) {
                return false;
            }
            return this.newLength == singleDiffChunk.newLength;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LineType.values().length];
            try {
                nArray[LineType.CONTEXT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LineType.ADDED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LineType.REMOVED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

