/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.aiplugin.editor.prediction;

import com.google.tools.aiplugin.editor.prediction.Delta;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0006H\u0002\u001a\u0014\u0010\t\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0006H\u0002\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\u000b\u00a8\u0006\f"}, d2={"shouldBreak", "", "prev", "", "curr", "findBreakAtOrBefore", "", "", "target", "findBreakAtOrAfter", "refine", "Lcom/google/tools/aiplugin/editor/prediction/Delta;", "aiplugin.editor.prediction"})
public final class EditScriptKt {
    private static final boolean shouldBreak(char prev, char curr) {
        return Character.isLowerCase(prev) && Character.isUpperCase(curr) || Character.isLetter(prev) && Character.isDigit(curr) || Character.isDigit(prev) && Character.isLetter(curr) || Character.isLetterOrDigit(prev) != Character.isLetterOrDigit(curr);
    }

    private static final int findBreakAtOrBefore(String $this$findBreakAtOrBefore, int target) {
        if (target == $this$findBreakAtOrBefore.length()) {
            return target;
        }
        for (int i2 = RangesKt.coerceAtMost((int)target, (int)($this$findBreakAtOrBefore.length() - 1)); 0 < i2; --i2) {
            if (!EditScriptKt.shouldBreak($this$findBreakAtOrBefore.charAt(i2 - 1), $this$findBreakAtOrBefore.charAt(i2))) continue;
            return i2;
        }
        return 0;
    }

    private static final int findBreakAtOrAfter(String $this$findBreakAtOrAfter, int target) {
        if (target == 0) {
            return $this$findBreakAtOrAfter.length();
        }
        int n = $this$findBreakAtOrAfter.length();
        for (int i2 = RangesKt.coerceAtLeast((int)target, (int)1); i2 < n; ++i2) {
            if (!EditScriptKt.shouldBreak($this$findBreakAtOrAfter.charAt(i2 - 1), $this$findBreakAtOrAfter.charAt(i2))) continue;
            return $this$findBreakAtOrAfter.length() - i2;
        }
        return 0;
    }

    @NotNull
    public static final Delta refine(@NotNull Delta $this$refine) {
        Intrinsics.checkNotNullParameter((Object)$this$refine, (String)"<this>");
        int commonPrefixLen = StringsKt.commonPrefixWith$default((CharSequence)$this$refine.getBefore(), (CharSequence)$this$refine.getAfter(), (boolean)false, (int)2, null).length();
        String string = $this$refine.getBefore().substring(commonPrefixLen);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        CharSequence charSequence = string;
        String string2 = $this$refine.getAfter().substring(commonPrefixLen);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        int commonSuffixLen = StringsKt.commonSuffixWith$default((CharSequence)charSequence, (CharSequence)string2, (boolean)false, (int)2, null).length();
        int prefixBreakLength = Math.min(EditScriptKt.findBreakAtOrBefore($this$refine.getBefore(), commonPrefixLen), EditScriptKt.findBreakAtOrBefore($this$refine.getAfter(), commonPrefixLen));
        int suffixBreakLength = Math.min(EditScriptKt.findBreakAtOrAfter($this$refine.getBefore(), $this$refine.getBefore().length() - commonSuffixLen), EditScriptKt.findBreakAtOrAfter($this$refine.getAfter(), $this$refine.getAfter().length() - commonSuffixLen));
        if (prefixBreakLength == 0 && suffixBreakLength == 0) {
            return $this$refine;
        }
        int newOffset = $this$refine.getOffset() + prefixBreakLength;
        String string3 = $this$refine.getBefore().substring(prefixBreakLength, $this$refine.getBefore().length() - suffixBreakLength);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String newBefore = string3;
        String string4 = $this$refine.getAfter().substring(prefixBreakLength, $this$refine.getAfter().length() - suffixBreakLength);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        String newAfter = string4;
        return new Delta(newOffset, newBefore, newAfter);
    }
}

